/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.package;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import java.io.Serializable;
import java.util.Date;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Growable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\rx!B\u0011#\u0011\u0003yc!B\u0019#\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004\"B\u001e\u0002\t\u0003a\u0004\"B'\u0002\t\u0003qe\u0001B\u0019#\u0001EC\u0011BW\u0003\u0003\u0002\u0003\u0006Ya\u00177\t\u000be*A\u0011A7\t\u000bA,A\u0011A9\t\u000bI,A\u0011A:\t\u000f\u0005=Q\u0001\"\u0001\u0002\u0012!9\u0011qD\u0003\u0005\u0002\u0005\u0005\u0002bBA \u000b\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u0013*A\u0011AA&\u0011\u001d\t9&\u0002C\u0001\u00033Bq!a\u0018\u0006\t\u0003\t\t\u0007C\u0004\u0002|\u0015!\t!! \t\u000f\u0005\rU\u0001\"\u0001\u0002\u0006\"9\u0011\u0011R\u0003\u0005\u0002\u0005-\u0005bBAI\u000b\u0011\u0005\u00111\u0013\u0005\b\u0003?+A\u0011AAQ\u0011\u001d\tI+\u0002C\u0001\u0003WCa!a/\u0006\t\u0003\t\bBBA_\u000b\u0011\u0005\u0011\u000fC\u0004\u0002@\u0016!I!!1\t\u000f\u0005%W\u0001\"\u0003\u0002L\"9\u00111[\u0003\u0005\n\u0005-\u0007bBAk\u000b\u0011%\u00111\u001a\u0005\b\u0003/,A\u0011BAf\u0011\u001d\tI.\u0002C\u0005\u0003\u0017Dq!a7\u0006\t\u0013\tY\rC\u0004\u0002^\u0016!I!a3\t\u000f\u0005}W\u0001\"\u0011\u0002b\u0006yA+Y:lgN\u000bHNQ;jY\u0012,'O\u0003\u0002$I\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002*U\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003W1\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\n1aY8n\u0007\u0001\u0001\"\u0001M\u0001\u000e\u0003\t\u0012q\u0002V1tWN\u001c\u0016\u000f\u001c\"vS2$WM]\n\u0003\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00010\u00035qwN]7bY&TX\rV1hgR\u0011Qh\u0013\t\u0004}\u0015CeBA D!\t\u0001U'D\u0001B\u0015\t\u0011e&\u0001\u0004=e>|GOP\u0005\u0003\tV\na\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\r\u0019V\r\u001e\u0006\u0003\tV\u0002\"AP%\n\u0005);%AB*ue&tw\rC\u0003M\u0007\u0001\u0007Q(\u0001\u0003uC\u001e\u001c\u0018\u0001\u00048pe6\fG.\u001b>f)\u0006<GC\u0001%P\u0011\u0015\u0001F\u00011\u0001I\u0003\r!\u0018mZ\n\u0003\u000bI\u00032aU,Z\u001b\u0005!&BA\u0013V\u0015\t1\u0006&\u0001\u0002eE&\u0011\u0001\f\u0016\u0002\u000b'Fd')^5mI\u0016\u0014\bC\u0001\u0019\u0006\u0003\u001d!\u0017.\u00197fGR\u0004\"\u0001X5\u000f\u0005u;gB\u00010g\u001d\tyVM\u0004\u0002aI:\u0011\u0011m\u0019\b\u0003\u0001\nL\u0011!L\u0005\u0003W1J!!\u000b\u0016\n\u0005YC\u0013BA\u0013V\u0013\tAG+\u0001\u0006Tc2\u0014U/\u001b7eKJL!A[6\u0003\u000f\u0011K\u0017\r\\3di*\u0011\u0001\u000eV\u0005\u00035^#\u0012A\u001c\u000b\u00033>DQAW\u0004A\u0004m\u000bAb]3mK\u000e$H+Y:l\u0013\u0012$\u0012!W\u0001\u0019o&$\bn\u00148f\u001f\u001a\u0014V\r\\3bg\u0016\u001cF/\u0019;vg\u0016\u001cHCA-u\u0011\u0015)\u0018\u00021\u0001w\u0003!\u0019H/\u0019;vg\u0016\u001c\bcA<}\u007f:\u0011\u0001P\u001f\b\u0003\u0001fL\u0011AN\u0005\u0003wV\nq\u0001]1dW\u0006<W-\u0003\u0002~}\n\u00191+Z9\u000b\u0005m,\u0004\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0007gR\fG/^:\u000b\u0007\u0005%\u0001&\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003\u001b\t\u0019AA\u0007SK2,\u0017m]3Ti\u0006$Xo]\u0001\u0010o&$\bNU3mK\u0006\u001cXmS5oIR\u0019\u0011,a\u0005\t\u000f\u0005U!\u00021\u0001\u0002\u0018\u0005!1.\u001b8e!\u0011\tI\"a\u0007\u000e\u0005\u0005\u001d\u0011\u0002BA\u000f\u0003\u000f\u00111BU3mK\u0006\u001cXmS5oI\u0006yq/\u001b;i)\u0006\u001c8\u000eV=qK:{G\u000fF\u0002Z\u0003GAq!!\n\f\u0001\u0004\t9#\u0001\u0005uCN\\G+\u001f9f!\u0011\tI#a\u000f\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\tqA]3gY\u0016\u001cGO\u0003\u0003\u00022\u0005M\u0012aA1qS*!\u0011QGA\u001c\u0003\u0019\u0001H.^4j]*\u0019\u0011\u0011\b\u0016\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!!\u0010\u0002,\t!A+\u001f9f\u000359\u0018\u000e\u001e5UCN\\G+\u001f9fgR\u0019\u0011,a\u0011\t\u000f\u0005\u0015C\u00021\u0001\u0002H\u0005IA/Y:l)f\u0004Xm\u001d\t\u0005or\f9#A\u000bxSRDwJ\\3PMR\u000b7o[*uCR,8/Z:\u0015\u0007e\u000bi\u0005\u0003\u0004v\u001b\u0001\u0007\u0011q\n\t\u0005or\f\t\u0006\u0005\u0003\u0002\u0002\u0005M\u0013\u0002BA+\u0003\u0007\u0011!\u0002V1tWN#\u0018\r^;t\u0003)9\u0018\u000e\u001e5GS2$XM\u001d\u000b\u00043\u0006m\u0003BBA/\u001d\u0001\u0007\u0001*\u0001\u0004gS2$XM]\u0001\no&$\b\u000eR1uKN$R!WA2\u0003oBq!!\u001a\u0010\u0001\u0004\t9'\u0001\u0003ge>l\u0007\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0005kRLGN\u0003\u0002\u0002r\u0005!!.\u0019<b\u0013\u0011\t)(a\u001b\u0003\t\u0011\u000bG/\u001a\u0005\b\u0003sz\u0001\u0019AA4\u0003\t!x.\u0001\fxSRD7k\u00195fIVdW\rZ*uCJ$H)\u0019;f)\rI\u0016q\u0010\u0005\b\u0003\u0003\u0003\u0002\u0019AA4\u0003\u0011!\u0017\r^3\u0002\u001b]LG\u000f[!os>3G+Y4t)\rI\u0016q\u0011\u0005\u0006\u0019F\u0001\r!P\u0001\u000eo&$\bNR8mI\u0016\u0014\u0018\nZ:\u0015\u0007e\u000bi\t\u0003\u0004\u0002\u0010J\u0001\r!P\u0001\nM>dG-\u001a:JIN\f\u0001c^5uQ\u0006\u001b8/[4oK\u0012$v.T3\u0015\u0007e\u000b)\nC\u0004\u0002\u0018N\u0001\r!!'\u0002\u0015A\u0014\u0018N\\2ja\u0006d7\u000f\u0005\u0003x\u00037C\u0015bAAO}\nA\u0011\n^3sC\ndW-A\rxSRD\u0017i]:jO:,G\rV8NK>\u0013X*\u001f+fC6\u001cH#B-\u0002$\u0006\u0015\u0006bBAL)\u0001\u0007\u0011\u0011\u0014\u0005\b\u0003O#\u0002\u0019AAM\u0003\u001d\u0011x\u000e\\3JIN\fQc^5uQ\u0006\u001b8/[4oK\u0012$v.\u00118zE>$\u0017\u0010F\u0004Z\u0003[\u000by+!-\t\u000f\u0005]U\u00031\u0001\u0002\u001a\"9\u0011qU\u000bA\u0002\u0005e\u0005bBAZ+\u0001\u0007\u0011QW\u0001\bSN\fE-\\5o!\r!\u0014qW\u0005\u0004\u0003s+$a\u0002\"p_2,\u0017M\\\u0001\u000eo&$\b.\u00118z\r\u0006\u001cW\r^:\u0002\u001b=\u0014H-\u001a:CsR\u000b7o[%e\u0003\u001d\u0011\u0017N\u001c3j]\u001e$2\u0001SAb\u0011\u001d\t)\r\u0007a\u0001\u0003\u000f\faA^1mk\u0016\u001c\b\u0003B<\u0002\u001cN\n\u0011B[8j]R+\u0017-\\:\u0015\u0005\u00055\u0007c\u0001\u001b\u0002P&\u0019\u0011\u0011[\u001b\u0003\tUs\u0017\u000e^\u0001\u0011U>Lg\u000eV3b[N$v\u000eV1tWN\fQB[8j]R+\u0017-\u001c*pY\u0016\u001c\u0018A\u00056pS:$V-Y7Qe&t7-\u001b9bYN\f1C[8j]R+\u0017-\u001c)fe6L7o]5p]N\f1B[8j]\u001a{G\u000eZ3sg\u0006Q!n\\5o\r\u0006\u001cW\r^:\u0002\u00179,w/\u00138ti\u0006t7-Z\u000b\u00023\u0002")
public class TasksSqlBuilder
extends SqlBuilder<TasksSqlBuilder> {
    public static String normalizeTag(String tag) {
        return TasksSqlBuilder$.MODULE$.normalizeTag(tag);
    }

    public static Set<String> normalizeTags(Set<String> tags) {
        return TasksSqlBuilder$.MODULE$.normalizeTags(tags);
    }

    public TasksSqlBuilder selectTaskId() {
        return (TasksSqlBuilder)super.select(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT\n         |  DISTINCT tasks." + Schema.TASKS$.MODULE$.TASK_ID() + "\n         |FROM\n         |  " + Schema.TASKS$.MODULE$.TABLE() + " tasks\n         |  JOIN " + Schema.RELEASES$.MODULE$.TABLE() + " releases ON tasks." + Schema.TASKS$.MODULE$.RELEASE_UID() + " = releases." + Schema.RELEASES$.MODULE$.CI_UID() + "\n         ")));
    }

    public TasksSqlBuilder withOneOfReleaseStatuses(Seq<ReleaseStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql("releases." + Schema.RELEASES$.MODULE$.STATUS() + " IN (" + this.binding((Iterable<Object>)statuses) + ")", (Iterable)statuses.map((Function1 & Serializable)x$1 -> x$1.value()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withReleaseKind(ReleaseKind kind) {
        this.conditions().$plus$eq((Object)new package.Sql("releases." + Schema.RELEASES$.MODULE$.KIND() + " = ?", (Iterable)new .colon.colon((Object)kind.value(), (List)Nil$.MODULE$)));
        return this;
    }

    public TasksSqlBuilder withTaskTypeNot(Type taskType) {
        this.conditions().$plus$eq((Object)new package.Sql("tasks." + Schema.TASKS$.MODULE$.TASK_TYPE() + " != ?", (Iterable)new .colon.colon((Object)taskType.toString(), (List)Nil$.MODULE$)));
        return this;
    }

    public TasksSqlBuilder withTaskTypes(Seq<Type> taskTypes) {
        this.conditions().$plus$eq((Object)new package.Sql("tasks." + Schema.TASKS$.MODULE$.TASK_TYPE() + " IN (" + this.binding((Iterable<Object>)taskTypes) + ")", (Iterable)taskTypes.map((Function1 & Serializable)x$2 -> x$2.toString())));
        return this;
    }

    public TasksSqlBuilder withOneOfTaskStatuses(Seq<TaskStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql("tasks." + Schema.TASKS$.MODULE$.STATUS() + " IN (" + this.binding((Iterable<Object>)statuses) + ")", (Iterable)statuses.map((Function1 & Serializable)x$3 -> x$3.value()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withFilter(String filter) {
        Object object = filter != null ? this.likeOr((Seq)new .colon.colon((Object)("tasks." + Schema.TASKS$.MODULE$.TITLE()), (List)new .colon.colon((Object)("tasks." + Schema.TASKS$.MODULE$.OWNER()), (List)new .colon.colon((Object)("tasks." + Schema.TASKS$.MODULE$.TEAM()), (List)new .colon.colon((Object)("releases." + Schema.RELEASES$.MODULE$.RELEASE_TITLE()), (List)Nil$.MODULE$)))), filter) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withDates(Date from, Date to) {
        Object object;
        if (from != null && to != null) {
            object = this.conditions().$plus$eq((Object)new package.Sql("(? <= tasks." + Schema.TASKS$.MODULE$.START_DATE() + " OR ? <= tasks." + Schema.TASKS$.MODULE$.END_DATE() + ") AND tasks." + Schema.TASKS$.MODULE$.START_DATE() + " < ?", (Iterable)new .colon.colon((Object)from, (List)new .colon.colon((Object)from, (List)new .colon.colon((Object)to, (List)Nil$.MODULE$)))));
        } else {
            Object object2 = from != null ? this.conditions().$plus$eq((Object)new package.Sql("(? <= tasks." + Schema.TASKS$.MODULE$.START_DATE() + " OR ? <= tasks." + Schema.TASKS$.MODULE$.END_DATE() + ")", (Iterable)new .colon.colon((Object)from, (List)new .colon.colon((Object)from, (List)Nil$.MODULE$)))) : BoxedUnit.UNIT;
            object = to != null ? this.conditions().$plus$eq((Object)new package.Sql("tasks." + Schema.TASKS$.MODULE$.START_DATE() + " < ?", (Iterable)new .colon.colon((Object)to, (List)Nil$.MODULE$))) : BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withScheduledStartDate(Date date) {
        this.conditions().$plus$eq((Object)new package.Sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |tasks." + Schema.TASKS$.MODULE$.START_DATE() + " = ?\n         |")), (Iterable)new .colon.colon((Object)new Date(Predef$.MODULE$.Long2long(DateVariableUtils.truncateMilliseconds((Long)Predef$.MODULE$.long2Long(date.getTime())))), (List)Nil$.MODULE$)));
        return this;
    }

    public TasksSqlBuilder withAnyOfTags(Set<String> tags) {
        BoxedUnit boxedUnit;
        Set<String> normalizedTags = TasksSqlBuilder$.MODULE$.normalizeTags(tags);
        if (normalizedTags.nonEmpty()) {
            String sql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |tasks." + Schema.TASKS$.MODULE$.CI_UID() + " IN (\n           |  SELECT DISTINCT task_tags." + Schema.TASK_TAGS$.MODULE$.CI_UID() + "\n           |  FROM " + Schema.TASK_TAGS$.MODULE$.TABLE() + " task_tags\n           |  WHERE task_tags." + Schema.TASK_TAGS$.MODULE$.VALUE() + " IN (" + this.binding((Iterable<Object>)normalizedTags) + ")\n           |)\n           |"));
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(sql, normalizedTags));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withFolderIds(Set<String> folderIds) {
        BoxedUnit boxedUnit;
        Set normalizedFolderIds = (Set)folderIds.map((Function1 & Serializable)x$1 -> Ids.getName((String)x$1));
        if (normalizedFolderIds.nonEmpty()) {
            this.joinFolders();
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql("folders." + Schema.FOLDERS$.MODULE$.FOLDER_ID() + " IN (" + this.binding((Iterable<Object>)normalizedFolderIds) + ")", (Iterable)normalizedFolderIds));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMe(Iterable<String> principals) {
        BoxedUnit boxedUnit;
        if (principals.nonEmpty()) {
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql("LOWER(tasks." + Schema.TASKS$.MODULE$.OWNER() + ") IN (" + this.binding(principals) + ")", (Iterable)principals.map((Function1 & Serializable)x$4 -> x$4.toLowerCase())));
        } else {
            this.nothingToBeFound_$eq(true);
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMeOrMyTeams(Iterable<String> principals, Iterable<String> roleIds) {
        this.joinTeamsToTasks();
        Seq orConditions = (Seq)Nil$.MODULE$;
        if (principals.nonEmpty()) {
            orConditions = (Seq)orConditions.$plus$plus((IterableOnce)new .colon.colon((Object)new package.Sql("LOWER(tasks." + Schema.TASKS$.MODULE$.OWNER() + ") IN (" + this.binding(principals) + ")", (Iterable)principals.map((Function1 & Serializable)x$5 -> x$5.toLowerCase())), (List)Nil$.MODULE$));
            orConditions = (Seq)orConditions.$plus$plus((IterableOnce)new .colon.colon((Object)new package.Sql("teams." + SecuritySchema.ROLES$.MODULE$.id() + " IN (SELECT " + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId() + " FROM " + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE() + " assignedToMeOrTeamsPrincipals WHERE " + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId() + " LIKE 'Team%' AND LOWER(assignedToMeOrTeamsPrincipals." + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.principalName() + ") IN (" + this.binding(principals) + "))", (Iterable)principals.map((Function1 & Serializable)x$6 -> x$6.toLowerCase())), (List)Nil$.MODULE$));
        }
        if (roleIds.nonEmpty()) {
            orConditions = (Seq)orConditions.$plus$plus((IterableOnce)new .colon.colon((Object)new package.Sql("teams." + SecuritySchema.ROLES$.MODULE$.id() + " IN (SELECT " + SecuritySchema.ROLE_ROLES$.MODULE$.roleId() + " FROM " + SecuritySchema.ROLE_ROLES$.MODULE$.TABLE() + " assignedToMeOrTeamsRoles WHERE assignedToMeOrTeamsRoles." + SecuritySchema.ROLE_ROLES$.MODULE$.memberRoleId() + " IN (" + this.binding(roleIds) + "))", roleIds), (List)Nil$.MODULE$));
        }
        Growable growable = orConditions.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql("(" + ((IterableOnceOps)orConditions.map((Function1 & Serializable)c -> "(" + c.sql() + ")")).mkString(" OR ") + ")", (Iterable)orConditions.flatMap((Function1 & Serializable)x$7 -> x$7.parameters()))) : this.conditions().$plus$eq((Object)new package.Sql("(1 = 0)", (Iterable)Nil$.MODULE$));
        return this;
    }

    public TasksSqlBuilder withAssignedToAnybody(Iterable<String> principals, Iterable<String> roleIds, boolean isAdmin) {
        BoxedUnit boxedUnit;
        if (!isAdmin) {
            Seq orConditions = (Seq)Nil$.MODULE$;
            if (roleIds.nonEmpty()) {
                orConditions = (Seq)orConditions.$plus$plus((IterableOnce)new .colon.colon((Object)new package.Sql("(assignedToTeamRoles.MEMBER_ROLE_ID IN (" + this.binding(roleIds) + "))", roleIds), (List)Nil$.MODULE$));
            }
            if (principals.nonEmpty()) {
                orConditions = (Seq)orConditions.$plus$plus((IterableOnce)new .colon.colon((Object)new package.Sql("(LOWER(assignedToTeamPrincipals.PRINCIPAL_NAME) IN (" + this.binding(principals) + "))", (Iterable)principals.map((Function1 & Serializable)x$8 -> x$8.toLowerCase())), (List)Nil$.MODULE$));
            }
            boxedUnit = orConditions.isEmpty() ? this.conditions().$plus$eq((Object)new package.Sql("(1 = 0)", (Iterable)Nil$.MODULE$)) : this.conditions().$plus$eq((Object)new package.Sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("releases." + Schema.RELEASES$.MODULE$.SECURITY_UID() + " IN (\n             |  SELECT assignedToTeams." + SecuritySchema.ROLES$.MODULE$.ciId() + " FROM " + SecuritySchema.ROLES$.MODULE$.TABLE() + " assignedToTeams\n             |  JOIN " + SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE() + " assignedToTeamPermissions ON assignedToTeams." + SecuritySchema.ROLES$.MODULE$.id() + " = assignedToTeamPermissions." + SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId() + "\n             |  LEFT JOIN " + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE() + " assignedToTeamPrincipals ON assignedToTeams." + SecuritySchema.ROLES$.MODULE$.id() + " = assignedToTeamPrincipals." + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId() + "\n             |  LEFT JOIN " + SecuritySchema.ROLE_ROLES$.MODULE$.TABLE() + " assignedToTeamRoles ON assignedToTeams." + SecuritySchema.ROLES$.MODULE$.id() + " = assignedToTeamRoles." + SecuritySchema.ROLE_ROLES$.MODULE$.roleId() + "\n             |  WHERE assignedToTeamPermissions." + SecuritySchema.ROLE_PERMISSIONS$.MODULE$.permissionName() + " = '" + XLReleasePermissions.VIEW_RELEASE.getPermissionName() + "' AND (" + ((IterableOnceOps)orConditions.map((Function1 & Serializable)x$9 -> x$9.sql())).mkString(" OR ") + "))")), (Iterable)orConditions.flatMap((Function1 & Serializable)x$10 -> x$10.parameters())));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAnyFacets() {
        this.joinFacets();
        return this;
    }

    public TasksSqlBuilder orderByTaskId() {
        this.orderBy("tasks." + Schema.TASKS$.MODULE$.TASK_ID());
        return this;
    }

    private String binding(Iterable<Object> values) {
        return ((IterableOnceOps)values.toSeq().map((Function1 & Serializable)x$11 -> "?")).mkString(",");
    }

    private void joinTeams() {
        this.addJoin("JOIN " + SecuritySchema.ROLES$.MODULE$.TABLE() + " teams ON releases." + Schema.RELEASES$.MODULE$.SECURITY_UID() + " = teams." + SecuritySchema.ROLES$.MODULE$.ciId());
    }

    private void joinTeamsToTasks() {
        this.addJoin("LEFT JOIN " + SecuritySchema.ROLES$.MODULE$.TABLE() + " teams ON releases." + Schema.RELEASES$.MODULE$.SECURITY_UID() + " = teams." + SecuritySchema.ROLES$.MODULE$.ciId() + " AND tasks." + Schema.TASKS$.MODULE$.TEAM() + " = teams." + SecuritySchema.ROLES$.MODULE$.name());
    }

    private void joinTeamRoles() {
        this.addJoin("LEFT JOIN " + SecuritySchema.ROLE_ROLES$.MODULE$.TABLE() + " teamRoles ON teams." + SecuritySchema.ROLES$.MODULE$.id() + " = teamRoles." + SecuritySchema.ROLE_ROLES$.MODULE$.roleId());
    }

    private void joinTeamPrincipals() {
        this.addJoin("LEFT JOIN " + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE() + " teamPrincipals ON teams." + SecuritySchema.ROLES$.MODULE$.id() + " = teamPrincipals." + SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId());
    }

    private void joinTeamPermissions() {
        this.addJoin("JOIN " + SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE() + " teamPermissions ON teams." + SecuritySchema.ROLES$.MODULE$.id() + " = teamPermissions." + SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId());
    }

    private void joinFolders() {
        this.addJoin("JOIN " + Schema.FOLDERS$.MODULE$.TABLE() + " folders ON releases." + Schema.RELEASES$.MODULE$.FOLDER_CI_UID() + " = folders." + Schema.FOLDERS$.MODULE$.CI_UID());
    }

    private void joinFacets() {
        this.addJoin("JOIN " + Schema.FACETS$.MODULE$.TABLE() + " facets ON tasks." + Schema.TASKS$.MODULE$.CI_UID() + " = facets." + Schema.FACETS$.MODULE$.APPLIED_TO_TASK_UID());
    }

    public TasksSqlBuilder newInstance() {
        return new TasksSqlBuilder(super.dialect());
    }

    public TasksSqlBuilder(SqlBuilder.Dialect dialect) {
        super(dialect);
    }
}

