/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r-d\u0001B\u0016-\u0001]B\u0001\"\u0018\u0001\u0003\u0006\u0004%\tA\u0018\u0005\tK\u0002\u0011\t\u0011)A\u0005?\"Aa\r\u0001BC\u0002\u0013\u0005q\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003i\u0011!a\u0007A!b\u0001\n\u0003i\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u00028\t\u0011I\u0004!Q1A\u0005\u0002MD\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\tq\u0002\u0011)\u0019!C\u0001s\"AQ\u0010\u0001B\u0001B\u0003%!\u0010\u0003\u0005\u007f\u0001\t\u0015\r\u0011\"\u0001\u0000\u0011)\ti\u0001\u0001B\u0001B\u0003%\u0011\u0011\u0001\u0005\u000b\u0003\u001f\u0001!Q1A\u0005\u0002\u0005E\u0001BCA\r\u0001\t\u0005\t\u0015!\u0003\u0002\u0014!Q\u00111\u0004\u0001\u0003\u0006\u0004%\u0019!!\b\t\u0015\u00055\u0003A!A!\u0002\u0013\ty\u0002C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h!9\u0011Q\r\u0001\u0005B\u0005\u0015\u0006bBAd\u0001\u0011\u0005\u0013\u0011\u001a\u0005\b\u0003{\u0004A\u0011IA\u0000\u0011\u001d\u0011i\u0001\u0001C!\u0005\u001fAqAa\u0006\u0001\t\u0003\u0012I\u0002C\u0004\u0003:\u0001!\tEa\u000f\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D!9!q\t\u0001\u0005B\t%\u0003b\u0002B+\u0001\u0011\u0005#q\u000b\u0005\b\u0005O\u0002A\u0011\tB5\u0011\u001d\u0011y\u0007\u0001C!\u0005cBqAa\u001e\u0001\t\u0013\u0011I\bC\u0004\u0003\u0000\u0001!\tE!!\t\u000f\t\u001d\u0005\u0001\"\u0011\u0003\n\"9!1\u0015\u0001\u0005B\t\u0015\u0006b\u0002B]\u0001\u0011\u0005#1\u0018\u0005\b\u0005\u007f\u0003A\u0011\tBa\u0011\u001d\u0011I\r\u0001C!\u0005\u0017DqAa8\u0001\t\u0003\u0012\t\u000fC\u0004\u0003z\u0002!\tE!9\t\u000f\t}\b\u0001\"\u0011\u0004\u0002!91Q\u0003\u0001\u0005B\r]\u0001bBB\u0014\u0001\u0011\u00053\u0011\u0006\u0005\b\u00073\u0002A\u0011IB.\u0005E\u0019\u0016\u000f\u001c+bg.\u0014V\r]8tSR|'/\u001f\u0006\u0003[9\n1a]9m\u0015\ty\u0003'\u0001\u0006sKB|7/\u001b;pefT!!\r\u001a\u0002\u0013ad'/\u001a7fCN,'BA\u001a5\u0003%AXMY5bY\u0006\u00147OC\u00016\u0003\r\u0019w.\\\u0002\u0001'!\u0001\u0001H\u0010\"M\u001fJ+\u0006CA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$AB!osJ+g\r\u0005\u0002@\u00016\ta&\u0003\u0002B]\tqA+Y:l%\u0016\u0004xn]5u_JL\bcA\"E\r6\tA&\u0003\u0002FY\t)\u0012J\u001c;fe\u000e,\u0007\u000f^3e%\u0016\u0004xn]5u_JL\bCA$K\u001b\u0005A%BA%1\u0003\u0019!w.\\1j]&\u00111\n\u0013\u0002\u0005)\u0006\u001c8\u000e\u0005\u0002D\u001b&\u0011a\n\f\u0002\u001a\u0005\u0006\u001cXMU3mK\u0006\u001cX-\u0013;f[J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002D!&\u0011\u0011\u000b\f\u0002\u0017\t\u0016\u001cXM]5bY&T\u0018\r^5p]N+\b\u000f]8siB\u00111iU\u0005\u0003)2\u0012adQ8oM&<WO]1uS>t'+\u001a4fe\u0016t7-Z:TkB\u0004xN\u001d;\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016!B:mMRR'\"\u0001.\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001X,\u0003\u000f1{wmZ5oO\u0006\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f+\u0005y\u0006C\u00011d\u001b\u0005\t'B\u00012-\u0003-\u0001XM]:jgR,gnY3\n\u0005\u0011\f'A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\f1C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0002\nQ\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-F\u0001i!\t\u0001\u0017.\u0003\u0002kC\n)B)\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u00063fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-\u001a\u0011\u0002\u001fQ\f7o\u001b)feNL7\u000f^3oG\u0016,\u0012A\u001c\t\u0003A>L!\u0001]1\u0003\u001fQ\u000b7o\u001b)feNL7\u000f^3oG\u0016\f\u0001\u0003^1tWB+'o]5ti\u0016t7-\u001a\u0011\u0002#\r|W.\\3oiJ+\u0007o\\:ji>\u0014\u00180F\u0001u!\tyT/\u0003\u0002w]\t\t2i\\7nK:$(+\u001a9pg&$xN]=\u0002%\r|W.\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014X#\u0001>\u0011\u0005\r[\u0018B\u0001?-\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0006\u0011\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:!\u0003a\u0019wN\u001c4jOV\u0014\u0018\r^5p]B+'o]5ti\u0016t7-Z\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f\t\u0017!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002\f\u0005\u0015!!I\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017!G2p]\u001aLw-\u001e:bi&|g\u000eU3sg&\u001cH/\u001a8dK\u0002\n\u0011DZ1dKR\u0014V\r]8tSR|'/\u001f#jgB\fGo\u00195feV\u0011\u00111\u0003\t\u0004\u007f\u0005U\u0011bAA\f]\tIb)Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s\u0003i1\u0017mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:!\u0003\u001d!\u0017.\u00197fGR,\"!a\b\u0011\t\u0005\u0005\u0012q\t\b\u0005\u0003G\t\tE\u0004\u0003\u0002&\u0005ub\u0002BA\u0014\u0003sqA!!\u000b\u000289!\u00111FA\u001b\u001d\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019m\u00051AH]8pizJ\u0011!N\u0005\u0003gQJ!!\r\u001a\n\u0007\u0005m\u0002'\u0001\u0002eE&\u0019Q&a\u0010\u000b\u0007\u0005m\u0002'\u0003\u0003\u0002D\u0005\u0015\u0013AC*rY\n+\u0018\u000e\u001c3fe*\u0019Q&a\u0010\n\t\u0005%\u00131\n\u0002\b\t&\fG.Z2u\u0015\u0011\t\u0019%!\u0012\u0002\u0011\u0011L\u0017\r\\3di\u0002\na\u0001P5oSRtDCEA*\u0003+\n9&!\u0017\u0002\\\u0005u\u0013qLA1\u0003G\u0002\"a\u0011\u0001\t\u000bu\u000b\u0002\u0019A0\t\u000b\u0019\f\u0002\u0019\u00015\t\u000b1\f\u0002\u0019\u00018\t\u000bI\f\u0002\u0019\u0001;\t\u000ba\f\u0002\u0019\u0001>\t\ry\f\u0002\u0019AA\u0001\u0011\u001d\ty!\u0005a\u0001\u0003'Aq!a\u0007\u0012\u0001\b\ty\"\u0001\u0005gS:$')_%e+\u0011\tI'a\u001c\u0015\t\u0005-\u00141\u0010\t\u0005\u0003[\ny\u0007\u0004\u0001\u0005\u000f\u0005E$C1\u0001\u0002t\t\tA+E\u0002\u0002v\u0019\u00032!OA<\u0013\r\tIH\u000f\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\tiH\u0005a\u0001\u0003\u007f\na\u0001^1tW&#\u0007\u0003BAA\u0003\u0013sA!a!\u0002\u0006B\u0019\u0011Q\u0006\u001e\n\u0007\u0005\u001d%(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\u000biI\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000fS\u0004f\u0001\n\u0002\u0012B!\u00111SAQ\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006e\u0015AC1o]>$\u0018\r^5p]*!\u00111TAO\u0003\u001diW\r\u001e:jGNT1!a(5\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAR\u0003+\u0013Q\u0001V5nK\u0012,B!a*\u0002,R1\u0011\u0011VAW\u0003_\u0003B!!\u001c\u0002,\u00129\u0011\u0011O\nC\u0002\u0005M\u0004bBA?'\u0001\u0007\u0011q\u0010\u0005\b\u0003c\u001b\u0002\u0019AAZ\u00039\u0011Xm]8mm\u0016|\u0005\u000f^5p]N\u0004B!!.\u0002B6\u0011\u0011q\u0017\u0006\u0004_\u0005e&\u0002BA^\u0003{\u000bAA[:p]*\u0019\u0011q\u0018\u0019\u0002\u001bM,'/[1mSj\fG/[8o\u0013\u0011\t\u0019-a.\u0003\u001dI+7o\u001c7wK>\u0003H/[8og\"\u001a1#!%\u0002%\u0019Lg\u000e\u001a+bg.\u001c()Y:jG\u0012\u000bG/\u0019\u000b\u0005\u0003\u0017\f9\u000f\u0005\u0004\u0002N\u0006]\u00171\\\u0007\u0003\u0003\u001fTA!!5\u0002T\u0006!Q\u000f^5m\u0015\t\t).\u0001\u0003kCZ\f\u0017\u0002BAm\u0003\u001f\u0014A\u0001T5tiB!\u0011Q\\Ar\u001b\t\tyNC\u0002\u0002b:\nQ!];fefLA!!:\u0002`\niA+Y:l\u0005\u0006\u001c\u0018n\u0019#bi\u0006Dq!!;\u0015\u0001\u0004\tY/A\u0004uCN\\\u0017\nZ:\u0011\r\u00055\u0017q[A@Q\r!\u0012q\u001e\t\u0005\u0003c\f90\u0004\u0002\u0002t*!\u0011Q_A#\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005e\u00181\u001f\u0002\u000b\u0013N\u0014V-\u00193P]2L\bf\u0001\u000b\u0002\u0012\u00061Q\r_5tiN$BA!\u0001\u0003\bA\u0019\u0011Ha\u0001\n\u0007\t\u0015!HA\u0004C_>dW-\u00198\t\u000f\u0005uT\u00031\u0001\u0002\u0000!\u001aQ#a<)\u0007U\t\t*\u0001\u0004va\u0012\fG/\u001a\u000b\u0004\r\nE\u0001B\u0002B\n-\u0001\u0007a)\u0001\u0003uCN\\\u0007f\u0001\f\u0002\u0012\u0006YQ\u000f\u001d3bi\u0016$\u0016m]6t)\u0011\u0011YB!\t\u0011\u0007e\u0012i\"C\u0002\u0003 i\u0012A!\u00168ji\"9!1E\fA\u0002\t\u0015\u0012!\u0002;bg.\u001c\b\u0003B\u001d\u0003(\u0019K1A!\u000b;\u0005)a$/\u001a9fCR,GM\u0010\u0015\u0004/\t5\u0002\u0003\u0002B\u0018\u0005gi!A!\r\u000b\u0007\u0005]%(\u0003\u0003\u00036\tE\"a\u0002<be\u0006\u0014xm\u001d\u0015\u0004/\u0005E\u0015\u0001F;qI\u0006$X\rV1tWB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0003\u001c\tu\u0002B\u0002B\n1\u0001\u0007a\tK\u0002\u0019\u0003#\u000bA$\u001e9eCR,G+Y:l!J|\u0007/\u001a:uS\u0016\u001c\u0018J\u001c;fe:\fG\u000e\u0006\u0003\u0003\u001c\t\u0015\u0003B\u0002B\n3\u0001\u0007a)A\rcCR\u001c\u0007.\u00169eCR,G+Y:l!J|\u0007/\u001a:uS\u0016\u001cH\u0003\u0002B\u000e\u0005\u0017BqAa\t\u001b\u0001\u0004\u0011i\u0005E\u0003\u0002\u0002\n=c)\u0003\u0003\u0003R\u00055%aA*fi\"\u001a!$!%\u0002=U\u0004H-\u0019;f)\u0006\u001c8.\u00118e%\u0016dW-Y:f\r2\fwm\u0015;biV\u001cH#\u0002$\u0003Z\tm\u0003B\u0002B\n7\u0001\u0007a\tC\u0004\u0003^m\u0001\rAa\u0018\u0002\u000fI,G.Z1tKB\u0019qI!\u0019\n\u0007\t\r\u0004JA\u0004SK2,\u0017m]3)\u0007m\t\t*\u0001\u0006va\u0012\fG/\u001a+za\u0016$2A\u0012B6\u0011\u0019\u0011\u0019\u0002\ba\u0001\r\"\u001aA$!%\u0002\r\u0011,G.\u001a;f)\u0011\u0011YBa\u001d\t\r\tMQ\u00041\u0001GQ\ri\u0012\u0011S\u0001\u000bGJ,\u0017\r^3UCN\\Gc\u0001$\u0003|!1!Q\u0010\u0010A\u0002\u0019\u000bqA\\3x)\u0006\u001c8.\u0001\u0004de\u0016\fG/\u001a\u000b\u0004\r\n\r\u0005B\u0002B??\u0001\u0007a\tK\u0002 \u0003#\u000b\u0001\"\\8wKR\u000b7o\u001b\u000b\n\r\n-%q\u0012BJ\u0005;CaA!$!\u0001\u00041\u0015A\u0003;bg.$v.T8wK\"1!\u0011\u0013\u0011A\u0002\u0019\u000b\u0011\"\\8wK\u0012$\u0016m]6\t\u000f\tU\u0005\u00051\u0001\u0003\u0018\u00061R\u000f\u001d3bi\u0016$wJ]5hS:\u001cuN\u001c;bS:,'\u000fE\u0002H\u00053K1Aa'I\u00055!\u0016m]6D_:$\u0018-\u001b8fe\"9!q\u0014\u0011A\u0002\t]\u0015AF;qI\u0006$X\r\u001a+be\u001e,GoQ8oi\u0006Lg.\u001a:)\u0007\u0001\n\t*\u0001\fgS:$\u0017I\u001a4fGR,GMQ=CY\u0006\u001c7n\\;u)\u0011\tYOa*\t\u000f\t%\u0016\u00051\u0001\u0003,\u0006A!\r\\1dW>,H\u000f\u0005\u0003\u0003.\nMVB\u0001BX\u0015\r\u0011\t\fS\u0001\tG\u0006dWM\u001c3be&!!Q\u0017BX\u0005!\u0011E.Y2l_V$\bfA\u0011\u0002\u0012\u0006Qb-\u001b8e!\u0016tG-\u001b8h)\u0006\u001c8n],ji\"4\u0015mY3ugR\u0011\u00111\u001e\u0015\u0004E\u0005E\u0015\u0001C4fiRKG\u000f\\3\u0015\t\u0005}$1\u0019\u0005\b\u0003{\u001a\u0003\u0019AA@Q\r\u0019\u0013q\u001e\u0015\u0004G\u0005E\u0015AC4fi\u0006cG\u000eV1hgR!!Q\u001aBi!\u0019\tiMa4\u0002\u0000%!!\u0011KAh\u0011\u001d\u0011\u0019\u000e\na\u0001\u0005+\f1\u0002\\5nSRtU/\u001c2feB\u0019\u0011Ha6\n\u0007\te'HA\u0002J]RD3\u0001JAxQ\r!\u0013\u0011S\u0001\u0013M&tGm\u0014<fe\u0012,X\rV1tW&#7\u000f\u0006\u0002\u0003dB1!Q\u001dBx\u0003\u007frAAa:\u0003l:!\u0011Q\u0006Bu\u0013\u0005Y\u0014b\u0001Bwu\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002By\u0005g\u00141aU3r\u0015\r\u0011iO\u000f\u0015\u0004K\u0005=\bfA\u0013\u0002\u0012\u0006\u0011b-\u001b8e\tV,7k\\8o)\u0006\u001c8.\u00133tQ\r1\u0013q\u001e\u0015\u0004M\u0005E\u0015!C4fiN#\u0018\r^;t)\u0011\u0019\u0019aa\u0004\u0011\t\r\u001511B\u0007\u0003\u0007\u000fQ1a!\u0003I\u0003\u0019\u0019H/\u0019;vg&!1QBB\u0004\u0005)!\u0016m]6Ti\u0006$Xo\u001d\u0005\b\u0003{:\u0003\u0019AA@Q\r9\u0013q\u001e\u0015\u0004O\u0005E\u0015aD4fiR\u000b7o[*uCR,8/Z:\u0015\t\re1q\u0004\t\t\u0003\u001b\u001cY\"a \u0004\u0004%!1QDAh\u0005\ri\u0015\r\u001d\u0005\b\u0007CA\u0003\u0019AA@\u0003%\u0011X\r\\3bg\u0016LE\rK\u0002)\u0003_D3\u0001KAI\u0003\u001d2\u0017N\u001c3UCN\\\u0017\nZ:CsR\u000b7o\u001b+za\u0016\u001cF/\u0019;vg\u0006sGm\u0015;beR$\u0015\r^3\u0015\u0011\t\r81FB$\u0007\u0017Bqa!\f*\u0001\u0004\u0019y#\u0001\u0005uCN\\G+\u001f9f!\u0011\u0019\tda\u0011\u000e\u0005\rM\"\u0002BB\u001b\u0007o\tqA]3gY\u0016\u001cGO\u0003\u0003\u0004:\rm\u0012aA1qS*!1QHB \u0003\u0019\u0001H.^4j]*\u00191\u0011\t\u001a\u0002\u0011\u0011,\u0007\u000f\\8zSRLAa!\u0012\u00044\t!A+\u001f9f\u0011\u001d\u0019I%\u000ba\u0001\u0007\u0007\t!\u0002^1tWN#\u0018\r^;t\u0011\u001d\u0019i%\u000ba\u0001\u0007\u001f\nQb\u001d;beR,GMQ3g_J,\u0007\u0003BAg\u0007#JAaa\u0015\u0002P\n!A)\u0019;fQ\rI\u0013q\u001e\u0015\u0004S\u0005E\u0015\u0001F;qI\u0006$X\rV1tWN#\u0018\r^;t\u0019&tW\r\u0006\u0004\u0003\u001c\ru3q\f\u0005\b\u0003{R\u0003\u0019AA@\u0011\u001d\u0019\tG\u000ba\u0001\u0003\u007f\n!b\u001d;biV\u001cH*\u001b8fQ\r\u00011Q\r\t\u0005\u0003c\u001c9'\u0003\u0003\u0004j\u0005M(aD%t)J\fgn]1di&|g.\u00197")
public class SqlTaskRepository
implements TaskRepository,
InterceptedRepository<Task>,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Task>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Task> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public TaskBasicData findTaskBasicData(String taskId) throws NotFoundException {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Task>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Task>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public void updateTasks(Task ... tasks) {
        this.updateTasks((scala.collection.immutable.Seq<Task>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tasks));
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, ResolveOptions$.MODULE$.WITH_DECORATORS());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException("Repository entity [" + taskId + "] not found", new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [" + taskId + "] not found in release", new Object[0]);
        }, (Function1 & Serializable)task -> {
            task.getAllTasks().forEach(t -> this.commentRepository().decorate(t));
            return task;
        }));
    }

    @Timed
    @IsReadOnly
    public java.util.List<TaskBasicData> findTasksBasicData(java.util.List<String> taskIds) {
        if (taskIds.isEmpty()) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        }
        scala.collection.immutable.Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala());
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala().map((Function1 & Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))))).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TaskRow data = (TaskRow)some.value();
                    return new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id));
                }
            }
            return None$.MODULE$;
        })).asJava();
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> "Checking if exists task [" + taskId + "]");
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.interceptUpdate((ConfigurationItem)task);
        this.releasePersistence().update(release);
        this.updateTaskPropertiesInternal(task);
        this.updateConfigurationRefs((CiWithUid)release);
        this.afterUpdate((ConfigurationItem)task);
        return task;
    }

    @Timed
    public void updateTasks(scala.collection.immutable.Seq<Task> tasks) {
        tasks.groupBy((Function1 & Serializable)x$1 -> x$1.getRelease()).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTasks$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.interceptUpdate((ConfigurationItem)task);
        this.updateTaskPropertiesInternal(task);
        this.afterUpdate((ConfigurationItem)task);
    }

    private void updateTaskPropertiesInternal(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskPropertiesInternal$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void batchUpdateTaskProperties(scala.collection.immutable.Set<Task> tasks) {
        tasks.foreach((Function1 & Serializable)ci -> {
            this.interceptUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
        this.taskPersistence().batchUpdateTaskProperties(tasks);
        Tuple2 tuple2 = ((IterableOps)tasks.flatMap((Function1 & Serializable)x$2 -> syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(x$2)))).partition((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isArchived()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Set archivedDeps = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set otherDeps = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)archivedDeps, (Object)otherDeps);
        scala.collection.immutable.Set archivedDeps2 = (scala.collection.immutable.Set)tuple22._1();
        scala.collection.immutable.Set otherDeps2 = (scala.collection.immutable.Set)tuple22._2();
        this.dependencyPersistence().batchDeleteDependencies((scala.collection.immutable.Set<Dependency>)archivedDeps2);
        this.dependencyPersistence().batchUpdateDependencies((scala.collection.immutable.Set<Dependency>)otherDeps2);
        tasks.foreach((Function1 & Serializable)ci -> {
            this.afterUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    @Timed
    public Task updateType(Task task) {
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return updated;
    }

    @Timed
    public void delete(Task task) {
        String taskId = task.getId();
        this.checkIsNotReferencedByDependencies(taskId);
        this.interceptDelete(taskId);
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs((CiWithUid)task.getRelease());
        this.afterDelete(taskId);
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(newTask2.getAllTasks()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$5)))).map((Function1 & Serializable)newTask -> this.createTask((Task)newTask)) : BoxedUnit.UNIT;
        return newTask2;
    }

    @Timed
    public Task create(Task newTask) {
        this.interceptCreate((ConfigurationItem)newTask);
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(newTask.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        this.afterCreate((ConfigurationItem)createdTask);
        return createdTask;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            CollectionConverters$.MODULE$.ListHasAsScala(taskToMove.getAllTasks()).asScala().foreach((Function1 & Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public java.util.List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)ReleaseStatus.ACTIVE_STATUSES)).build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)releaseData -> this.tryDeserializeRelease((ReleaseRow)releaseData))).flatMap((Function1 & Serializable)rel -> CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala())).filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable)x$6 -> x$6.getId())).asJava();
    }

    @Timed
    public java.util.List<String> findPendingTasksWithFacets() {
        Tuple2 sqlWithParams = new TasksSqlBuilder(this.dialect()).selectTaskId().withOneOfTaskStatuses((scala.collection.immutable.Seq<TaskStatus>)new .colon.colon((Object)TaskStatus.PENDING, (List)Nil$.MODULE$)).withAnyFacets().build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.taskPersistence().findTaskIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSet().toList()).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.taskPersistence().findAllTags(limitNumber)).asJava();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueTaskIds() {
        return this.taskPersistence().findOverdueTaskIds();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findDueSoonTaskIds() {
        return this.taskPersistence().findDueSoonTaskIds();
    }

    @Timed
    @IsReadOnly
    public TaskStatus getStatus(String taskId) {
        return (TaskStatus)this.taskPersistence().getStatus(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("getStatus: could not find task '" + taskId + "'", new Object[0]);
        });
    }

    @Timed
    @IsReadOnly
    public Map<String, TaskStatus> getTaskStatuses(String releaseId) {
        return this.taskPersistence().getTaskStatuses(releaseId);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findTaskIdsByTaskTypeStatusAndStartDate(Type taskType, TaskStatus taskStatus, Date startedBefore) {
        return this.taskPersistence().findTaskIdsByTaskTypeStatusAndStartDate(taskType, taskStatus, startedBefore);
    }

    public void updateTaskStatusLine(String taskId, String statusLine) {
        this.taskPersistence().updateStatusLine(taskId, statusLine);
    }

    public static final /* synthetic */ void $anonfun$updateTasks$2(SqlTaskRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Release release = (Release)tuple2._1();
            scala.collection.immutable.Seq tasks = (scala.collection.immutable.Seq)tuple2._2();
            tasks.foreach((Function1 & Serializable)ci -> {
                $this.interceptUpdate((ConfigurationItem)ci);
                return BoxedUnit.UNIT;
            });
            $this.releasePersistence().update(release);
            tasks.foreach((Function1 & Serializable)task -> {
                $this.updateTaskPropertiesInternal(task);
                return BoxedUnit.UNIT;
            });
            tasks.foreach((Function1 & Serializable)ci -> {
                $this.afterUpdate((ConfigurationItem)ci);
                return BoxedUnit.UNIT;
            });
            $this.updateConfigurationRefs((CiWithUid)release);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$updateTaskPropertiesInternal$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        BoxedUnit boxedUnit;
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            return;
        }
        try {
            $this.dependencyPersistence().updateDependency(dependency);
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (NotFoundException e) {
            $this.logger().error((Function0 & Serializable)() -> "Dependency " + dependency + " not found when updating task " + task$1, (Function0 & Serializable)() -> e);
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$5) {
        String string = x$5.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationReferencePersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        TaskRepository.$init$((TaskRepository)this);
        InterceptedRepository.$init$((InterceptedRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

