package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.runner.JobRunner
import com.xebialabs.xlrelease.repository.{ConfigurationRepository, JobRunnerRepository}
import com.xebialabs.xlrelease.runner.domain.RunnerId
import grizzled.slf4j.Logging


class SqlJobRunnerRepository(configurationRepository: ConfigurationRepository)
  extends JobRunnerRepository
    with Logging {

  override def findAll(): java.util.List[JobRunner] = {
    configurationRepository.findAllByType[JobRunner](Type.valueOf(classOf[JobRunner]))
  }

  override def findRunner(runnerId: RunnerId): Option[_ <: JobRunner] = {
    try {
      Option(configurationRepository.read[JobRunner](runnerId))
    } catch {
      case _: NotFoundException => None
    }
  }
}
