package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence
import com.xebialabs.xlrelease.repository.{PersistenceInterceptor, TaskRepository}
import org.springframework.stereotype.Component


@Component
@IsTransactional
class TaskPersistenceInterceptor(taskRepository: TaskRepository,
                                 val taskPersistence: TaskPersistence)
  extends PersistenceInterceptor[Task]
    with WorkflowTaskValidator
    with WorkflowInterceptorLogic {

  taskRepository.registerPersistenceInterceptor(this)

  override def onCreate(ci: Task): Unit = {
    onCreateOrUpdate(ci)
  }

  override def onUpdate(ci: Task): Unit = {
    onCreateOrUpdate(ci)
  }

  private def onCreateOrUpdate(task: Task): Unit = {
    if (task.getRelease.isWorkflow) {
      updateWorkflowProperties(task)
      validateNoLockTaskPresent(task)
      validateNoUnsupportedTaskPresent(task)
      validateWorkflowTaskCount(task.getRelease)
    }
  }

}
