package com.xebialabs.xlrelease.spring.config

import com.p6spy.engine.logging.P6LogOptions
import com.p6spy.engine.spy.{P6DataSource, P6SpyOptions}
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.support.config.TypesafeConfigExt._
import com.xebialabs.xlrelease.features.DatabaseProxyFeature
import com.zaxxer.hikari.HikariDataSource
import org.springframework.jdbc.datasource.DelegatingDataSource

import java.util.concurrent.atomic.AtomicBoolean
import javax.sql.DataSource
import scala.jdk.CollectionConverters._

class XlrDelegatingDataSource(target: HikariDataSource, databaseProxyFeature: DatabaseProxyFeature, xlrConfig: XlrConfig)
  extends DelegatingDataSource(target) with CloseableDataSource {

  private val alreadyRequested: ThreadLocal[AtomicBoolean] = ThreadLocal.withInitial(() => new AtomicBoolean(false))
  private lazy val p6DataSource = {
    val props = xlrConfig.features.databaseProxy.databaseProxyConfig.toMap.asJava
    val spyOptions = P6SpyOptions.getActiveInstance
    spyOptions.load(props)
    val logOptions = P6LogOptions.getActiveInstance
    logOptions.load(props)
    new P6DataSource(target)
  }

  override def obtainTargetDataSource(): DataSource = {
    try {
      val wasNotAlreadyRequested = alreadyRequested.get().compareAndSet(false, true)
      if (wasNotAlreadyRequested && databaseProxyFeature.isSpyProxyEnabled) {
        p6DataSource
      } else {
        target
      }
    } finally {
      alreadyRequested.get().set(false)
    }
  }

  override def close(): Unit = {
    target.close()
  }
}
