package com.xebialabs.xlrelease.service

import com.xebialabs.deployit.security.PermissionEnforcer
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.domain.status.ReleaseStatus.TEMPLATE
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder
import com.xebialabs.xlrelease.security.XLReleasePermissions.{AUDIT_ALL, VIEW_TEMPLATE}
import com.xebialabs.xlrelease.views.TemplateFilters

import scala.jdk.CollectionConverters._

object SqlTemplatesFilterSupport extends SqlFilterSupport[TemplateFilters, ReleasesSqlBuilder] {

  override def sqlBuilderByFilters(filters: TemplateFilters, principals: Iterable[String], roleIds: Iterable[String], enforcePermission: Boolean = true)
                                  (implicit permissionEnforcer: PermissionEnforcer, sqlDialect: Dialect): ReleasesSqlBuilder = {
    val sqlBuilder: ReleasesSqlBuilder = new ReleasesSqlBuilder()
      .withOneOfStatuses(Seq(TEMPLATE))
      .withTitleLike(filters.getTitle)

    if (enforcePermission && !permissionEnforcer.isCurrentUserAdmin && !permissionEnforcer.hasLoggedInUserPermission(AUDIT_ALL)) {
      sqlBuilder.withPermission(VIEW_TEMPLATE, principals, roleIds)
    }
    if (filters.getTags != null && !filters.getTags.isEmpty) {
      sqlBuilder.withTags(filters.getTags.asScala.toSet)
    }
    if (filters.getParentId != null) {
      sqlBuilder.withFolder(filters.getParentId)
    }
    if (filters.getKind != null) {
      sqlBuilder.withKind(filters.getKind)
    }

    if (filters.getCategories != null && !filters.getCategories.isEmpty) {
      sqlBuilder.withCategories(filters.getCategories.asScala.toSeq)
    }

    sqlBuilder.orderBy(ReleaseOrderMode.title)
  }
}
