package com.xebialabs.xlrelease.spring.config

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.spring.config.SqlCiReferenceCacheConfiguration._
import com.xebialabs.xlrelease.support.cache.caffeine.spring.XlrCaffeineCacheManager
import org.springframework.cache.CacheManager
import org.springframework.cache.interceptor.{CacheResolver, KeyGenerator, NamedCacheResolver, SimpleKeyGenerator}
import org.springframework.context.annotation.{Bean, Configuration, Primary}


@Configuration
class SqlCiReferenceCacheConfiguration(xlrConfig: XlrConfig) {
  @Bean(name = Array(CI_REFERENCE_CACHE_KEY_GENERATOR))
  def ciReferenceCacheKeyGenerator(): KeyGenerator = {
    new SimpleKeyGenerator()
  }


  @Bean(name = Array(CACHE_RESOLVER_CI_REFERENCE))
  def ciReferenceCacheResolver(): CacheResolver = {
    new NamedCacheResolver(ciReferenceCacheManager(), CACHE_CI_TASK_TYPES, CACHE_CI_REFERENCE_TYPES)
  }

  @Primary
  @Bean(name = Array(CACHE_MANAGER_CI_REFERENCE))
  def ciReferenceCacheManager(): CacheManager = {
    new XlrCaffeineCacheManager(CACHE_MANAGER_CI_REFERENCE, "default-cache-values", xlrConfig.cache)
  }

}


object SqlCiReferenceCacheConfiguration {
  final val CACHE_CI_TASK_TYPES = "task-types"
  final val CACHE_CI_REFERENCE_TYPES = "ci-reference-types"
  final val CACHE_MANAGER_CI_REFERENCE = "ciReferenceCacheManager"
  final val CACHE_RESOLVER_CI_REFERENCE = "ciReferenceCacheResolver"
  final val CI_REFERENCE_CACHE_KEY_GENERATOR = "ciReferenceCacheKeyGenerator"
}
