package com.xebialabs.xlrelease.repository.sql

import org.springframework.jdbc.core.JdbcTemplate

import java.util.concurrent.atomic.AtomicReference

object JdbcTemplateHolder {
  private val TEMPLATE_HOLDER = new AtomicReference[JdbcTemplate]

  def init(template: JdbcTemplate): Unit = {
    TEMPLATE_HOLDER.getAndSet(template)
  }

  def get(): JdbcTemplate = JdbcTemplateHolder.TEMPLATE_HOLDER.get
}

