/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r\u0005e\u0001B\u0017/\u0001eB\u0001b\u0018\u0001\u0003\u0006\u0004%\t\u0001\u0019\u0005\tO\u0002\u0011\t\u0011)A\u0005C\"A\u0001\u000e\u0001BC\u0002\u0013\u0005\u0011\u000e\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003k\u0011!q\u0007A!b\u0001\n\u0003y\u0007\u0002C:\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011Q\u0004!Q1A\u0005\u0002UD\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\tu\u0002\u0011)\u0019!C\u0001w\"Aq\u0010\u0001B\u0001B\u0003%A\u0010\u0003\u0006\u0002\u0002\u0001\u0011)\u0019!C\u0001\u0003\u0007A!\"!\u0005\u0001\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011)\t\u0019\u0002\u0001BC\u0002\u0013\u0005\u0011Q\u0003\u0005\u000b\u0003;\u0001!\u0011!Q\u0001\n\u0005]\u0001BCA\u0010\u0001\t\u0015\r\u0011b\u0001\u0002\"!Q\u0011\u0011\u000b\u0001\u0003\u0002\u0003\u0006I!a\t\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u0011\u0011\u000e\u0001\u0005B\u0005-\u0004bBA5\u0001\u0011\u0005\u0013Q\u0016\u0005\b\u0003\u001f\u0004A\u0011IAi\u0011\u001d\u0011)\u0001\u0001C!\u0005\u000fAqA!\u0006\u0001\t\u0003\u00129\u0002C\u0004\u0003 \u0001!\tE!\t\t\u000f\t\u0005\u0003\u0001\"\u0011\u0003D!9!\u0011\n\u0001\u0005\n\t-\u0003b\u0002B(\u0001\u0011\u0005#\u0011\u000b\u0005\b\u0005;\u0002A\u0011\tB0\u0011\u001d\u0011)\u0007\u0001C\u0005\u0005OBqAa\u001b\u0001\t\u0003\u0012i\u0007C\u0004\u0003~\u0001!\tEa \t\u000f\t\u0015\u0005\u0001\"\u0011\u0003\b\"9!Q\u0012\u0001\u0005\n\t=\u0005b\u0002BK\u0001\u0011\u0005#q\u0013\u0005\b\u0005;\u0003A\u0011\tBP\u0011\u001d\u0011I\f\u0001C!\u0005wCqAa4\u0001\t\u0003\u0012\t\u000eC\u0004\u0003V\u0002!\tEa6\t\u000f\t}\u0007\u0001\"\u0011\u0003b\"9!Q\u001f\u0001\u0005B\t]\bbBB\b\u0001\u0011\u0005#q\u001f\u0005\b\u0007+\u0001A\u0011IB\f\u0011\u001d\u0019Y\u0003\u0001C!\u0007[Aqa!\u0010\u0001\t\u0003\u001ay\u0004C\u0004\u0004p\u0001!\te!\u001d\u0003#M\u000bH\u000eV1tWJ+\u0007o\\:ji>\u0014\u0018P\u0003\u00020a\u0005\u00191/\u001d7\u000b\u0005E\u0012\u0014A\u0003:fa>\u001c\u0018\u000e^8ss*\u00111\u0007N\u0001\nq2\u0014X\r\\3bg\u0016T!!\u000e\u001c\u0002\u0013a,'-[1mC\n\u001c(\"A\u001c\u0002\u0007\r|Wn\u0001\u0001\u0014\u0011\u0001Q\u0004\t\u0012(R)^\u0003\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012a!\u00118z%\u00164\u0007CA!C\u001b\u0005\u0001\u0014BA\"1\u00059!\u0016m]6SKB|7/\u001b;pef\u00042!\u0012$I\u001b\u0005q\u0013BA$/\u0005UIe\u000e^3sG\u0016\u0004H/\u001a3SKB|7/\u001b;pef\u0004\"!\u0013'\u000e\u0003)S!a\u0013\u001a\u0002\r\u0011|W.Y5o\u0013\ti%J\u0001\u0003UCN\\\u0007CA#P\u0013\t\u0001fFA\rCCN,'+\u001a7fCN,\u0017\n^3n%\u0016\u0004xn]5u_JL\bCA#S\u0013\t\u0019fF\u0001\fEKN,'/[1mSj\fG/[8o'V\u0004\bo\u001c:u!\t)U+\u0003\u0002W]\tq2i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cWm]*vaB|'\u000f\u001e\t\u00031vk\u0011!\u0017\u0006\u00035n\u000bQa\u001d7gi)T\u0011\u0001X\u0001\tOJL'P\u001f7fI&\u0011a,\u0017\u0002\b\u0019><w-\u001b8h\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0018\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003M\u000e\u0014!CU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0006\u0019\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2fA\u0005)B-\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,W#\u00016\u0011\u0005\t\\\u0017B\u00017d\u0005U!U\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\fa\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0010i\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dKV\t\u0001\u000f\u0005\u0002cc&\u0011!o\u0019\u0002\u0010)\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0006\u0001B/Y:l!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0012G>lW.\u001a8u%\u0016\u0004xn]5u_JLX#\u0001<\u0011\u0005\u0005;\u0018B\u0001=1\u0005E\u0019u.\\7f]R\u0014V\r]8tSR|'/_\u0001\u0013G>lW.\u001a8u%\u0016\u0004xn]5u_JL\b%A\tsKB|7/\u001b;pef\fE-\u00199uKJ,\u0012\u0001 \t\u0003\u000bvL!A \u0018\u0003)M\u000bHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003I\u0011X\r]8tSR|'/_!eCB$XM\u001d\u0011\u00021\r|gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW-\u0006\u0002\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f\r\fQbY8oM&<WO]1uS>t\u0017\u0002BA\b\u0003\u0013\u0011\u0011eQ8oM&<WO]1uS>t'+\u001a4fe\u0016t7-\u001a)feNL7\u000f^3oG\u0016\f\u0011dY8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2fA\u0005Ib-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s+\t\t9\u0002E\u0002B\u00033I1!a\u00071\u0005e1\u0015mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u00025\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM\u001d\u0011\u0002\u000f\u0011L\u0017\r\\3diV\u0011\u00111\u0005\t\u0005\u0003K\tYE\u0004\u0003\u0002(\u0005\u0015c\u0002BA\u0015\u0003\u0003rA!a\u000b\u0002>9!\u0011QFA\u001e\u001d\u0011\ty#!\u000f\u000f\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e9\u0003\u0019a$o\\8u}%\tq'\u0003\u00026m%\u00111\u0007N\u0005\u0004\u0003\u007f\u0011\u0014A\u00013c\u0013\ry\u00131\t\u0006\u0004\u0003\u007f\u0011\u0014\u0002BA$\u0003\u0013\n!bU9m\u0005VLG\u000eZ3s\u0015\ry\u00131I\u0005\u0005\u0003\u001b\nyEA\u0004ES\u0006dWm\u0019;\u000b\t\u0005\u001d\u0013\u0011J\u0001\tI&\fG.Z2uA\u00051A(\u001b8jiz\"\"#a\u0016\u0002Z\u0005m\u0013QLA0\u0003C\n\u0019'!\u001a\u0002hA\u0011Q\t\u0001\u0005\u0006?F\u0001\r!\u0019\u0005\u0006QF\u0001\rA\u001b\u0005\u0006]F\u0001\r\u0001\u001d\u0005\u0006iF\u0001\rA\u001e\u0005\u0006uF\u0001\r\u0001 \u0005\b\u0003\u0003\t\u0002\u0019AA\u0003\u0011\u001d\t\u0019\"\u0005a\u0001\u0003/Aq!a\b\u0012\u0001\b\t\u0019#\u0001\u0005gS:$')_%e+\u0011\ti'a\u001d\u0015\t\u0005=\u0014q\u0010\t\u0005\u0003c\n\u0019\b\u0004\u0001\u0005\u000f\u0005U$C1\u0001\u0002x\t\tA+E\u0002\u0002z!\u00032aOA>\u0013\r\ti\b\u0010\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\t\tI\u0005a\u0001\u0003\u0007\u000ba\u0001^1tW&#\u0007\u0003BAC\u0003\u001bsA!a\"\u0002\nB\u0019\u0011\u0011\u0007\u001f\n\u0007\u0005-E(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\u000b\tJ\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017c\u0004f\u0001\n\u0002\u0016B!\u0011qSAU\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006u\u0015AC1o]>$\u0018\r^5p]*!\u0011qTAQ\u0003\u0011\u0019wN]3\u000b\t\u0005\r\u0016QU\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(BAAT\u0003\tIw.\u0003\u0003\u0002,\u0006e%!\u0002+j[\u0016$W\u0003BAX\u0003g#b!!-\u00026\u0006]\u0006\u0003BA9\u0003g#q!!\u001e\u0014\u0005\u0004\t9\bC\u0004\u0002\u0002N\u0001\r!a!\t\u000f\u0005e6\u00031\u0001\u0002<\u0006q!/Z:pYZ,w\n\u001d;j_:\u001c\b\u0003BA_\u0003\u0013l!!a0\u000b\u0007E\n\tM\u0003\u0003\u0002D\u0006\u0015\u0017\u0001\u00026t_:T1!a23\u00035\u0019XM]5bY&T\u0018\r^5p]&!\u00111ZA`\u00059\u0011Vm]8mm\u0016|\u0005\u000f^5p]ND3aEAK\u0003I1\u0017N\u001c3UCN\\7OQ1tS\u000e$\u0015\r^1\u0015\t\u0005M\u0017q\u001e\t\u0007\u0003+\fy.a9\u000e\u0005\u0005]'\u0002BAm\u00037\fA!\u001e;jY*\u0011\u0011Q\\\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002b\u0006]'\u0001\u0002'jgR\u0004B!!:\u0002l6\u0011\u0011q\u001d\u0006\u0004\u0003S\u0004\u0014!B9vKJL\u0018\u0002BAw\u0003O\u0014Q\u0002V1tW\n\u000b7/[2ECR\f\u0007bBAy)\u0001\u0007\u00111_\u0001\bi\u0006\u001c8.\u00133t!\u0019\t).a8\u0002\u0004\"\u001aA#!&)\u0007Q\tI\u0010\u0005\u0003\u0002|\n\u0005QBAA\u007f\u0015\u0011\ty0!\u0013\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0005\u0007\tiP\u0001\u0006JgJ+\u0017\rZ(oYf\fa!\u001a=jgR\u001cH\u0003\u0002B\u0005\u0005\u001f\u00012a\u000fB\u0006\u0013\r\u0011i\u0001\u0010\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t)\u0006a\u0001\u0003\u0007C3!FAKQ\r)\u0012\u0011`\u0001\u0007kB$\u0017\r^3\u0015\u0007!\u0013I\u0002\u0003\u0004\u0003\u001cY\u0001\r\u0001S\u0001\u0005i\u0006\u001c8\u000eK\u0002\u0017\u0003+\u000b1\"\u001e9eCR,G+Y:lgR!!1\u0005B\u0015!\rY$QE\u0005\u0004\u0005Oa$\u0001B+oSRDqAa\u000b\u0018\u0001\u0004\u0011i#A\u0003uCN\\7\u000f\u0005\u0003<\u0005_A\u0015b\u0001B\u0019y\tQAH]3qK\u0006$X\r\u001a )\u0007]\t)\nK\u0002\u0018\u0005o\u0001BA!\u000f\u0003>5\u0011!1\b\u0006\u0004\u00037c\u0014\u0002\u0002B \u0005w\u0011qA^1sCJ<7/\u0001\u000bva\u0012\fG/\u001a+bg.\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0005G\u0011)\u0005\u0003\u0004\u0003\u001ca\u0001\r\u0001\u0013\u0015\u00041\u0005U\u0015\u0001H;qI\u0006$X\rV1tWB\u0013x\u000e]3si&,7/\u00138uKJt\u0017\r\u001c\u000b\u0005\u0005G\u0011i\u0005\u0003\u0004\u0003\u001ce\u0001\r\u0001S\u0001\u001aE\u0006$8\r[+qI\u0006$X\rV1tWB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0003$\tM\u0003b\u0002B\u00165\u0001\u0007!Q\u000b\t\u0006\u0003\u000b\u00139\u0006S\u0005\u0005\u00053\n\tJA\u0002TKRD3AGAK\u0003\u0019\u0012\u0017\r^2i+B$\u0017\r^3UCN\\\u0007K]8qKJ$\u0018.Z:XSRD\u0017\nZ!oI\"\u000b7\u000f\u001b\u000b\u0005\u0005G\u0011\t\u0007C\u0004\u0003,m\u0001\rA!\u0016)\u0007m\t)*A\fcCR\u001c\u0007.\u00169eCR,G)\u001a9f]\u0012,gnY5fgR!!1\u0005B5\u0011\u001d\u0011Y\u0003\ba\u0001\u0005+\na$\u001e9eCR,G+Y:l\u0003:$'+\u001a7fCN,g\t\\1h'R\fG/^:\u0015\u000b!\u0013yG!\u001d\t\r\tmQ\u00041\u0001I\u0011\u001d\u0011\u0019(\ba\u0001\u0005k\nqA]3mK\u0006\u001cX\rE\u0002J\u0005oJ1A!\u001fK\u0005\u001d\u0011V\r\\3bg\u0016D3!HAK\u0003))\b\u000fZ1uKRK\b/\u001a\u000b\u0004\u0011\n\u0005\u0005B\u0002B\u000e=\u0001\u0007\u0001\nK\u0002\u001f\u0003+\u000ba\u0001Z3mKR,G\u0003\u0002B\u0012\u0005\u0013CaAa\u0007 \u0001\u0004A\u0005fA\u0010\u0002\u0016\u0006Q1M]3bi\u0016$\u0016m]6\u0015\u0007!\u0013\t\n\u0003\u0004\u0003\u0014\u0002\u0002\r\u0001S\u0001\b]\u0016<H+Y:l\u0003\u0019\u0019'/Z1uKR\u0019\u0001J!'\t\r\tM\u0015\u00051\u0001IQ\r\t\u0013QS\u0001\t[>4X\rV1tWRI\u0001J!)\u0003&\n%&1\u0017\u0005\u0007\u0005G\u0013\u0003\u0019\u0001%\u0002\u0015Q\f7o\u001b+p\u001b>4X\r\u0003\u0004\u0003(\n\u0002\r\u0001S\u0001\n[>4X\r\u001a+bg.DqAa+#\u0001\u0004\u0011i+\u0001\fva\u0012\fG/\u001a3Pe&<\u0017N\\\"p]R\f\u0017N\\3s!\rI%qV\u0005\u0004\u0005cS%!\u0004+bg.\u001cuN\u001c;bS:,'\u000fC\u0004\u00036\n\u0002\rA!,\u0002-U\u0004H-\u0019;fIR\u000b'oZ3u\u0007>tG/Y5oKJD3AIAK\u0003Y1\u0017N\u001c3BM\u001a,7\r^3e\u0005f\u0014E.Y2l_V$H\u0003BAz\u0005{CqAa0$\u0001\u0004\u0011\t-\u0001\u0005cY\u0006\u001c7n\\;u!\u0011\u0011\u0019M!3\u000e\u0005\t\u0015'b\u0001Bd\u0015\u0006A1-\u00197f]\u0012\f'/\u0003\u0003\u0003L\n\u0015'\u0001\u0003\"mC\u000e\\w.\u001e;)\u0007\r\n)*\u0001\u000egS:$\u0007+\u001a8eS:<G+Y:lg^KG\u000f\u001b$bG\u0016$8\u000f\u0006\u0002\u0002t\"\u001aA%!&\u0002\u0011\u001d,G\u000fV5uY\u0016$B!a!\u0003Z\"9\u0011\u0011Q\u0013A\u0002\u0005\r\u0005fA\u0013\u0002\u0016\"\u001aQ%!?\u0002\u0015\u001d,G/\u00117m)\u0006<7\u000f\u0006\u0003\u0003d\n\u001d\bCBAk\u0005K\f\u0019)\u0003\u0003\u0003Z\u0005]\u0007b\u0002BuM\u0001\u0007!1^\u0001\fY&l\u0017\u000e\u001e(v[\n,'\u000fE\u0002<\u0005[L1Aa<=\u0005\rIe\u000e\u001e\u0015\u0004M\u0005U\u0005f\u0001\u0014\u0002z\u0006\u0011b-\u001b8e\u001fZ,'\u000fZ;f)\u0006\u001c8.\u00133t)\t\u0011I\u0010\u0005\u0004\u0003|\u000e\u0015\u00111\u0011\b\u0005\u0005{\u001c\tA\u0004\u0003\u00022\t}\u0018\"A\u001f\n\u0007\r\rA(A\u0004qC\u000e\\\u0017mZ3\n\t\r\u001d1\u0011\u0002\u0002\u0004'\u0016\f(bAB\u0002y!\u001aq%!&)\u0007\u001d\nI0\u0001\ngS:$G)^3T_>tG+Y:l\u0013\u0012\u001c\bf\u0001\u0015\u0002\u0016\"\u001a\u0001&!?\u0002\u0013\u001d,Go\u0015;biV\u001cH\u0003BB\r\u0007K\u0001Baa\u0007\u0004\"5\u00111Q\u0004\u0006\u0004\u0007?Q\u0015AB:uCR,8/\u0003\u0003\u0004$\ru!A\u0003+bg.\u001cF/\u0019;vg\"9\u0011\u0011Q\u0015A\u0002\u0005\r\u0005fA\u0015\u0002\u0016\"\u001a\u0011&!?\u0002\u001f\u001d,G\u000fV1tWN#\u0018\r^;tKN$Baa\f\u00046AA\u0011Q[B\u0019\u0003\u0007\u001bI\"\u0003\u0003\u00044\u0005]'aA'ba\"91q\u0007\u0016A\u0002\u0005\r\u0015!\u0003:fY\u0016\f7/Z%eQ\rQ\u0013Q\u0013\u0015\u0004U\u0005e\u0018a\n4j]\u0012$\u0016m]6JIN\u0014\u0015\u0010V1tWRK\b/Z*uCR,8/\u00118e'R\f'\u000f\u001e#bi\u0016$\u0002B!?\u0004B\ru3\u0011\r\u0005\b\u0007\u0007Z\u0003\u0019AB#\u0003!!\u0018m]6UsB,\u0007\u0003BB$\u00073j!a!\u0013\u000b\t\r-3QJ\u0001\be\u00164G.Z2u\u0015\u0011\u0019ye!\u0015\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0004T\rU\u0013A\u00029mk\u001eLgNC\u0002\u0004XQ\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u00077\u001aIE\u0001\u0003UsB,\u0007bBB0W\u0001\u00071\u0011D\u0001\u000bi\u0006\u001c8n\u0015;biV\u001c\bbBB2W\u0001\u00071QM\u0001\u000egR\f'\u000f^3e\u0005\u00164wN]3\u0011\t\u0005U7qM\u0005\u0005\u0007S\n9N\u0001\u0003ECR,\u0007fA\u0016\u0002\u0016\"\u001a1&!?\u0002)U\u0004H-\u0019;f)\u0006\u001c8n\u0015;biV\u001cH*\u001b8f)\u0019\u0011\u0019ca\u001d\u0004v!9\u0011\u0011\u0011\u0017A\u0002\u0005\r\u0005bBB<Y\u0001\u0007\u00111Q\u0001\u000bgR\fG/^:MS:,\u0007f\u0001\u0001\u0004|A!\u00111`B?\u0013\u0011\u0019y(!@\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\u0004")
public class SqlTaskRepository
implements TaskRepository,
InterceptedRepository<Task>,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Task>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Task> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public TaskBasicData findTaskBasicData(String taskId) throws NotFoundException {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Task>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Task>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public void updateTasks(Task ... tasks) {
        this.updateTasks((scala.collection.immutable.Seq<Task>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tasks));
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, ResolveOptions$.MODULE$.WITH_DECORATORS());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException("Repository entity [" + taskId + "] not found", new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [" + taskId + "] not found in release", new Object[0]);
        }, (Function1 & Serializable)task -> {
            task.getAllTasks().forEach(t -> this.commentRepository().decorate(t));
            return task;
        }));
    }

    @Timed
    @IsReadOnly
    public java.util.List<TaskBasicData> findTasksBasicData(java.util.List<String> taskIds) {
        if (taskIds.isEmpty()) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        }
        scala.collection.immutable.Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala());
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala().map((Function1 & Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))))).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TaskRow data = (TaskRow)some.value();
                    return new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id));
                }
            }
            return None$.MODULE$;
        })).asJava();
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> "Checking if exists task [" + taskId + "]");
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.interceptUpdate((ConfigurationItem)task);
        this.releasePersistence().update(release);
        this.updateTaskPropertiesInternal(task);
        this.updateConfigurationRefs((CiWithUid)release);
        this.afterUpdate((ConfigurationItem)task);
        return task;
    }

    @Timed
    public void updateTasks(scala.collection.immutable.Seq<Task> tasks) {
        tasks.groupBy((Function1 & Serializable)x$1 -> x$1.getRelease()).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTasks$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.interceptUpdate((ConfigurationItem)task);
        this.updateTaskPropertiesInternal(task);
        this.afterUpdate((ConfigurationItem)task);
    }

    private void updateTaskPropertiesInternal(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskPropertiesInternal$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void batchUpdateTaskProperties(scala.collection.immutable.Set<Task> tasks) {
        tasks.foreach((Function1 & Serializable)ci -> {
            this.interceptUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
        this.taskPersistence().batchUpdateTaskProperties(tasks);
        this.batchUpdateDependencies(tasks);
    }

    @Timed
    public void batchUpdateTaskPropertiesWithIdAndHash(scala.collection.immutable.Set<Task> tasks) {
        tasks.foreach((Function1 & Serializable)ci -> {
            this.interceptUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
        this.taskPersistence().batchUpdateTaskPropertiesWithIdAndHash(tasks);
        this.batchUpdateDependencies(tasks);
    }

    private void batchUpdateDependencies(scala.collection.immutable.Set<Task> tasks) {
        Tuple2 tuple2 = ((IterableOps)tasks.flatMap((Function1 & Serializable)x$2 -> syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(x$2)))).partition((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isArchived()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Set archivedDeps = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set otherDeps = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)archivedDeps, (Object)otherDeps);
        scala.collection.immutable.Set archivedDeps2 = (scala.collection.immutable.Set)tuple22._1();
        scala.collection.immutable.Set otherDeps2 = (scala.collection.immutable.Set)tuple22._2();
        this.dependencyPersistence().batchDeleteDependencies((scala.collection.immutable.Set<Dependency>)archivedDeps2);
        this.dependencyPersistence().batchUpdateDependencies((scala.collection.immutable.Set<Dependency>)otherDeps2);
        tasks.foreach((Function1 & Serializable)ci -> {
            this.afterUpdate((ConfigurationItem)ci);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    @Timed
    public Task updateType(Task task) {
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return updated;
    }

    @Timed
    public void delete(Task task) {
        String taskId = task.getId();
        this.checkIsNotReferencedByDependencies(taskId);
        this.interceptDelete(taskId);
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs((CiWithUid)task.getRelease());
        this.afterDelete(taskId);
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(newTask2.getAllTasks()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$5)))).map((Function1 & Serializable)newTask -> this.createTask((Task)newTask)) : BoxedUnit.UNIT;
        return newTask2;
    }

    @Timed
    public Task create(Task newTask) {
        this.interceptCreate((ConfigurationItem)newTask);
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(newTask.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        this.afterCreate((ConfigurationItem)createdTask);
        return createdTask;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            CollectionConverters$.MODULE$.ListHasAsScala(taskToMove.getAllTasks()).asScala().foreach((Function1 & Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public java.util.List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)ReleaseStatus.ACTIVE_STATUSES)).build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)releaseData -> this.tryDeserializeRelease((ReleaseRow)releaseData))).flatMap((Function1 & Serializable)rel -> CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala())).filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable)x$6 -> x$6.getId())).asJava();
    }

    @Timed
    public java.util.List<String> findPendingTasksWithFacets() {
        Tuple2 sqlWithParams = new TasksSqlBuilder(this.dialect()).selectTaskId().withOneOfTaskStatuses((scala.collection.immutable.Seq<TaskStatus>)new .colon.colon((Object)TaskStatus.PENDING, (List)Nil$.MODULE$)).withAnyFacets().build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.taskPersistence().findTaskIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSet().toList()).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.taskPersistence().findAllTags(limitNumber)).asJava();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueTaskIds() {
        return this.taskPersistence().findOverdueTaskIds();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findDueSoonTaskIds() {
        return this.taskPersistence().findDueSoonTaskIds();
    }

    @Timed
    @IsReadOnly
    public TaskStatus getStatus(String taskId) {
        return (TaskStatus)this.taskPersistence().getStatus(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("getStatus: could not find task '" + taskId + "'", new Object[0]);
        });
    }

    @Timed
    @IsReadOnly
    public Map<String, TaskStatus> getTaskStatuses(String releaseId) {
        return this.taskPersistence().getTaskStatuses(releaseId);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findTaskIdsByTaskTypeStatusAndStartDate(Type taskType, TaskStatus taskStatus, Date startedBefore) {
        return this.taskPersistence().findTaskIdsByTaskTypeStatusAndStartDate(taskType, taskStatus, startedBefore);
    }

    public void updateTaskStatusLine(String taskId, String statusLine) {
        this.taskPersistence().updateStatusLine(taskId, statusLine);
    }

    public static final /* synthetic */ void $anonfun$updateTasks$2(SqlTaskRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Release release = (Release)tuple2._1();
            scala.collection.immutable.Seq tasks = (scala.collection.immutable.Seq)tuple2._2();
            tasks.foreach((Function1 & Serializable)ci -> {
                $this.interceptUpdate((ConfigurationItem)ci);
                return BoxedUnit.UNIT;
            });
            $this.releasePersistence().update(release);
            tasks.foreach((Function1 & Serializable)task -> {
                $this.updateTaskPropertiesInternal(task);
                return BoxedUnit.UNIT;
            });
            tasks.foreach((Function1 & Serializable)ci -> {
                $this.afterUpdate((ConfigurationItem)ci);
                return BoxedUnit.UNIT;
            });
            $this.updateConfigurationRefs((CiWithUid)release);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$updateTaskPropertiesInternal$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        BoxedUnit boxedUnit;
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            return;
        }
        try {
            $this.dependencyPersistence().updateDependency(dependency);
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (NotFoundException e) {
            $this.logger().error((Function0 & Serializable)() -> "Dependency " + dependency + " not found when updating task " + task$1, (Function0 & Serializable)() -> e);
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$5) {
        String string = x$5.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationReferencePersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        TaskRepository.$init$((TaskRepository)this);
        InterceptedRepository.$init$((InterceptedRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

