package com.xebialabs.xlrelease.spring.config

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.security.DistributedUserGroupEventListener
import com.xebialabs.xlrelease.security.sql.SecurityCacheConfigurationConstants._
import com.xebialabs.xlrelease.security.sql.UserGroupCacheConfigurationCondition
import com.xebialabs.xlrelease.support.cache.caffeine.spring.XlrCaffeineCacheManager
import org.springframework.cache.CacheManager
import org.springframework.context.annotation.{Bean, Conditional, Configuration}

@Configuration
@Conditional(value = Array(classOf[UserGroupCacheConfigurationCondition]))
class UserGroupCacheConfiguration(xlrConfig: XlrConfig) {

  @Bean
  def securityUserGroupCacheManager(): CacheManager = {
    new XlrCaffeineCacheManager(SECURITY_USER_GROUP_CACHE_MANAGER, "external-user-groups", xlrConfig.cache)
  }

  @Bean
  def distributedUserGroupEventListener(): DistributedUserGroupEventListener = {
    new DistributedUserGroupEventListener(securityUserGroupCacheManager())
  }

}
