package com.xebialabs.xlrelease.repository.sql.persistence

import com.xebialabs.xlrelease.domain.events.{ReleaseActorStarted, ReleaseActorStopped}
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}

@EventListener
class ReleaseCacheEventHandler(releaseCacheService: ReleaseCacheService) {

  @Subscribe
  def onActorStart(event: ReleaseActorStarted): Unit = {
    releaseCacheService.invalidate(event.releaseId)
    releaseCacheService.allow(event.releaseId)
  }

  @Subscribe
  def onActorStop(event: ReleaseActorStopped): Unit = {
    releaseCacheService.disallow(event.releaseId)
    releaseCacheService.invalidate(event.releaseId)
  }

}
