package com.xebialabs.xlrelease.security.entities;

import jakarta.persistence.*;

@Entity
@Table(name = "XL_ROLE_PERMISSIONS")
public class XlRolePermission {
    @EmbeddedId
    private XlRolePermissionId id;

    @MapsId("roleId")
    @ManyToOne(fetch = FetchType.LAZY, optional = false)
    @JoinColumn(name = "ROLE_ID", nullable = false)
    private XlRole role;

    public XlRolePermission() {
    }

    public XlRolePermission(final XlRolePermissionId id, final XlRole role) {
        this.id = id;
        this.role = role;
    }

    public XlRolePermission(XlRole role, String permissionName) {
        this.id = new XlRolePermissionId(role.getId(), permissionName, role.getCiId());
        this.role = role;
    }

    public XlRolePermissionId getId() {
        return id;
    }

    public void setId(XlRolePermissionId id) {
        this.id = id;
    }

    public XlRole getRole() {
        return role;
    }

    public void setRole(XlRole role) {
        this.role = role;
    }

}