package com.xebialabs.xlrelease.repository.sql.query

import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.domain.UserProfile
import com.xebialabs.xlrelease.repository.query.FiltersQueryBuilder
import com.xebialabs.xlrelease.views.users.UserFilters
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate

trait UserProfileQueryBuilder extends FiltersQueryBuilder[UserFilters, UserProfile]

object UserProfileQueryBuilder {
  def apply(dialect: Dialect, jdbcTemplate: JdbcTemplate): UserProfileQueryBuilder = {
    new SqlUserProfileQueryBuilder(dialect, new NamedParameterJdbcTemplate(jdbcTemplate))
  }
}






