/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.xebialabs.xlrelease.domain.distributed.events.DistributedGroupDeleted;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedUserGroupMembershipUpdated;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent;
import com.xebialabs.xlrelease.security.UserGroupRepository;
import com.xebialabs.xlrelease.service.BroadcastService;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@CacheConfig(cacheManager="securityUserGroupCacheManager")
@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001B\u0007\u000f\u0001]A\u0001B\t\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tG\u0001\u0011\t\u0011)A\u0005I!)!\u0006\u0001C\u0001W!)q\u0006\u0001C!a!)\u0001\f\u0001C!3\")A\f\u0001C!;\")\u0001\r\u0001C!C\")a\r\u0001C!O\")!\u000e\u0001C!W\")a\u000e\u0001C!_\")!\u000f\u0001C!g\")a\u000f\u0001C!o\nY2+\u001d7Vg\u0016\u0014xI]8vaJ+\u0007o\\:ji>\u0014\u0018pQ1dQ\u0016T!a\u0004\t\u0002\u0011M,7-\u001e:jifT!!\u0005\n\u0002\u0013ad'/\u001a7fCN,'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0001S\"\u0001\b\n\u0005\u0005r!aE+tKJ<%o\\;q%\u0016\u0004xn]5u_JL\u0018aE;tKJ<%o\\;q%\u0016\u0004xn]5u_JL\u0018\u0001\u00052s_\u0006$7-Y:u'\u0016\u0014h/[2f!\t)\u0003&D\u0001'\u0015\t9\u0003#A\u0004tKJ4\u0018nY3\n\u0005%2#\u0001\u0005\"s_\u0006$7-Y:u'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q\u0019A&\f\u0018\u0011\u0005}\u0001\u0001\"\u0002\u0012\u0004\u0001\u0004q\u0002\"B\u0012\u0004\u0001\u0004!\u0013!\u00054j]\u0012<%o\\;qg\u001a{'/V:feR\u0011\u0011g\u0010\t\u0004eebdBA\u001a8!\t!$$D\u00016\u0015\t1d#\u0001\u0004=e>|GOP\u0005\u0003qi\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\r\u0019V\r\u001e\u0006\u0003qi\u0001\"AM\u001f\n\u0005yZ$AB*ue&tw\rC\u0003A\t\u0001\u0007A(\u0001\u0005vg\u0016\u0014h.Y7fQ!!!IT(S'V3\u0006CA\"M\u001b\u0005!%BA#G\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u000f\"\u000bQaY1dQ\u0016T!!\u0013&\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aS\u0001\u0004_J<\u0017BA'E\u0005%\u0019\u0015m\u00195fC\ndW-\u0001\u0006dC\u000eDWMT1nKNd\u0013\u0001U\u0011\u0002#\u0006!R\r\u001f;fe:\fG.L;tKJlsM]8vaN\f1a[3zC\u0005!\u0016!C\u0012vg\u0016\u0014h.Y7f\u0003\u0019)h\u000e\\3tg\u0006\nq+A\b$e\u0016\u001cX\u000f\u001c;/SN,U\u000e\u001d;z\u0003-\u0019'/Z1uK\u001e\u0013x.\u001e9\u0015\u0005qR\u0006\"B.\u0006\u0001\u0004a\u0014!C4s_V\u0004h*Y7f\u00031\u0019'/Z1uK\u001e\u0013x.\u001e9t)\t\td\fC\u0003`\r\u0001\u0007\u0011'\u0001\u0006he>,\bOT1nKN\f1\u0002Z3mKR,wI]8vaR\u0011!-\u001a\t\u00033\rL!\u0001\u001a\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u00067\u001e\u0001\r\u0001P\u0001\u000fC\u0012$Wk]3s)><%o\\;q)\r\u0011\u0007.\u001b\u0005\u0006\u0001\"\u0001\r\u0001\u0010\u0005\u00067\"\u0001\r\u0001P\u0001\u0014e\u0016lwN^3Vg\u0016\u0014hI]8n\u000fJ|W\u000f\u001d\u000b\u0004E2l\u0007\"\u0002!\n\u0001\u0004a\u0004\"B.\n\u0001\u0004a\u0014!H;qI\u0006$Xm\u0012:pkB\u001cX*Z7cKJ\u001c\b.\u001b9G_J,6/\u001a:\u0015\u0007\t\u0004\u0018\u000fC\u0003A\u0015\u0001\u0007A\bC\u0003`\u0015\u0001\u0007\u0011'A\bbI\u0012,6/\u001a:U_\u001e\u0013x.\u001e9t)\r\u0011G/\u001e\u0005\u0006\u0001.\u0001\r\u0001\u0010\u0005\u0006?.\u0001\r!M\u0001\u0015e\u0016lwN^3Vg\u0016\u0014hI]8n\u000fJ|W\u000f]:\u0015\u0007\tD\u0018\u0010C\u0003A\u0019\u0001\u0007A\bC\u0003`\u0019\u0001\u0007\u0011\u0007\u000b\u0003\u0001wz|\bCA\"}\u0013\tiHIA\u0006DC\u000eDWmQ8oM&<\u0017\u0001D2bG\",W*\u00198bO\u0016\u0014\u0018EAA\u0001\u0003u\u0019XmY;sSRLXk]3s\u000fJ|W\u000f]\"bG\",W*\u00198bO\u0016\u0014\b")
public class SqlUserGroupRepositoryCache
implements UserGroupRepository {
    private final UserGroupRepository userGroupRepository;
    private final BroadcastService broadcastService;

    @Cacheable(cacheNames={"external-user-groups"}, key="#username", unless="#result.isEmpty")
    public Set<String> findGroupsForUser(String username) {
        return this.userGroupRepository.findGroupsForUser(username);
    }

    public String createGroup(String groupName) {
        return this.userGroupRepository.createGroup(groupName);
    }

    public Set<String> createGroups(Set<String> groupNames) {
        return this.userGroupRepository.createGroups(groupNames);
    }

    public void deleteGroup(String groupName) {
        this.userGroupRepository.deleteGroup(groupName);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedGroupDeleted(groupName), true);
    }

    public void addUserToGroup(String username, String groupName) {
        this.userGroupRepository.addUserToGroup(username, groupName);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUserGroupMembershipUpdated(username), true);
    }

    public void removeUserFromGroup(String username, String groupName) {
        this.userGroupRepository.removeUserFromGroup(username, groupName);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUserGroupMembershipUpdated(username), true);
    }

    public void updateGroupsMembershipForUser(String username, Set<String> groupNames) {
        this.userGroupRepository.updateGroupsMembershipForUser(username, groupNames);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUserGroupMembershipUpdated(username), true);
    }

    public void addUserToGroups(String username, Set<String> groupNames) {
        this.userGroupRepository.addUserToGroups(username, groupNames);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUserGroupMembershipUpdated(username), true);
    }

    public void removeUserFromGroups(String username, Set<String> groupNames) {
        this.userGroupRepository.removeUserFromGroups(username, groupNames);
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUserGroupMembershipUpdated(username), true);
    }

    public SqlUserGroupRepositoryCache(UserGroupRepository userGroupRepository, BroadcastService broadcastService) {
        this.userGroupRepository = userGroupRepository;
        this.broadcastService = broadcastService;
    }
}

