package com.xebialabs.xlrelease.repository.sql.persistence.reference

import com.xebialabs.xlrelease.repository.sql.persistence.CiUid

trait ReferenceMapTablePersistence {
  def insert(sourceId: CiUid, targetIds: Set[CiUid]): Unit

  def delete(sourceId: CiUid, targetIds: Set[CiUid]): Unit

  def isReferenced(targetId: CiUid): Boolean

  def getTargetIds(sourceId: CiUid): List[CiUid]

  def deleteRefsBySource(sourceId: CiUid): Unit

  def deleteRefsByTarget(targetId: CiUid): Unit

  def deleteRefsByTargets(targetIds: Set[CiUid]): Unit
}


