package com.xebialabs.xlrelease.repository.sql.persistence

import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.repository.sql.SqlRepository
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.SPRING_SESSION
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.params
import grizzled.slf4j.Logging
import org.springframework.jdbc.core.JdbcTemplate

@IsTransactional
class SpringSessionPersistence(implicit val jdbcTemplate: JdbcTemplate,
                               implicit val dialect: Dialect)
  extends SqlRepository with PersistenceSupport with Logging {

  private val STMT_DELETE_SESSIONS_BY_EMPTY_PRINCIPALS =
    s"""DELETE FROM ${SPRING_SESSION.TABLE}
       |WHERE PRINCIPAL_NAME IS NULL
       |""".stripMargin

  def cleanUpSessionsWithEmptyPrincipal(): Unit = {
    sqlUpdate(STMT_DELETE_SESSIONS_BY_EMPTY_PRINCIPALS, params(),
      numRows => logger.debug(s"Cleaned up $numRows with empty principal names"))
  }

}
