package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.repository.TeamRepository
import com.xebialabs.xlrelease.security.XLReleasePermissions.{LOCK_RELEASE_TASK, LOCK_TEMPLATE_TASK}
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class XLRelease800LockTaskPermissionsUpgrade @Autowired()(@Qualifier("xlrRepositoryJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                                          @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect,
                                                          val teamRepository: TeamRepository)
  extends BaseAdminTeamsPermissionsUpgrade {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "8.0.0#1")

  override def doUpgrade(): Boolean = {
    logger.info("'Lock task permission upgrade.")
    val securedCis = findFolderSecuredCis ++ findReleaseSecuredCis
    for (ci <- securedCis) upgradeCiTeams(ci, LOCK_RELEASE_TASK, LOCK_TEMPLATE_TASK)
    logger.debug("Finished lock task permissions upgrade")
    true
  }
}
