package com.xebialabs.xlrelease.repository.sql.persistence.data

import com.xebialabs.xlplatform.utils.ResourceManagement
import com.xebialabs.xlrelease.domain.ReleaseExtension
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.RELEASES_EXT
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper

import java.sql.ResultSet


case class ReleaseExtensionRow private(id: String,
                                       ciType: String,
                                       json: String)

object ReleaseExtensionRow extends CompressionSupport {
  def releaseAndInternalIds(fullId: String): (String, String) = {
    toInternalReleaseId(fullId) -> toInternalId(fullId)
  }

  def toInternalReleaseId(fullId: String): String =
    Ids.getName(Ids.releaseIdFrom(fullId))

  def toInternalId(fullId: String): String =
    Ids.getReleaselessChildId(fullId)

  def toExternalId(fullReleaseId: String, internalId: String): String =
    s"$fullReleaseId${Ids.SEPARATOR}$internalId"

  def apply(id: String, ciType: String, json: String): ReleaseExtensionRow =
    new ReleaseExtensionRow(
      id = toInternalId(id),
      ciType = ciType,
      json = json
    )

  def fromExtension(extension: ReleaseExtension): ReleaseExtensionRow =
    apply(
      extension.getId,
      extension.getType.toString,
      CiSerializerHelper.serialize(extension)
    )

  def fromDatabase(rs: ResultSet): ReleaseExtensionRow = {
    val data = ResourceManagement.using(rs.getBinaryStream(RELEASES_EXT.CONTENT))(decompress)
    new ReleaseExtensionRow(
      id = rs.getString(RELEASES_EXT.EXTENSION_ID),
      ciType = rs.getString(RELEASES_EXT.EXTENSION_TYPE),
      json = data
    )
  }
}
