/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.security;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.utils.IdUtils$;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.SecurityRepository;
import com.xebialabs.xlrelease.repository.TeamArrayPropertyChange;
import com.xebialabs.xlrelease.repository.sql.security.FolderTeamLimitEnforcer;
import com.xebialabs.xlrelease.repository.sql.security.TeamMemberLimitEnforcer;
import com.xebialabs.xlrelease.security.XlRolePermissionRepository;
import com.xebialabs.xlrelease.security.XlRolePrincipalRepository;
import com.xebialabs.xlrelease.security.XlRoleRepository;
import com.xebialabs.xlrelease.security.XlRoleRoleRepository;
import com.xebialabs.xlrelease.security.entities.XlRole;
import com.xebialabs.xlrelease.security.entities.XlRolePermission;
import com.xebialabs.xlrelease.security.entities.XlRolePermissionId;
import com.xebialabs.xlrelease.security.entities.XlRolePrincipal;
import com.xebialabs.xlrelease.security.entities.XlRolePrincipalId;
import com.xebialabs.xlrelease.security.entities.XlRoleRole;
import com.xebialabs.xlrelease.security.entities.XlRoleRoleId;
import com.xebialabs.xlrelease.security.sql.db.Ids$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\tMd\u0001B\u0014)\u0001UB\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\"\u00020\u0001\t\u0003y\u0006bB4\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007Y\u0002\u0001\u000b\u0011B5\t\u000fq\u0004!\u0019!C\u0005{\"9\u00111\u0001\u0001!\u0002\u0013q\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011%\ti\u0007AI\u0001\n\u0003\ty\u0007C\u0005\u0002\u0004\u0002\t\n\u0011\"\u0001\u0002p!I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0011q\u000e\u0005\b\u0003\u000f\u0003A\u0011IAE\u0011\u001d\tI\n\u0001C!\u00037Cq!a*\u0001\t\u0003\nI\u000bC\u0004\u00022\u0002!\t%a-\t\u000f\u0005e\u0006\u0001\"\u0011\u0002<\"9\u0011Q\u0019\u0001\u0005B\u0005\u001d\u0007bBAh\u0001\u0011\u0005\u0013\u0011\u001b\u0005\b\u0003/\u0004A\u0011IAm\u0011\u001d\t\t\u000f\u0001C!\u0003GDq!!;\u0001\t\u0003\nY\u000fC\u0004\u0002r\u0002!\t%a=\t\u000f\u0005e\b\u0001\"\u0003\u0002|\"9!Q\u0001\u0001\u0005\n\t\u001d\u0001b\u0002B\u000f\u0001\u0011%!q\u0004\u0005\b\u0005G\u0001A\u0011\u0002B\u0013\u0011\u001d\u0011I\u0003\u0001C\u0005\u0005WAq!!2\u0001\t\u0013\u0011\t\u0004C\u0004\u0002P\u0002!IA!\u000f\t\u000f\u0005]\u0007\u0001\"\u0003\u0003@!9\u0011\u0011\u001d\u0001\u0005\n\t\u0015\u0003bBAu\u0001\u0011%!1\n\u0005\b\u0003c\u0004A\u0011\u0002B)\u0011\u001d\u00119\u0006\u0001C\u0005\u00053\u0012QcU9m'\u0016\u001cWO]5usJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002*U\u0005A1/Z2ve&$\u0018P\u0003\u0002,Y\u0005\u00191/\u001d7\u000b\u00055r\u0013A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011q\u0006M\u0001\nq2\u0014X\r\\3bg\u0016T!!\r\u001a\u0002\u0013a,'-[1mC\n\u001c(\"A\u001a\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u00011D\b\u0011\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005urT\"\u0001\u0017\n\u0005}b#AE*fGV\u0014\u0018\u000e^=SKB|7/\u001b;pef\u0004\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u000bMdg\r\u000e6\u000b\u0003\u0015\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003\u000f\n\u0013q\u0001T8hO&tw-\u0001\bs_2,'+\u001a9pg&$xN]=\u0011\u0005)cU\"A&\u000b\u0005%r\u0013BA'L\u0005AAFNU8mKJ+\u0007o\\:ji>\u0014\u00180A\ns_2,'k\u001c7fgJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002K!&\u0011\u0011k\u0013\u0002\u001512\u0014v\u000e\\3S_2,'+\u001a9pg&$xN]=\u00021I|G.\u001a)sS:\u001c\u0017\u000e]1mgJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002K)&\u0011Qk\u0013\u0002\u001a12\u0014v\u000e\\3Qe&t7-\u001b9bYJ+\u0007o\\:ji>\u0014\u00180A\rs_2,\u0007+\u001a:nSN\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JL\bC\u0001&Y\u0013\tI6J\u0001\u000eYYJ{G.\u001a)fe6L7o]5p]J+\u0007o\\:ji>\u0014\u00180\u0001\u0006tK\u000e,(/\u001a3DSN\u0004\"!\u0010/\n\u0005uc#AC*fGV\u0014X\rZ\"jg\u00061A(\u001b8jiz\"b\u0001\u00192dI\u00164\u0007CA1\u0001\u001b\u0005A\u0003\"\u0002%\u0007\u0001\u0004I\u0005\"\u0002(\u0007\u0001\u0004y\u0005\"\u0002*\u0007\u0001\u0004\u0019\u0006\"\u0002,\u0007\u0001\u00049\u0006\"\u0002.\u0007\u0001\u0004Y\u0016a\u0006;fC6lU-\u001c2fe2KW.\u001b;F]\u001a|'oY3s+\u0005I\u0007CA1k\u0013\tY\u0007FA\fUK\u0006lW*Z7cKJd\u0015.\\5u\u000b:4wN]2fe\u0006AB/Z1n\u001b\u0016l'-\u001a:MS6LG/\u00128g_J\u001cWM\u001d\u0011)\u0005!q\u0007CA8{\u001b\u0005\u0001(BA9s\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003gR\fqAZ1di>\u0014\u0018P\u0003\u0002vm\u0006)!-Z1og*\u0011q\u000f_\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u00110A\u0002pe\u001eL!a\u001f9\u0003\u0013\u0005+Ho\\<je\u0016$\u0017a\u00064pY\u0012,'\u000fV3b[2KW.\u001b;F]\u001a|'oY3s+\u0005q\bCA1\u0000\u0013\r\t\t\u0001\u000b\u0002\u0018\r>dG-\u001a:UK\u0006lG*[7ji\u0016sgm\u001c:dKJ\f\u0001DZ8mI\u0016\u0014H+Z1n\u0019&l\u0017\u000e^#oM>\u00148-\u001a:!Q\tQa.A\u0004hKR$V-Y7\u0015\t\u0005-\u0011q\u0003\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\u0018\u0002\r\u0011|W.Y5o\u0013\u0011\t)\"a\u0004\u0003\tQ+\u0017-\u001c\u0005\b\u00033Y\u0001\u0019AA\u000e\u0003\u0019!X-Y7JIB!\u0011QDA\u001d\u001d\u0011\ty\"!\u000e\u000f\t\u0005\u0005\u00121\u0007\b\u0005\u0003G\t\tD\u0004\u0003\u0002&\u0005=b\u0002BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-B'\u0001\u0004=e>|GOP\u0005\u0002g%\u0011\u0011GM\u0005\u0003_AJ!!\f\u0018\n\u0007\u0005]B&\u0001\nTK\u000e,(/\u001b;z%\u0016\u0004xn]5u_JL\u0018\u0002BA\u001e\u0003{\u0011a\u0001V3b[&#'bAA\u001cY\u0005Q1M]3bi\u0016$V-Y7\u0015\u0019\u0005m\u00111IA$\u0003\u0017\n)'!\u001b\t\u000f\u0005\u0015C\u00021\u0001\u0002\u001c\u0005Y1m\u001c8uC&tWM]%e\u0011\u001d\tI\u0005\u0004a\u0001\u00037\t\u0001\u0002^3b[:\u000bW.\u001a\u0005\n\u0003\u001bb\u0001\u0013!a\u0001\u0003\u001f\nQA]8mKN\u0004b!!\u0015\u0002Z\u0005}c\u0002BA*\u0003+\u00022!a\n9\u0013\r\t9\u0006O\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0013Q\f\u0002\u0004'\u0016$(bAA,qA!\u0011\u0011KA1\u0013\u0011\t\u0019'!\u0018\u0003\rM#(/\u001b8h\u0011%\t9\u0007\u0004I\u0001\u0002\u0004\ty%\u0001\u0006qe&t7-\u001b9bYND\u0011\"a\u001b\r!\u0003\u0005\r!a\u0014\u0002\u0017A,'/\\5tg&|gn]\u0001\u0015GJ,\u0017\r^3UK\u0006lG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005E$\u0006BA(\u0003gZ#!!\u001e\u0011\t\u0005]\u0014qP\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003cbJA!!!\u0002z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002)\r\u0014X-\u0019;f)\u0016\fW\u000e\n3fM\u0006,H\u000e\u001e\u00135\u0003Q\u0019'/Z1uKR+\u0017-\u001c\u0013eK\u001a\fW\u000f\u001c;%k\u0005QQ\u000f\u001d3bi\u0016$V-Y7\u0015\u0015\u0005m\u00111RAG\u0003+\u000b9\nC\u0004\u0002\u001aA\u0001\r!a\u0007\t\u000f\u00055\u0003\u00031\u0001\u0002\u0010B\u0019Q(!%\n\u0007\u0005MEFA\fUK\u0006l\u0017I\u001d:bsB\u0013x\u000e]3sif\u001c\u0005.\u00198hK\"9\u0011q\r\tA\u0002\u0005=\u0005bBA6!\u0001\u0007\u0011qR\u0001\u000bM&tG\rV3b[&#GCBAO\u0003G\u000b)\u000bE\u00038\u0003?\u000bY\"C\u0002\u0002\"b\u0012aa\u00149uS>t\u0007bBA##\u0001\u0007\u0011q\f\u0005\b\u0003\u0013\n\u0002\u0019AA0\u000311\u0017N\u001c3UK\u0006l')_%e)\u0019\tY+!,\u00020B)q'a(\u0002\f!9\u0011Q\t\nA\u0002\u0005m\u0001bBA\r%\u0001\u0007\u00111D\u0001\u000fM&tG\rV3b[\nKh*Y7f)\u0019\tY+!.\u00028\"9\u0011QI\nA\u0002\u0005}\u0003bBA%'\u0001\u0007\u0011qL\u0001\u000bI\u0016dW\r^3UK\u0006lG\u0003BA_\u0003\u0007\u00042aNA`\u0013\r\t\t\r\u000f\u0002\u0005+:LG\u000fC\u0004\u0002\u001aQ\u0001\r!a\u0007\u0002'\u0005$G\r\u0015:j]\u000eL\u0007/\u00197t)>$V-Y7\u0015\r\u0005u\u0016\u0011ZAf\u0011\u001d\tI\"\u0006a\u0001\u00037Aq!a\u001a\u0016\u0001\u0004\ti\r\u0005\u0004\u0002R\u0005e\u00131D\u0001\u0019e\u0016lwN^3Qe&t7-\u001b9bYN4%o\\7UK\u0006lGCBA_\u0003'\f)\u000eC\u0004\u0002\u001aY\u0001\r!a\u0007\t\u000f\u0005\u001dd\u00031\u0001\u0002N\u0006!\u0012\r\u001a3S_2,7OQ=OC6,Gk\u001c+fC6$b!!0\u0002\\\u0006u\u0007bBA\r/\u0001\u0007\u00111\u0004\u0005\b\u0003?<\u0002\u0019AA(\u0003%\u0011x\u000e\\3OC6,7/A\rsK6|g/\u001a*pY\u0016\u001c()\u001f(b[\u00164%o\\7UK\u0006lGCBA_\u0003K\f9\u000fC\u0004\u0002\u001aa\u0001\r!a\u0007\t\u000f\u0005}\u0007\u00041\u0001\u0002P\u0005!\u0012\r\u001a3QKJl\u0017n]:j_:\u001cHk\u001c+fC6$b!!0\u0002n\u0006=\bbBA\r3\u0001\u0007\u00111\u0004\u0005\b\u0003WJ\u0002\u0019AA(\u0003e\u0011X-\\8wKB+'/\\5tg&|gn\u001d$s_6$V-Y7\u0015\r\u0005u\u0016Q_A|\u0011\u001d\tIB\u0007a\u0001\u00037Aq!a\u001b\u001b\u0001\u0004\ty%\u0001\thKR\u001cuN\u001c;bS:,'oQ5JIR!\u0011Q B\u0002!\r9\u0014q`\u0005\u0004\u0005\u0003A$aA%oi\"9\u0011QI\u000eA\u0002\u0005}\u0013\u0001\u00074j]\u0012|\u0005\u000f^5p]\u0006d\u0007\f\u001c*pY\u0016\u0014\u0015PT1nKR1!\u0011\u0002B\f\u00057\u0001RaNAP\u0005\u0017\u0001BA!\u0004\u0003\u00145\u0011!q\u0002\u0006\u0004\u0005#Y\u0015\u0001C3oi&$\u0018.Z:\n\t\tU!q\u0002\u0002\u000712\u0014v\u000e\\3\t\u000f\teA\u00041\u0001\u0002~\u0006i1m\u001c8uC&tWM]\"j\u0013\u0012Dq!!\u0013\u001d\u0001\u0004\ty&\u0001\tgS:$w\n\u001d;j_:\fG\u000eV3b[R!!\u0011\u0002B\u0011\u0011\u001d\tI\"\ba\u0001\u00037\t\u0001CZ5oIJ+\u0017/^5sK\u0012$V-Y7\u0015\t\t-!q\u0005\u0005\b\u00033q\u0002\u0019AA\u000e\u0003]1\u0017N\u001c3HY>\u0014\u0017\r\u001c*pY\u0016LEm\u001d\"z\u001d\u0006lW\r\u0006\u0003\u0003.\t=\u0002CBA)\u00033\u0012Y\u0001C\u0004\u0002`~\u0001\r!a\u0014\u0015\r\u0005u&1\u0007B\u001c\u0011\u001d\u0011)\u0004\ta\u0001\u0005\u0017\tA\u0001^3b[\"9\u0011q\r\u0011A\u0002\u0005=CCBA_\u0005w\u0011i\u0004C\u0004\u00036\u0005\u0002\rAa\u0003\t\u000f\u0005\u001d\u0014\u00051\u0001\u0002NR1\u0011Q\u0018B!\u0005\u0007BqA!\u000e#\u0001\u0004\u0011Y\u0001C\u0004\u0002`\n\u0002\r!a\u0014\u0015\r\u0005u&q\tB%\u0011\u001d\u0011)d\ta\u0001\u0005\u0017Aq!a8$\u0001\u0004\ty\u0005\u0006\u0004\u0002>\n5#q\n\u0005\b\u0005k!\u0003\u0019\u0001B\u0006\u0011\u001d\tY\u0007\na\u0001\u0003\u001f\"b!!0\u0003T\tU\u0003b\u0002B\u001bK\u0001\u0007!1\u0002\u0005\b\u0003W*\u0003\u0019AA(\u0003E9W\r\u001e+fC6\fE\u000f\u001e:jEV$Xm\u001d\u000b\u0005\u0003\u0017\u0011Y\u0006C\u0004\u0003^\u0019\u0002\rAa\u0003\u0002\rad'k\u001c7fQ\r\u0001!\u0011\r\t\u0005\u0005G\u0012y'\u0004\u0002\u0003f)!!q\rB5\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0007-\u0012YGC\u0002\u0003n9\n!\u0001\u001a2\n\t\tE$Q\r\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlSecurityRepository
implements SecurityRepository,
Logging {
    private final XlRoleRepository roleRepository;
    private final XlRoleRoleRepository roleRolesRepository;
    private final XlRolePrincipalRepository rolePrincipalsRepository;
    private final XlRolePermissionRepository rolePermissionsRepository;
    private final SecuredCis securedCis;
    @Autowired
    private final TeamMemberLimitEnforcer teamMemberLimitEnforcer;
    @Autowired
    private final FolderTeamLimitEnforcer folderTeamLimitEnforcer;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlSecurityRepository sqlSecurityRepository = this;
        synchronized (sqlSecurityRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private TeamMemberLimitEnforcer teamMemberLimitEnforcer() {
        return this.teamMemberLimitEnforcer;
    }

    private FolderTeamLimitEnforcer folderTeamLimitEnforcer() {
        return this.folderTeamLimitEnforcer;
    }

    public Team getTeam(String teamId) {
        XlRole xlRole = this.findRequiredTeam(teamId);
        Team team = this.getTeamAttributes(xlRole);
        return team;
    }

    public String createTeam(String containerId, String teamName, scala.collection.immutable.Set<String> roles, scala.collection.immutable.Set<String> principals, scala.collection.immutable.Set<String> permissions) {
        XlRole xlRole;
        int containerCiId = this.getContainerCiId(containerId);
        Option<XlRole> option = this.findOptionalXlRoleByName(containerCiId, teamName);
        if (option instanceof Some) {
            XlRole xlRole2;
            Some some = (Some)option;
            xlRole = xlRole2 = (XlRole)some.value();
        } else if (None$.MODULE$.equals(option)) {
            this.teamMemberLimitEnforcer().enforceLimitForTeamMemberCreation(containerId, principals.size() + roles.size());
            String roleId = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(IdUtils$.MODULE$.getUniqueId("Team", "")), "/");
            XlRole xlRole3 = new XlRole(roleId, teamName, Predef$.MODULE$.int2Integer(containerCiId));
            xlRole = (XlRole)this.roleRepository.save(xlRole3);
        } else {
            throw new MatchError(option);
        }
        XlRole team = xlRole;
        this.addRolesByNameToTeam(team, roles);
        this.addPrincipalsToTeam(team, principals);
        this.addPermissionsToTeam(team, permissions);
        return team.getId();
    }

    public scala.collection.immutable.Set<String> createTeam$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public scala.collection.immutable.Set<String> createTeam$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public scala.collection.immutable.Set<String> createTeam$default$5() {
        return Predef$.MODULE$.Set().empty();
    }

    public String updateTeam(String teamId, TeamArrayPropertyChange roles, TeamArrayPropertyChange principals, TeamArrayPropertyChange permissions) {
        XlRole team = this.findRequiredTeam(teamId);
        this.teamMemberLimitEnforcer().enforceLimitForTeamMemberUpdate(teamId, principals, roles);
        this.addRolesByNameToTeam(team, (scala.collection.immutable.Set<String>)roles.add());
        this.addPrincipalsToTeam(team, (scala.collection.immutable.Set<String>)principals.add());
        this.addPermissionsToTeam(team, (scala.collection.immutable.Set<String>)permissions.add());
        this.removeRolesByNameFromTeam(team, (scala.collection.immutable.Set<String>)roles.remove());
        this.removePrincipalsFromTeam(team, (scala.collection.immutable.Set<String>)principals.remove());
        this.removePermissionsFromTeam(team, (scala.collection.immutable.Set<String>)permissions.remove());
        return team.getId();
    }

    public Option<String> findTeamId(String containerId, String teamName) {
        return this.findOptionalXlRoleByName(this.getContainerCiId(containerId), teamName).map((Function1 & Serializable)x$1 -> x$1.getId());
    }

    public Option<Team> findTeamById(String containerId, String teamId) {
        Some some;
        XlRole xlRole;
        int ciId = this.getContainerCiId(containerId);
        Option<XlRole> option = this.roleRepository.findByCiIdAndId(Predef$.MODULE$.int2Integer(ciId), teamId);
        if (option instanceof Some && (xlRole = (XlRole)(some = (Some)option).value()) != null) {
            XlRole xlRole2 = xlRole;
            Team team = this.getTeamAttributes(xlRole2);
            return Option$.MODULE$.apply((Object)team);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public Option<Team> findTeamByName(String containerId, String teamName) {
        Some some;
        XlRole xlRole;
        int ciId = this.getContainerCiId(containerId);
        Option<XlRole> option = this.findOptionalXlRoleByName(ciId, teamName);
        if (option instanceof Some && (xlRole = (XlRole)(some = (Some)option).value()) != null) {
            XlRole xlRole2 = xlRole;
            Team team = this.getTeamAttributes(xlRole2);
            return Option$.MODULE$.apply((Object)team);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public void deleteTeam(String teamId) {
        this.roleRolesRepository.deleteByIdRoleId(teamId);
        this.rolePrincipalsRepository.deleteByIdRoleId(teamId);
        this.rolePermissionsRepository.deleteByIdRoleId(teamId);
        this.roleRepository.deleteById(teamId);
    }

    public void addPrincipalsToTeam(String teamId, scala.collection.immutable.Set<String> principals) {
        XlRole team = this.findRequiredTeam(teamId);
        this.teamMemberLimitEnforcer().enforceLimitForTeamMemberAddition(teamId, principals.size(), this.teamMemberLimitEnforcer().enforceLimitForTeamMemberAddition$default$3());
        this.addPrincipalsToTeam(team, principals);
    }

    public void removePrincipalsFromTeam(String teamId, scala.collection.immutable.Set<String> principals) {
        this.findOptionalTeam(teamId).foreach((Function1 & Serializable)x$2 -> {
            this.removePrincipalsFromTeam(x$2, (scala.collection.immutable.Set<String>)principals);
            return BoxedUnit.UNIT;
        });
    }

    public void addRolesByNameToTeam(String teamId, scala.collection.immutable.Set<String> roleNames) {
        XlRole team = this.findRequiredTeam(teamId);
        this.teamMemberLimitEnforcer().enforceLimitForTeamMemberAddition(teamId, roleNames.size(), this.teamMemberLimitEnforcer().enforceLimitForTeamMemberAddition$default$3());
        this.addRolesByNameToTeam(team, roleNames);
    }

    public void removeRolesByNameFromTeam(String teamId, scala.collection.immutable.Set<String> roleNames) {
        this.findOptionalTeam(teamId).foreach((Function1 & Serializable)x$3 -> {
            this.removeRolesByNameFromTeam(x$3, (scala.collection.immutable.Set<String>)roleNames);
            return BoxedUnit.UNIT;
        });
    }

    public void addPermissionsToTeam(String teamId, scala.collection.immutable.Set<String> permissions) {
        XlRole team = this.findRequiredTeam(teamId);
        this.addPermissionsToTeam(team, permissions);
    }

    public void removePermissionsFromTeam(String teamId, scala.collection.immutable.Set<String> permissions) {
        this.findOptionalTeam(teamId).foreach((Function1 & Serializable)x$4 -> {
            this.removePermissionsFromTeam(x$4, (scala.collection.immutable.Set<String>)permissions);
            return BoxedUnit.UNIT;
        });
    }

    private int getContainerCiId(String containerId) {
        Option securityUid = Option$.MODULE$.apply((Object)this.securedCis.getEffectiveSecuredCi(containerId).getSecurityUid());
        return Ids$.MODULE$.toDbId(securityUid);
    }

    private Option<XlRole> findOptionalXlRoleByName(int containerCiId, String teamName) {
        return this.roleRepository.findByCiIdAndNameIgnoreCase(Predef$.MODULE$.int2Integer(containerCiId), teamName);
    }

    private Option<XlRole> findOptionalTeam(String teamId) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.roleRepository.findById(teamId)));
    }

    private XlRole findRequiredTeam(String teamId) {
        return (XlRole)this.roleRepository.findById(teamId).orElseThrow(() -> new NotFoundException("Team [" + teamId + "] not found", new Object[0]));
    }

    private scala.collection.immutable.Set<XlRole> findGlobalRoleIdsByName(scala.collection.immutable.Set<String> roleNames) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.roleRepository.findByCiIdAndNameIgnoreCaseIn(Predef$.MODULE$.int2Integer(-1), CollectionConverters$.MODULE$.SetHasAsJava(roleNames).asJava())).asScala().toSet();
    }

    private void addPrincipalsToTeam(XlRole team, scala.collection.immutable.Set<String> principals) {
        scala.collection.immutable.Set teamPrincipals = (scala.collection.immutable.Set)principals.map((Function1 & Serializable)x$5 -> new XlRolePrincipal(team, (String)x$5));
        this.rolePrincipalsRepository.saveAll(CollectionConverters$.MODULE$.SetHasAsJava((Set)teamPrincipals).asJava());
    }

    private void removePrincipalsFromTeam(XlRole team, scala.collection.immutable.Set<String> principals) {
        java.util.Set ids = CollectionConverters$.MODULE$.SetHasAsJava((Set)principals.map((Function1 & Serializable)principal -> new XlRolePrincipalId(team.getId(), (String)principal))).asJava();
        this.rolePrincipalsRepository.deleteAllById(ids);
    }

    private void addRolesByNameToTeam(XlRole team, scala.collection.immutable.Set<String> roleNames) {
        scala.collection.immutable.Set<XlRole> globalRoleIds = this.findGlobalRoleIdsByName(roleNames);
        scala.collection.immutable.Set teamRoles = (scala.collection.immutable.Set)globalRoleIds.map((Function1 & Serializable)x$6 -> new XlRoleRole(team, (XlRole)x$6));
        this.roleRolesRepository.saveAll(CollectionConverters$.MODULE$.SetHasAsJava((Set)teamRoles).asJava());
    }

    private void removeRolesByNameFromTeam(XlRole team, scala.collection.immutable.Set<String> roleNames) {
        scala.collection.immutable.Set<XlRole> memberRoles = this.findGlobalRoleIdsByName(roleNames);
        java.util.Set ids = CollectionConverters$.MODULE$.SetHasAsJava((Set)memberRoles.map((Function1 & Serializable)memberRole -> new XlRoleRoleId(team.getId(), memberRole.getId()))).asJava();
        this.roleRolesRepository.deleteAllById(ids);
    }

    private void addPermissionsToTeam(XlRole team, scala.collection.immutable.Set<String> permissions) {
        scala.collection.immutable.Set teamPermissions = (scala.collection.immutable.Set)permissions.map((Function1 & Serializable)x$7 -> new XlRolePermission(team, (String)x$7));
        this.rolePermissionsRepository.saveAll(CollectionConverters$.MODULE$.SetHasAsJava((Set)teamPermissions).asJava());
    }

    private void removePermissionsFromTeam(XlRole team, scala.collection.immutable.Set<String> permissions) {
        java.util.Set ids = CollectionConverters$.MODULE$.SetHasAsJava((Set)permissions.map((Function1 & Serializable)permission -> new XlRolePermissionId(team, (String)permission))).asJava();
        this.rolePermissionsRepository.deleteAllById(ids);
    }

    private Team getTeamAttributes(XlRole xlRole) {
        String teamId = xlRole.getId();
        List memberRoleNames = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.roleRolesRepository.findByIdRoleId(teamId)).asScala().map((Function1 & Serializable)x$8 -> x$8.getMemberRole().getName())).asJava();
        List permissions = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.rolePermissionsRepository.findByIdRoleId(teamId)).asScala().map((Function1 & Serializable)x$9 -> x$9.getId().getPermissionName())).asJava();
        List principals = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.rolePrincipalsRepository.findByIdRoleId(teamId)).asScala().map((Function1 & Serializable)x$10 -> x$10.getId().getPrincipalName())).asJava();
        Team team = new Team();
        team.setId(teamId);
        team.setTeamName(xlRole.getName());
        team.setPermissions(permissions);
        team.setMembers(principals);
        team.setRoles(memberRoleNames);
        return team;
    }

    public SqlSecurityRepository(XlRoleRepository roleRepository, XlRoleRoleRepository roleRolesRepository, XlRolePrincipalRepository rolePrincipalsRepository, XlRolePermissionRepository rolePermissionsRepository, SecuredCis securedCis) {
        this.roleRepository = roleRepository;
        this.roleRolesRepository = roleRolesRepository;
        this.rolePrincipalsRepository = rolePrincipalsRepository;
        this.rolePermissionsRepository = rolePermissionsRepository;
        this.securedCis = securedCis;
        Logging.$init$((Logging)this);
        this.teamMemberLimitEnforcer = null;
        this.folderTeamLimitEnforcer = null;
    }
}

