package com.xebialabs.xlrelease.spring.config

import com.xebialabs.xlrelease.config.CacheManagementConstants.SECURITY_USER_CACHE_MANAGER
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.security.sql.SecurityUserCacheConfigurationCondition
import com.xebialabs.xlrelease.support.cache.caffeine.spring.XlrCaffeineCacheManager
import org.springframework.cache.CacheManager
import org.springframework.context.annotation.{Bean, Conditional, Configuration}

@Configuration
@Conditional(value = Array(classOf[SecurityUserCacheConfigurationCondition]))
class SecurityUserCacheConfiguration(xlrConfig: XlrConfig) {

  @Bean(name = Array(SECURITY_USER_CACHE_MANAGER))
  def securityUserCacheManager(): CacheManager = {
    new XlrCaffeineCacheManager(SECURITY_USER_CACHE_MANAGER, xlrConfig.getCacheSettings("security-user"))
  }

}

