package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.limits.LimitEnforcer
import com.xebialabs.xlrelease.limits.LimitEnforcer.LimitType
import com.xebialabs.xlrelease.repository.{FolderRepository, PersistenceInterceptor}
import com.xebialabs.xlrelease.utils.TenantContext
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
@IsTransactional
class FolderLimitPersistenceInterceptor(limitEnforcer: LimitEnforcer,
                                        folderRepository: FolderRepository)
  extends PersistenceInterceptor[Folder] with Logging {

  folderRepository.registerPersistenceInterceptor(this)

  override def onCreate(ci: Folder): Unit = {
    enforceMaximumFolderLimits()
  }

  private def enforceMaximumFolderLimits(): Unit = {
    val tenantId = TenantContext.getTenant()
    limitEnforcer.enforceLimit(tenantId, LimitType.FOLDERS, 1, () => folderRepository.tenantFolderCount(tenantId))
  }
}
