package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.actors.cluster.ClusterMember
import com.xebialabs.xlrelease.db.sql.transaction.{IsReadOnly, IsTransactional}
import com.xebialabs.xlrelease.repository.ClusterMembersRepository
import com.xebialabs.xlrelease.repository.sql.persistence.ClusterMembersPersistence
import com.xebialabs.xlrelease.repository.sql.persistence.ClusterMembersPersistence.{ClusterMemberKey, ClusterMemberRow}

import java.time.Instant

@IsTransactional
class SqlClusterMembersRepository(persistence: ClusterMembersPersistence) extends ClusterMembersRepository {

  override def create(member: ClusterMember, ttl: Instant): Unit = {
    val clusterMemberRow = ClusterMemberRow(
      ClusterMemberKey.from(member),
      ttl
    )
    persistence.create(clusterMemberRow)
  }

  override def updateTtl(memberAddress: ClusterMember, ttl: Instant): Unit = {
    val clusterMemberKey = ClusterMemberKey.from(memberAddress)
    persistence.updateTtl(clusterMemberKey, ttl)
  }

  override def delete(memberAddress: ClusterMember): Unit = {
    val clusterMemberKey = ClusterMemberKey.from(memberAddress)
    persistence.delete(clusterMemberKey)
  }

  @IsReadOnly
  override def listActiveMembers(ttl: Instant): Seq[ClusterMember] = {
    persistence.listActiveMembers(ttl).map(_.toMember)
  }

  @IsReadOnly
  override def exits(member: ClusterMember): Boolean = {
    val clusterMemberKey = ClusterMemberKey.from(member)
    persistence.exists(clusterMemberKey)
  }

  override def deleteExpiredMembers(expiresAt: Instant): Unit = {
    persistence.deleteExpiredMembers(expiresAt)
  }
}
