package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.domain.{Release, ReleaseKind}
import com.xebialabs.xlrelease.limits.LimitEnforcer
import com.xebialabs.xlrelease.limits.LimitEnforcer.LimitType
import com.xebialabs.xlrelease.utils.TenantContext
import org.springframework.util.StringUtils.hasText

private[sql] trait ReleasePhaseTaskLimitValidator {
  def limitEnforcer: LimitEnforcer

  def ensureTenantId(ci: Release): String = {
    if (hasText(ci.getTenantId)) {
      ci.getTenantId
    } else {
      val tenantIdFromContext = TenantContext.getTenant()
      ci.setTenantId(tenantIdFromContext)
      tenantIdFromContext
    }
  }

  def enforcePhaseAndTaskLimits(ci: Release, tenantId: String): Unit = {
    if (!ci.getStatus.isInactive) {
      val (phaseLimitType, taskLimitType) = (ci.getKind, ci.isTemplate) match {
        case (ReleaseKind.RELEASE, true) => (LimitType.TEMPLATE_PHASES, LimitType.TEMPLATE_TASKS)
        case (ReleaseKind.RELEASE, false) => (LimitType.RELEASE_PHASES, LimitType.RELEASE_TASKS)
        case (ReleaseKind.WORKFLOW, true) => (LimitType.WORKFLOW_PHASES, LimitType.WORKFLOW_TASKS)
        case (ReleaseKind.WORKFLOW, false) => (LimitType.WORKFLOW_EXECUTION_PHASES, LimitType.WORKFLOW_EXECUTION_TASKS)
      }

      limitEnforcer.enforceLimit(tenantId, phaseLimitType, 0, () => ci.getPhases.size())
      limitEnforcer.enforceLimit(tenantId, taskLimitType, 0, () => ci.getAllTasks.size())
    }
  }
}
