/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import java.io.Serializable;
import java.util.List;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u001b\t92+\u001d7BiR\f7\r[7f]R\u0014V\r]8tSR|'/\u001f\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0006sKB|7/\u001b;pefT!a\u0002\u0005\u0002\u0013ad'/\u001a7fCN,'BA\u0005\u000b\u0003%AXMY5bY\u0006\u00147OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0003\n\u0005]!!\u0001F!ui\u0006\u001c\u0007.\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u0005mqR\"\u0001\u000f\u000b\u0005u\u0011\u0011a\u00039feNL7\u000f^3oG\u0016L!a\b\u000f\u0003%I+G.Z1tKB+'o]5ti\u0016t7-\u001a\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r*\u0003C\u0001\u0013\u0001\u001b\u0005\u0011\u0001\"B\r!\u0001\u0004Q\u0002\"B\u0014\u0001\t\u0003B\u0013\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\u0005%z\u0003C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u0019!w.\\1j]&\u0011af\u000b\u0002\u000b\u0003R$\u0018m\u00195nK:$\b\"\u0002\u0019'\u0001\u0004\t\u0014\u0001D1ui\u0006\u001c\u0007.\\3oi&#\u0007C\u0001\u001a:\u001d\t\u0019t\u0007\u0005\u00025!5\tQG\u0003\u00027\u0019\u00051AH]8pizJ!\u0001\u000f\t\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003qAA#AJ\u001f\u0011\u0005y*U\"A \u000b\u0005\u0001\u000b\u0015AC1o]>$\u0018\r^5p]*\u0011!iQ\u0001\b[\u0016$(/[2t\u0015\t!%\"\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\t1uHA\u0003US6,G\rC\u0003I\u0001\u0011\u0005\u0013*\u0001\u0004de\u0016\fG/\u001a\u000b\u0005S){E\u000bC\u0003L\u000f\u0002\u0007A*A\u0004sK2,\u0017m]3\u0011\u0005)j\u0015B\u0001(,\u0005\u001d\u0011V\r\\3bg\u0016DQ\u0001U$A\u0002E\u000bA\u0001^1tWB\u0011!FU\u0005\u0003'.\u0012A\u0001V1tW\")Qk\u0012a\u0001S\u0005Q\u0011\r\u001e;bG\"lWM\u001c;)\u0005\u001dk\u0004\"\u0002%\u0001\t\u0003BFcA\u0015Z5\")1j\u0016a\u0001\u0019\")Qk\u0016a\u0001S!\u0012q+\u0010\u0005\u0006;\u0002!\tEX\u0001\u0007I\u0016dW\r^3\u0015\u0007}\u00137\r\u0005\u0002\u0010A&\u0011\u0011\r\u0005\u0002\u0005+:LG\u000fC\u0003L9\u0002\u0007A\nC\u0003V9\u0002\u0007\u0011\u0006\u000b\u0002]{!\u0012\u0001A\u001a\t\u0003O6l\u0011\u0001\u001b\u0006\u0003S*\f1\u0002\u001e:b]N\f7\r^5p]*\u00111a\u001b\u0006\u0003Y\u001a\t!\u0001\u001a2\n\u00059D'aD%t)J\fgn]1di&|g.\u00197")
public class SqlAttachmentRepository
implements AttachmentRepository {
    private final ReleasePersistence releasePersistence;

    @Timed
    public Attachment findById(String attachmentId) {
        return (Attachment)this.releasePersistence.findAttachmentById(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{attachmentId});
        });
    }

    @Timed
    public Attachment create(Release release, Task task, Attachment attachment) {
        Task releaseTask = release.getTask(task.getId());
        Set taskAttachments = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(releaseTask.getAttachments()).asScala()).toSet().$plus((Object)attachment);
        releaseTask.setAttachments((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)taskAttachments.toList()).asJava());
        return this.create(release, attachment);
    }

    @Timed
    public Attachment create(Release release, Attachment attachment) {
        this.releasePersistence.update((Option<Release>)None$.MODULE$, release);
        this.releasePersistence.insertAttachments(release.getId(), (Seq<SourceArtifact>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attachment[]{attachment})));
        return attachment;
    }

    @Timed
    public void delete(Release release, Attachment attachment) {
        this.releasePersistence.update((Option<Release>)None$.MODULE$, release);
        this.releasePersistence.deleteAttachmentById(attachment.getId());
    }

    public SqlAttachmentRepository(ReleasePersistence releasePersistence) {
        this.releasePersistence = releasePersistence;
    }
}

