/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u001b\ti1+\u001d7TK\u000e,(/\u001a3DSNT!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005Q!/\u001a9pg&$xN]=\u000b\u0005\u001dA\u0011!\u0003=me\u0016dW-Y:f\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005!\u0011BA\f\u0005\u0005)\u0019VmY;sK\u0012\u001c\u0015n\u001d\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005\tbm\u001c7eKJ\u0004VM]:jgR,gnY3\u0011\u0005mqR\"\u0001\u000f\u000b\u0005u\u0011\u0011a\u00039feNL7\u000f^3oG\u0016L!a\b\u000f\u0003#\u0019{G\u000eZ3s!\u0016\u00148/[:uK:\u001cW\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u0005m\u0019\u0013B\u0001\u0013\u001d\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\t\u000b\u0019\u0002A\u0011A\u0014\u0002\rqJg.\u001b;?)\rA#f\u000b\t\u0003S\u0001i\u0011A\u0001\u0005\u00063\u0015\u0002\rA\u0007\u0005\u0006C\u0015\u0002\rA\t\u0005\u0006[\u0001!\tEL\u0001\u0016O\u0016$XI\u001a4fGRLg/Z*fGV\u0014X\rZ\"j)\tyS\u0007\u0005\u00021g5\t\u0011G\u0003\u00023\r\u0005A1/Z2ve&$\u00180\u0003\u00025c\tI1+Z2ve\u0016$7)\u001b\u0005\u0006m1\u0002\raN\u0001\fG>tG/Y5oKJLE\r\u0005\u00029\u007f9\u0011\u0011(\u0010\t\u0003uAi\u0011a\u000f\u0006\u0003y1\ta\u0001\u0010:p_Rt\u0014B\u0001 \u0011\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\u0002\u0002F\u0001\u0017D!\t!5*D\u0001F\u0015\t1u)\u0001\u0006b]:|G/\u0019;j_:T!\u0001S%\u0002\u000f5,GO]5dg*\u0011!JC\u0001\tG>$\u0017\r[1mK&\u0011A*\u0012\u0002\u0006)&lW\r\u001a\u0005\u0006\u001d\u0002!\teT\u0001\rO\u0016$8+Z2ve\u0016$7)\u001b\u000b\u0003_ACQAN'A\u0002]B#!T\"\t\u000bM\u0003A\u0011\u0002+\u0002\u0017\u0005\u001c8+Z2ve\u0016$7)\u001b\u000b\u0004_U3\u0006\"\u0002\u001cS\u0001\u00049\u0004\"B,S\u0001\u0004A\u0016aA;jIB\u0019q\"W.\n\u0005i\u0003\"AB(qi&|g\u000e\u0005\u0002]C6\tQL\u0003\u0002_?\u0006!A.\u00198h\u0015\u0005\u0001\u0017\u0001\u00026bm\u0006L!AY/\u0003\u000f%sG/Z4fe\")A\r\u0001C!K\u000692/\u001a;Bg\u00163g-Z2uSZ,7+Z2ve\u0016$7)\u001b\u000b\u0004M&T\u0007CA\bh\u0013\tA\u0007C\u0001\u0003V]&$\b\"\u0002\u001cd\u0001\u00049\u0004\"B6d\u0001\u0004a\u0017aC5t\u000b\u001a4Wm\u0019;jm\u0016\u0004\"aD7\n\u00059\u0004\"a\u0002\"p_2,\u0017M\u001c\u0015\u0003G\u000eC#\u0001A9\u0011\u0005IDX\"A:\u000b\u0005Q,\u0018a\u0003;sC:\u001c\u0018m\u0019;j_:T!a\u0001<\u000b\u0005]4\u0011A\u00013c\u0013\tI8OA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0001")
public class SqlSecuredCis
implements SecuredCis {
    private final FolderPersistence folderPersistence;
    private final ReleasePersistence releasePersistence;

    @Timed
    public SecuredCi getEffectiveSecuredCi(String containerId) {
        String string = containerId;
        SecuredCi securedCi = Ids.isFolderId((String)string) ? this.folderPersistence.getEffectiveSecuredCi(string) : (Ids.isReleaseId((String)string) ? this.releasePersistence.getEffectiveSecuredCi(string) : this.getSecuredCi(string));
        return securedCi;
    }

    @Timed
    public SecuredCi getSecuredCi(String containerId) {
        SecuredCi securedCi;
        String string = containerId;
        if (Ids.isFolderId((String)string)) {
            securedCi = this.folderPersistence.getSecuredCi(containerId);
        } else if (Ids.isReleaseId((String)string)) {
            securedCi = this.asSecuredCi(string, this.releasePersistence.findUidByReleaseId(string));
        } else {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to get UID for unsupported ID format [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{containerId})));
        }
        return securedCi;
    }

    private SecuredCi asSecuredCi(String containerId, Option<Integer> uid) {
        return new SecuredCi(containerId, ((Integer)uid.getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find release by ID [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{containerId})));
        })).toString());
    }

    @Timed
    public void setAsEffectiveSecuredCi(String containerId, boolean isEffective) {
        if (Ids.isFolderId((String)containerId)) {
            int oldSecurityUid = new StringOps(Predef$.MODULE$.augmentString(this.folderPersistence.getEffectiveSecuredCi(containerId).getSecurityUid())).toInt();
            FolderRow newFolderData = isEffective ? this.folderPersistence.setAsEffectiveSecuredCi(containerId) : this.folderPersistence.inheritEffectiveSecuredCi(containerId);
            this.releasePersistence.replaceSecurityUid(newFolderData.uid(), Predef$.MODULE$.int2Integer(oldSecurityUid), newFolderData.securityUid());
        } else if (isEffective) {
            this.releasePersistence.setAsEffectiveSecuredCi(containerId);
        } else {
            SecuredCi effectiveFolder = this.folderPersistence.getEffectiveSecuredCi(Ids.getParentId((String)containerId));
            this.releasePersistence.inheritSecurityFromFolder(containerId, Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(effectiveFolder.getSecurityUid())).toInt()));
        }
    }

    public SqlSecuredCis(FolderPersistence folderPersistence, ReleasePersistence releasePersistence) {
        this.folderPersistence = folderPersistence;
        this.releasePersistence = releasePersistence;
    }
}

