/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0005\u000b\u0001UA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\u0006i\u0001!\t%\u000e\u0005\u0006)\u0002!\t%\u0016\u0005\u0006)\u0002!\te\u0019\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006O\u0002!\te\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0002\u0018'Fd\u0017\t\u001e;bG\"lWM\u001c;SKB|7/\u001b;pefT!a\u0003\u0007\u0002\u0007M\fHN\u0003\u0002\u000e\u001d\u0005Q!/\u001a9pg&$xN]=\u000b\u0005=\u0001\u0012!\u0003=me\u0016dW-Y:f\u0015\t\t\"#A\u0005yK\nL\u0017\r\\1cg*\t1#A\u0002d_6\u001c\u0001a\u0005\u0003\u0001-q\u0001\u0003CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001e=5\tA\"\u0003\u0002 \u0019\t!\u0012\t\u001e;bG\"lWM\u001c;SKB|7/\u001b;pef\u0004\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u000bMdg\r\u000e6\u000b\u0003\u0015\n\u0001b\u001a:jujdW\rZ\u0005\u0003O\t\u0012q\u0001T8hO&tw-\u0001\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u000b\u0003-\u0001XM]:jgR,gnY3\n\u00059Z#A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\fa\u0001P5oSRtDCA\u00194!\t\u0011\u0004!D\u0001\u000b\u0011\u0015A#\u00011\u0001*\u0003!1\u0017N\u001c3Cs&#GC\u0001\u001c=!\t9$(D\u00019\u0015\tId\"\u0001\u0004e_6\f\u0017N\\\u0005\u0003wa\u0012!\"\u0011;uC\u000eDW.\u001a8u\u0011\u0015i4\u00011\u0001?\u00031\tG\u000f^1dQ6,g\u000e^%e!\tydI\u0004\u0002A\tB\u0011\u0011\tG\u0007\u0002\u0005*\u00111\tF\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015C\u0012A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\r)\u0005\rQ\u0005CA&S\u001b\u0005a%BA'O\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u001fB\u000bq!\\3ue&\u001c7O\u0003\u0002R%\u0005A1m\u001c3bQ\u0006dW-\u0003\u0002T\u0019\n)A+[7fI\u000611M]3bi\u0016$BA\u000e,\\A\")q\u000b\u0002a\u00011\u00069!/\u001a7fCN,\u0007CA\u001cZ\u0013\tQ\u0006HA\u0004SK2,\u0017m]3\t\u000bq#\u0001\u0019A/\u0002\tQ\f7o\u001b\t\u0003oyK!a\u0018\u001d\u0003\tQ\u000b7o\u001b\u0005\u0006C\u0012\u0001\rAN\u0001\u000bCR$\u0018m\u00195nK:$\bF\u0001\u0003K)\r1D-\u001a\u0005\u0006/\u0016\u0001\r\u0001\u0017\u0005\u0006C\u0016\u0001\rA\u000e\u0015\u0003\u000b)\u000ba\u0001Z3mKR,GcA5m[B\u0011qC[\u0005\u0003Wb\u0011A!\u00168ji\")qK\u0002a\u00011\")\u0011M\u0002a\u0001m!\u0012aA\u0013\u000b\u0004SB\f\b\"\u0002/\b\u0001\u0004i\u0006\"B1\b\u0001\u00041\u0004FA\u0004K\u0003-\u0011\u0017\r^2i\u0013:\u001cXM\u001d;\u0015\u0007%,h\u000fC\u0003X\u0011\u0001\u0007\u0001\fC\u0003x\u0011\u0001\u0007\u00010A\u0006biR\f7\r[7f]R\u001c\bcA=\u007fm9\u0011!\u0010 \b\u0003\u0003nL\u0011!G\u0005\u0003{b\tq\u0001]1dW\u0006<W-C\u0002\u0000\u0003\u0003\u00111aU3r\u0015\ti\b\u0004K\u0002\u0001\u0003\u000b\u0001B!a\u0002\u0002\u00145\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!A\u0006ue\u0006t7/Y2uS>t'bA\u0006\u0002\u0010)\u0019\u0011\u0011\u0003\b\u0002\u0005\u0011\u0014\u0017\u0002BA\u000b\u0003\u0013\u0011q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c")
public class SqlAttachmentRepository
implements AttachmentRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlAttachmentRepository sqlAttachmentRepository = this;
        synchronized (sqlAttachmentRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Attachment findById(String attachmentId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Searching for attachment [").append(attachmentId).append("]").toString());
        return (Attachment)this.releasePersistence.findAttachmentById(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{attachmentId});
        });
    }

    @Timed
    public Attachment create(Release release, Task task, Attachment attachment) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Adding attachment to task [").append(task.getId()).append("]").toString());
        Task releaseTask = release.getTask(task.getId());
        Set taskAttachments = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(releaseTask.getAttachments()).asScala()).toSet().$plus((Object)attachment);
        releaseTask.setAttachments((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)taskAttachments.toList()).asJava());
        return this.create(release, attachment);
    }

    @Timed
    public Attachment create(Release release, Attachment attachment) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Adding attachment to release [").append(release.getId()).append("]").toString());
        this.releasePersistence.update((Option<Release>)None$.MODULE$, release);
        this.releasePersistence.insertAttachments(release.getId(), (Seq<SourceArtifact>)new .colon.colon((Object)attachment, (List)Nil$.MODULE$));
        return attachment;
    }

    @Timed
    public void delete(Release release, Attachment attachment) {
        block0: {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Deleting attachment reference '").append(attachment.getId()).append("' from release '").append(release.getId()).append("'").toString());
            release.deleteAttachment(attachment.getId());
            this.releasePersistence.update(release);
            if (release.isTemplate()) break block0;
            this.releasePersistence.deleteAttachmentById(attachment.getId());
        }
    }

    @Timed
    public void delete(Task task, Attachment attachment) {
        task.deleteAttachment(attachment.getId());
        Release release = task.getRelease();
        if (release.getTasksUsingAttachment(attachment.getId()).isEmpty()) {
            this.delete(release, attachment);
        } else {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Deleting attachment reference ").append(attachment.getId()).append(" from task ").append(task.getId()).toString());
            this.releasePersistence.update(release);
        }
    }

    public void batchInsert(Release release, Seq<Attachment> attachments) {
        this.releasePersistence.insertAttachments(release.getId(), attachments);
    }

    public SqlAttachmentRepository(ReleasePersistence releasePersistence) {
        this.releasePersistence = releasePersistence;
        Logging.$init$((Logging)this);
    }
}

