/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.utils.Tree;
import com.xebialabs.xlrelease.domain.utils.Tree$;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.FoldersStoreException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderId$;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$FolderDataOps$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$NodeFolderDataOps$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\teh\u0001B\u0001\u0003\u00015\u00111cU9m\r>dG-\u001a:SKB|7/\u001b;pefT!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005Q!/\u001a9pg&$xN]=\u000b\u0005\u001dA\u0011!\u0003=me\u0016dW-Y:f\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001a\u0005\u0004\u0001\u001dQABe\n\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0003\n\u0005]!!\u0001\u0005$pY\u0012,'OU3q_NLGo\u001c:z!\rI\"\u0004H\u0007\u0002\u0005%\u00111D\u0001\u0002\u0016\u0013:$XM]2faR,GMU3q_NLGo\u001c:z!\ti\"%D\u0001\u001f\u0015\ty\u0002%\u0001\u0004g_2$WM\u001d\u0006\u0003C\u0019\ta\u0001Z8nC&t\u0017BA\u0012\u001f\u0005\u00191u\u000e\u001c3feB\u0011\u0011$J\u0005\u0003M\t\u0011QbU9m%\u0016\u0004xn]5u_JL\bC\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005a\u0013\u0001C4sSjTH.\u001a3\n\u00059J#a\u0002'pO\u001eLgn\u001a\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u0005\tbm\u001c7eKJ\u0004VM]:jgR,gnY3\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0012\u0011a\u00039feNL7\u000f^3oG\u0016L!AN\u001a\u0003#\u0019{G\u000eZ3s!\u0016\u00148/[:uK:\u001cW\r\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u0005IR\u0014BA\u001e4\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\t\u0011u\u0002!\u0011!Q\u0001\ny\na\u0002^3b[J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u0016\u007f%\u0011\u0001\t\u0002\u0002\u000f)\u0016\fWNU3q_NLGo\u001c:z\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0015A\u00059fe6L7o]5p]\u0016sgm\u001c:dKJ\u0004\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\u0011M,7-\u001e:jifT!\u0001\u0013\u0005\u0002\u0011\u0011,\u0007\u000f\\8zSRL!AS#\u0003%A+'/\\5tg&|g.\u00128g_J\u001cWM\u001d\u0005\t\u0019\u0002\u0011)\u0019!C\u0001\u001b\u0006\u0001B-Z2pe\u0006$xN]*feZL7-Z\u000b\u0002\u001dB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\tS:$XM\u001d8bY*\u00111KB\u0001\u0004CBL\u0017BA+Q\u0005\u0001Je\u000e^3s]\u0006dW*\u001a;bI\u0006$\u0018\rR3d_J\fGo\u001c:TKJ4\u0018nY3\t\u0011]\u0003!\u0011!Q\u0001\n9\u000b\u0011\u0003Z3d_J\fGo\u001c:TKJ4\u0018nY3!\u0011!I\u0006A!b\u0001\n\u0007Q\u0016\u0001\u00046eE\u000e$V-\u001c9mCR,W#A.\u0011\u0005q+W\"A/\u000b\u0005y{\u0016\u0001B2pe\u0016T!\u0001Y1\u0002\t)$'m\u0019\u0006\u0003E\u000e\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002I\u0006\u0019qN]4\n\u0005\u0019l&\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0007\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B.\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0011!Q\u0007A!b\u0001\n\u0007Y\u0017a\u00023jC2,7\r^\u000b\u0002YB\u0019Q.!\u0001\u000f\u00059lhBA8|\u001d\t\u0001\u0018P\u0004\u0002rq:\u0011!o\u001e\b\u0003gZl\u0011\u0001\u001e\u0006\u0003k2\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\tQh!\u0001\u0002eE&\u00111\u0001 \u0006\u0003u\u001aI!A`@\u0002\u0015M\u000bHNQ;jY\u0012,'O\u0003\u0002\u0004y&!\u00111AA\u0003\u0005\u001d!\u0015.\u00197fGRT!A`@\t\u0013\u0005%\u0001A!A!\u0002\u0013a\u0017\u0001\u00033jC2,7\r\u001e\u0011\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010\u00051A(\u001b8jiz\"\u0002#!\u0005\u0002\u0014\u0005U\u0011qCA\r\u00037\ti\"a\b\u0011\u0005e\u0001\u0001B\u0002\u0019\u0002\f\u0001\u0007\u0011\u0007\u0003\u00049\u0003\u0017\u0001\r!\u000f\u0005\u0007{\u0005-\u0001\u0019\u0001 \t\r\t\u000bY\u00011\u0001D\u0011\u0019a\u00151\u0002a\u0001\u001d\"1\u0011,a\u0003A\u0004mCaA[A\u0006\u0001\ba\u0007bBA\u0012\u0001\u0011\u0005\u0013QE\u0001\u0007KbL7\u000f^:\u0015\t\u0005\u001d\u0012Q\u0006\t\u0004\u001f\u0005%\u0012bAA\u0016!\t9!i\\8mK\u0006t\u0007\u0002CA\u0018\u0003C\u0001\r!!\r\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012\u0004B!a\r\u0002<9!\u0011QGA\u001c!\t\u0019\b#C\u0002\u0002:A\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u001f\u0003\u007f\u0011aa\u0015;sS:<'bAA\u001d!!\"\u0011\u0011EA\"!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%\u007f\u0006YAO]1og\u0006\u001cG/[8o\u0013\u0011\ti%a\u0012\u0003\u0015%\u001b(+Z1e\u001f:d\u0017\u0010\u000b\u0003\u0002\"\u0005E\u0003\u0003BA*\u0003Cj!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u000bC:tw\u000e^1uS>t'\u0002BA.\u0003;\nq!\\3ue&\u001c7OC\u0002\u0002`)\t\u0001bY8eC\"\fG.Z\u0005\u0005\u0003G\n)FA\u0003US6,G\rC\u0004\u0002h\u0001!\t%!\u001b\u0002\u0011\u001d,G\u000fV5uY\u0016$B!a\u001b\u0002rA)q\"!\u001c\u00022%\u0019\u0011q\u000e\t\u0003\r=\u0003H/[8o\u0011!\ty#!\u001aA\u0002\u0005E\u0002\u0006BA3\u0003\u0007BC!!\u001a\u0002R!9\u0011\u0011\u0010\u0001\u0005B\u0005m\u0014aB4fiB\u000bG\u000f\u001b\u000b\u0005\u0003{\ny\t\u0005\u0004\u0002\u0000\u0005%\u0015\u0011\u0007\b\u0005\u0003\u0003\u000b)ID\u0002t\u0003\u0007K\u0011!E\u0005\u0004\u0003\u000f\u0003\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\u000biIA\u0002TKFT1!a\"\u0011\u0011!\ty#a\u001eA\u0002\u0005E\u0002\u0006BA<\u0003\u0007BC!a\u001e\u0002R!9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0015AB4fiVKG\r\u0006\u0003\u0002\u001c\u0006M\u0006\u0003BAO\u0003[sA!a(\u0002,:!\u0011\u0011UAU\u001d\u0011\t\u0019+a*\u000f\u0007A\f)+\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003i\tI1!a\"4\u0013\u0011\ty+!-\u0003\u000b\rKW+\u001b3\u000b\u0007\u0005\u001d5\u0007\u0003\u0005\u00020\u0005U\u0005\u0019AA\u0019Q\u0011\t)*a\u0011)\t\u0005U\u0015\u0011\u000b\u0005\b\u0003w\u0003A\u0011IA_\u0003!1\u0017N\u001c3Cs&#GCBA`\u0003\u0003\f\u0019\r\u0005\u0003\u0010\u0003[b\u0002\u0002CA\u0018\u0003s\u0003\r!!\r\t\u0015\u0005\u0015\u0017\u0011\u0018I\u0001\u0002\u0004\t9-A\u0003eKB$\b\u000eE\u0002\u0010\u0003\u0013L1!a3\u0011\u0005\rIe\u000e\u001e\u0015\u0005\u0003s\u000b\t\u0006C\u0004\u0002R\u0002!\t%a5\u0002'1L7\u000f\u001e,jK^\f'\r\\3G_2$WM]:\u0015\u0011\u0005U\u0017q[An\u0003K\u0004R!a \u0002\nrA\u0001\"!7\u0002P\u0002\u0007\u0011\u0011G\u0001\ta\u0006\u0014XM\u001c;JI\"A\u0011Q\\Ah\u0001\u0004\ty.\u0001\u0003qC\u001e,\u0007cA\u000b\u0002b&\u0019\u00111\u001d\u0003\u0003\tA\u000bw-\u001a\u0005\u000b\u0003O\fy\r%AA\u0002\u0005\u001d\u0012a\u00063fG>\u0014\u0018\r^3XSRD\u0007+\u001a:nSN\u001c\u0018n\u001c8tQ\u0011\ty-!\u0015\t\u000f\u00055\b\u0001\"\u0001\u0002p\u0006A2/\u001a;Bg\u00163g-Z2uSZ,7+Z2ve&$\u00180\u00133\u0015\t\u0005E\u0018q\u001f\t\u0004\u001f\u0005M\u0018bAA{!\t!QK\\5u\u0011!\ty#a;A\u0002\u0005E\u0002\u0006BAv\u0003#Bq!!@\u0001\t\u0003\ty0\u0001\u000ej]\",'/\u001b;FM\u001a,7\r^5wKN+7-\u001e:jifLE\r\u0006\u0003\u0002r\n\u0005\u0001\u0002CA\u0018\u0003w\u0004\r!!\r)\t\u0005m\u0018\u0011\u000b\u0005\b\u0005\u000f\u0001A\u0011\tB\u0005\u0003\u0019\u0019'/Z1uKR)ADa\u0003\u0003\u000e!A\u0011\u0011\u001cB\u0003\u0001\u0004\t\t\u0004\u0003\u0004 \u0005\u000b\u0001\r\u0001\b\u0015\u0005\u0005\u000b\t\t\u0006C\u0004\u0003\u0014\u0001!\tE!\u0006\u0002\r\u0011,G.\u001a;f)\u0019\t\tPa\u0006\u0003\u001a!A\u0011q\u0006B\t\u0001\u0004\t\t\u0004\u0003\u0006\u0003\u001c\tE\u0001\u0013!a\u0001\u0005;\tQ\u0002Z3mKR,'+\u001a7fCN,\u0007#C\b\u0003 \u0005\u001d\u0017\u0011GAy\u0013\r\u0011\t\u0003\u0005\u0002\n\rVt7\r^5p]JBCA!\u0005\u0002R!9!q\u0005\u0001\u0005B\t%\u0012A\u0002:f]\u0006lW\rF\u0003\u001d\u0005W\u0011i\u0003\u0003\u0005\u00020\t\u0015\u0002\u0019AA\u0019\u0011!\u0011yC!\nA\u0002\u0005E\u0012a\u00028fo:\u000bW.\u001a\u0015\u0005\u0005K\t\t\u0006C\u0004\u00036\u0001!\tEa\u000e\u0002\t5|g/\u001a\u000b\u00069\te\"1\b\u0005\t\u0003_\u0011\u0019\u00041\u0001\u00022!A!Q\bB\u001a\u0001\u0004\t\t$A\u0006oK^\u0004\u0016M]3oi&#\u0007\u0006\u0002B\u001a\u0003#BqAa\u0011\u0001\t\u0003\u0012)%\u0001\u0006gS:$')\u001f)bi\"$R\u0001\bB$\u0005\u0017B\u0001B!\u0013\u0003B\u0001\u0007\u0011\u0011G\u0001\ni&$H.\u001a)bi\"D!\"!2\u0003BA\u0005\t\u0019AAdQ\u0011\u0011\t%!\u0015\t\u000f\tE\u0003\u0001\"\u0011\u0003T\u0005!b-\u001b8e'V\u0014gi\u001c7eKJ\u0014\u0015\u0010V5uY\u0016$b!a0\u0003V\t]\u0003\u0002CAm\u0005\u001f\u0002\r!!\r\t\u0011\te#q\na\u0001\u0003c\tAA\\1nK\"\"!qJA)\u0011!\u0011y\u0006\u0001C\u0001\u0005\t\u0005\u0014\u0001\u00074j]\u0012\u001cVO\u0019$pY\u0012,'\u000fR1uC\nKH+\u001b;mKR1!1\rB9\u0005g\u0002RaDA7\u0005K\u0002BAa\u001a\u0003n5\u0011!\u0011\u000e\u0006\u0004\u0005W\u001a\u0014\u0001\u00023bi\u0006LAAa\u001c\u0003j\tIai\u001c7eKJ\u0014vn\u001e\u0005\t\u0003_\u0011i\u00061\u0001\u00022!A!\u0011\fB/\u0001\u0004\t\t\u0004\u0003\u0005\u0003x\u0001!\tA\u0001B=\u0003)Ign]3si:{G-\u001a\u000b\t\u0005w\u0012)Ja&\u0003\u001cB1!Q\u0010BH\u0005KrAAa \u0003\n:!!\u0011\u0011BC\u001d\r\u0001(1Q\u0005\u0003C\u0019I1Aa\"!\u0003\u0015)H/\u001b7t\u0013\u0011\u0011YI!$\u0002\tQ\u0013X-\u001a\u0006\u0004\u0005\u000f\u0003\u0013\u0002\u0002BI\u0005'\u0013AAT8eK*!!1\u0012BG\u0011!\u0011IF!\u001eA\u0002\u0005E\u0002\u0002\u0003BM\u0005k\u0002\r!!\r\u0002\u000f\u001dLg/\u001a8JI\"A!Q\u0014B;\u0001\u0004\tY'A\u0006qCJ,g\u000e^%e\u001fB$\b\u0002\u0003BQ\u0001\u0011\u0005!Aa)\u0002\u0019\u0019Lg\u000e\u001a(pI\u0016\u0014\u00150\u00133\u0015\r\tm$Q\u0015BT\u0011!\tyCa(A\u0002\u0005E\u0002BCAc\u0005?\u0003\n\u00111\u0001\u0002H\"A!1\u0016\u0001\u0005\u0002\t\u0011i+A\u0007gS:$gj\u001c3f\u0005f,\u0016\u000e\u001a\u000b\u0007\u0005w\u0012yKa-\t\u0011\tE&\u0011\u0016a\u0001\u00037\u000bQaY5VS\u0012D!\"!2\u0003*B\u0005\t\u0019AAd\u0011\u001d\u00119\f\u0001C\u0005\u0005s\u000b\u0011\u0003\\5tiZKWm^1cY\u0016tu\u000eZ3t)\u0019\u0011YL!1\u0003DB1\u0011q\u0010B_\u0005wJAAa0\u0002\u000e\n!A*[:u\u0011!\tyC!.A\u0002\u0005E\u0002BCAc\u0005k\u0003\n\u00111\u0001\u0002H\"Q!q\u0019\u0001\u0012\u0002\u0013\u0005!A!3\u0002-\u0019Lg\u000e\u001a(pI\u0016\u0014\u00150\u00133%I\u00164\u0017-\u001e7uII*\"Aa3+\t\u0005\u001d'QZ\u0016\u0003\u0005\u001f\u0004BA!5\u0003Z6\u0011!1\u001b\u0006\u0005\u0005+\u00149.A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u000b\t\n\t\tm'1\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003Bp\u0001E\u0005I\u0011\u0001Bq\u0003ua\u0017n\u001d;WS\u0016<\u0018M\u00197f\r>dG-\u001a:tI\u0011,g-Y;mi\u0012\u001aTC\u0001BrU\u0011\t9C!4\t\u0013\t\u001d\b!%A\u0005\n\t%\u0017a\u00077jgR4\u0016.Z<bE2,gj\u001c3fg\u0012\"WMZ1vYR$#\u0007C\u0005\u0003l\u0002\t\n\u0011\"\u0011\u0003J\u0006!b-\u001b8e\u0005f\u0004\u0016\r\u001e5%I\u00164\u0017-\u001e7uIIB!Ba<\u0001#\u0003%\tA\u0001Be\u0003]1\u0017N\u001c3O_\u0012,')_+jI\u0012\"WMZ1vYR$#\u0007K\u0002\u0001\u0005g\u0004B!!\u0012\u0003v&!!q_A$\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlFolderRepository
implements FolderRepository,
InterceptedRepository<Folder>,
SqlRepository {
    private final FolderPersistence folderPersistence;
    private final ReleasePersistence releasePersistence;
    private final TeamRepository teamRepository;
    private final PermissionEnforcer permissionEnforcer;
    private final InternalMetadataDecoratorService decoratorService;
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private Seq<PersistenceInterceptor<Folder>> persistenceInterceptors;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    @Override
    public void registerPersistenceInterceptor(PersistenceInterceptor<Folder> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$(this, persistenceInterceptor);
    }

    @Override
    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$(this, ci);
    }

    @Override
    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$(this, ciId);
    }

    public void checkFolderExists(String folderId) {
        FolderRepository.checkFolderExists$((FolderRepository)this, (String)folderId);
    }

    public void checkNameIsUnique(String parentId, String name) {
        FolderRepository.checkNameIsUnique$((FolderRepository)this, (String)parentId, (String)name);
    }

    public Seq<Folder> paginate(Seq<Folder> folders, Page page) {
        return FolderRepository.paginate$((FolderRepository)this, folders, (Page)page);
    }

    public Seq<Folder> decorateWithEffectiveSecurity(Seq<Folder> folders) {
        return FolderRepository.decorateWithEffectiveSecurity$((FolderRepository)this, folders);
    }

    public Function2<Object, String, BoxedUnit> delete$default$2() {
        return FolderRepository.delete$default$2$((FolderRepository)this);
    }

    public int findById$default$2() {
        return FolderRepository.findById$default$2$((FolderRepository)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Seq<PersistenceInterceptor<Folder>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    @Override
    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Folder>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlFolderRepository sqlFolderRepository = this;
        synchronized (sqlFolderRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String folderId) {
        return this.folderPersistence.exists(folderId);
    }

    @Timed
    @IsReadOnly
    public Option<String> getTitle(String folderId) {
        return this.findById(folderId, 0).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getTitle());
    }

    @Timed
    @IsReadOnly
    public Seq<String> getPath(String folderId) {
        return this.folderPersistence.getFolderPathSegments(folderId);
    }

    @Timed
    @IsReadOnly
    public Integer getUid(String folderId) {
        return this.folderPersistence.getUid(folderId);
    }

    @Timed
    public Option<Folder> findById(String folderId, int depth) {
        return Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, this.findNodeById$default$2()))).map((Function1 & Serializable & scala.Serializable)tree -> {
            void var2_2;
            Folder folder = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)tree));
            this.decoratorService().decorate((ConfigurationItem)folder, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
            return var2_2;
        });
    }

    @Timed
    public Seq<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions) {
        Seq<Folder> results = (Seq<Folder>)this.listViewableNodes(parentId, this.listViewableNodes$default$2()).map((Function1 & Serializable & scala.Serializable)x$2 -> FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)x$2)), List$.MODULE$.canBuildFrom());
        return this.paginate(decorateWithPermissions ? this.decorateWithEffectiveSecurity(results) : results, page);
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    @Timed
    public void setAsEffectiveSecurityId(String folderId) {
        this.folderPersistence.setAsEffectiveSecuredCi(folderId);
    }

    @Timed
    public void inheritEffectiveSecurityId(String folderId) {
        this.folderPersistence.inheritEffectiveSecuredCi(folderId);
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            this.interceptCreate((ConfigurationItem)folder);
            return this.insertNode(folder.getTitle(), folder.getId(), (Option<String>)new Some((Object)parentId));
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new FoldersStoreException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot create folder ", " under ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folder.getId(), parentId})), e);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Tree.Node created = (Tree.Node)success.value();
        Folder folder2 = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)created));
        return folder2;
    }

    @Timed
    public void delete(String folderId, Function2<Object, String, BoxedUnit> deleteRelease) {
        Integer ciUid = ((FolderRow)this.findNodeById(folderId, 0).value()).uid();
        this.folderPersistence.deleteReleases(ciUid, deleteRelease);
        Tree.TreeOps$.MODULE$.bottomUp$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, this.findNodeById$default$2()))).foreach((Function1 & Serializable & scala.Serializable)data -> {
            SqlFolderRepository.$anonfun$delete$1(this, data);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        return this.folderPersistence.rename(folderId, newName, this.folderPersistence.rename$default$3());
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        Integer oldSubtreeSecurityUid = ((FolderRow)this.findNodeById(folderId, 0).value()).securityUid();
        Tree.Node<FolderRow> moved = this.folderPersistence.move(folderId, newParentId, this.folderPersistence.move$default$3());
        Integer newSubtreeSecurityUid = ((FolderRow)moved.value()).securityUid();
        this.releasePersistence.replaceSecurityUid(((FolderRow)moved.value()).uid(), oldSubtreeSecurityUid, newSubtreeSecurityUid);
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps(moved));
    }

    @Timed
    public Folder findByPath(String titlePath, int depth) {
        if (Strings.isEmpty((String)titlePath)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find folder by empty path: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{titlePath})), new Object[0]);
        }
        String pathFromRoot = titlePath.startsWith("/") ? titlePath.substring(1) : titlePath;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finding folder by path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pathFromRoot})));
        String[] pathElements = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathFromRoot.split("/"))).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty()));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).isEmpty()) {
            throw new IllegalArgumentException("No folder path specified, the root path is not supported");
        }
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).headOption();
        if (None$.MODULE$.equals(option)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find folder by empty path: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{titlePath})), new Object[0]);
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String topName = (String)some.value();
        Option<FolderRow> option2 = this.findSubFolderDataByTitle(Ids.ROOT_FOLDER_ID, topName);
        Option<FolderRow> topLevelData = option2;
        Integer topLevelUid = (Integer)topLevelData.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.uid()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find folder [", "] in path [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), titlePath})), new Object[0]);
        });
        Tree.Node topNode = (Tree.Node)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeByUid(topLevelUid, Math.max(depth, ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).tail()).length)))).get();
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)((Tree.Node)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).tail())).foldLeft((Object)topNode, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tree.Node node = (Tree.Node)tuple2._1();
            String pathElement = (String)tuple2._2();
            Tree.Node node2 = (Tree.Node)node.children().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlFolderRepository.$anonfun$findByPath$7(pathElement, x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find folder [", "] in path [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pathElement, titlePath})), new Object[0]);
            });
            return node2;
        }))));
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public Option<Folder> findSubFolderByTitle(String parentId, String name) {
        return this.findSubFolderDataByTitle(parentId, name).map((Function1 & Serializable & scala.Serializable)x$6 -> FolderRow$FolderDataOps$.MODULE$.asFolder$extension(FolderRow$.MODULE$.FolderDataOps((FolderRow)x$6)));
    }

    public Option<FolderRow> findSubFolderDataByTitle(String folderId, String name) {
        return this.folderPersistence.findSubFolderByTitle(name, folderId);
    }

    public Tree.Node<FolderRow> insertNode(String name, String givenId, Option<String> parentIdOpt) {
        return this.folderPersistence.create(name, givenId, parentIdOpt);
    }

    public Tree.Node<FolderRow> findNodeById(String folderId, int depth) {
        return this.folderPersistence.findById(folderId, depth);
    }

    public int findNodeById$default$2() {
        return Integer.MAX_VALUE;
    }

    public Tree.Node<FolderRow> findNodeByUid(Integer ciUid, int depth) {
        return this.folderPersistence.findByUid(ciUid, depth);
    }

    public int findNodeByUid$default$2() {
        return Integer.MAX_VALUE;
    }

    private List<Tree.Node<FolderRow>> listViewableNodes(String folderId, int depth) {
        Tree.Node<FolderRow> viewableTree = this.permissionEnforcer.isCurrentUserAdmin() ? this.folderPersistence.findById(folderId, depth) : this.folderPersistence.findByIdHavingPermission(folderId, XLReleasePermissions.VIEW_FOLDER, (Iterable<String>)((Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala()), depth);
        return (List)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(viewableTree)).fold((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)x$7 -> x$7.children());
    }

    private int listViewableNodes$default$2() {
        return Integer.MAX_VALUE;
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlFolderRepository $this, FolderRow data) {
        if (data.hasSecurity()) {
            $this.teamRepository.deleteTeamsFromPlatform(FolderId$.MODULE$.absolute$extension(data.folderId()));
        }
        $this.folderPersistence.deleteByUid(data.uid());
        $this.interceptDelete(FolderId$.MODULE$.absolute$extension(data.folderId()));
    }

    public static final /* synthetic */ boolean $anonfun$findByPath$7(String pathElement$1, Tree.Node x$5) {
        String string = ((FolderRow)x$5.value()).name();
        String string2 = pathElement$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlFolderRepository(FolderPersistence folderPersistence, ReleasePersistence releasePersistence, TeamRepository teamRepository, PermissionEnforcer permissionEnforcer, InternalMetadataDecoratorService decoratorService, JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.folderPersistence = folderPersistence;
        this.releasePersistence = releasePersistence;
        this.teamRepository = teamRepository;
        this.permissionEnforcer = permissionEnforcer;
        this.decoratorService = decoratorService;
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Logging.$init$((Logging)this);
        FolderRepository.$init$((FolderRepository)this);
        InterceptedRepository.$init$(this);
    }
}

