/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\tUc\u0001B\u0001\u0003\u00015\u0011\u0011cU9m)\u0006\u001c8NU3q_NLGo\u001c:z\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\b\u0011\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u0019r\u0001\u0001\b\u00151qy\"\u0005\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011\u0001B\u0005\u0003/\u0011\u0011a\u0002V1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u001a55\t!!\u0003\u0002\u001c\u0005\tI\")Y:f%\u0016dW-Y:f\u0013R,WNU3q_NLGo\u001c:z!\tIR$\u0003\u0002\u001f\u0005\t1B)Z:fe&\fG.\u001b>bi&|gnU;qa>\u0014H\u000f\u0005\u0002\u001aA%\u0011\u0011E\u0001\u0002\u001f\u0007>tg-[4ve\u0006$\u0018n\u001c8SK\u001a,'/\u001a8dKN\u001cV\u000f\u001d9peR\u0004\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\u000bMdg\r\u000e6\u000b\u0003\u001d\n\u0001b\u001a:jujdW\rZ\u0005\u0003S\u0011\u0012q\u0001T8hO&tw\r\u0003\u0005,\u0001\t\u0015\r\u0011\"\u0001-\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0016\u00035\u0002\"AL\u0019\u000e\u0003=R!\u0001\r\u0002\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003e=\u0012!CU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\"AA\u0007\u0001B\u0001B\u0003%Q&A\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0005\u0003\u00057\u0001\t\u0015\r\u0011\"\u00018\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016,\u0012\u0001\u000f\t\u0003]eJ!AO\u0018\u0003+\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dK\"AA\b\u0001B\u0001B\u0003%\u0001(\u0001\feKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3!\u0011!q\u0004A!b\u0001\n\u0003y\u0014a\u0004;bg.\u0004VM]:jgR,gnY3\u0016\u0003\u0001\u0003\"AL!\n\u0005\t{#a\u0004+bg.\u0004VM]:jgR,gnY3\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0001\u000b\u0001\u0003^1tWB+'o]5ti\u0016t7-\u001a\u0011\t\u0011\u0019\u0003!Q1A\u0005\u0002\u001d\u000b\u0011cY8n[\u0016tGOU3q_NLGo\u001c:z+\u0005A\u0005CA\u000bJ\u0013\tQEAA\tD_6lWM\u001c;SKB|7/\u001b;pefD\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I\u0001S\u0001\u0013G>lW.\u001a8u%\u0016\u0004xn]5u_JL\b\u0005\u0003\u0005O\u0001\t\u0015\r\u0011\"\u0001P\u0003E\u0011X\r]8tSR|'/_!eCB$XM]\u000b\u0002!B\u0011\u0011$U\u0005\u0003%\n\u0011AcU9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000f\t\u0005\t-\u0002\u0011)\u0019!C\u0001/\u0006A2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3\u0016\u0003a\u0003\"AL-\n\u0005i{#\u0001G\"p]\u001aLw-\u001e:bi&|g\u000eU3sg&\u001cH/\u001a8dK\"AA\f\u0001B\u0001B\u0003%\u0001,A\rd_:4\u0017nZ;sCRLwN\u001c)feNL7\u000f^3oG\u0016\u0004\u0003\u0002\u00030\u0001\u0005\u000b\u0007I\u0011A0\u0002\u001f\u0019\f7-\u001a;SKB|7/\u001b;pef,\u0012\u0001\u0019\t\u0003+\u0005L!A\u0019\u0003\u0003\u001f\u0019\u000b7-\u001a;SKB|7/\u001b;pefD\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I\u0001Y\u0001\u0011M\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0002B\u0001B\u001a\u0001\u0003\u0006\u0004%\u0019aZ\u0001\bI&\fG.Z2u+\u0005A\u0007CA5}\u001d\tQ\u0017P\u0004\u0002lo:\u0011A.\u001e\b\u0003[Rt!A\\:\u000f\u0005=\u0014X\"\u00019\u000b\u0005Ed\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011aOB\u0001\u0003I\nL!a\u0001=\u000b\u0005Y4\u0011B\u0001>|\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003\u0007aL!! @\u0003\u000f\u0011K\u0017\r\\3di*\u0011!p\u001f\u0005\n\u0003\u0003\u0001!\u0011!Q\u0001\n!\f\u0001\u0002Z5bY\u0016\u001cG\u000f\t\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0003\u0019a\u0014N\\5u}Q\u0011\u0012\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0011qCA\r!\tI\u0002\u0001\u0003\u0004,\u0003\u0007\u0001\r!\f\u0005\u0007m\u0005\r\u0001\u0019\u0001\u001d\t\ry\n\u0019\u00011\u0001A\u0011\u00191\u00151\u0001a\u0001\u0011\"1a*a\u0001A\u0002ACaAVA\u0002\u0001\u0004A\u0006B\u00020\u0002\u0004\u0001\u0007\u0001\r\u0003\u0004g\u0003\u0007\u0001\u001d\u0001\u001b\u0005\b\u0003;\u0001A\u0011IA\u0010\u0003!1\u0017N\u001c3Cs&#W\u0003BA\u0011\u0003O!B!a\t\u0002@A!\u0011QEA\u0014\u0019\u0001!\u0001\"!\u000b\u0002\u001c\t\u0007\u00111\u0006\u0002\u0002)F!\u0011QFA\u001a!\ry\u0011qF\u0005\u0004\u0003c\u0001\"a\u0002(pi\"Lgn\u001a\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b\u0004\u0002\r\u0011|W.Y5o\u0013\u0011\ti$a\u000e\u0003\tQ\u000b7o\u001b\u0005\t\u0003\u0003\nY\u00021\u0001\u0002D\u00051A/Y:l\u0013\u0012\u0004B!!\u0012\u0002N9!\u0011qIA%!\ty\u0007#C\u0002\u0002LA\ta\u0001\u0015:fI\u00164\u0017\u0002BA(\u0003#\u0012aa\u0015;sS:<'bAA&!!\"\u00111DA+!\u0011\t9&!\u001a\u000e\u0005\u0005e#\u0002BA.\u0003;\n!\"\u00198o_R\fG/[8o\u0015\u0011\ty&!\u0019\u0002\u000f5,GO]5dg*\u0019\u00111\r\u0006\u0002\u0011\r|G-\u00195bY\u0016LA!a\u001a\u0002Z\t)A+[7fI\"9\u00111\u000e\u0001\u0005B\u00055\u0014a\u00054j]\u0012$\u0016m]6t\r>\u0014\bk\u001c7mS:<G\u0003BA8\u0003\u0017\u0003b!!\u001d\u0002|\u0005}TBAA:\u0015\u0011\t)(a\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003s\nAA[1wC&!\u0011QPA:\u0005\u0011a\u0015n\u001d;\u0011\t\u0005\u0005\u0015qQ\u0007\u0003\u0003\u0007S1!!\"\u0005\u0003\u0015\tX/\u001a:z\u0013\u0011\tI)a!\u0003\u001bQ\u000b7o\u001b\"bg&\u001cG)\u0019;b\u0011!\ti)!\u001bA\u0002\u0005=\u0015a\u0002;bg.LEm\u001d\t\u0007\u0003c\nY(a\u0011)\t\u0005%\u00141\u0013\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011T>\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003;\u000b9J\u0001\u0006JgJ+\u0017\rZ(oYfDC!!\u001b\u0002V!9\u00111\u0015\u0001\u0005B\u0005\u0015\u0016AB3ySN$8\u000f\u0006\u0003\u0002(\u00065\u0006cA\b\u0002*&\u0019\u00111\u0016\t\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011IAQ\u0001\u0004\t\u0019\u0005\u000b\u0003\u0002\"\u0006M\u0005\u0006BAQ\u0003+Bq!!.\u0001\t\u0003\n9,\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003g\tI\f\u0003\u0005\u0002<\u0006M\u0006\u0019AA\u001a\u0003\u0011!\u0018m]6)\t\u0005M\u0016Q\u000b\u0005\b\u0003\u0003\u0004A\u0011IAb\u0003Q)\b\u000fZ1uKR\u000b7o\u001b)s_B,'\u000f^5fgR!\u0011QYAf!\ry\u0011qY\u0005\u0004\u0003\u0013\u0004\"\u0001B+oSRD\u0001\"a/\u0002@\u0002\u0007\u00111\u0007\u0015\u0005\u0003\u007f\u000b)\u0006C\u0004\u0002R\u0002!\t%a5\u0002=U\u0004H-\u0019;f)\u0006\u001c8.\u00118e%\u0016dW-Y:f\r2\fwm\u0015;biV\u001cHCBA\u001a\u0003+\f9\u000e\u0003\u0005\u0002<\u0006=\u0007\u0019AA\u001a\u0011!\tI.a4A\u0002\u0005m\u0017a\u0002:fY\u0016\f7/\u001a\t\u0005\u0003k\ti.\u0003\u0003\u0002`\u0006]\"a\u0002*fY\u0016\f7/\u001a\u0015\u0005\u0003\u001f\f)\u0006C\u0004\u0002f\u0002!\t%a:\u0002\u0015U\u0004H-\u0019;f)f\u0004X\r\u0006\u0003\u00024\u0005%\b\u0002CA^\u0003G\u0004\r!a\r)\t\u0005\r\u0018Q\u000b\u0005\b\u0003_\u0004A\u0011IAy\u0003\u0019!W\r\\3uKR!\u0011QYAz\u0011!\tY,!<A\u0002\u0005M\u0002\u0006BAw\u0003+Bq!!?\u0001\t\u0013\tY0\u0001\u0006de\u0016\fG/\u001a+bg.$B!a\r\u0002~\"A\u0011q`A|\u0001\u0004\t\u0019$A\u0004oK^$\u0016m]6\t\u000f\t\r\u0001\u0001\"\u0011\u0003\u0006\u000511M]3bi\u0016$B!a\r\u0003\b!A\u0011q B\u0001\u0001\u0004\t\u0019\u0004\u000b\u0003\u0003\u0002\u0005U\u0003b\u0002B\u0007\u0001\u0011\u0005#qB\u0001\t[>4X\rV1tWRQ\u00111\u0007B\t\u0005+\u0011IBa\t\t\u0011\tM!1\u0002a\u0001\u0003g\t!\u0002^1tWR{Wj\u001c<f\u0011!\u00119Ba\u0003A\u0002\u0005M\u0012!C7pm\u0016$G+Y:l\u0011!\u0011YBa\u0003A\u0002\tu\u0011AF;qI\u0006$X\rZ(sS\u001eLgnQ8oi\u0006Lg.\u001a:\u0011\t\u0005U\"qD\u0005\u0005\u0005C\t9DA\u0007UCN\\7i\u001c8uC&tWM\u001d\u0005\t\u0005K\u0011Y\u00011\u0001\u0003\u001e\u00051R\u000f\u001d3bi\u0016$G+\u0019:hKR\u001cuN\u001c;bS:,'\u000f\u000b\u0003\u0003\f\u0005U\u0003b\u0002B\u0016\u0001\u0011\u0005#QF\u0001\u0017M&tG-\u00114gK\u000e$X\r\u001a\"z\u00052\f7m[8viR!\u0011q\u0012B\u0018\u0011!\u0011\tD!\u000bA\u0002\tM\u0012\u0001\u00032mC\u000e\\w.\u001e;\u0011\t\tU\"1H\u0007\u0003\u0005oQAA!\u000f\u00028\u0005A1-\u00197f]\u0012\f'/\u0003\u0003\u0003>\t]\"\u0001\u0003\"mC\u000e\\w.\u001e;)\t\t%\u0012Q\u000b\u0005\b\u0005\u0007\u0002A\u0011\tB#\u0003!9W\r\u001e+ji2,G\u0003BA\"\u0005\u000fB\u0001\"!\u0011\u0003B\u0001\u0007\u00111\t\u0015\u0005\u0005\u0003\n\u0019\n\u000b\u0003\u0003B\u0005U\u0003f\u0001\u0001\u0003PA!\u0011Q\u0013B)\u0013\u0011\u0011\u0019&a&\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\u0004")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationPersistence configurationPersistence;
    private final FacetRepository facetRepository;
    private final SqlBuilder.Dialect dialect;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(Release release) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, release);
    }

    @Override
    public void deleteConfigurationRefs(Integer releaseUid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, releaseUid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationPersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepository facetRepository() {
        return this.facetRepository;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Repository entity [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskId})), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$.MODULE$.RichCiId(taskId).normalized())).map((Function1 & Serializable & scala.Serializable)task -> this.commentRepository().decorate(task)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Repository entity [", "] not found in release"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskId})), new Object[0]);
        }));
    }

    @Timed
    @IsReadOnly
    public List<TaskBasicData> findTasksForPolling(List<String> taskIds) {
        Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()));
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()).map((Function1 & Serializable & scala.Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            String id = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (!(option instanceof Some)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            Some some = (Some)option;
            TaskRow data = (TaskRow)some.value();
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id)));
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking if exists task [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskId})));
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs(release);
        return task;
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            SqlTaskRepository.$anonfun$updateTaskProperties$1(this, task, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task2) {
        this.checkIsNotReferencedByDependencies(task2.getId());
        this.releasePersistence().update(task2.getRelease());
        this.commentRepository().deleteByTask(task2);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task2)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(task2.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlTaskRepository.$anonfun$delete$2(this, task);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs(task2.getRelease());
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newTask2.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$2)))).map((Function1 & Serializable & scala.Serializable)newTask -> this.createTask((Task)newTask), Buffer$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs(createdTask.getRelease());
        this.facetRepository().createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(newTask.getAllTasks()).asScala());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskToMove.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)releaseData -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)releaseData)), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)rel -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    public static final /* synthetic */ void $anonfun$updateTaskProperties$1(SqlTaskRepository $this, Task task$1, Dependency x0$2) {
        Dependency dependency = x0$2;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                $this.dependencyPersistence().updateDependency(dependency);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NotFoundException e) {
                $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dependency ", " not found when updating task ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency, task$1})), (Function0 & Serializable & scala.Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ void $anonfun$delete$2(SqlTaskRepository $this, Task task) {
        $this.taskPersistence().delete(task);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$2) {
        String string = x$2.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationPersistence configurationPersistence, FacetRepository facetRepository, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepository = facetRepository;
        this.dialect = dialect;
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

