/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator$;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.search.PlanItemSearchResult;
import com.xebialabs.xlrelease.search.ReleaseCountResults;
import com.xebialabs.xlrelease.search.ReleaseFullSearchResult;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.SqlReleasesFilterSupport$;
import com.xebialabs.xlrelease.service.SqlTemplatesFilterSupport$;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t=h\u0001B\u0001\u0003\u0001-\u0011qcU9m%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u001dA\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u00011#\u0002\u0001\r%Yq\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t!\"+\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\u000bMdg\r\u000e6\u000b\u0003m\t\u0001b\u001a:jujdW\rZ\u0005\u0003;a\u0011q\u0001T8hO&tw\r\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011Q\u0005\t\u0002\u0017\t\u0016\u001cXM]5bY&T\u0018\r^5p]N+\b\u000f]8si\"Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007CA\u0015-\u001b\u0005Q#BA\u0016!\u0003-\u0001XM]:jgR,gnY3\n\u00055R#A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016D\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\"aE\u0019\n\u0005I\u0012!\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0011!!\u0004A!b\u0001\n\u0003)\u0014!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\ta\u0007\u0005\u0002 o%\u0011\u0001\b\t\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\t\u0011i\u0002!\u0011!Q\u0001\nY\n!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA!AA\b\u0001BC\u0002\u0013\u0005Q(A\u0006uK\u0006l7+\u001a:wS\u000e,W#\u0001 \u0011\u0005My\u0014B\u0001!\u0003\u0005-!V-Y7TKJ4\u0018nY3\t\u0011\t\u0003!\u0011!Q\u0001\ny\nA\u0002^3b[N+'O^5dK\u0002B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R\u0001\u0011I\u0016\u001cwN]1u_J\u001cVM\u001d<jG\u0016\u0004\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u0011%tG/\u001a:oC2T!A\u0013\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002M\u000f\n\u0001\u0013J\u001c;fe:\fG.T3uC\u0012\fG/\u0019#fG>\u0014\u0018\r^8s'\u0016\u0014h/[2f\u0011!q\u0005A!b\u0001\n\u0007y\u0015AC:rY\u0012K\u0017\r\\3diV\t\u0001\u000b\u0005\u0002RI:\u0011!+\u0019\b\u0003'~s!\u0001V/\u000f\u0005UcfB\u0001,\\\u001d\t9&,D\u0001Y\u0015\tI&\"\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019I!A\u0018\u0003\u0002\u0005\u0011\u0014\u0017BA\u0011a\u0015\tqF!\u0003\u0002cG\u0006Q1+\u001d7Ck&dG-\u001a:\u000b\u0005\u0005\u0002\u0017BA3g\u0005\u001d!\u0015.\u00197fGRT!AY2\t\u0011!\u0004!\u0011!Q\u0001\nA\u000b1b]9m\t&\fG.Z2uA!A!\u000e\u0001BC\u0002\u0013\r1.\u0001\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014X#\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005E4\u0011\u0001\u00033fa2|\u00170\u001b;\n\u0005Mt'A\u0005)fe6L7o]5p]\u0016sgm\u001c:dKJD\u0001\"\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\\\u0001\u0014a\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'\u000f\t\u0005\to\u0002\u0011)\u0019!C\u0001q\u0006Y!o\u001c7f'\u0016\u0014h/[2f+\u0005I\bCA7{\u0013\tYhNA\u0006S_2,7+\u001a:wS\u000e,\u0007\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011B=\u0002\u0019I|G.Z*feZL7-\u001a\u0011\t\u0013}\u0004!Q1A\u0005\u0002\u0005\u0005\u0011AC:fGV\u0014X\rZ\"jgV\u0011\u00111\u0001\t\u0005\u0003\u000b\t9!D\u0001#\u0013\r\tIA\t\u0002\u000b'\u0016\u001cWO]3e\u0007&\u001c\bBCA\u0007\u0001\t\u0005\t\u0015!\u0003\u0002\u0004\u0005Y1/Z2ve\u0016$7)[:!\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u00111C\u0001\u001ce\u0016dW-Y:f\u000bb$XM\\:j_:\u001c(+\u001a9pg&$xN]=\u0011\t\u0005\u0015\u0011QC\u0005\u0004\u0003/\u0011#a\u0007*fY\u0016\f7/Z#yi\u0016t7/[8ogJ+\u0007o\\:ji>\u0014\u0018\u0010C\u0004\u0002\u001c\u0001!\t!!\b\u0002\rqJg.\u001b;?)Y\ty\"!\t\u0002$\u0005\u0015\u0012qEA\u0015\u0003W\ti#a\f\u00022\u0005M\u0002CA\n\u0001\u0011\u00199\u0013\u0011\u0004a\u0001Q!1q&!\u0007A\u0002ABa\u0001NA\r\u0001\u00041\u0004B\u0002\u001f\u0002\u001a\u0001\u0007a\b\u0003\u0004E\u00033\u0001\r!\u0012\u0005\u0007\u001d\u0006e\u00019\u0001)\t\r)\fI\u0002q\u0001m\u0011\u00199\u0018\u0011\u0004a\u0001s\"9q0!\u0007A\u0002\u0005\r\u0001\u0002CA\t\u00033\u0001\r!a\u0005\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:\u0005)1m\\;oiR!\u00111HA$!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!\t\u000511/Z1sG\"LA!!\u0012\u0002@\t\u0019\"+\u001a7fCN,7i\\;oiJ+7/\u001e7ug\"A\u0011\u0011JA\u001b\u0001\u0004\tY%A\bsK2,\u0017m]3t\r&dG/\u001a:t!\u0011\ti%a\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\nQAZ8s[NT1!!\u0016J\u0003\t1\u0018'\u0003\u0003\u0002Z\u0005=#a\u0004*fY\u0016\f7/Z:GS2$XM]:)\t\u0005U\u0012Q\f\t\u0005\u0003?\ni'\u0004\u0002\u0002b)!\u00111MA3\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003O\nI'A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005-\u0004\"\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\ty'!\u0019\u0003\u000bQKW.\u001a3\t\u000f\u0005M\u0004\u0001\"\u0011\u0002v\u0005Qa-\u001e7m'\u0016\f'o\u00195\u0015\u0011\u0005]\u0014QPA@\u0003\u0013\u0003B!!\u0010\u0002z%!\u00111PA \u0005]\u0011V\r\\3bg\u00164U\u000f\u001c7TK\u0006\u00148\r\u001b*fgVdG\u000f\u0003\u0005\u0002J\u0005E\u0004\u0019AA&\u0011!\t\t)!\u001dA\u0002\u0005\r\u0015aC2veJ,g\u000e\u001e)bO\u0016\u0004B!!\u0002\u0002\u0006&\u0019\u0011q\u0011\u0012\u0003\tA\u000bw-\u001a\u0005\t\u0003\u0017\u000b\t\b1\u0001\u0002\u0004\u0006Y\u0011M]2iSZ,\u0007+Y4fQ\u0011\t\t(!\u0018\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002\u0012Ra\u00111SAM\u00037\u000b)+!+\u00024B!\u0011QHAK\u0013\u0011\t9*a\u0010\u0003'I+G.Z1tKN+\u0017M]2i%\u0016\u001cX\u000f\u001c;\t\u0011\u0005%\u0013q\u0012a\u0001\u0003\u0017B\u0001\"!(\u0002\u0010\u0002\u0007\u0011qT\u0001\u0005a\u0006<W\rE\u0002\u000e\u0003CK1!a)\u000f\u0005\u0011auN\\4\t\u0011\u0005\u001d\u0016q\u0012a\u0001\u0003?\u000bAB\\;nE\u0016\u0014()\u001f)bO\u0016D\u0001\"a+\u0002\u0010\u0002\u0007\u0011QV\u0001\u0006I\u0016\u0004H\u000f\u001b\t\u0004\u001b\u0005=\u0016bAAY\u001d\t\u0019\u0011J\u001c;\t\u0011\u0005U\u0016q\u0012a\u0001\u0003o\u000b1CZ5mi\u0016\u0014xJ\u001c)fe6L7o]5p]N\u00042!DA]\u0013\r\tYL\u0004\u0002\b\u0005>|G.Z1oQ\u0011\ty)!\u0018\t\u000f\u0005\u0005\u0007\u0001\"\u0011\u0002D\u0006y1/Z1sG\"$V-\u001c9mCR,7\u000f\u0006\u0006\u0002\u0014\u0006\u0015\u0017Q[Al\u00033D\u0001\"a2\u0002@\u0002\u0007\u0011\u0011Z\u0001\u0010i\u0016l\u0007\u000f\\1uK\u001aKG\u000e^3sgB!\u00111ZAi\u001b\t\tiMC\u0002\u0002P\u0012\tQA^5foNLA!a5\u0002N\nyA+Z7qY\u0006$XMR5mi\u0016\u00148\u000f\u0003\u0005\u0002\u001e\u0006}\u0006\u0019AAP\u0011!\t9+a0A\u0002\u0005}\u0005\u0002CAV\u0003\u007f\u0003\r!!,)\t\u0005}\u0016Q\f\u0005\b\u0003?\u0004A\u0011IAq\u0003U\u0019X-\u0019:dQJ+G.Z1tKN\u0014\u0015\u0010V5uY\u0016$\"\"a9\u0002\u0000\nM!Q\u0003B\f!\u0019\t)/a<\u0002t6\u0011\u0011q\u001d\u0006\u0005\u0003S\fY/\u0001\u0003vi&d'BAAw\u0003\u0011Q\u0017M^1\n\t\u0005E\u0018q\u001d\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002v\u0006mXBAA|\u0015\r\tI\u0010B\u0001\u0007I>l\u0017-\u001b8\n\t\u0005u\u0018q\u001f\u0002\b%\u0016dW-Y:f\u0011!\u0011\t!!8A\u0002\t\r\u0011\u0001\u0004:fY\u0016\f7/\u001a+ji2,\u0007\u0003\u0002B\u0003\u0005\u001bqAAa\u0002\u0003\nA\u0011qKD\u0005\u0004\u0005\u0017q\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0003\u0010\tE!AB*ue&twMC\u0002\u0003\f9A\u0001\"!(\u0002^\u0002\u0007\u0011q\u0014\u0005\t\u0003O\u000bi\u000e1\u0001\u0002 \"A\u00111VAo\u0001\u0004\ti\u000b\u000b\u0003\u0002^\u0006u\u0003b\u0002B\u000f\u0001\u0011\u0005#qD\u0001#M&tG-\u00117m%\u0016dW-Y:f\u0013\u0012\u001c\u0018I\u001c3USRdWm\u001d\"z'R\fG/^:\u0015\t\t\u0005\"q\u0005\t\t\u0005\u000b\u0011\u0019Ca\u0001\u0003\u0004%!!Q\u0005B\t\u0005\ri\u0015\r\u001d\u0005\t\u0005S\u0011Y\u00021\u0001\u0003,\u0005A1\u000f^1ukN,7\u000fE\u0003\u000e\u0005[\u0011\t$C\u0002\u000309\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\u0011\u0011\u0019D!\u000f\u000e\u0005\tU\"\u0002\u0002B\u001c\u0003o\faa\u001d;biV\u001c\u0018\u0002\u0002B\u001e\u0005k\u0011QBU3mK\u0006\u001cXm\u0015;biV\u001c\b\u0006\u0002B\u000e\u0003;BqA!\u0011\u0001\t\u0003\u0012\u0019%A\u000egS:$\u0017\t\u001c7UK6\u0004H.\u0019;f\u0013\u0012\u001c\u0018I\u001c3USRdWm\u001d\u000b\u0007\u0005\u000b\u0012YE!\u0014\u0011\t\u0005u\"qI\u0005\u0005\u0005\u0013\nyD\u0001\u000bQY\u0006t\u0017\n^3n'\u0016\f'o\u00195SKN,H\u000e\u001e\u0005\t\u0003;\u0013y\u00041\u0001\u0002 \"A\u0011q\u0015B \u0001\u0004\ty\n\u000b\u0003\u0003@\u0005u\u0003b\u0002B*\u0001\u0011\u0005#QK\u0001\tO\u0016$H+\u001b;mKR!!q\u000bB/!\u0015i!\u0011\fB\u0002\u0013\r\u0011YF\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\t}#\u0011\u000ba\u0001\u0005\u0007\t\u0011B]3mK\u0006\u001cX-\u00133)\t\tE\u0013Q\f\u0005\b\u0005K\u0002A\u0011\tB4\u0003I1\u0017N\u001c3BY2$V-\u001c9mCR,\u0017\nZ:\u0016\u0005\t%\u0004CBAs\u0003_\u0014\u0019\u0001\u000b\u0003\u0003d\u0005u\u0003b\u0002B8\u0001\u0011\u0005#qM\u0001\u0018M&tG-\u00117m\u0003\u000e$\u0018N^3SK2,\u0017m]3JINDCA!\u001c\u0002^!9!Q\u000f\u0001\u0005B\t\u001d\u0014\u0001\u00074j]\u0012\fE\u000e\u001c)f]\u0012Lgn\u001a*fY\u0016\f7/Z%eg\"\"!1OA/\u0011\u001d\u0011Y\b\u0001C\u0005\u0005{\nQ\"];fef\u0014V\r\\3bg\u0016\u001cH\u0003\u0003B@\u0005#\u0013iJa(\u0011\r\t\u0005%1RAz\u001d\u0011\u0011\u0019Ia\"\u000f\u0007]\u0013))C\u0001\u0010\u0013\r\u0011IID\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iIa$\u0003\u0007M+\u0017OC\u0002\u0003\n:A\u0001Ba%\u0003z\u0001\u0007!QS\u0001\ng\u0016\f'o\u00195JIN\u0004r!\u0004BL\u0003\u0007\u0013Y*C\u0002\u0003\u001a:\u0011\u0011BR;oGRLwN\\\u0019\u0011\r\t\u0005%1\u0012B\u0002\u0011!\tiJ!\u001fA\u0002\u0005}\u0005\u0002CAT\u0005s\u0002\r!a(\t\u000f\t\r\u0006\u0001\"\u0003\u0003&\u0006\u0011\u0012/^3ssJ+G.Z1tKN\u0014\u00150\u00133t)\u0011\u0011yHa*\t\u0011\t%&\u0011\u0015a\u0001\u00057\u000b!B]3mK\u0006\u001cX-\u00133t\u0011\u001d\u0011i\u000b\u0001C\u0005\u0005_\u000b\u0001DZ5oIJ+G.Z1tKN\u0014\u00150\u00133t\u0013:|%\u000fZ3s)\u0011\u0011yH!-\t\u0011\t%&1\u0016a\u0001\u00057CqA!.\u0001\t\u0013\u00119,\u0001\bu_N+\u0017M]2i%\u0016\u001cX\u000f\u001c;\u0015\r\u0005M%\u0011\u0018B^\u0011!\tiJa-A\u0002\u0005}\u0005\u0002\u0003B_\u0005g\u0003\rAa \u0002\u0011I,G.Z1tKNDqAa%\u0001\t\u0013\u0011\t\r\u0006\u0003\u0003\u0016\n\r\u0007\u0002CA%\u0005\u007f\u0003\r!a\u0013\t\u000f\t\u001d\u0007\u0001\"\u0003\u0003J\u0006y1/Z1sG\"Le.\u0011:dQ&4X\r\u0006\u0005\u0003\u0000\t-'Q\u001aBh\u0011!\tIE!2A\u0002\u0005-\u0003\u0002CAT\u0005\u000b\u0004\r!a(\t\u0011\tE'Q\u0019a\u0001\u0003?\u000baa\u001c4gg\u0016$\bb\u0002Bk\u0001\u0011\u0005#q[\u0001\rKbL7\u000f^:Cs:\u000bW.\u001a\u000b\u0005\u0003o\u0013I\u000e\u0003\u0005\u0003\\\nM\u0007\u0019\u0001B\u0002\u00035\u0019\u0017M\u001c3jI\u0006$XMT1nK\"\"!1[A/\u0011\u001d\u0011\t\u000f\u0001C\u0005\u0005G\f\u0011cY;se\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197t)\t\u0011)\u000f\u0005\u0004\u0003\u0002\n\u001d(1A\u0005\u0005\u0005S\u0014yI\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u0011i\u000f\u0001C\u0005\u0005G\fabY;se\u0016tGOU8mK&#7\u000f")
public class SqlReleaseSearchService
implements ReleaseSearchService,
Logging,
DeserializationSupport {
    private final ReleasePersistence releasePersistence;
    private final ArchivingService archivingService;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final TeamService teamService;
    private final InternalMetadataDecoratorService decoratorService;
    private final SqlBuilder.Dialect sqlDialect;
    private final PermissionEnforcer permissionEnforcer;
    private final RoleService roleService;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private Logger grizzled$slf4j$Logging$$_logger;
    private final long DEFAULT_NUMBER_OF_RELEASES_PER_PAGE;
    private final int DEFAULT_RELEASE_LOAD_DEPTH;
    private volatile boolean bitmap$0;

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page, long numberByPage) {
        return ReleaseSearchService.search$((ReleaseSearchService)this, (ReleasesFilters)releasesFilters, (long)page, (long)numberByPage);
    }

    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page, long numberByPage, int depth) {
        return ReleaseSearchService.search$((ReleaseSearchService)this, (ReleasesFilters)releasesFilters, (long)page, (long)numberByPage, (int)depth);
    }

    public scala.collection.immutable.Map<String, String> findAllReleaseIdsAndTitlesByStatus(ReleaseStatus ... statuses) {
        return ReleaseSearchService.findAllReleaseIdsAndTitlesByStatus$((ReleaseSearchService)this, (ReleaseStatus[])statuses);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseSearchService sqlReleaseSearchService = this;
        synchronized (sqlReleaseSearchService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public long DEFAULT_NUMBER_OF_RELEASES_PER_PAGE() {
        return this.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE;
    }

    public int DEFAULT_RELEASE_LOAD_DEPTH() {
        return this.DEFAULT_RELEASE_LOAD_DEPTH;
    }

    public void com$xebialabs$xlrelease$service$ReleaseSearchService$_setter_$DEFAULT_NUMBER_OF_RELEASES_PER_PAGE_$eq(long x$1) {
        this.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE = x$1;
    }

    public void com$xebialabs$xlrelease$service$ReleaseSearchService$_setter_$DEFAULT_RELEASE_LOAD_DEPTH_$eq(int x$1) {
        this.DEFAULT_RELEASE_LOAD_DEPTH = x$1;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public TeamService teamService() {
        return this.teamService;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public SecuredCis securedCis() {
        return this.securedCis;
    }

    @Timed
    public ReleaseCountResults count(ReleasesFilters releasesFilters) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        releasesFilters.setOrderBy(null);
        scala.collection.immutable.Map fromArchive = this.archivingService.countReleasesByStatus(releasesFilters).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
        if (releasesFilters.withOnlyArchived()) {
            tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().empty()), (Object)fromArchive);
        } else {
            Iterable<String> principals = this.currentPrincipals();
            Iterable<String> roleIds = this.currentRoleIds();
            ReleasesSqlBuilder statusQuery = SqlReleasesFilterSupport$.MODULE$.sqlBuilderByFilters(releasesFilters, principals, roleIds, this.permissionEnforcer(), this.sqlDialect()).countByStatus();
            tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.releasePersistence.countReleasesByStatus((Tuple2<String, Seq<Object>>)statusQuery.build()).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))), (Object)fromArchive);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Map current = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map archived = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)current, (Object)archived);
        Tuple2 tuple24 = tuple23;
        scala.collection.immutable.Map current2 = (scala.collection.immutable.Map)tuple24._1();
        scala.collection.immutable.Map archived2 = (scala.collection.immutable.Map)tuple24._2();
        return new ReleaseCountResults((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)current2).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)archived2).asJava());
    }

    @Timed
    public ReleaseFullSearchResult fullSearch(ReleasesFilters releasesFilters, Page currentPage, Page archivePage) {
        Function1<Page, Seq<String>> getIds = this.searchIds(releasesFilters);
        ReleaseSearchResult archived = new ReleaseSearchResult((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.searchInArchive(releasesFilters, archivePage.resultsPerPage(), archivePage.offset())).asJava(), archivePage.page());
        ReleaseSearchResult live = releasesFilters.withOnlyArchived() ? ReleaseSearchResult.empty((long)currentPage.page()) : new ReleaseSearchResult((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.queryReleases(getIds, currentPage.page(), currentPage.resultsPerPage())).asJava(), currentPage.page());
        return new ReleaseFullSearchResult(live, archived);
    }

    @Timed
    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page, long numberByPage, int depth, boolean filterOnPermissions) {
        Seq<Release> results = releasesFilters.withOnlyArchived() ? this.searchInArchive(releasesFilters, numberByPage, numberByPage * page) : this.queryReleases(this.searchIds(releasesFilters), page, numberByPage);
        return this.toSearchResult(page, results);
    }

    @Timed
    public ReleaseSearchResult searchTemplates(TemplateFilters templateFilters, long page2, long numberByPage, int depth) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for templates by filters"})).s((Seq)Nil$.MODULE$));
        ReleasesSqlBuilder query = SqlTemplatesFilterSupport$.MODULE$.sqlBuilderByFilters(templateFilters, this.currentPrincipals(), this.currentRoleIds(), this.permissionEnforcer(), this.sqlDialect()).selectReleaseId();
        Seq<Release> templates = this.queryReleases((Function1<Page, Seq<String>>)(Function1 & Serializable & scala.Serializable)page -> this.searchIds$1((Page)page, query), page2, numberByPage);
        return this.toSearchResult(page2, templates);
    }

    @Timed
    public java.util.List<Release> searchReleasesByTitle(String releaseTitle, long page2, long numberByPage, int depth) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for releases by title ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseTitle})));
        ReleasesSqlBuilder query = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withTitle(releaseTitle);
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? query.withPermission(XLReleasePermissions.VIEW_RELEASE, this.currentPrincipals(), this.currentRoleIds()) : BoxedUnit.UNIT;
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.queryReleases((Function1<Page, Seq<String>>)(Function1 & Serializable & scala.Serializable)page -> this.getIds$1((Page)page, query), page2, numberByPage)).asJava();
    }

    @Timed
    public scala.collection.immutable.Map<String, String> findAllReleaseIdsAndTitlesByStatus(Seq<ReleaseStatus> statuses) {
        ReleasesSqlBuilder sqlBuilder = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseIdAndTitle().withOneOfStatuses(statuses);
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? sqlBuilder.withPermission(XLReleasePermissions.VIEW_RELEASE, this.currentPrincipals(), this.currentRoleIds()) : BoxedUnit.UNIT;
        Tuple2 sqlWithParams = sqlBuilder.build();
        return this.releasePersistence.findReleaseIdsAndTitlesByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).toMap(Predef$.MODULE$.$conforms());
    }

    @Timed
    public PlanItemSearchResult findAllTemplateIdsAndTitles(long page, long numberByPage) {
        ReleasesSqlBuilder sqlBuilder = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseIdAndTitle().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE})))).orderBy(ReleaseOrderMode.title).withPage(new Page((long)((int)page), (long)((int)numberByPage), Predef$.MODULE$.int2Integer(0)));
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? sqlBuilder.withPermission(XLReleasePermissions.VIEW_TEMPLATE, this.currentPrincipals(), this.currentRoleIds()) : BoxedUnit.UNIT;
        scala.collection.immutable.Map idToTitle = this.releasePersistence.findReleaseIdsAndTitlesByQuery((Tuple2<String, Seq<Object>>)sqlBuilder.build()).toMap(Predef$.MODULE$.$conforms());
        PlanItemSearchResult searchResult = new PlanItemSearchResult();
        searchResult.setPage(page + 1L);
        searchResult.setItems(JavaConverters$.MODULE$.mapAsJavaMap((Map)idToTitle));
        return searchResult;
    }

    @Timed
    public Option<String> getTitle(String releaseId) {
        return this.releasePersistence.findReleaseTitle(releaseId).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.archivingService.getReleaseTitle(releaseId)).toOption());
    }

    @Timed
    public java.util.List<String> findAllTemplateIds() {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE})))).build();
        return (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    @Timed
    public java.util.List<String> findAllActiveReleaseIds() {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    @Timed
    public java.util.List<String> findAllPendingReleaseIds() {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for all pending releases"})).s((Seq)Nil$.MODULE$));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED})))).withAutoStart().build();
        return (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    private Seq<Release> queryReleases(Function1<Page, Seq<String>> searchIds, long page, long numberByPage) {
        return this.queryReleasesByIds((Seq<String>)((Seq)searchIds.apply((Object)new Page((long)((int)page), (long)((int)numberByPage), Predef$.MODULE$.int2Integer(0)))));
    }

    private Seq<Release> queryReleasesByIds(Seq<String> releaseIds) {
        Seq releases = releaseIds.nonEmpty() ? this.findReleasesByIdsInOrder(releaseIds) : (Seq)Seq$.MODULE$.empty();
        return (Seq)((TraversableLike)releases.map((Function1 & Serializable & scala.Serializable)release -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.teamService().decorateWithEffectiveTeams(release)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.decoratorService.decorate((ConfigurationItem)release, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava())).map((Function1 & Serializable & scala.Serializable)_ -> release)), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            List list;
            Try try_ = x0$1;
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> err);
                list = List$.MODULE$.empty();
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                Release release = (Release)success.value();
                list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Release[]{release}));
            } else {
                throw new MatchError((Object)try_);
            }
            return list;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Release> findReleasesByIdsInOrder(Seq<String> releaseIds) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds(releaseIds).build();
        Seq releasesUnordered = (Seq)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)releaseData -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)releaseData)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> $this.releaseExtensionsRepository.decorate(release), Seq$.MODULE$.canBuildFrom());
        return (Seq)releasesUnordered.sortBy((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)releaseIds.indexOf((Object)r.getId())), (Ordering)Ordering.Int$.MODULE$);
    }

    private ReleaseSearchResult toSearchResult(long page, Seq<Release> releases) {
        return new ReleaseSearchResult((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(releases).asJava(), page + 1L);
    }

    private Function1<Page, Seq<String>> searchIds(ReleasesFilters releasesFilters) {
        if (releasesFilters.getOrderBy() == null) {
            releasesFilters.setOrderBy(ReleaseOrderMode.risk);
        }
        ReleasesSqlBuilder query = SqlReleasesFilterSupport$.MODULE$.sqlBuilderByFilters(releasesFilters, this.currentPrincipals(), this.currentRoleIds(), this.permissionEnforcer(), this.sqlDialect()).selectReleaseId();
        return (Function1 & Serializable & scala.Serializable)page -> {
            Tuple2 sqlWithParams = query.withPage((Page)page).build();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for a batch of releases by SQL query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlWithParams._1()})));
            return $this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        };
    }

    private Seq<Release> searchInArchive(ReleasesFilters releasesFilters, long numberByPage, long offset) {
        java.util.List releases = this.archivingService.searchReleases(releasesFilters, numberByPage, offset);
        this.decoratorService.decorate((Collection)releases, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(releases).asScala();
    }

    @Timed
    public boolean existsByName(String candidateName) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withReleaseName(candidateName).withPage(new Page(0L, 1L, Predef$.MODULE$.int2Integer(0))).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).nonEmpty();
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Iterable<String> currentRoleIds() {
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Buffer$.MODULE$.canBuildFrom());
    }

    private final Seq searchIds$1(Page page, ReleasesSqlBuilder query$1) {
        Tuple2 sqlWithParams = query$1.withPage(page).build();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for a batch of templates by SQL query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlWithParams._1()})));
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    private final Seq getIds$1(Page page, ReleasesSqlBuilder query$2) {
        Tuple2 sqlWithParams = query$2.withPage(page).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    public SqlReleaseSearchService(ReleasePersistence releasePersistence, ArchivingService archivingService, SqlRepositoryAdapter repositoryAdapter, TeamService teamService, InternalMetadataDecoratorService decoratorService, SqlBuilder.Dialect sqlDialect, PermissionEnforcer permissionEnforcer, RoleService roleService, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository) {
        this.releasePersistence = releasePersistence;
        this.archivingService = archivingService;
        this.repositoryAdapter = repositoryAdapter;
        this.teamService = teamService;
        this.decoratorService = decoratorService;
        this.sqlDialect = sqlDialect;
        this.permissionEnforcer = permissionEnforcer;
        this.roleService = roleService;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        ReleaseSearchService.$init$((ReleaseSearchService)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
    }
}

