/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator$;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksUnionSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.service.SqlTasksFilterSupport$;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.TaskSearchService;
import com.xebialabs.xlrelease.views.ReleaseTasks;
import com.xebialabs.xlrelease.views.TaskSearchView;
import com.xebialabs.xlrelease.views.TasksFilters;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001\u0002\n\u0014\u0001qA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011}\u0003!Q1A\u0005\u0002\u0001D\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tM\u0002\u0011)\u0019!C\u0002O\"A1\u000e\u0001B\u0001B\u0003%\u0001\u000e\u0003\u0005m\u0001\t\u0015\r\u0011b\u0001n\u0011%\tY\u0001\u0001B\u0001B\u0003%a\u000eC\u0004\u0002\u000e\u0001!\t!a\u0004\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u00111\f\u0001\u0005\n\u0005u\u0003bBAO\u0001\u0011%\u0011q\u0014\u0005\b\u0003\u0013\u0004A\u0011BAf\u0005Q\u0019\u0016\u000f\u001c+bg.\u001cV-\u0019:dQN+'O^5dK*\u0011A#F\u0001\bg\u0016\u0014h/[2f\u0015\t1r#A\u0005yYJ,G.Z1tK*\u0011\u0001$G\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AG\u0001\u0004G>l7\u0001A\n\u0005\u0001u)\u0013\u0006\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005!A.\u00198h\u0015\u0005\u0011\u0013\u0001\u00026bm\u0006L!\u0001J\u0010\u0003\r=\u0013'.Z2u!\t1s%D\u0001\u0014\u0013\tA3CA\tUCN\\7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u000bMdg\r\u000e6\u000b\u00039\n\u0001b\u001a:jujdW\rZ\u0005\u0003a-\u0012q\u0001T8hO&tw-A\u0006s_2,7+\u001a:wS\u000e,\u0007CA\u001a9\u001b\u0005!$BA\u001b7\u0003!\u0019XmY;sSRL(BA\u001c\u0018\u0003!!W\r\u001d7ps&$\u0018BA\u001d5\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0002#Q\f7o[!dG\u0016\u001c8oU3sm&\u001cW\r\u0005\u0002'y%\u0011Qh\u0005\u0002\u0012)\u0006\u001c8.Q2dKN\u001c8+\u001a:wS\u000e,\u0017A\u0005;bg.\u001ch+[3x\u0007>tg/\u001a:uKJ\u0004\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\u0015\r|gN^3si\u0016\u00148O\u0003\u0002E+\u0005)a/[3xg&\u0011a)\u0011\u0002\u0013)\u0006\u001c8n\u001d,jK^\u001cuN\u001c<feR,'/\u0001\teK\u000e|'/\u0019;peN+'O^5dKB\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\tS:$XM\u001d8bY*\u0011Q*F\u0001\u0004CBL\u0017BA(K\u0005\u0001Je\u000e^3s]\u0006dW*\u001a;bI\u0006$\u0018\rR3d_J\fGo\u001c:TKJ4\u0018nY3\u0002%I,G.Z1tKB+'o]5ti\u0016t7-\u001a\t\u0003%fk\u0011a\u0015\u0006\u0003)V\u000b1\u0002]3sg&\u001cH/\u001a8dK*\u0011akV\u0001\u0004gFd'B\u0001-\u0016\u0003)\u0011X\r]8tSR|'/_\u0005\u00035N\u0013!CU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0006yA/Y:l!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002S;&\u0011al\u0015\u0002\u0010)\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0006\t\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0016\u0003\u0005\u0004\"AY2\u000e\u0003UK!\u0001Z+\u0003)M\u000bHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003I\u0011X\r]8tSR|'/_!eCB$XM\u001d\u0011\u0002%A,'/\\5tg&|g.\u00128g_J\u001cWM]\u000b\u0002QB\u00111'[\u0005\u0003UR\u0012!\u0003U3s[&\u001c8/[8o\u000b:4wN]2fe\u0006\u0019\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3sA\u0005Q1/\u001d7ES\u0006dWm\u0019;\u0016\u00039\u00042a\\A\u0003\u001d\t\u0001xP\u0004\u0002r{:\u0011!o\u001f\b\u0003gjt!\u0001^=\u000f\u0005UDX\"\u0001<\u000b\u0005]\\\u0012A\u0002\u001fs_>$h(C\u0001\u001b\u0013\tA\u0012$\u0003\u0002\u0017/%\u0011A0F\u0001\u0003I\nL!A\u0016@\u000b\u0005q,\u0012\u0002BA\u0001\u0003\u0007\t!bU9m\u0005VLG\u000eZ3s\u0015\t1f0\u0003\u0003\u0002\b\u0005%!a\u0002#jC2,7\r\u001e\u0006\u0005\u0003\u0003\t\u0019!A\u0006tc2$\u0015.\u00197fGR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u000b\u0002\u0012\u0005M\u0011QCA\f\u00033\tY\"!\b\u0002 \u0005\u0005\u00121\u0005\t\u0003M\u0001AQ!M\u0007A\u0002IBQAO\u0007A\u0002mBQAP\u0007A\u0002}BQaR\u0007A\u0002!CQ\u0001U\u0007A\u0002ECQaW\u0007A\u0002qCQaX\u0007A\u0002\u0005DQAZ\u0007A\u0004!DQ\u0001\\\u0007A\u00049\f\u0011cZ3u)\u0006\u001c8n\u001d\"z%\u0016dW-Y:f)\u0019\tI#!\r\u0002<A!\u00111FA\u0017\u001b\u0005\u0019\u0015bAA\u0018\u0007\nqA+Y:l'\u0016\f'o\u00195WS\u0016<\bbBA\u001a\u001d\u0001\u0007\u0011QG\u0001\ri\u0006\u001c8n\u001d$jYR,'o\u001d\t\u0005\u0003W\t9$C\u0002\u0002:\r\u0013A\u0002V1tWN4\u0015\u000e\u001c;feNDq!!\u0010\u000f\u0001\u0004\ty$\u0001\u000bmS6LG\u000fV1tWND\u0015N\u001c;PaRLwN\u001c\t\u0004=\u0005\u0005\u0013bAA\"?\t9\u0011J\u001c;fO\u0016\u0014\bf\u0001\b\u0002HA!\u0011\u0011JA,\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013AC1o]>$\u0018\r^5p]*!\u0011\u0011KA*\u0003\u001diW\r\u001e:jGNT1!!\u0016\u001a\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA-\u0003\u0017\u0012Q\u0001V5nK\u0012\fA\u0001^5nKV!\u0011qLA4)\u0011\t\t'!#\u0015\t\u0005\r\u0014q\u0010\t\u0005\u0003K\n9\u0007\u0004\u0001\u0005\u000f\u0005%tB1\u0001\u0002l\t\t\u0011)\u0005\u0003\u0002n\u0005e\u0004\u0003BA8\u0003kj!!!\u001d\u000b\u0005\u0005M\u0014!B:dC2\f\u0017\u0002BA<\u0003c\u0012qAT8uQ&tw\r\u0005\u0003\u0002p\u0005m\u0014\u0002BA?\u0003c\u00121!\u00118z\u0011!\t\ti\u0004CA\u0002\u0005\r\u0015!\u00022m_\u000e\\\u0007CBA8\u0003\u000b\u000b\u0019'\u0003\u0003\u0002\b\u0006E$\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\u0005-u\u00021\u0001\u0002\u000e\u0006!A-Z:d!\u0011\ty)a&\u000f\t\u0005E\u00151\u0013\t\u0004k\u0006E\u0014\u0002BAK\u0003c\na\u0001\u0015:fI\u00164\u0017\u0002BAM\u00037\u0013aa\u0015;sS:<'\u0002BAK\u0003c\n!c]8si\nK(+\u001a7fCN,G+\u001b;mKR!\u0011\u0011UAZ!\u0019\t\u0019+!+\u0002.6\u0011\u0011Q\u0015\u0006\u0004\u0003O\u000b\u0013\u0001B;uS2LA!a+\u0002&\n!A*[:u!\u0011\tY#a,\n\u0007\u0005E6I\u0001\u0007SK2,\u0017m]3UCN\\7\u000fC\u0004\u00026B\u0001\r!a.\u0002\u001bI,G.Z1tKN$\u0016m]6t!\u0019\tI,a1\u0002.:!\u00111XA`\u001d\r)\u0018QX\u0005\u0003\u0003gJA!!1\u0002r\u00059\u0001/Y2lC\u001e,\u0017\u0002BAc\u0003\u000f\u00141aU3r\u0015\u0011\t\t-!\u001d\u0002\u001bM,\u0017M]2i)\u0006\u001c8.\u00133t)\u0019\ti-!;\u0002lB1\u0011\u0011XAb\u0003\u001f\u0004B!!5\u0002d:!\u00111[Ap\u001d\u0011\t).!8\u000f\t\u0005]\u00171\u001c\b\u0004e\u0006e\u0017B\u0001-\u0016\u0013\t1v+\u0003\u0002U+&\u0019\u0011\u0011]*\u0002\t\rK\u0017\nZ\u0005\u0005\u0003K\f9O\u0001\u0003DS&#'bAAq'\"9\u00111G\tA\u0002\u0005U\u0002bBAw#\u0001\u0007\u0011q^\u0001\u0006Y&l\u0017\u000e\u001e\t\u0005\u0003_\n\t0\u0003\u0003\u0002t\u0006E$aA%oi\u0002")
public class SqlTaskSearchService
implements TaskSearchService,
Logging {
    private final RoleService roleService;
    private final TaskAccessService taskAccessService;
    private final TasksViewConverter tasksViewConverter;
    private final InternalMetadataDecoratorService decoratorService;
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect sqlDialect;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskSearchService sqlTaskSearchService = this;
        synchronized (sqlTaskSearchService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    public TaskSearchView getTasksByRelease(TasksFilters tasksFilters, Integer limitTasksHintOption) {
        int limit = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)limitTasksHintOption).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 30));
        Seq taskIds = (Seq)this.time("finding task ids", (Function0 & Serializable & scala.Serializable)() -> this.searchTaskIds(tasksFilters, limit));
        Seq releaseIds = (Seq)((SeqLike)taskIds.map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.releaseIdFrom((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Found ").append(taskIds.size()).append(" tasks in ").append(releaseIds.size()).append(" releases for user ").append(Permissions.getAuthenticatedUserName()).toString());
        List allowedTaskTypesForAuthenticatedUser = (List)this.time("fetching allowed task types for authenticated user", (Function0 & Serializable & scala.Serializable)() -> $this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
        Tuple2 queryReleases = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds((Seq<String>)releaseIds).build();
        Seq releasesTasks = (Seq)this.time("total time to create releasesTasks", (Function0 & Serializable & scala.Serializable)() -> (Seq)((TraversableLike)((GenericTraversableTemplate)this.time("de-serializing releases", (Function0 & Serializable & scala.Serializable)() -> {
            boolean bl = this.repositoryAdapter().tryDeserialize$default$1();
            return (Seq)$this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)queryReleases).map((Function1 & Serializable & scala.Serializable)releaseData -> this.repositoryAdapter().tryDeserialize(bl, (ReleaseRow)releaseData), Seq$.MODULE$.canBuildFrom());
        })).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).flatMap((Function1 & Serializable & scala.Serializable)foundRelease -> {
            $this.decoratorService.decorate((ConfigurationItem)foundRelease, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
            return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)BoxedUnit.UNIT).map((Function1 & Serializable & scala.Serializable)x$2 -> {
                Buffer orderedTasks = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(foundRelease.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)taskIds.exists((Function1 & Serializable & scala.Serializable)foundId -> BoxesRunTime.boxToBoolean((boolean)SqlTaskSearchService.$anonfun$getTasksByRelease$14(task, foundId)))))).sortBy((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToInteger((int)taskIds.indexWhere((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)SqlTaskSearchService.$anonfun$getTasksByRelease$16(task, id)))), (Ordering)Ordering.Int$.MODULE$);
                return new Tuple2(x$2, (Object)orderedTasks);
            }).map((Function1 & Serializable & scala.Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Buffer orderedTasks = (Buffer)tuple2._2();
                ReleaseTasks releaseTasks = new ReleaseTasks(foundRelease, $this.tasksViewConverter.toFullView((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(orderedTasks).asJava(), allowedTaskTypesForAuthenticatedUser));
                return releaseTasks;
            }));
        }, Seq$.MODULE$.canBuildFrom()));
        return new TaskSearchView(this.sortByReleaseTitle((Seq<ReleaseTasks>)releasesTasks), taskIds.size() >= limit);
    }

    private <A> A time(String desc, Function0<A> block) {
        long startTime = System.currentTimeMillis();
        Object res = block.apply();
        long endTime = System.currentTimeMillis();
        long total = endTime - startTime;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("TIME: ").append(desc).append(" took ").append(total).toString());
        return (A)res;
    }

    private List<ReleaseTasks> sortByReleaseTitle(Seq<ReleaseTasks> releasesTasks) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releasesTasks.sortBy((Function1 & Serializable & scala.Serializable)releaseTasks -> (String)Option$.MODULE$.apply((Object)releaseTasks.getTitle()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    private Seq<String> searchTaskIds(TasksFilters tasksFilters, int limit) {
        Iterable principals = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
        Buffer roleIds = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getId(), Buffer$.MODULE$.canBuildFrom());
        Tuple2<String, Seq<Object>> tasksQuery = ((TasksUnionSqlBuilder)SqlTasksFilterSupport$.MODULE$.sqlBuilderByFilters(tasksFilters, (Iterable<String>)principals, (Iterable<String>)roleIds, this.permissionEnforcer(), this.sqlDialect()).limit(limit)).build();
        return this.taskPersistence.findTaskIdsByQuery(tasksQuery);
    }

    public static final /* synthetic */ boolean $anonfun$getTasksByRelease$14(Task task$1, String foundId) {
        return task$1.getId().endsWith(foundId);
    }

    public static final /* synthetic */ boolean $anonfun$getTasksByRelease$16(Task task$2, String id) {
        return task$2.getId().startsWith(id);
    }

    public SqlTaskSearchService(RoleService roleService, TaskAccessService taskAccessService, TasksViewConverter tasksViewConverter, InternalMetadataDecoratorService decoratorService, ReleasePersistence releasePersistence, TaskPersistence taskPersistence, SqlRepositoryAdapter repositoryAdapter, PermissionEnforcer permissionEnforcer, SqlBuilder.Dialect sqlDialect) {
        this.roleService = roleService;
        this.taskAccessService = taskAccessService;
        this.tasksViewConverter = tasksViewConverter;
        this.decoratorService = decoratorService;
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.sqlDialect = sqlDialect;
        Logging.$init$((Logging)this);
    }
}

