/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001\u0002\n\u0014\u0001yA\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005o!Aa\b\u0001BC\u0002\u0013\u0005q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003A\u0011!!\u0005A!b\u0001\n\u0003)\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b9\u0003A\u0011A(\t\u000bQ\u0003A\u0011I+\t\u000bQ\u0004A\u0011I;\t\u000by\u0004A\u0011I@\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u001a\u0001\u0011\u0005\u0013Q\u0007\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!a\u001c\u0001\t\u0013\t\t\bC\u0004\u0002\u0006\u0002!I!a\"\u0003/M\u000bH\u000eR3qK:$WM\\2z%\u0016\u0004xn]5u_JL(B\u0001\u000b\u0016\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003-]\t!B]3q_NLGo\u001c:z\u0015\tA\u0012$A\u0005yYJ,G.Z1tK*\u0011!dG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001H\u0001\u0004G>l7\u0001A\n\u0006\u0001})\u0013&\f\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019:S\"A\u000b\n\u0005!*\"\u0001\u0006#fa\u0016tG-\u001a8dsJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002+W5\t1#\u0003\u0002-'\tI\")Y:f%\u0016dW-Y:f\u0013R,WNU3q_NLGo\u001c:z!\tq3'D\u00010\u0015\t\u0001\u0014'A\u0003tY\u001a$$NC\u00013\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001b0\u0005\u001daunZ4j]\u001e\f!C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dKV\tq\u0007\u0005\u00029w5\t\u0011H\u0003\u0002;'\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\ta\u0014H\u0001\nSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017a\u0005:fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\u0004\u0013!\u00063fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-Z\u000b\u0002\u0001B\u0011\u0001(Q\u0005\u0003\u0005f\u0012Q\u0003R3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-\u0001\feKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3!\u0003E\u0011X\r]8tSR|'/_!eCB$XM]\u000b\u0002\rB\u0011qiS\u0007\u0002\u0011*\u0011a#\u0013\u0006\u0003\u0015f\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003\u0019\"\u0013\u0011CU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003I\u0011X\r]8tSR|'/_!eCB$XM\u001d\u0011\u0002\rqJg.\u001b;?)\u0011\u0001\u0016KU*\u0011\u0005)\u0002\u0001\"B\u001b\b\u0001\u00049\u0004\"\u0002 \b\u0001\u0004\u0001\u0005\"\u0002#\b\u0001\u00041\u0015\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\u0005Yc\u0006CA,[\u001b\u0005A&BA-\u0018\u0003\u0019!w.\\1j]&\u00111\f\u0017\u0002\u000b\t\u0016\u0004XM\u001c3f]\u000eL\b\"B/\t\u0001\u0004q\u0016AA5e!\tyfM\u0004\u0002aIB\u0011\u0011-I\u0007\u0002E*\u00111-H\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015\f\u0013A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!Z\u0011)\u0005!Q\u0007CA6s\u001b\u0005a'BA7o\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003_B\fq!\\3ue&\u001c7O\u0003\u0002r7\u0005A1m\u001c3bQ\u0006dW-\u0003\u0002tY\n)A+[7fI\u000611M]3bi\u0016$2A\u0016<|\u0011\u00159\u0018\u00021\u0001y\u0003\u001d\u0011X\r\\3bg\u0016\u0004\"aV=\n\u0005iD&a\u0002*fY\u0016\f7/\u001a\u0005\u0006y&\u0001\rAV\u0001\u000bI\u0016\u0004XM\u001c3f]\u000eL\bFA\u0005k\u0003\u0019)\b\u000fZ1uKR)a+!\u0001\u0002\u0004!)qO\u0003a\u0001q\")AP\u0003a\u0001-\"\u0012!B[\u0001\u0007I\u0016dW\r^3\u0015\t\u0005-\u0011\u0011\u0003\t\u0004A\u00055\u0011bAA\bC\t!QK\\5u\u0011\u0015a8\u00021\u0001WQ\tY!.A\u0004be\u000eD\u0017N^3\u0015\r\u0005-\u0011\u0011DA\u000e\u0011\u00159H\u00021\u0001y\u0011\u001d\ti\u0002\u0004a\u0001\u0003?\tA#\u0019:dQ&4X\r\u001a#fa\u0016tG-\u001a8dS\u0016\u001c\b#BA\u0011\u0003W1f\u0002BA\u0012\u0003Oq1!YA\u0013\u0013\u0005\u0011\u0013bAA\u0015C\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0017\u0003_\u00111aU3r\u0015\r\tI#\t\u0015\u0003\u0019)\fqBZ5oI\nK(+\u001a7fCN,\u0017\n\u001a\u000b\u0005\u0003o\t9\u0005E\u0003\u0002:\u0005\rc+\u0004\u0002\u0002<)!\u0011QHA \u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0005\u0013\u0001\u00026bm\u0006LA!!\u0012\u0002<\t!A*[:u\u0011\u0019\tI%\u0004a\u0001=\u0006I!/\u001a7fCN,\u0017\n\u001a\u0015\u0003\u001b)\f1DZ5oI\u0006cG.\u00138d_6Lgn\u001a#fa\u0016tG-\u001a8dS\u0016\u001cH\u0003CA\u0010\u0003#\n9&a\u0017\t\u000f\u0005Mc\u00021\u0001\u0002V\u0005IA/\u0019:hKRLEm\u001d\t\u0006\u0003C\tYC\u0018\u0005\b\u00033r\u0001\u0019AA+\u0003!\u0019H/\u0019;vg\u0016\u001c\bbBA/\u001d\u0001\u0007\u0011qL\u0001\u0014e\u00164WM]3oG&twm\u00115jY\u0012\u0014XM\u001c\t\u0004A\u0005\u0005\u0014bAA2C\t9!i\\8mK\u0006t\u0007F\u0001\bk\u00039\u0011Xm]8mm\u0016$\u0016M]4fiN$B!a\b\u0002l!9\u0011QN\bA\u0002\u0005}\u0011\u0001\u00043fa\u0016tG-\u001a8dS\u0016\u001c\u0018a\u0007:fg>dg/\u001a+be\u001e,GO\u0012:p[\u000e\u000bg\u000eZ5eCR,7\u000fF\u0003W\u0003g\n\u0019\tC\u0004\u0002vA\u0001\r!a\u001e\u0002-Q\f'oZ3u%\u0016dW-Y:f!2\fg.\u0013;f[N\u0004RaXA=\u0003{J1!a\u001fi\u0005\r\u0019V\r\u001e\t\u0004/\u0006}\u0014bAAA1\nA\u0001\u000b\\1o\u0013R,W\u000eC\u0003}!\u0001\u0007a+\u0001\u000bm_\u0006$'+\u001a7fCN,\u0007\u000b\\1o\u0013R,Wn\u001d\u000b\u0005\u0003o\nI\t\u0003\u0004\u0002\fF\u0001\rAX\u0001\u0010i\u0006\u0014x-\u001a;SK2,\u0017m]3JI\"\u001a\u0001!a$\u0011\t\u0005E\u0015QT\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006YAO]1og\u0006\u001cG/[8o\u0015\r!\u0012\u0011\u0014\u0006\u0004\u00037;\u0012A\u00013c\u0013\u0011\ty*a%\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\u0004")
public class SqlDependencyRepository
implements DependencyRepository,
BaseReleaseItemRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final RepositoryAdapter repositoryAdapter;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlDependencyRepository sqlDependencyRepository = this;
        synchronized (sqlDependencyRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    @Override
    public RepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    public Dependency findById(String id) {
        String releaseId = Ids.releaseIdFrom((String)id);
        Release release = this.getRelease(releaseId, id);
        Option maybeDependency = ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$findById$2(id, x$2)));
        return (Dependency)maybeDependency.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(id).append("] not found").toString(), new Object[0]);
        });
    }

    @Timed
    public Dependency create(Release release, Dependency dependency) {
        this.insertDependency(dependency);
        this.releasePersistence().update(release);
        return dependency;
    }

    @Timed
    public Dependency update(Release release, Dependency dependency) {
        if (!dependency.isArchived()) {
            this.dependencyPersistence().updateDependency(dependency);
        }
        this.releasePersistence().update(release);
        return dependency;
    }

    @Timed
    public void delete(Dependency dependency) {
        Release release = this.getRelease(Ids.releaseIdFrom((String)dependency.getId()), dependency.getId());
        Option maybeGateTask = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$delete$1(dependency, x$3)));
        maybeGateTask.map((Function1 & Serializable & scala.Serializable)gateTask -> {
            gateTask.setDependencies((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getDependencies()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$delete$3(dependency, x$4)))).asJava());
            this.releasePersistence().update(release);
            this.dependencyPersistence().deleteDependency(dependency);
            return dependency;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(47).append("GateTask ").append(dependency.getGateTask().getId()).append(" not found while deleting dependency ").append(dependency.getId()).append(".").toString(), new Object[0]);
        });
    }

    @Timed
    public void archive(Release release, Seq<Dependency> archivedDependencies) {
        block0: {
            if (!archivedDependencies.nonEmpty()) break block0;
            archivedDependencies.foreach((Function1 & Serializable & scala.Serializable)dependency -> {
                SqlDependencyRepository.$anonfun$archive$1(this, dependency);
                return BoxedUnit.UNIT;
            });
            this.releasePersistence().update(release);
        }
    }

    @Timed
    public List<Dependency> findByReleaseId(String releaseId) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.resolveTargets(DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence().findByGateReleaseId(CiId$.MODULE$.RichCiId(releaseId).normalized())).asDependencies())).asJava();
    }

    @Timed
    public Seq<Dependency> findAllIncomingDependencies(Seq<String> targetIds, Seq<String> statuses, boolean referencingChildren) {
        return referencingChildren ? DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence().findByPartialTargetIds((Set<String>)targetIds.toSet(), (Option<Set<String>>)SqlDependencyRepository.status$1(statuses))).asDependencies() : DependencyRow$.MODULE$.DependencyDataSeqOps(this.dependencyPersistence().findByTargetIds((Set<String>)targetIds.toSet(), (Option<Set<String>>)SqlDependencyRepository.status$1(statuses))).asDependencies();
    }

    private Seq<Dependency> resolveTargets(Seq<Dependency> dependencies) {
        ((TraversableLike)((TraversableLike)dependencies.filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.hasVariableTarget()))).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$resolveTargets$2(d)))).groupBy((Function1 & Serializable & scala.Serializable)d -> Ids.releaseIdFrom((String)d.getTargetId())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SqlDependencyRepository.$anonfun$resolveTargets$4(this, x0$1);
            return BoxedUnit.UNIT;
        });
        return dependencies;
    }

    private Dependency resolveTargetFromCandidates(Set<PlanItem> targetReleasePlanItems, Dependency dependency) {
        String targetId = dependency.getTargetId();
        if (!dependency.hasVariableTarget()) {
            Option option = targetReleasePlanItems.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SqlDependencyRepository.$anonfun$resolveTargetFromCandidates$1(targetId, x$6)));
            if (option instanceof Some) {
                Some some = (Some)option;
                PlanItem target = (PlanItem)some.value();
                dependency.setTarget(target);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Target '").append(dependency.getTargetId()).append("' of the Dependency '").append(dependency.getId()).append("' could not be resolved").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        return dependency;
    }

    private Set<PlanItem> loadReleasePlanItems(String targetReleaseId) {
        Set set;
        try {
            Release releaseOrNull = (Release)this.repositoryAdapter().read(targetReleaseId);
            set = (Set)Option$.MODULE$.apply((Object)releaseOrNull).map((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getAllPlanItems()).asScala()).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        }
        catch (NotFoundException notFoundException) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Could not find release by ID ").append(targetReleaseId).toString());
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public static final /* synthetic */ boolean $anonfun$findById$2(String id$1, Dependency x$2) {
        String string = x$2.getId();
        String string2 = CiId$.MODULE$.RichCiId(id$1).normalized();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$delete$1(Dependency dependency$1, GateTask x$3) {
        String string = x$3.getId();
        String string2 = CiId$.MODULE$.RichCiId(dependency$1.getGateTask().getId()).normalized();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$delete$3(Dependency dependency$1, Dependency x$4) {
        String string = x$4.getId();
        String string2 = CiId$.MODULE$.RichCiId(dependency$1.getId()).normalized();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$archive$1(SqlDependencyRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    private static final Option status$1(Seq statuses$1) {
        return statuses$1.isEmpty() ? None$.MODULE$ : new Some((Object)statuses$1.toSet());
    }

    public static final /* synthetic */ boolean $anonfun$resolveTargets$2(Dependency d) {
        return Ids.isReleaseId((String)d.getTargetId()) || Ids.isInRelease((String)d.getTargetId());
    }

    public static final /* synthetic */ void $anonfun$resolveTargets$4(SqlDependencyRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String targetReleaseId = (String)tuple2._1();
        Seq releaseDependencies = (Seq)tuple2._2();
        Set<PlanItem> targetReleasePlanItems = $this.loadReleasePlanItems(targetReleaseId);
        releaseDependencies.foreach((Function1 & Serializable & scala.Serializable)d -> $this.resolveTargetFromCandidates(targetReleasePlanItems, (Dependency)d));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$resolveTargetFromCandidates$1(String targetId$1, PlanItem x$6) {
        String string = x$6.getId();
        String string2 = targetId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlDependencyRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, RepositoryAdapter repositoryAdapter) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.repositoryAdapter = repositoryAdapter;
        BaseReleaseItemRepository.$init$(this);
        Logging.$init$((Logging)this);
    }
}

