/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator$;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.search.PlanItemSearchResult;
import com.xebialabs.xlrelease.search.ReleaseCountResults;
import com.xebialabs.xlrelease.search.ReleaseFullSearchResult;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.SqlReleasesFilterSupport$;
import com.xebialabs.xlrelease.service.SqlTemplatesFilterSupport$;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t=h\u0001\u0002\u0014(\u0001AB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aa\u000b\u0001BC\u0002\u0013\u0005q\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003Y\u0011!a\u0006A!b\u0001\n\u0003i\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\t\u0004!\u0011!Q\u0001\n\rD\u0001b\u001b\u0001\u0003\u0006\u0004%\u0019\u0001\u001c\u0005\n\u0003\u0013\u0001!\u0011!Q\u0001\n5D!\"a\u0003\u0001\u0005\u000b\u0007I1AA\u0007\u0011)\ty\u0002\u0001B\u0001B\u0003%\u0011q\u0002\u0005\u000b\u0003C\u0001!Q1A\u0005\u0002\u0005\r\u0002BCA\u0016\u0001\t\u0005\t\u0015!\u0003\u0002&!Q\u0011Q\u0006\u0001\u0003\u0006\u0004%\t!a\f\t\u0015\u0005e\u0002A!A!\u0002\u0013\t\t\u0004\u0003\u0006\u0002<\u0001\u0011\t\u0011)A\u0005\u0003{Aq!a\u0011\u0001\t\u0003\t)\u0005C\u0004\u0002^\u0001!\t%a\u0018\t\u000f\u0005]\u0005\u0001\"\u0011\u0002\u001a\"9\u0011q\r\u0001\u0005B\u0005M\u0006bBAq\u0001\u0011\u0005\u00131\u001d\u0005\b\u0003{\u0004A\u0011IA\u0000\u0011\u001d\u0011I\u0004\u0001C!\u0005wAqAa\u0017\u0001\t\u0003\u0012i\u0006C\u0004\u0003l\u0001!\tE!\u001c\t\u000f\tm\u0004\u0001\"\u0011\u0003~!9!1\u0011\u0001\u0005B\tu\u0004b\u0002BD\u0001\u0011\u0005#Q\u0010\u0005\b\u0005\u0017\u0003A\u0011\u0002BG\u0011\u001d\u0011\t\f\u0001C\u0005\u0005gCqA!/\u0001\t\u0013\u0011Y\fC\u0004\u0003@\u0002!IA!1\t\u000f\t\r\u0006\u0001\"\u0003\u0003J\"9!Q\u001a\u0001\u0005\n\t=\u0007b\u0002Bm\u0001\u0011\u0005#1\u001c\u0005\b\u0005G\u0004A\u0011\u0002Bs\u0011\u001d\u0011i\u000f\u0001C\u0005\u0005K\u0014qcU9m%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u000b\u0005!J\u0013aB:feZL7-\u001a\u0006\u0003U-\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u00051j\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005q\u0013aA2p[\u000e\u00011#\u0002\u00012om\u001a\u0005C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$AB!osJ+g\r\u0005\u00029s5\tq%\u0003\u0002;O\t!\"+\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\u000bMdg\r\u000e6\u000b\u0003\u0001\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003\u0005v\u0012q\u0001T8hO&tw\r\u0005\u0002E\u00136\tQI\u0003\u0002G\u000f\u0006\u00191/\u001d7\u000b\u0005!K\u0013A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011!*\u0012\u0002\u0017\t\u0016\u001cXM]5bY&T\u0018\r^5p]N+\b\u000f]8si\u0006\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f!\ti\u0005+D\u0001O\u0015\tyU)A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017BA)O\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0002!\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,\u0007C\u0001\u001dU\u0013\t)vE\u0001\tBe\u000eD\u0017N^5oON+'O^5dK\u0006\t\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0016\u0003a\u0003\"\u0001R-\n\u0005i+%\u0001F*rYJ+\u0007o\\:ji>\u0014\u00180\u00113baR,'/\u0001\nsKB|7/\u001b;pef\fE-\u00199uKJ\u0004\u0013a\u0003;fC6\u001cVM\u001d<jG\u0016,\u0012A\u0018\t\u0003q}K!\u0001Y\u0014\u0003\u0017Q+\u0017-\\*feZL7-Z\u0001\ri\u0016\fWnU3sm&\u001cW\rI\u0001\u0011I\u0016\u001cwN]1u_J\u001cVM\u001d<jG\u0016\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\u0011%tG/\u001a:oC2T!\u0001[\u0015\u0002\u0007\u0005\u0004\u0018.\u0003\u0002kK\n\u0001\u0013J\u001c;fe:\fG.T3uC\u0012\fG/\u0019#fG>\u0014\u0018\r^8s'\u0016\u0014h/[2f\u0003)\u0019\u0018\u000f\u001c#jC2,7\r^\u000b\u0002[B\u0019a.a\u0001\u000f\u0005=thB\u00019}\u001d\t\t(P\u0004\u0002ss:\u00111\u000f\u001f\b\u0003i^l\u0011!\u001e\u0006\u0003m>\na\u0001\u0010:p_Rt\u0014\"\u0001\u0018\n\u00051j\u0013B\u0001\u0016,\u0013\tY\u0018&\u0001\u0002eE&\u0011a) \u0006\u0003w&J1a`A\u0001\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003\rvLA!!\u0002\u0002\b\t9A)[1mK\u000e$(bA@\u0002\u0002\u0005Y1/\u001d7ES\u0006dWm\u0019;!\u0003I\u0001XM]7jgNLwN\\#oM>\u00148-\u001a:\u0016\u0005\u0005=\u0001\u0003BA\t\u00037i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\tg\u0016\u001cWO]5us*\u0019\u0011\u0011D\u0016\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!!\b\u0002\u0014\t\u0011\u0002+\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3s\u0003M\u0001XM]7jgNLwN\\#oM>\u00148-\u001a:!\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0016\u0005\u0005\u0015\u0002\u0003BA\t\u0003OIA!!\u000b\u0002\u0014\tY!k\u001c7f'\u0016\u0014h/[2f\u00031\u0011x\u000e\\3TKJ4\u0018nY3!\u0003)\u0019XmY;sK\u0012\u001c\u0015n]\u000b\u0003\u0003c\u0001B!a\r\u000265\tq)C\u0002\u00028\u001d\u0013!bU3dkJ,GmQ5t\u0003-\u0019XmY;sK\u0012\u001c\u0015n\u001d\u0011\u00027I,G.Z1tK\u0016CH/\u001a8tS>t7OU3q_NLGo\u001c:z!\u0011\t\u0019$a\u0010\n\u0007\u0005\u0005sIA\u000eSK2,\u0017m]3FqR,gn]5p]N\u0014V\r]8tSR|'/_\u0001\u0007y%t\u0017\u000e\u001e \u0015-\u0005\u001d\u0013\u0011JA&\u0003\u001b\ny%!\u0015\u0002T\u0005U\u0013qKA-\u00037\u0002\"\u0001\u000f\u0001\t\u000b-\u000b\u0002\u0019\u0001'\t\u000bI\u000b\u0002\u0019A*\t\u000bY\u000b\u0002\u0019\u0001-\t\u000bq\u000b\u0002\u0019\u00010\t\u000b\t\f\u0002\u0019A2\t\u000b-\f\u00029A7\t\u000f\u0005-\u0011\u0003q\u0001\u0002\u0010!9\u0011\u0011E\tA\u0002\u0005\u0015\u0002bBA\u0017#\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003w\t\u0002\u0019AA\u001f\u0003\u0015\u0019w.\u001e8u)\u0011\t\t'!\u001c\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001a*\u0003\u0019\u0019X-\u0019:dQ&!\u00111NA3\u0005M\u0011V\r\\3bg\u0016\u001cu.\u001e8u%\u0016\u001cX\u000f\u001c;t\u0011\u001d\tyG\u0005a\u0001\u0003c\nqB]3mK\u0006\u001cXm\u001d$jYR,'o\u001d\t\u0005\u0003g\ni(\u0004\u0002\u0002v)!\u0011qOA=\u0003\u00151wN]7t\u0015\r\tYhZ\u0001\u0003mFJA!a \u0002v\ty!+\u001a7fCN,7OR5mi\u0016\u00148\u000fK\u0002\u0013\u0003\u0007\u0003B!!\"\u0002\u00146\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)\u0001\u0006b]:|G/\u0019;j_:TA!!$\u0002\u0010\u00069Q.\u001a;sS\u000e\u001c(bAAI[\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002\u0016\u0006\u001d%!\u0002+j[\u0016$\u0017A\u00034vY2\u001cV-\u0019:dQRA\u00111TAQ\u0003G\u000bi\u000b\u0005\u0003\u0002d\u0005u\u0015\u0002BAP\u0003K\u0012qCU3mK\u0006\u001cXMR;mYN+\u0017M]2i%\u0016\u001cX\u000f\u001c;\t\u000f\u0005=4\u00031\u0001\u0002r!9\u0011QU\nA\u0002\u0005\u001d\u0016aC2veJ,g\u000e\u001e)bO\u0016\u0004B!a\r\u0002*&\u0019\u00111V$\u0003\tA\u000bw-\u001a\u0005\b\u0003_\u001b\u0002\u0019AAT\u0003-\t'o\u00195jm\u0016\u0004\u0016mZ3)\u0007M\t\u0019\t\u0006\u0007\u00026\u0006m\u0016QXAd\u0003\u0017\f)\u000e\u0005\u0003\u0002d\u0005]\u0016\u0002BA]\u0003K\u00121CU3mK\u0006\u001cXmU3be\u000eD'+Z:vYRDq!a\u001c\u0015\u0001\u0004\t\t\bC\u0004\u0002@R\u0001\r!!1\u0002\tA\fw-\u001a\t\u0004e\u0005\r\u0017bAAcg\t!Aj\u001c8h\u0011\u001d\tI\r\u0006a\u0001\u0003\u0003\fAB\\;nE\u0016\u0014()\u001f)bO\u0016Dq!!4\u0015\u0001\u0004\ty-A\u0003eKB$\b\u000eE\u00023\u0003#L1!a54\u0005\rIe\u000e\u001e\u0005\b\u0003/$\u0002\u0019AAm\u0003M1\u0017\u000e\u001c;fe>s\u0007+\u001a:nSN\u001c\u0018n\u001c8t!\r\u0011\u00141\\\u0005\u0004\u0003;\u001c$a\u0002\"p_2,\u0017M\u001c\u0015\u0004)\u0005\r\u0015aD:fCJ\u001c\u0007\u000eV3na2\fG/Z:\u0015\u0015\u0005U\u0016Q]A{\u0003o\fI\u0010C\u0004\u0002hV\u0001\r!!;\u0002\u001fQ,W\u000e\u001d7bi\u00164\u0015\u000e\u001c;feN\u0004B!a;\u0002r6\u0011\u0011Q\u001e\u0006\u0004\u0003_L\u0013!\u0002<jK^\u001c\u0018\u0002BAz\u0003[\u0014q\u0002V3na2\fG/\u001a$jYR,'o\u001d\u0005\b\u0003\u007f+\u0002\u0019AAa\u0011\u001d\tI-\u0006a\u0001\u0003\u0003Dq!!4\u0016\u0001\u0004\ty\rK\u0002\u0016\u0003\u0007\u000bQc]3be\u000eD'+\u001a7fCN,7OQ=USRdW\r\u0006\u0006\u0003\u0002\tu!\u0011\u0007B\u001a\u0005k\u0001bAa\u0001\u0003\u000e\tEQB\u0001B\u0003\u0015\u0011\u00119A!\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005\u0017\tAA[1wC&!!q\u0002B\u0003\u0005\u0011a\u0015n\u001d;\u0011\t\tM!\u0011D\u0007\u0003\u0005+Q1Aa\u0006*\u0003\u0019!w.\\1j]&!!1\u0004B\u000b\u0005\u001d\u0011V\r\\3bg\u0016DqAa\b\u0017\u0001\u0004\u0011\t#\u0001\u0007sK2,\u0017m]3USRdW\r\u0005\u0003\u0003$\t-b\u0002\u0002B\u0013\u0005O\u0001\"\u0001^\u001a\n\u0007\t%2'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005[\u0011yC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005S\u0019\u0004bBA`-\u0001\u0007\u0011\u0011\u0019\u0005\b\u0003\u00134\u0002\u0019AAa\u0011\u001d\tiM\u0006a\u0001\u0003\u001fD3AFAB\u0003\t2\u0017N\u001c3BY2\u0014V\r\\3bg\u0016LEm]!oIRKG\u000f\\3t\u0005f\u001cF/\u0019;vgR!!Q\bB\"!!\u0011\u0019Ca\u0010\u0003\"\t\u0005\u0012\u0002\u0002B!\u0005_\u00111!T1q\u0011\u001d\u0011)e\u0006a\u0001\u0005\u000f\n\u0001b\u001d;biV\u001cXm\u001d\t\u0006e\t%#QJ\u0005\u0004\u0005\u0017\u001a$A\u0003\u001fsKB,\u0017\r^3e}A!!q\nB+\u001b\t\u0011\tF\u0003\u0003\u0003T\tU\u0011AB:uCR,8/\u0003\u0003\u0003X\tE#!\u0004*fY\u0016\f7/Z*uCR,8\u000fK\u0002\u0018\u0003\u0007\u000b1DZ5oI\u0006cG\u000eV3na2\fG/Z%eg\u0006sG\rV5uY\u0016\u001cHC\u0002B0\u0005K\u00129\u0007\u0005\u0003\u0002d\t\u0005\u0014\u0002\u0002B2\u0003K\u0012A\u0003\u00157b]&#X-\\*fCJ\u001c\u0007NU3tk2$\bbBA`1\u0001\u0007\u0011\u0011\u0019\u0005\b\u0003\u0013D\u0002\u0019AAaQ\rA\u00121Q\u0001\tO\u0016$H+\u001b;mKR!!q\u000eB;!\u0015\u0011$\u0011\u000fB\u0011\u0013\r\u0011\u0019h\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\t]\u0014\u00041\u0001\u0003\"\u0005I!/\u001a7fCN,\u0017\n\u001a\u0015\u00043\u0005\r\u0015A\u00054j]\u0012\fE\u000e\u001c+f[Bd\u0017\r^3JIN,\"Aa \u0011\r\t\r!Q\u0002B\u0011Q\rQ\u00121Q\u0001\u0018M&tG-\u00117m\u0003\u000e$\u0018N^3SK2,\u0017m]3JIND3aGAB\u0003a1\u0017N\u001c3BY2\u0004VM\u001c3j]\u001e\u0014V\r\\3bg\u0016LEm\u001d\u0015\u00049\u0005\r\u0015!D9vKJL(+\u001a7fCN,7\u000f\u0006\u0005\u0003\u0010\n\u0005&Q\u0016BX!\u0019\u0011\tJa'\u0003\u00129!!1\u0013BL\u001d\r!(QS\u0005\u0002i%\u0019!\u0011T\u001a\u0002\u000fA\f7m[1hK&!!Q\u0014BP\u0005\r\u0019V-\u001d\u0006\u0004\u00053\u001b\u0004b\u0002BR;\u0001\u0007!QU\u0001\ng\u0016\f'o\u00195JIN\u0004rA\rBT\u0003O\u0013Y+C\u0002\u0003*N\u0012\u0011BR;oGRLwN\\\u0019\u0011\r\tE%1\u0014B\u0011\u0011\u001d\ty,\ba\u0001\u0003\u0003Dq!!3\u001e\u0001\u0004\t\t-\u0001\nrk\u0016\u0014\u0018PU3mK\u0006\u001cXm\u001d\"z\u0013\u0012\u001cH\u0003\u0002BH\u0005kCqAa.\u001f\u0001\u0004\u0011Y+\u0001\u0006sK2,\u0017m]3JIN\f\u0001DZ5oIJ+G.Z1tKN\u0014\u00150\u00133t\u0013:|%\u000fZ3s)\u0011\u0011yI!0\t\u000f\t]v\u00041\u0001\u0003,\u0006qAo\\*fCJ\u001c\u0007NU3tk2$HCBA[\u0005\u0007\u0014)\rC\u0004\u0002@\u0002\u0002\r!!1\t\u000f\t\u001d\u0007\u00051\u0001\u0003\u0010\u0006A!/\u001a7fCN,7\u000f\u0006\u0003\u0003&\n-\u0007bBA8C\u0001\u0007\u0011\u0011O\u0001\u0010g\u0016\f'o\u00195J]\u0006\u00138\r[5wKRA!q\u0012Bi\u0005'\u0014)\u000eC\u0004\u0002p\t\u0002\r!!\u001d\t\u000f\u0005%'\u00051\u0001\u0002B\"9!q\u001b\u0012A\u0002\u0005\u0005\u0017AB8gMN,G/\u0001\u0007fq&\u001cHo\u001d\"z\u001d\u0006lW\r\u0006\u0003\u0002Z\nu\u0007b\u0002BpG\u0001\u0007!\u0011E\u0001\u000eG\u0006tG-\u001b3bi\u0016t\u0015-\\3)\u0007\r\n\u0019)A\tdkJ\u0014XM\u001c;Qe&t7-\u001b9bYN$\"Aa:\u0011\r\tE%\u0011\u001eB\u0011\u0013\u0011\u0011YOa(\u0003\u0011%#XM]1cY\u0016\fabY;se\u0016tGOU8mK&#7\u000f")
public class SqlReleaseSearchService
implements ReleaseSearchService,
Logging,
DeserializationSupport {
    private final ReleasePersistence releasePersistence;
    private final ArchivingService archivingService;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final TeamService teamService;
    private final InternalMetadataDecoratorService decoratorService;
    private final SqlBuilder.Dialect sqlDialect;
    private final PermissionEnforcer permissionEnforcer;
    private final RoleService roleService;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private Logger grizzled$slf4j$Logging$$_logger;
    private final long DEFAULT_NUMBER_OF_RELEASES_PER_PAGE;
    private final int DEFAULT_RELEASE_LOAD_DEPTH;
    private volatile boolean bitmap$0;

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page, long numberByPage) {
        return ReleaseSearchService.search$((ReleaseSearchService)this, (ReleasesFilters)releasesFilters, (long)page, (long)numberByPage);
    }

    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page, long numberByPage, int depth) {
        return ReleaseSearchService.search$((ReleaseSearchService)this, (ReleasesFilters)releasesFilters, (long)page, (long)numberByPage, (int)depth);
    }

    public scala.collection.immutable.Map<String, String> findAllReleaseIdsAndTitlesByStatus(ReleaseStatus ... statuses) {
        return ReleaseSearchService.findAllReleaseIdsAndTitlesByStatus$((ReleaseSearchService)this, (ReleaseStatus[])statuses);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseSearchService sqlReleaseSearchService = this;
        synchronized (sqlReleaseSearchService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public long DEFAULT_NUMBER_OF_RELEASES_PER_PAGE() {
        return this.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE;
    }

    public int DEFAULT_RELEASE_LOAD_DEPTH() {
        return this.DEFAULT_RELEASE_LOAD_DEPTH;
    }

    public void com$xebialabs$xlrelease$service$ReleaseSearchService$_setter_$DEFAULT_NUMBER_OF_RELEASES_PER_PAGE_$eq(long x$1) {
        this.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE = x$1;
    }

    public void com$xebialabs$xlrelease$service$ReleaseSearchService$_setter_$DEFAULT_RELEASE_LOAD_DEPTH_$eq(int x$1) {
        this.DEFAULT_RELEASE_LOAD_DEPTH = x$1;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public TeamService teamService() {
        return this.teamService;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public SecuredCis securedCis() {
        return this.securedCis;
    }

    @Timed
    public ReleaseCountResults count(ReleasesFilters releasesFilters) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        releasesFilters.setOrderBy(null);
        scala.collection.immutable.Map fromArchive = this.archivingService.countReleasesByStatus(releasesFilters).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
        if (releasesFilters.withOnlyArchived()) {
            tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().empty()), (Object)fromArchive);
        } else {
            Iterable<String> principals = this.currentPrincipals();
            Iterable<String> roleIds = this.currentRoleIds();
            ReleasesSqlBuilder statusQuery = SqlReleasesFilterSupport$.MODULE$.sqlBuilderByFilters(releasesFilters, principals, roleIds, this.permissionEnforcer(), this.sqlDialect()).countByStatus();
            tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.releasePersistence.countReleasesByStatus((Tuple2<String, Seq<Object>>)statusQuery.build()).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))), (Object)fromArchive);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Map current = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map archived = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)current, (Object)archived);
        Tuple2 tuple24 = tuple23;
        scala.collection.immutable.Map current2 = (scala.collection.immutable.Map)tuple24._1();
        scala.collection.immutable.Map archived2 = (scala.collection.immutable.Map)tuple24._2();
        return new ReleaseCountResults((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)current2).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)archived2).asJava());
    }

    @Timed
    public ReleaseFullSearchResult fullSearch(ReleasesFilters releasesFilters, Page currentPage, Page archivePage) {
        Function1<Page, Seq<String>> getIds = this.searchIds(releasesFilters);
        ReleaseSearchResult archived = new ReleaseSearchResult((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.searchInArchive(releasesFilters, archivePage.resultsPerPage(), archivePage.offset())).asJava(), archivePage.page());
        ReleaseSearchResult live = releasesFilters.withOnlyArchived() ? ReleaseSearchResult.empty((long)currentPage.page()) : new ReleaseSearchResult((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.queryReleases(getIds, currentPage.page(), currentPage.resultsPerPage())).asJava(), currentPage.page());
        return new ReleaseFullSearchResult(live, archived);
    }

    @Timed
    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page, long numberByPage, int depth, boolean filterOnPermissions) {
        Seq<Release> results = releasesFilters.withOnlyArchived() ? this.searchInArchive(releasesFilters, numberByPage, numberByPage * page) : this.queryReleases(this.searchIds(releasesFilters), page, numberByPage);
        return this.toSearchResult(page, results);
    }

    @Timed
    public ReleaseSearchResult searchTemplates(TemplateFilters templateFilters, long page2, long numberByPage, int depth) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Searching for templates by filters");
        ReleasesSqlBuilder query = SqlTemplatesFilterSupport$.MODULE$.sqlBuilderByFilters(templateFilters, this.currentPrincipals(), this.currentRoleIds(), this.permissionEnforcer(), this.sqlDialect()).selectReleaseId();
        Seq<Release> templates = this.queryReleases((Function1<Page, Seq<String>>)(Function1 & Serializable & scala.Serializable)page -> this.searchIds$1((Page)page, query), page2, numberByPage);
        return this.toSearchResult(page2, templates);
    }

    @Timed
    public java.util.List<Release> searchReleasesByTitle(String releaseTitle, long page2, long numberByPage, int depth) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Searching for releases by title ").append(releaseTitle).toString());
        ReleasesSqlBuilder query = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withTitle(releaseTitle);
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? query.withPermission(XLReleasePermissions.VIEW_RELEASE, this.currentPrincipals(), this.currentRoleIds()) : BoxedUnit.UNIT;
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.queryReleases((Function1<Page, Seq<String>>)(Function1 & Serializable & scala.Serializable)page -> this.getIds$1((Page)page, query), page2, numberByPage)).asJava();
    }

    @Timed
    public scala.collection.immutable.Map<String, String> findAllReleaseIdsAndTitlesByStatus(Seq<ReleaseStatus> statuses) {
        ReleasesSqlBuilder sqlBuilder = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseIdAndTitle().withOneOfStatuses(statuses);
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? sqlBuilder.withPermission(XLReleasePermissions.VIEW_RELEASE, this.currentPrincipals(), this.currentRoleIds()) : BoxedUnit.UNIT;
        Tuple2 sqlWithParams = sqlBuilder.build();
        return this.releasePersistence.findReleaseIdsAndTitlesByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).toMap(Predef$.MODULE$.$conforms());
    }

    @Timed
    public PlanItemSearchResult findAllTemplateIdsAndTitles(long page, long numberByPage) {
        ReleasesSqlBuilder sqlBuilder = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseIdAndTitle().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE})))).orderBy(ReleaseOrderMode.title).withPage(new Page((long)((int)page), (long)((int)numberByPage), Predef$.MODULE$.int2Integer(0)));
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? sqlBuilder.withPermission(XLReleasePermissions.VIEW_TEMPLATE, this.currentPrincipals(), this.currentRoleIds()) : BoxedUnit.UNIT;
        scala.collection.immutable.Map idToTitle = this.releasePersistence.findReleaseIdsAndTitlesByQuery((Tuple2<String, Seq<Object>>)sqlBuilder.build()).toMap(Predef$.MODULE$.$conforms());
        PlanItemSearchResult searchResult = new PlanItemSearchResult();
        searchResult.setPage(page + 1L);
        searchResult.setItems(JavaConverters$.MODULE$.mapAsJavaMap((Map)idToTitle));
        return searchResult;
    }

    @Timed
    public Option<String> getTitle(String releaseId) {
        return this.releasePersistence.findReleaseTitle(releaseId).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.archivingService.getReleaseTitle(releaseId)).toOption());
    }

    @Timed
    public java.util.List<String> findAllTemplateIds() {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE})))).build();
        return (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    @Timed
    public java.util.List<String> findAllActiveReleaseIds() {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    @Timed
    public java.util.List<String> findAllPendingReleaseIds() {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Searching for all pending releases");
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED})))).withAutoStart().build();
        return (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams)).asJava();
    }

    private Seq<Release> queryReleases(Function1<Page, Seq<String>> searchIds, long page, long numberByPage) {
        return this.queryReleasesByIds((Seq<String>)((Seq)searchIds.apply((Object)new Page((long)((int)page), (long)((int)numberByPage), Predef$.MODULE$.int2Integer(0)))));
    }

    private Seq<Release> queryReleasesByIds(Seq<String> releaseIds) {
        Seq releases = releaseIds.nonEmpty() ? this.findReleasesByIdsInOrder(releaseIds) : (Seq)Seq$.MODULE$.empty();
        return (Seq)((TraversableLike)releases.map((Function1 & Serializable & scala.Serializable)release -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.teamService().decorateWithEffectiveTeams(release)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.decoratorService.decorate((ConfigurationItem)release, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava())).map((Function1 & Serializable & scala.Serializable)_ -> release)), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            List list;
            Try try_ = x0$1;
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> err);
                list = List$.MODULE$.empty();
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                Release release = (Release)success.value();
                list = new .colon.colon((Object)release, (List)Nil$.MODULE$);
            } else {
                throw new MatchError((Object)try_);
            }
            return list;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Release> findReleasesByIdsInOrder(Seq<String> releaseIds) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds(releaseIds).build();
        Seq releasesUnordered = (Seq)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)releaseData -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)releaseData)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> $this.releaseExtensionsRepository.decorate(release), Seq$.MODULE$.canBuildFrom());
        return (Seq)releasesUnordered.sortBy((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)releaseIds.indexOf((Object)r.getId())), (Ordering)Ordering.Int$.MODULE$);
    }

    private ReleaseSearchResult toSearchResult(long page, Seq<Release> releases) {
        return new ReleaseSearchResult((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(releases).asJava(), page + 1L);
    }

    private Function1<Page, Seq<String>> searchIds(ReleasesFilters releasesFilters) {
        if (releasesFilters.getOrderBy() == null) {
            releasesFilters.setOrderBy(ReleaseOrderMode.risk);
        }
        ReleasesSqlBuilder query = SqlReleasesFilterSupport$.MODULE$.sqlBuilderByFilters(releasesFilters, this.currentPrincipals(), this.currentRoleIds(), this.permissionEnforcer(), this.sqlDialect()).selectReleaseId();
        return (Function1 & Serializable & scala.Serializable)page -> {
            Tuple2 sqlWithParams = query.withPage((Page)page).build();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Searching for a batch of releases by SQL query: ").append(sqlWithParams._1()).toString());
            return $this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        };
    }

    private Seq<Release> searchInArchive(ReleasesFilters releasesFilters, long numberByPage, long offset) {
        java.util.List releases = this.archivingService.searchReleases(releasesFilters, numberByPage, offset);
        this.decoratorService.decorate((Collection)releases, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), (List)new .colon.colon((Object)EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), (List)Nil$.MODULE$))).asJava());
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(releases).asScala();
    }

    @Timed
    public boolean existsByName(String candidateName) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withReleaseName(candidateName).withPage(new Page(0L, 1L, Predef$.MODULE$.int2Integer(0))).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).nonEmpty();
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Iterable<String> currentRoleIds() {
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Buffer$.MODULE$.canBuildFrom());
    }

    private final Seq searchIds$1(Page page, ReleasesSqlBuilder query$1) {
        Tuple2 sqlWithParams = query$1.withPage(page).build();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Searching for a batch of templates by SQL query: ").append(sqlWithParams._1()).toString());
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    private final Seq getIds$1(Page page, ReleasesSqlBuilder query$2) {
        Tuple2 sqlWithParams = query$2.withPage(page).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    public SqlReleaseSearchService(ReleasePersistence releasePersistence, ArchivingService archivingService, SqlRepositoryAdapter repositoryAdapter, TeamService teamService, InternalMetadataDecoratorService decoratorService, SqlBuilder.Dialect sqlDialect, PermissionEnforcer permissionEnforcer, RoleService roleService, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository) {
        this.releasePersistence = releasePersistence;
        this.archivingService = archivingService;
        this.repositoryAdapter = repositoryAdapter;
        this.teamService = teamService;
        this.decoratorService = decoratorService;
        this.sqlDialect = sqlDialect;
        this.permissionEnforcer = permissionEnforcer;
        this.roleService = roleService;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        ReleaseSearchService.$init$((ReleaseSearchService)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
    }
}

