/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator$;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksUnionSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.service.SqlTasksFilterSupport$;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.TaskSearchService;
import com.xebialabs.xlrelease.views.ReleaseTasks;
import com.xebialabs.xlrelease.views.TaskSearchView;
import com.xebialabs.xlrelease.views.TasksFilters;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\tUa\u0001\u0002\u000b\u0016\u0001yA\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\u0005\u0004!Q1A\u0005\u0002\tD\u0001b\u001a\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\tQ\u0002\u0011)\u0019!C\u0002S\"AQ\u000e\u0001B\u0001B\u0003%!\u000e\u0003\u0005o\u0001\t\u0015\r\u0011b\u0001p\u0011%\ty\u0001\u0001B\u0001B\u0003%\u0001\u000fC\u0004\u0002\u0012\u0001!\t!a\u0005\t\u0013\u0005%\u0002A1A\u0005\n\u0005-\u0002\u0002CA\u001d\u0001\u0001\u0006I!!\f\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0004bBAW\u0001\u0011%\u0011q\u0016\u0005\b\u00033\u0004A\u0011AAn\u0005Q\u0019\u0016\u000f\u001c+bg.\u001cV-\u0019:dQN+'O^5dK*\u0011acF\u0001\bg\u0016\u0014h/[2f\u0015\tA\u0012$A\u0005yYJ,G.Z1tK*\u0011!dG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001H\u0001\u0004G>l7\u0001A\n\u0005\u0001}93\u0006\u0005\u0002!K5\t\u0011E\u0003\u0002#G\u0005!A.\u00198h\u0015\u0005!\u0013\u0001\u00026bm\u0006L!AJ\u0011\u0003\r=\u0013'.Z2u!\tA\u0013&D\u0001\u0016\u0013\tQSCA\tUCN\\7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\u000bMdg\r\u000e6\u000b\u0003A\n\u0001b\u001a:jujdW\rZ\u0005\u0003e5\u0012q\u0001T8hO&tw-A\u0006s_2,7+\u001a:wS\u000e,\u0007CA\u001b;\u001b\u00051$BA\u001c9\u0003!\u0019XmY;sSRL(BA\u001d\u001a\u0003!!W\r\u001d7ps&$\u0018BA\u001e7\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0002#Q\f7o[!dG\u0016\u001c8oU3sm&\u001cW\r\u0005\u0002)}%\u0011q(\u0006\u0002\u0012)\u0006\u001c8.Q2dKN\u001c8+\u001a:wS\u000e,\u0017A\u0005;bg.\u001ch+[3x\u0007>tg/\u001a:uKJ\u0004\"AQ$\u000e\u0003\rS!\u0001R#\u0002\u0015\r|gN^3si\u0016\u00148O\u0003\u0002G/\u0005)a/[3xg&\u0011\u0001j\u0011\u0002\u0013)\u0006\u001c8n\u001d,jK^\u001cuN\u001c<feR,'/\u0001\teK\u000e|'/\u0019;peN+'O^5dKB\u00111\nU\u0007\u0002\u0019*\u0011QJT\u0001\tS:$XM\u001d8bY*\u0011qjF\u0001\u0004CBL\u0017BA)M\u0005\u0001Je\u000e^3s]\u0006dW*\u001a;bI\u0006$\u0018\rR3d_J\fGo\u001c:TKJ4\u0018nY3\u0002%I,G.Z1tKB+'o]5ti\u0016t7-\u001a\t\u0003)nk\u0011!\u0016\u0006\u0003-^\u000b1\u0002]3sg&\u001cH/\u001a8dK*\u0011\u0001,W\u0001\u0004gFd'B\u0001.\u0018\u0003)\u0011X\r]8tSR|'/_\u0005\u00039V\u0013!CU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0006yA/Y:l!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002U?&\u0011\u0001-\u0016\u0002\u0010)\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0006\t\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0016\u0003\r\u0004\"\u0001Z3\u000e\u0003]K!AZ,\u0003)M\u000bHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003I\u0011X\r]8tSR|'/_!eCB$XM\u001d\u0011\u0002%A,'/\\5tg&|g.\u00128g_J\u001cWM]\u000b\u0002UB\u0011Qg[\u0005\u0003YZ\u0012!\u0003U3s[&\u001c8/[8o\u000b:4wN]2fe\u0006\u0019\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3sA\u0005Q1/\u001d7ES\u0006dWm\u0019;\u0016\u0003A\u00042!]A\u0005\u001d\r\u0011\u00181\u0001\b\u0003g~t!\u0001^?\u000f\u0005UdhB\u0001<|\u001d\t9(0D\u0001y\u0015\tIX$\u0001\u0004=e>|GOP\u0005\u00029%\u0011!dG\u0005\u00031eI!A`\f\u0002\u0005\u0011\u0014\u0017b\u0001-\u0002\u0002)\u0011apF\u0005\u0005\u0003\u000b\t9!\u0001\u0006Tc2\u0014U/\u001b7eKJT1\u0001WA\u0001\u0013\u0011\tY!!\u0004\u0003\u000f\u0011K\u0017\r\\3di*!\u0011QAA\u0004\u0003-\u0019\u0018\u000f\u001c#jC2,7\r\u001e\u0011\u0002\rqJg.\u001b;?)Q\t)\"a\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\t\u0019#!\n\u0002(A\u0011\u0001\u0006\u0001\u0005\u0006g5\u0001\r\u0001\u000e\u0005\u0006y5\u0001\r!\u0010\u0005\u0006\u00016\u0001\r!\u0011\u0005\u0006\u00136\u0001\rA\u0013\u0005\u0006%6\u0001\ra\u0015\u0005\u0006;6\u0001\rA\u0018\u0005\u0006C6\u0001\ra\u0019\u0005\u0006Q6\u0001\u001dA\u001b\u0005\u0006]6\u0001\u001d\u0001]\u0001\u0014\u001b\u0006CvLT+N\u0005\u0016\u0013vl\u0014$`\u0015>KejU\u000b\u0003\u0003[\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0003\u0003g\tQa]2bY\u0006LA!a\u000e\u00022\t\u0019\u0011J\u001c;\u0002)5\u000b\u0005l\u0018(V\u001b\n+%kX(G?*{\u0015JT*!\u0003E9W\r\u001e+bg.\u001c()\u001f*fY\u0016\f7/\u001a\u000b\u0007\u0003\u007f\t9%!\u0015\u0011\t\u0005\u0005\u00131I\u0007\u0002\u000b&\u0019\u0011QI#\u0003\u001dQ\u000b7o[*fCJ\u001c\u0007NV5fo\"9\u0011\u0011\n\tA\u0002\u0005-\u0013\u0001\u0004;bg.\u001ch)\u001b7uKJ\u001c\b\u0003BA!\u0003\u001bJ1!a\u0014F\u00051!\u0016m]6t\r&dG/\u001a:t\u0011\u001d\t\u0019\u0006\u0005a\u0001\u0003+\nA\u0003\\5nSR$\u0016m]6t\u0011&tGo\u00149uS>t\u0007c\u0001\u0011\u0002X%\u0019\u0011\u0011L\u0011\u0003\u000f%sG/Z4fe\"\u001a\u0001#!\u0018\u0011\t\u0005}\u0013QN\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005\u001d\u0014\u0011N\u0001\b[\u0016$(/[2t\u0015\r\tYgG\u0001\tG>$\u0017\r[1mK&!\u0011qNA1\u0005\u0015!\u0016.\\3e\u0003\u0011!\u0018.\\3\u0016\t\u0005U\u0014Q\u0010\u000b\u0005\u0003o\nI\n\u0006\u0003\u0002z\u0005=\u0005\u0003BA>\u0003{b\u0001\u0001B\u0004\u0002\u0000E\u0011\r!!!\u0003\u0003\u0005\u000bB!a!\u0002\nB!\u0011qFAC\u0013\u0011\t9)!\r\u0003\u000f9{G\u000f[5oOB!\u0011qFAF\u0013\u0011\ti)!\r\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u0012F!\t\u0019AAJ\u0003\u0015\u0011Gn\\2l!\u0019\ty#!&\u0002z%!\u0011qSA\u0019\u0005!a$-\u001f8b[\u0016t\u0004bBAN#\u0001\u0007\u0011QT\u0001\u0005I\u0016\u001c8\r\u0005\u0003\u0002 \u0006\u001df\u0002BAQ\u0003G\u00032a^A\u0019\u0013\u0011\t)+!\r\u0002\rA\u0013X\rZ3g\u0013\u0011\tI+a+\u0003\rM#(/\u001b8h\u0015\u0011\t)+!\r\u0002%M|'\u000f\u001e\"z%\u0016dW-Y:f)&$H.\u001a\u000b\u0005\u0003c\u000b\u0019\r\u0005\u0004\u00024\u0006e\u0016QX\u0007\u0003\u0003kS1!a.$\u0003\u0011)H/\u001b7\n\t\u0005m\u0016Q\u0017\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002B\u0005}\u0016bAAa\u000b\na!+\u001a7fCN,G+Y:lg\"9\u0011Q\u0019\nA\u0002\u0005\u001d\u0017!\u0004:fY\u0016\f7/Z:UCN\\7\u000f\u0005\u0004\u0002J\u0006M\u0017Q\u0018\b\u0005\u0003\u0017\fyMD\u0002x\u0003\u001bL!!a\r\n\t\u0005E\u0017\u0011G\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t).a6\u0003\u0007M+\u0017O\u0003\u0003\u0002R\u0006E\u0012!D:fCJ\u001c\u0007\u000eV1tW&#7\u000f\u0006\u0004\u0002^\u0006e\u00181 \t\u0007\u0003\u0013\f\u0019.a8\u0011\t\u0005\u0005\u00181\u001f\b\u0005\u0003G\fyO\u0004\u0003\u0002f\u00065h\u0002BAt\u0003Wt1\u0001^Au\u0013\tQv#\u0003\u0002Y3&\u0011akV\u0005\u0004\u0003c,\u0016\u0001B\"j\u0013\u0012LA!!>\u0002x\n!1)[%e\u0015\r\t\t0\u0016\u0005\b\u0003\u0013\u001a\u0002\u0019AA&\u0011\u001d\tip\u0005a\u0001\u0003[\tQ\u0001\\5nSRD3a\u0005B\u0001!\u0011\u0011\u0019A!\u0005\u000e\u0005\t\u0015!\u0002\u0002B\u0004\u0005\u0013\t1\"\u00198o_R\fG/[8og*!!1\u0002B\u0007\u0003\u0019\u0019w.\\7p]*\u0019!qB\u000e\u0002\r\u001d|wn\u001a7f\u0013\u0011\u0011\u0019B!\u0002\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw\r")
public class SqlTaskSearchService
implements TaskSearchService,
Logging {
    private final RoleService roleService;
    private final TaskAccessService taskAccessService;
    private final TasksViewConverter tasksViewConverter;
    private final InternalMetadataDecoratorService decoratorService;
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect sqlDialect;
    private final int MAX_NUMBER_OF_JOINS;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskSearchService sqlTaskSearchService = this;
        synchronized (sqlTaskSearchService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    private int MAX_NUMBER_OF_JOINS() {
        return this.MAX_NUMBER_OF_JOINS;
    }

    @Timed
    public TaskSearchView getTasksByRelease(TasksFilters tasksFilters, Integer limitTasksHintOption) {
        int limit = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)limitTasksHintOption).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 30));
        Seq taskIds = (Seq)this.time("finding task ids", (Function0 & Serializable & scala.Serializable)() -> this.searchTaskIds(tasksFilters, limit));
        Seq releaseIds = (Seq)((SeqLike)taskIds.map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.releaseIdFrom((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Found ").append(taskIds.size()).append(" tasks in ").append(releaseIds.size()).append(" releases for user ").append(Permissions.getAuthenticatedUserName()).toString());
        List allowedTaskTypesForAuthenticatedUser = (List)this.time("fetching allowed task types for authenticated user", (Function0 & Serializable & scala.Serializable)() -> $this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
        Tuple2 queryReleases = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds((Seq<String>)releaseIds).build();
        Seq releasesTasks = (Seq)this.time("total time to create releasesTasks", (Function0 & Serializable & scala.Serializable)() -> (Seq)((TraversableLike)((GenericTraversableTemplate)this.time("de-serializing releases", (Function0 & Serializable & scala.Serializable)() -> {
            boolean bl = this.repositoryAdapter().tryDeserialize$default$1();
            return (Seq)$this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)queryReleases).map((Function1 & Serializable & scala.Serializable)releaseData -> this.repositoryAdapter().tryDeserialize(bl, (ReleaseRow)releaseData), Seq$.MODULE$.canBuildFrom());
        })).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).flatMap((Function1 & Serializable & scala.Serializable)foundRelease -> {
            $this.decoratorService.decorate((ConfigurationItem)foundRelease, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ReleaseGlobalVariablesDecorator$.MODULE$.GLOBAL_VARIABLES(), EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
            return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)BoxedUnit.UNIT).map((Function1 & Serializable & scala.Serializable)x$2 -> {
                Buffer orderedTasks = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(foundRelease.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)taskIds.exists((Function1 & Serializable & scala.Serializable)foundId -> BoxesRunTime.boxToBoolean((boolean)SqlTaskSearchService.$anonfun$getTasksByRelease$14(task, foundId)))))).sortBy((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToInteger((int)taskIds.indexWhere((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)SqlTaskSearchService.$anonfun$getTasksByRelease$16(task, id)))), (Ordering)Ordering.Int$.MODULE$);
                return new Tuple2(x$2, (Object)orderedTasks);
            }).map((Function1 & Serializable & scala.Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Buffer orderedTasks = (Buffer)tuple2._2();
                ReleaseTasks releaseTasks = new ReleaseTasks(foundRelease, $this.tasksViewConverter.toFullView((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(orderedTasks).asJava(), allowedTaskTypesForAuthenticatedUser));
                return releaseTasks;
            }));
        }, Seq$.MODULE$.canBuildFrom()));
        return new TaskSearchView(this.sortByReleaseTitle((Seq<ReleaseTasks>)releasesTasks), taskIds.size() >= limit);
    }

    private <A> A time(String desc, Function0<A> block) {
        long startTime = System.currentTimeMillis();
        Object res = block.apply();
        long endTime = System.currentTimeMillis();
        long total = endTime - startTime;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("TIME: ").append(desc).append(" took ").append(total).toString());
        return (A)res;
    }

    private List<ReleaseTasks> sortByReleaseTitle(Seq<ReleaseTasks> releasesTasks) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releasesTasks.sortBy((Function1 & Serializable & scala.Serializable)releaseTasks -> (String)Option$.MODULE$.apply((Object)releaseTasks.getTitle()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    @VisibleForTesting
    public Seq<String> searchTaskIds(TasksFilters tasksFilters, int limit) {
        LinkedHashSet taskIds = (LinkedHashSet)((IterableLike)((IterableLike)SqlTaskSearchService.getPrincipals$1().$plus$plus((GenTraversableOnce)this.getRoleIds$1(), Iterable$.MODULE$.canBuildFrom())).grouped(this.sqlDialect().maxQueryParams() / this.MAX_NUMBER_OF_JOINS()).foldLeft((Object)LinkedHashSet$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            LinkedHashSet linkedHashSet;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                LinkedHashSet acc = (LinkedHashSet)tuple2._1();
                Iterable group = (Iterable)tuple2._2();
                if (acc.size() < limit) {
                    Seq newBatch = this.doSearch$1((Seq)SqlTaskSearchService.getPrincipalsFromGroup$1().apply((Object)group), (Seq)SqlTaskSearchService.getRoleIdsFromGroup$1().apply((Object)group), tasksFilters, limit);
                    linkedHashSet = (LinkedHashSet)acc.$plus$plus((GenTraversableOnce)newBatch);
                } else {
                    linkedHashSet = acc;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            LinkedHashSet linkedHashSet2 = linkedHashSet;
            return linkedHashSet2;
        })).take(limit);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append(tasksFilters).append(": results ").append(taskIds.size()).toString());
        return taskIds.toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$getTasksByRelease$14(Task task$1, String foundId) {
        return task$1.getId().endsWith(foundId);
    }

    public static final /* synthetic */ boolean $anonfun$getTasksByRelease$16(Task task$2, String id) {
        return task$2.getId().startsWith(id);
    }

    private static final Function1 getPrincipalsFromGroup$1() {
        return (Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)x$4.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Either<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Left) {
                    Left left = (Left)A1;
                    String id = (String)left.value();
                    object = id;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Either<String, String> x1) {
                Either<String, String> either = x1;
                boolean bl = either instanceof Left;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private static final Function1 getRoleIdsFromGroup$1() {
        return (Function1 & Serializable & scala.Serializable)x$5 -> ((TraversableOnce)x$5.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Either<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Right) {
                    Right right = (Right)A1;
                    String id = (String)right.value();
                    object = id;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Either<String, String> x1) {
                Either<String, String> either = x1;
                boolean bl = either instanceof Right;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private final Seq doSearch$1(Seq principals, Seq roleIds, TasksFilters tasksFilters$2, int limit$2) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append(tasksFilters$2).append(": Searching with ").append(principals.length()).append(" principals and ").append(roleIds.length()).append(" roles").toString());
        Tuple2<String, Seq<Object>> tasksQuery = ((TasksUnionSqlBuilder)SqlTasksFilterSupport$.MODULE$.sqlBuilderByFilters(tasksFilters$2, (Iterable<String>)principals, (Iterable<String>)roleIds, this.permissionEnforcer(), this.sqlDialect()).limit(limit$2)).build();
        return this.taskPersistence.findTaskIdsByQuery(tasksQuery);
    }

    private static final Iterable getPrincipals$1() {
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)value -> package$.MODULE$.Left().apply(value), Iterable$.MODULE$.canBuildFrom());
    }

    private final Buffer getRoleIds$1() {
        return (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getId(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)value -> package$.MODULE$.Right().apply(value), Buffer$.MODULE$.canBuildFrom());
    }

    public SqlTaskSearchService(RoleService roleService, TaskAccessService taskAccessService, TasksViewConverter tasksViewConverter, InternalMetadataDecoratorService decoratorService, ReleasePersistence releasePersistence, TaskPersistence taskPersistence, SqlRepositoryAdapter repositoryAdapter, PermissionEnforcer permissionEnforcer, SqlBuilder.Dialect sqlDialect) {
        this.roleService = roleService;
        this.taskAccessService = taskAccessService;
        this.tasksViewConverter = tasksViewConverter;
        this.decoratorService = decoratorService;
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.sqlDialect = sqlDialect;
        Logging.$init$((Logging)this);
        this.MAX_NUMBER_OF_JOINS = 5;
    }
}

