/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlplatform.security.sql.SqlRoleService;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.PlatformSecurityMappingSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.security.SecuredCi;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005s!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003E\u0011!i\u0005A!b\u0001\n\u0003q\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u000bM\u0003A\u0011\u0001+\t\u000be\u0003A\u0011\t.\t\u000bm\u0004A\u0011\t?\t\r}\u0004A\u0011IA\u0001\u0011\u0019y\b\u0001\"\u0011\u0002\u0018!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA\u001d\u0001\u0011\u0005\u00131\b\u0005\b\u0003s\u0001A\u0011IA!\u0011\u001d\tI\u0005\u0001C!\u0003\u0017Bq!!\u0013\u0001\t\u0013\t)\u0006C\u0004\u0002n\u0001!I!a\u001c\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"9\u0011Q\u0013\u0001\u0005\n\u0005]%!E*rYR+\u0017-\u001c*fa>\u001c\u0018\u000e^8ss*\u0011acF\u0001\u0004gFd'B\u0001\r\u001a\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u00035m\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005qi\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005q\u0012aA2p[\u000e\u00011#\u0002\u0001\"O-z\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)S5\tq#\u0003\u0002+/\tqA+Z1n%\u0016\u0004xn]5u_JL\bC\u0001\u0017.\u001b\u0005)\u0012B\u0001\u0018\u0016\u0005y\u0001F.\u0019;g_Jl7+Z2ve&$\u00180T1qa&twmU;qa>\u0014H\u000f\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005)1\u000f\u001c45U*\tA'\u0001\u0005he&T(\u0010\\3e\u0013\t1\u0014GA\u0004M_\u001e<\u0017N\\4\u0002!A,'/\\5tg&|g.\u00123ji>\u0014X#A\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005yZ\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005\u0001[$\u0001\u0005)fe6L7o]5p]\u0016#\u0017\u000e^8s\u0003E\u0001XM]7jgNLwN\\#eSR|'\u000fI\u0001\fe>dWmU3sm&\u001cW-F\u0001E!\t)%*D\u0001G\u0015\t1rI\u0003\u0002=\u0011*\u0011\u0011jG\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017BA&G\u00059\u0019\u0016\u000f\u001c*pY\u0016\u001cVM\u001d<jG\u0016\fAB]8mKN+'O^5dK\u0002\n!b]3dkJ,GmQ5t+\u0005y\u0005C\u0001\u0015Q\u0013\t\tvC\u0001\u0006TK\u000e,(/\u001a3DSN\f1b]3dkJ,GmQ5tA\u00051A(\u001b8jiz\"B!\u0016,X1B\u0011A\u0006\u0001\u0005\u0006o\u001d\u0001\r!\u000f\u0005\u0006\u0005\u001e\u0001\r\u0001\u0012\u0005\u0006\u001b\u001e\u0001\raT\u0001\u0007GJ,\u0017\r^3\u0015\u0007m\u000bg\u000e\u0005\u0002]?6\tQL\u0003\u0002_3\u00051Am\\7bS:L!\u0001Y/\u0003\tQ+\u0017-\u001c\u0005\u0006E\"\u0001\raY\u0001\fG>tG/Y5oKJLE\r\u0005\u0002eW:\u0011Q-\u001b\t\u0003M\u000ej\u0011a\u001a\u0006\u0003Q~\ta\u0001\u0010:p_Rt\u0014B\u00016$\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)\u001c\u0003\"B8\t\u0001\u0004Y\u0016\u0001\u0002;fC6D#\u0001C9\u0011\u0005ILX\"A:\u000b\u0005Q,\u0018AC1o]>$\u0018\r^5p]*\u0011ao^\u0001\b[\u0016$(/[2t\u0015\tAX$\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\tQ8OA\u0003US6,G-\u0001\u0004va\u0012\fG/\u001a\u000b\u00037vDQa\\\u0005A\u0002mC#!C9\u0002\u0011\u001d,G\u000fV3b[N$B!a\u0001\u0002\u0014A)\u0011QAA\b76\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003vi&d'BAA\u0007\u0003\u0011Q\u0017M^1\n\t\u0005E\u0011q\u0001\u0002\u0005\u0019&\u001cH\u000fC\u0003c\u0015\u0001\u00071\r\u000b\u0002\u000bcR!\u00111AA\r\u0011\u001d\tYb\u0003a\u0001\u0003;\t!aY5\u0011\t\u0005}\u00111E\u0007\u0003\u0003CQ!\u0001P\r\n\t\u0005\u0015\u0012\u0011\u0005\u0002\n'\u0016\u001cWO]3e\u0007&D#aC9\u0002\r\u0011,G.\u001a;f)\u0011\ti#a\r\u0011\u0007\t\ny#C\u0002\u00022\r\u0012A!\u00168ji\"1\u0011Q\u0007\u0007A\u0002\r\fa\u0001^3b[&#\u0007F\u0001\u0007r\u0003]!W\r\\3uKR+\u0017-\\:Ge>l\u0007\u000b\\1uM>\u0014X\u000e\u0006\u0003\u0002.\u0005u\u0002\"\u00022\u000e\u0001\u0004\u0019\u0007FA\u0007r)\u0011\ti#a\u0011\t\u000f\u0005\u0015c\u00021\u0001\u0002\u001e\u0005I1m\u001c8uC&tWM\u001d\u0015\u0003\u001dE\f1c]1wKR+\u0017-\\:U_Bc\u0017\r\u001e4pe6$b!a\u0001\u0002N\u0005=\u0003\"\u00022\u0010\u0001\u0004\u0019\u0007bBA)\u001f\u0001\u0007\u00111A\u0001\u0006i\u0016\fWn\u001d\u0015\u0003\u001fE$b!a\u0016\u0002j\u0005-\u0004#BA-\u0003GZf\u0002BA.\u0003?r1AZA/\u0013\u0005!\u0013bAA1G\u00059\u0001/Y2lC\u001e,\u0017\u0002BA3\u0003O\u00121aU3r\u0015\r\t\tg\t\u0005\u0006EB\u0001\ra\u0019\u0005\b\u0003#\u0002\u0002\u0019AA,\u0003E)\b\u000fZ1uKB+'/\\5tg&|gn\u001d\u000b\u0007\u0003[\t\t(!\u001e\t\r\u0005M\u0014\u00031\u0001d\u0003-\u0019XmY;sSRLX+\u001b3\t\u000f\u0005]\u0014\u00031\u0001\u0002z\u0005!\"o\u001c7fg^KG\u000f\u001b)fe6L7o]5p]N\u0004RAIA>\u0003\u007fJ1!! $\u0005)a$/\u001a9fCR,GM\u0010\t\bE\u0005\u0005\u0015QQAF\u0013\r\t\u0019i\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007i\n9)C\u0002\u0002\nn\u0012AAU8mKB)\u0011QAA\bG\u0006)R\u000f\u001d3bi\u0016Le\u000e[3sSR\fgnY3GY\u0006<GCBA\u0017\u0003#\u000b\u0019\nC\u0003c%\u0001\u00071\rC\u0004\u0002RI\u0001\r!a\u0016\u0002%I,Wn\u001c<f\u001b&\u001c8/\u001b8h%>dWm\u001d\u000b\u0005\u0003[\tI\nC\u0004\u0002RM\u0001\r!a'\u0011\t\t\nYh\u0017")
public class SqlTeamRepository
implements TeamRepository,
PlatformSecurityMappingSupport,
Logging {
    private final PermissionEditor permissionEditor;
    private final SqlRoleService roleService;
    private final SecuredCis securedCis;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Team fromPlatformRole(String containerId, Role role, Seq<Permission> permissions) {
        return PlatformSecurityMappingSupport.fromPlatformRole$(this, containerId, role, permissions);
    }

    @Override
    public Role toPlatformRole(Team team) {
        return PlatformSecurityMappingSupport.toPlatformRole$(this, team);
    }

    @Override
    public String toPlatformId(String id) {
        return PlatformSecurityMappingSupport.toPlatformId$(this, id);
    }

    @Override
    public String fromPlatformId(String containerId, String id) {
        return PlatformSecurityMappingSupport.fromPlatformId$(this, containerId, id);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTeamRepository sqlTeamRepository = this;
        synchronized (sqlTeamRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public PermissionEditor permissionEditor() {
        return this.permissionEditor;
    }

    public SqlRoleService roleService() {
        return this.roleService;
    }

    public SecuredCis securedCis() {
        return this.securedCis;
    }

    @Timed
    public Team create(String containerId, Team team) {
        this.removeMissingRoles((Seq<Team>)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{team}));
        Role role = this.toPlatformRole(team);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        this.roleService().create(securityUid, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Role[]{role}));
        this.updatePermissions(securityUid, (Seq<Tuple2<Role, java.util.List<String>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)role), (Object)team.getPermissions())}));
        this.updateInheritanceFlag(containerId, (Seq<Team>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{team}))));
        return team;
    }

    @Timed
    public Team update(Team team) {
        String containerId = Ids.getParentId((String)team.getId());
        this.removeMissingRoles((Seq<Team>)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{team}));
        Role role = this.toPlatformRole(team);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        this.roleService().update((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Role[]{role}));
        this.updatePermissions(securityUid, (Seq<Tuple2<Role, java.util.List<String>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)role), (Object)team.getPermissions())}));
        return team;
    }

    @Timed
    public java.util.List<Team> getTeams(String containerId) {
        return this.getTeams(this.securedCis().getSecuredCi(containerId));
    }

    @Timed
    public java.util.List<Team> getTeams(SecuredCi ci) {
        Seq seq;
        List roles = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().readRoleAssignments(ci.getSecurityUid())).asScala()).toList();
        List list = roles;
        if (Nil$.MODULE$.equals(list)) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            Map permissionsByRole = this.permissionEditor().readPermissions(ci.getSecurityUid());
            seq = (Seq)roles.map((Function1 & Serializable & scala.Serializable)role -> this.fromPlatformRole(ci.getId(), (Role)role, (Seq<Permission>)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter((java.util.Set)permissionsByRole.getOrDefault(role, new HashSet())).asScala()).toSeq()), List$.MODULE$.canBuildFrom());
        }
        return package$.MODULE$.ListExtensions(seq).asJavaMutable();
    }

    @Timed
    public void delete(String teamId) {
        this.roleService().delete((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.toPlatformId(teamId)}));
        String containerId = Ids.getParentId((String)teamId);
        this.updateInheritanceFlag(containerId, (Seq<Team>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.getTeams(containerId)).asScala()));
    }

    @Timed
    public void deleteTeamsFromPlatform(String containerId) {
        this.deleteTeamsFromPlatform(this.securedCis().getSecuredCi(containerId));
    }

    @Timed
    public void deleteTeamsFromPlatform(SecuredCi container) {
        block0: {
            Buffer roles = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRoles(container.getSecurityUid())).asScala();
            this.roleService().delete((Seq)roles.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Buffer$.MODULE$.canBuildFrom()));
            if (!Ids.isFolderId((String)container.getId())) break block0;
            this.securedCis().setAsEffectiveSecuredCi(container.getId(), false);
        }
    }

    @Timed
    public java.util.List<Team> saveTeamsToPlatform(String containerId, java.util.List<Team> teams) {
        return package$.MODULE$.ListExtensions(this.saveTeamsToPlatform(containerId, (Seq<Team>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(teams).asScala()))).asJavaMutable();
    }

    private Seq<Team> saveTeamsToPlatform(String containerId, Seq<Team> teams) {
        this.removeMissingRoles(teams);
        String securityUid = this.securedCis().getSecuredCi(containerId).getSecurityUid();
        Seq roles = (Seq)teams.map((Function1 & Serializable & scala.Serializable)team -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.toPlatformRole((Team)team)), (Object)team.getPermissions()), Seq$.MODULE$.canBuildFrom());
        this.roleService().writeRoleAssignments(securityUid, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)roles.map((Function1 & Serializable & scala.Serializable)x$2 -> (Role)x$2._1(), Seq$.MODULE$.canBuildFrom())).asJava());
        this.updatePermissions(securityUid, (Seq<Tuple2<Role, java.util.List<String>>>)roles);
        this.updateInheritanceFlag(containerId, teams);
        return teams;
    }

    private void updatePermissions(String securityUid, Seq<Tuple2<Role, java.util.List<String>>> rolesWithPermissions) {
        Map permissions = this.permissionEditor().readPermissions(securityUid);
        rolesWithPermissions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Role role = (Role)tuple2._1();
            java.util.List rolePermissions = (java.util.List)tuple2._2();
            java.util.Set set = (java.util.Set)permissions.put(role, JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rolePermissions).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> Permission.find((String)x$1), Buffer$.MODULE$.canBuildFrom())).toSet()).asJava());
            return set;
        });
        this.permissionEditor().editPermissions(securityUid, permissions);
    }

    private void updateInheritanceFlag(String containerId, Seq<Team> teams) {
        this.securedCis().setAsEffectiveSecuredCi(containerId, teams.nonEmpty());
    }

    private void removeMissingRoles(Seq<Team> teams) {
        Buffer availableRoles = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRoles()).asScala();
        teams.foreach((Function1 & Serializable & scala.Serializable)team -> {
            Object object;
            Buffer nonExistingRoles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(team.getRoles()).asScala()).filter((Function1 & Serializable & scala.Serializable)roleName -> BoxesRunTime.boxToBoolean((boolean)SqlTeamRepository.$anonfun$removeMissingRoles$2(availableRoles, roleName)));
            if (nonExistingRoles.nonEmpty()) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("The following role(s) do not exist: ").append(nonExistingRoles).append(". They were removed from the team ").append(team.getTeamName()).append(" [").append(team.getId()).append("].").toString());
                object = BoxesRunTime.boxToBoolean((boolean)team.getRoles().removeAll((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(nonExistingRoles).asJava()));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public static final /* synthetic */ boolean $anonfun$removeMissingRoles$3(String roleName$1, Role x$3) {
        String string = x$3.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removeMissingRoles$2(Buffer availableRoles$1, String roleName) {
        return !availableRoles$1.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlTeamRepository.$anonfun$removeMissingRoles$3(roleName, x$3)));
    }

    public SqlTeamRepository(PermissionEditor permissionEditor, SqlRoleService roleService, SecuredCis securedCis) {
        this.permissionEditor = permissionEditor;
        this.roleService = roleService;
        this.securedCis = securedCis;
        PlatformSecurityMappingSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

