/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.SqlStorageFacade$;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.TestCleanupException;
import com.xebialabs.xlrelease.actors.utils.ScalaSpringSupport;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.LiquibaseSupport;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeUpgrade;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import liquibase.Liquibase;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Profile(value={"integrationTest"})
@ScalaSignature(bytes="\u0006\u0001\r5b\u0001\u0002\u001c8\u0001yB\u0001B\u001c\u0001\u0003\u0002\u0003\u0006Ia\u001c\u0005\tk\u0002\u0011\t\u0011)A\u0005m\"Aa\u0010\u0001B\u0001B\u0003%q\u0010\u0003\u0006\u0002\b\u0001\u0011\t\u0011)A\u0005\u0003\u0013A!\"a\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\t\u0011)\ti\u0002\u0001B\u0001B\u0003%\u0011q\u0004\u0005\u000b\u0003K\u0001!\u0011!Q\u0001\n\u0005\u001d\u0002BCA\u0017\u0001\t\u0005\t\u0015!\u0003\u00020!Q\u0011Q\u0007\u0001\u0003\u0002\u0003\u0006I!a\u000e\t\u0015\u0005u\u0002A!A!\u0002\u0013\ty\u0004\u0003\u0006\u0002F\u0001\u0011\t\u0011)A\u0005\u0003\u000fB!\"a\u001d\u0001\u0005\u0003\u0005\u000b\u0011BA$\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!a)\u0001\t\u0003\n)\u000b\u0003\u0004Q\u0001\u0011\u0005\u0013Q\u0018\u0005\b\u0003\u0017\u0004A\u0011IAg\u0011\u001d\ti\u000e\u0001C!\u0003{Cq!a8\u0001\t\u0003\n\t\u000fC\u0004\u0003\u0004\u0001!IA!\u0002\t\u000f\t\u001d\u0001\u0001\"\u0003\u0003\u0006!9!\u0011\u0002\u0001\u0005\n\t-\u0001b\u0002B\n\u0001\u0011%!1\u0002\u0005\u000b\u0005+\u0001\u0001R1A\u0005\u0002\t]\u0001\"\u0003B\u0014\u0001\t\u0007I\u0011\u0002B\u0015\u0011!\u0011y\u0003\u0001Q\u0001\n\t-\u0002b\u0002B\u0019\u0001\u0011\u0005!1\u0007\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0011\u001d\u0011)\u0005\u0001C!\u0003{CqAa\u0012\u0001\t\u0003\ni\fC\u0004\u0003J\u0001!\tEa\u0013\t\u000f\tE\u0003\u0001\"\u0005\u0003T!9!\u0011\n\u0001\u0005B\t]\u0003b\u0002B5\u0001\u0011\u0005#1\u000e\u0005\b\u0005o\u0002A\u0011IA_\u0011\u001d\u0011I\b\u0001C\u0005\u0005wBqA! \u0001\t\u0013\u0011y\bC\u0004\u0003,\u0002!IAa\u001f\t\u000f\t5\u0006\u0001\"\u0003\u0003|!9!q\u0016\u0001\u0005\n\tE\u0006b\u0002B[\u0001\u0011%!q\u0017\u0005\b\u0005s\u0003A\u0011\u0002B\\\u0011\u001d\u0011Y\f\u0001C\u0005\u0005oCqA!0\u0001\t\u0013\u0011Y\bC\u0004\u0003@\u0002!\t!!0\t\u0017\t5\u0007\u00011AA\u0002\u0013\u0005!q\u001a\u0005\f\u0005/\u0004\u0001\u0019!a\u0001\n\u0003\u0011I\u000eC\u0006\u0003`\u0002\u0001\r\u0011!Q!\n\tE\u0007b\u0002Bw\u0001\u0011\u0005!q\u001e\u0005\b\u0005c\u0004A\u0011\u0001Bz\u000f\u001d\u00199b\u000eE\u0001\u000731aAN\u001c\t\u0002\rm\u0001bBA=g\u0011\u000511\u0005\u0005\b\u0005S\u001aD\u0011AB\u0013\u0005A\u0019\u0016\u000f\\*u_J\fw-\u001a$bG\u0006$WM\u0003\u00029s\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003um\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003q\n1aY8n\u0007\u0001\u0019\u0002\u0002A H\u0017N3F\f\u001a\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000bA\u0001\\1oO*\tA)\u0001\u0003kCZ\f\u0017B\u0001$B\u0005\u0019y%M[3diB\u0011\u0001*S\u0007\u0002o%\u0011!j\u000e\u0002\u000e'R|'/Y4f\r\u0006\u001c\u0017\rZ3\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015!\u00037jcVL'-Y:f\u0015\t\u0001v'A\u0004va\u001e\u0014\u0018\rZ3\n\u0005Ik%!\u0004\"fM>\u0014X-\u00169he\u0006$W\r\u0005\u0002I)&\u0011Qk\u000e\u0002\u0013)\u0016\u001cH/Q;uQ\u0016tG/[2bi&|g\u000e\u0005\u0002X56\t\u0001L\u0003\u0002Zo\u0005\u0011AMY\u0005\u00037b\u0013\u0001\u0003T5rk&\u0014\u0017m]3TkB\u0004xN\u001d;\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017!B;uS2\u001c(BA18\u0003\u0019\t7\r^8sg&\u00111M\u0018\u0002\u0013'\u000e\fG.Y*qe&twmU;qa>\u0014H\u000f\u0005\u0002fY6\taM\u0003\u0002hQ\u000691m\u001c8uKb$(BA5k\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A6\u0002\u0007=\u0014x-\u0003\u0002nM\n9\u0012\t\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u\u0003^\f'/Z\u0001\u000eM>dG-\u001a:TKJ4\u0018nY3\u0011\u0005A\u001cX\"A9\u000b\u0005I<\u0014aB:feZL7-Z\u0005\u0003iF\u0014QBR8mI\u0016\u00148+\u001a:wS\u000e,\u0017A\u0004;fC6\u0014V\r]8tSR|'/\u001f\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\f1a]9m\u0015\tYx'\u0001\u0006sKB|7/\u001b;pefL!! =\u0003#M\u000bH\u000eV3b[J+\u0007o\\:ji>\u0014\u00180A\tsK2,\u0017m]3SKB|7/\u001b;pef\u0004B!!\u0001\u0002\u00045\t!0C\u0002\u0002\u0006i\u0014\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0003Q\u0011X\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dKB\u0019\u0001/a\u0003\n\u0007\u00055\u0011O\u0001\u000bSK2,\u0017m]3TK\u0006\u00148\r[*feZL7-Z\u0001\u0016I\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2f!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\fq\u0006Y\u0001/\u001a:tSN$XM\\2f\u0013\u0011\tY\"!\u0006\u0003+\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dK\u000692m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0005\u0003\u0003\t\t#C\u0002\u0002$i\u0014qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0002/\r\fG.\u001a8eCJ,e\u000e\u001e:z%\u0016\u0004xn]5u_JL\b\u0003BA\u0001\u0003SI1!a\u000b{\u0005]\u0019\u0015\r\\3oI\u0006\u0014XI\u001c;ssJ+\u0007o\\:ji>\u0014\u00180\u0001\tbe\u000eD\u0017N^5oON+'O^5dKB\u0019\u0001/!\r\n\u0007\u0005M\u0012O\u0001\tBe\u000eD\u0017N^5oON+'O^5dK\u0006\tBO]5hO\u0016\u0014(+\u001a9pg&$xN]=\u0011\t\u0005\u0005\u0011\u0011H\u0005\u0004\u0003wQ(!\u0005+sS\u001e<WM\u001d*fa>\u001c\u0018\u000e^8ss\u0006yA/Y:l!\u0016\u00148/[:uK:\u001cW\r\u0005\u0003\u0002\u0014\u0005\u0005\u0013\u0002BA\"\u0003+\u0011q\u0002V1tWB+'o]5ti\u0016t7-Z\u0001\rU\u0012\u00147\rV3na2\fG/\u001a\t\u0005\u0003\u0013\n\u0019&\u0004\u0002\u0002L)!\u0011QJA(\u0003\u0011\u0019wN]3\u000b\u0007\u0005E\u0003.\u0001\u0003kI\n\u001c\u0017\u0002BA+\u0003\u0017\u0012AB\u00133cGR+W\u000e\u001d7bi\u0016DsaCA-\u0003[\ny\u0007\u0005\u0003\u0002\\\u0005%TBAA/\u0015\u0011\ty&!\u0019\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002d\u0005\u0015\u0014a\u00024bGR|'/\u001f\u0006\u0004\u0003OB\u0017!\u00022fC:\u001c\u0018\u0002BA6\u0003;\u0012\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0005\u0005E\u0014!\u0007=meJ+\u0007o\\:ji>\u0014\u0018P\u00133cGR+W\u000e\u001d7bi\u0016\fQC]3q_J$\u0018N\\4KI\n\u001cG+Z7qY\u0006$X\rK\u0004\r\u00033\ni'a\u001e\"\u0005\u0005M\u0014A\u0002\u001fj]&$h\b\u0006\u000e\u0002~\u0005}\u0014\u0011QAB\u0003\u000b\u000b9)!#\u0002\f\u00065\u0015qRAI\u0003'\u000b9\n\u0005\u0002I\u0001!)a.\u0004a\u0001_\")Q/\u0004a\u0001m\")a0\u0004a\u0001\u007f\"9\u0011qA\u0007A\u0002\u0005%\u0001bBA\b\u001b\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003;i\u0001\u0019AA\u0010\u0011\u001d\t)#\u0004a\u0001\u0003OAq!!\f\u000e\u0001\u0004\ty\u0003C\u0004\u000265\u0001\r!a\u000e\t\u000f\u0005uR\u00021\u0001\u0002@!9\u0011QI\u0007A\u0002\u0005\u001d\u0003\u0006CAJ\u00033\ni'a\u001c\t\u000f\u0005MT\u00021\u0001\u0002H!B\u0011qSA-\u0003[\n9\bK\u0002\u000e\u0003;\u0003B!a\u0017\u0002 &!\u0011\u0011UA/\u0005%\tU\u000f^8xSJ,G-\u0001\tyYJ+G.Z1tKZ+'o]5p]R\u0011\u0011q\u0015\t\u0005\u0003S\u000bI,\u0004\u0002\u0002,*\u0019\u0001+!,\u000b\t\u0005=\u0016\u0011W\u0001\u0004CBL'\u0002BAZ\u0003k\u000baa]3sm\u0016\u0014(bAA\\s\u0005AA-\u001a9m_fLG/\u0003\u0003\u0002<\u0006-&a\u0002,feNLwN\u001c\u000b\u0003\u0003\u007f\u0003B!!1\u0002H6\u0011\u00111\u0019\u0006\u0003\u0003\u000b\fQa]2bY\u0006LA!!3\u0002D\n!QK\\5u\u0003a\u0011X\r]8tSR|'/\u001f,feNLwN\\*feZL7-Z\u000b\u0003\u0003\u001f\u0004B!!5\u0002Z6\u0011\u00111\u001b\u0006\u0004!\u0006U'bAAls\u0005Q\u0001\u0010\u001c9mCR4wN]7\n\t\u0005m\u00171\u001b\u0002\u0019%\u0016\u0004xn]5u_JLh+\u001a:tS>t7+\u001a:wS\u000e,\u0017!\u00033p+B<'/\u00193f\u0003M\u0019w.\u001e8u%\u0016\u001cwN\u001d3t\u0013:$\u0016M\u00197f)\u0011\t\u0019/!;\u0011\t\u0005\u0005\u0017Q]\u0005\u0005\u0003O\f\u0019M\u0001\u0003M_:<\u0007bBAv%\u0001\u0007\u0011Q^\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004B!a<\u0002~:!\u0011\u0011_A}!\u0011\t\u00190a1\u000e\u0005\u0005U(bAA|{\u00051AH]8pizJA!a?\u0002D\u00061\u0001K]3eK\u001aLA!a@\u0003\u0002\t11\u000b\u001e:j]\u001eTA!a?\u0002D\u00061r/\u001b9f\u001fV$\u0018I]2iSZ,G)\u0019;bE\u0006\u001cX-\u0006\u0002\u0002@\u0006yq/\u001b9f\u001fV$H)\u0019;bE\u0006\u001cX-\u0001\njg\u0012\u00137\t\\3b]V\u0004XI\\1cY\u0016$WC\u0001B\u0007!\u0011\t\tMa\u0004\n\t\tE\u00111\u0019\u0002\b\u0005>|G.Z1o\u0003yI7/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e)s_\u001aLG.Z!di&4X-\u0001\u0006eCR\f7k\\;sG\u0016,\"A!\u0007\u0011\t\tm!1E\u0007\u0003\u0005;Q1!\u001fB\u0010\u0015\t\u0011\t#A\u0003kCZ\f\u00070\u0003\u0003\u0003&\tu!A\u0003#bi\u0006\u001cv.\u001e:dK\u0006\u0011a\nT\u000b\u0003\u0005W\u00012\u0001\u0011B\u0017\u0013\r\ty0Q\u0001\u0004\u001d2\u0003\u0013a\u0003;bE2,W\t_5tiN$BA!\u000e\u0003:Q!!Q\u0002B\u001c\u0011\u001d\t)E\u0007a\u0002\u0003\u000fBq!a;\u001b\u0001\u0004\ti/\u0001\neK2,G/\u001a+bE2,7i\u001c8uK:$H\u0003\u0002B \u0005\u0007\"B!a0\u0003B!9\u0011QI\u000eA\u0004\u0005\u001d\u0003bBAv7\u0001\u0007\u0011Q^\u0001\u001aI\u0016dW\r^3QKJl\u0017n]:j_:\u001cf.\u00199tQ>$8/A\u0004dY\u0016\fg.\u001e9\u0002\r\u0011,G.\u001a;f)\u0011\u0011iA!\u0014\t\u000f\t=c\u00041\u0001\u0002n\u0006\u0011\u0011\u000eZ\u0001\u000eI\u0016dW\r^3SK2,\u0017m]3\u0015\t\u0005}&Q\u000b\u0005\b\u0005\u001fz\u0002\u0019AAw)\u0011\u0011iA!\u0017\t\u000f\tm\u0003\u00051\u0001\u0003^\u0005!A/Z1n!\u0011\u0011yF!\u001a\u000e\u0005\t\u0005$b\u0001B2o\u00051Am\\7bS:LAAa\u001a\u0003b\t!A+Z1n\u0003E!W\r\\3uK\u001a\u0013x.\\!sG\"Lg/\u001a\u000b\u0005\u0005[\u0012\u0019\b\u0005\u0003\u0002B\n=\u0014\u0002\u0002B9\u0003\u0007\u00141!\u00138u\u0011\u001d\u0011)(\ta\u0001\u0003[\f\u0011B]3mK\u0006\u001cX-\u00133\u0002+Y,'/\u001b4z%\u0016\u0004xn]5u_JL8\t\\3b]\u0006a1m\\;oi\u001a{G\u000eZ3sgR\u0011!QN\u0001\u001bi\u0016\u001cH\u000fR5e\u001d>$8\t\\3b]\u00063G/\u001a:JiN,GN\u001a\u000b\t\u0005\u0003\u00139Ia#\u0003(B\u0019\u0001Ja!\n\u0007\t\u0015uG\u0001\u000bUKN$8\t\\3b]V\u0004X\t_2faRLwN\u001c\u0005\b\u0005\u0013#\u0003\u0019AAw\u0003!!Xm\u001d;OC6,\u0007b\u0002BGI\u0001\u0007!qR\u0001\u0007C\u000e$\u0018N^3\u0011\r\tE%1\u0014BQ\u001d\u0011\u0011\u0019Ja&\u000f\t\u0005M(QS\u0005\u0003\u0003\u000bLAA!'\u0002D\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002BO\u0005?\u00131aU3r\u0015\u0011\u0011I*a1\u0011\u0011\u0005\u0005'1UAw\u0003[LAA!*\u0002D\n1A+\u001e9mKJBqA!+%\u0001\u0004\u0011y)\u0001\u0005be\u000eD\u0017N^3e\u00035\u0019w.\u001e8u%\u0016dW-Y:fg\u0006i1m\\;oiR\u0013\u0018nZ4feN\f1dZ3u%\u0016l\u0017-\u001b8j]\u001e$&/[4hKJ\u001cH)\u001a;bS2\u001cHC\u0001BZ!\u0019\u0011\tJa'\u0002n\u0006Ir-\u001a;SK6\f\u0017N\\5oO\u001a{G\u000eZ3s\t\u0016$\u0018-\u001b7t)\t\u0011y)A\u000ehKR\u0014V-\\1j]&twMU3mK\u0006\u001cXm\u001d#fi\u0006LGn]\u0001$O\u0016$(+Z7bS:LgnZ!sG\"Lg/\u001a3SK2,\u0017m]3t\t\u0016$\u0018-\u001b7t\u0003U\u0019w.\u001e8u\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKN\f\u0011b\u00197fC:DF\u000e\u00122)\u00071\u0012\u0019\r\u0005\u0003\u0003F\n%WB\u0001Bd\u0015\u0011\tyFa\b\n\t\t-'q\u0019\u0002\u000b!J,G)Z:ue>L\u0018AE1qa2L7-\u0019;j_:\u001cuN\u001c;fqR,\"A!5\u0011\u0007\u0015\u0014\u0019.C\u0002\u0003V\u001a\u0014!#\u00119qY&\u001c\u0017\r^5p]\u000e{g\u000e^3yi\u00061\u0012\r\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u?\u0012*\u0017\u000f\u0006\u0003\u0002@\nm\u0007\"\u0003Bo]\u0005\u0005\t\u0019\u0001Bi\u0003\rAH%M\u0001\u0014CB\u0004H.[2bi&|gnQ8oi\u0016DH\u000f\t\u0015\u0004_\t\r\b\u0003\u0002Bs\u0005Sl!Aa:\u000b\t\u0005\u001d\u00141Y\u0005\u0005\u0005W\u00149O\u0001\u0007CK\u0006t\u0007K]8qKJ$\u00180A\u000bhKR\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0015\u0005\tE\u0017!F:fi\u0006\u0003\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010\u001e\u000b\u0005\u0003\u007f\u0013)\u0010C\u0005\u0003^F\n\t\u00111\u0001\u0003R\":\u0001A!?\u0002n\r\r\u0001\u0003\u0002B~\u0005\u007fl!A!@\u000b\u0007\u0005}c-\u0003\u0003\u0004\u0002\tu(a\u0002)s_\u001aLG.\u001a\u0017\u0003\u0007\u000b\t#aa\u0002\u0002\u001f%tG/Z4sCRLwN\u001c+fgRD3\u0001AB\u0006!\u0011\u0019iaa\u0005\u000e\u0005\r=!bAB\tQ\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\rU1q\u0002\u0002\n\u0007>l\u0007o\u001c8f]R\f\u0001cU9m'R|'/Y4f\r\u0006\u001c\u0017\rZ3\u0011\u0005!\u001b4cA\u001a\u0004\u001eA!\u0011\u0011YB\u0010\u0013\u0011\u0019\t#a1\u0003\r\u0005s\u0017PU3g)\t\u0019I\u0002\u0006\u0003\u0004(\r-B\u0003\u0002B7\u0007SAq!!\u00126\u0001\u0004\t9\u0005C\u0004\u0003vU\u0002\r!!<")
public class SqlStorageFacade
implements StorageFacade,
BeforeUpgrade,
TestAuthentication,
LiquibaseSupport,
ScalaSpringSupport,
ApplicationContextAware {
    private DataSource dataSource;
    private final FolderService folderService;
    private final SqlTeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    private final TriggerRepository triggerRepository;
    private final TaskPersistence taskPersistence;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;
    @Qualifier(value="reportingJdbcTemplate")
    private final JdbcTemplate reportingJdbcTemplate;
    private final String NL;
    private ApplicationContext applicationContext;
    private volatile boolean bitmap$0;

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
        return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
    }

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    public Version xlReleaseVersion() {
        return Version.valueOf((String)"xl-release", (String)"0.0.0");
    }

    public void upgrade() {
        this.doUpgrade();
    }

    public RepositoryVersionService repositoryVersionService() {
        return null;
    }

    public void doUpgrade() {
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    @Override
    public long countRecordsInTable(String tableName) {
        return BoxesRunTime.unboxToLong((Object)this.jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE));
    }

    private void wipeOutArchiveDatabase() {
        DataSource reportingDataSource = (DataSource)this.springBean("reportingDataSource", ClassTag$.MODULE$.apply(DataSource.class));
        LiquibaseSupport reporting = new LiquibaseSupport(null, reportingDataSource){
            private final DataSource reportingDataSource$1;

            public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
                return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
            }

            public DataSource dataSource() {
                return this.reportingDataSource$1;
            }
            {
                this.reportingDataSource$1 = reportingDataSource$1;
                LiquibaseSupport.$init$((LiquibaseSupport)this);
            }
        };
        reporting.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable & scala.Serializable)liquibase -> {
            SqlStorageFacade.$anonfun$wipeOutArchiveDatabase$1(this, liquibase);
            return BoxedUnit.UNIT;
        });
    }

    private void wipeOutDatabase() {
        block0: {
            if (!this.isDbCleanupEnabled() || !this.isIntegrationTestProfileActive()) break block0;
            this.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable & scala.Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
        }
    }

    private boolean isDbCleanupEnabled() {
        return !System.getProperties().contains("nodbcleanup");
    }

    private boolean isIntegrationTestProfileActive() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.applicationContext().getEnvironment().getActiveProfiles())).contains((Object)"integrationTest");
    }

    private DataSource dataSource$lzycompute() {
        SqlStorageFacade sqlStorageFacade = this;
        synchronized (sqlStorageFacade) {
            if (!this.bitmap$0) {
                this.dataSource = (DataSource)this.springBean("xlrRepositoryDataSource", ClassTag$.MODULE$.Nothing());
                this.bitmap$0 = true;
            }
        }
        return this.dataSource;
    }

    public DataSource dataSource() {
        return !this.bitmap$0 ? this.dataSource$lzycompute() : this.dataSource;
    }

    private String NL() {
        return this.NL;
    }

    public boolean tableExists(String tableName, JdbcTemplate jdbcTemplate) {
        boolean bl;
        try {
            jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void deleteTableContent(String tableName, JdbcTemplate jdbcTemplate) {
        block0: {
            if (!this.tableExists(tableName, jdbcTemplate)) break block0;
            this.logger().info(new StringBuilder(9).append("DELETING ").append(tableName).toString());
            jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(tableName).toString());
        }
    }

    @Override
    public void deletePermissionSnapshots() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.PERMISSION_SNAPSHOTS$.MODULE$.TABLE(), sqlJdbcTemplate);
    }

    @Override
    public void cleanup() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.DEPENDENCIES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASE_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.COMMENTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASKS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_ACTIVITY_LOGS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES_EXT$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISK_ASSESSMENTS", sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISKS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGER_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.ARTIFACTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deletePermissionSnapshots();
        if (this.tableExists(Schema.PATHS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(31).append("DELETE FROM ").append(Schema.PATHS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).append(" OR ").append(Schema.PATHS$.MODULE$.DESCENDANT_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        if (this.tableExists(Schema.FOLDERS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(15).append("UPDATE ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" SET ").append(Schema.FOLDERS$.MODULE$.SECURITY_UID()).append(" = ").append(FolderRow.Root$.MODULE$.uid()).toString());
            this.jdbcTemplate.execute(new StringBuilder(23).append("DELETE FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        this.deleteTableContent(MetadataSchema.METADATA$.MODULE$.TABLE(), sqlJdbcTemplate);
        if (this.tableExists(Schema.USER_PROFILE$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(30).append("DELETE FROM ").append(Schema.USER_PROFILE$.MODULE$.TABLE()).append(" WHERE ").append(Schema.USER_PROFILE$.MODULE$.USERNAME()).append(" <> 'admin'").toString());
        }
        JdbcTemplate sqlJdbcTemplate2 = this.reportingJdbcTemplate;
        this.deleteTableContent(Schema.Archive$.ITSM_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.DEPLOYMENT_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.CODE_COMPLIANCE_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_TASKS_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_PHASES_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), sqlJdbcTemplate2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean delete(String id) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.logger().trace(new StringBuilder(12).append("Deleting id ").append(id).toString());
            if (Ids.isReleaseId((String)id)) {
                this.deleteRelease(id);
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id, (Integer)$this.taskPersistence.taskUidById(Ids.getParentId((String)id)).get());
            } else if (!Ids.isPlanItemId((String)id)) {
                if (Ids.isFolderId((String)id)) {
                    if ($this.folderService.exists(id)) {
                        $this.folderService.delete(id);
                    }
                } else if (Ids.isCustomConfigurationId((String)id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isCalendarId((String)id)) {
                    $this.calendarEntryRepository.delete(id);
                } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn(new StringBuilder(63).append("Variable '").append(id).append("' will be deleted once the parent release is deleted.").toString());
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    if (Ids.isTriggerId((String)id)) {
                        $this.triggerRepository.delete(id);
                    } else if (Ids.isInRelease((String)id)) {
                        this.logger().warn(new StringBuilder(69).append("Id '").append(id).append("' will be deleted once the parent release or template is deleted.").toString());
                    } else {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                    }
                }
            }
            return true;
        });
        if (try_ instanceof Success) {
            this.logger().warn(new StringBuilder(8).append("Deleted ").append(id).toString());
            return true;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                this.logger().error(new StringBuilder(51).append("Unable to delete CI with Id: `").append(id).append("` as it was not found").toString());
                return true;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        this.logger().error(new StringBuilder(31).append("Unable to delete CI with Id: `").append(id).append("`").toString(), e);
        return false;
    }

    public void deleteRelease(String id) {
        block5: {
            this.logger().info("Deleting release {}", new Object[]{id});
            boolean found = false;
            if (this.releaseRepository.exists(id)) {
                this.logger().info("Release {} found in repository", new Object[]{id});
                try {
                    this.teamRepository.deleteTeamsFromPlatform(id);
                }
                catch (NotFoundException e) {
                    this.logger().warn(new StringBuilder(26).append("Could not delete teams of ").append(id).toString(), (Throwable)e);
                }
                this.releaseRepository.delete(id);
                found = true;
            }
            if (this.archivingService.exists(id)) {
                this.logger().info("Release {} found in archive", new Object[]{id});
                this.deleteFromArchive(id);
                found = true;
            }
            if (this.archivingService.existsPreArchived(id)) {
                this.logger().info("Release {} found as pre-archived", new Object[]{id});
                this.deleteFromArchive(id);
                found = true;
            }
            if (found) break block5;
            this.logger().error("Release {} not found neither in repository nor in archive (including pre-archived releases)", new Object[]{id});
        }
    }

    @Override
    public boolean delete(Team team) {
        boolean bl;
        this.logger().trace(new StringBuilder(14).append("Deleting team ").append(team.getId()).toString());
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int deleteFromArchive(String releaseId) {
        return SqlStorageFacade$.MODULE$.deleteFromArchive(releaseId, this.reportingJdbcTemplate);
    }

    @Override
    public void verifyRepositoryClean() {
        String testName;
        String string = testName = MDC.get((String)"testName") != null ? new StringBuilder(2).append(MDC.get((String)"testName")).append(": ").toString() : "";
        if (this.countReleases() > 0 || this.countArchivedReleases() > 0) {
            throw this.testDidNotCleanAfterItself(testName, this.getRemainingReleasesDetails(), this.getRemainingArchivedReleasesDetails());
        }
        int triggerCount = this.countTriggers();
        if (triggerCount > 0) {
            throw new TestCleanupException(new StringBuilder(38).append(testName).append("Found ").append(triggerCount).append(" remaining triggers in database:").append(this.NL()).append(this.getRemainingTriggersDetails().mkString(this.NL())).toString());
        }
        if (this.countFolders() > 1) {
            Seq folders = (Seq)this.getRemainingFolderDetails().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String id = (String)A1._1();
                        String path = (String)A1._2();
                        object = new StringBuilder(4).append(id).append(" -> ").append(path).toString();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, String> x1) {
                    Tuple2<String, String> tuple2 = x1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom());
            throw new TestCleanupException(new StringBuilder(28).append(testName).append("There are leftover folders: ").append(folders).toString());
        }
    }

    private int countFolders() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$1) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private TestCleanupException testDidNotCleanAfterItself(String testName, Seq<Tuple2<String, String>> active, Seq<Tuple2<String, String>> archived) {
        int numActive = active.size();
        int numArchived = archived.size();
        int numTotal = numActive + numArchived;
        return new TestCleanupException(new StringBuilder(62).append(testName).append("Found ").append(numTotal).append(" remaining releases (").append(numActive).append(" from database and ").append(numArchived).append(" from archive):\n").append(SqlStorageFacade.all$1(active, archived)).toString());
    }

    private int countReleases() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.RELEASES$.MODULE$.CI_UID()).append(") FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$2) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countTriggers() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.TRIGGERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$3) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<String> getRemainingTriggersDetails() {
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE()).append(", ").append(Schema.TRIGGERS$.MODULE$.ID()).append(" FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$4) -> new StringBuilder(19).append("Trigger: ").append(rs.getString(1)).append(" with id: ").append(rs.getString(2)).toString())).asScala()).toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingFolderDetails() {
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(", ").append(Schema.FOLDERS$.MODULE$.FOLDER_PATH()).append(" FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$5) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala()).toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingReleasesDetails() {
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.RELEASES$.MODULE$.RELEASE_ID()).append(", ").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).append(" FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$6) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala()).toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingArchivedReleasesDetails() {
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.reportingJdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(", ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TITLE_COLUMN()).append(" FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$7) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala()).toSeq();
    }

    private int countArchivedReleases() {
        return BoxesRunTime.unboxToInt((Object)this.reportingJdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(") FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$8) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    @PreDestroy
    public void cleanXlDb() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent("XL_VERSION", sqlJdbcTemplate);
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        this.applicationContext = x$1;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext();
    }

    public void setApplicationContext(ApplicationContext x$1) {
        this.applicationContext_$eq(x$1);
    }

    public static final /* synthetic */ void $anonfun$wipeOutArchiveDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out reporting database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$wipeOutDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out repository database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    private static final String showEntry$1(String tag, Tuple2 entry) {
        Tuple2 tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        String title = (String)tuple2._2();
        String string = new StringBuilder(9).append(id).append(" -> '").append(title).append("' (").append(tag).append(")").toString();
        return string;
    }

    private static final String all$1(Seq active$1, Seq archived$1) {
        return ((TraversableOnce)((TraversableLike)active$1.map((Function1 & Serializable & scala.Serializable)entry -> SqlStorageFacade.showEntry$1("active", entry), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)archived$1.map((Function1 & Serializable & scala.Serializable)entry -> SqlStorageFacade.showEntry$1("archive", entry), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).mkString("", "\n * ", "\n");
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, SqlTeamRepository teamRepository, ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, TriggerRepository triggerRepository, TaskPersistence taskPersistence, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate) {
        this.folderService = folderService;
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.triggerRepository = triggerRepository;
        this.taskPersistence = taskPersistence;
        this.jdbcTemplate = jdbcTemplate;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        BeforeUpgrade.$init$((BeforeUpgrade)this);
        TestAuthentication.$init$((TestAuthentication)this);
        LiquibaseSupport.$init$((LiquibaseSupport)this);
        ScalaSpringSupport.$init$((ScalaSpringSupport)this);
        this.NL = System.lineSeparator();
    }
}

