package com.xebialabs.xlrelease.test.async

import com.xebialabs.xlrelease.XLReleaseIntegrationScalaTest
import com.xebialabs.xlrelease.utils.{CleanupAwaiter, ConditionBuilder}

import scala.collection.mutable

trait AsyncSupport {
  self: XLReleaseIntegrationScalaTest =>

  var registeredListeners: mutable.ListBuffer[CleanupAwaiter] = new mutable.ListBuffer[CleanupAwaiter]

  def async[T](block: => T): ConditionBuilder[T] = ConditionBuilder.execute[T](eventBus, () => block)

  def listen(): CleanupAwaiter = registerCloseable(async(()).listen())
}