package com.xebialabs.xlrelease.utils

import com.xebialabs.xlrelease.domain.events.XLReleaseEvent
import com.xebialabs.xlrelease.events.{SynchronizedSubscribe, XLReleaseEventBus}
import grizzled.slf4j.Logging

class PickingAwaiter[T](
                         eventBus: XLReleaseEventBus,
                         timeout: Long,
                         picker: PartialFunction[XLReleaseEvent, Option[T]]
                       ) extends BaseConditionAwaiter(eventBus, timeout) with Logging {
  var result: Option[T] = None

  override protected def getErrorMessage: String = ""

  @SynchronizedSubscribe
  def onEvent(event: XLReleaseEvent): Unit = {
    if (latch.getCount > 0) {
      if (picker.isDefinedAt(event)) {
        result = picker.apply(event)
        latch.countDown()
      } else {
        logger.warn(s"Ignoring event: ${event.toString}")
      }
    }
  }

  def get(): Option[T] = {
    await()
    result;
  }

}
