/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.SqlStorageFacade$;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.TestCleanupException;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.LiquibaseSupport;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.support.akka.spring.ScalaSpringSupport;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeUpgrade;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import liquibase.Liquibase;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Profile(value={"integrationTest"})
@ScalaSignature(bytes="\u0006\u0005\rMe\u0001B A\u0001\u001dC\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\u000b\u0003\u0003\u0001!\u0011!Q\u0001\n\u0005\r\u0001BCA\b\u0001\t\u0005\t\u0015!\u0003\u0002\u0012!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005\u0015\u0002A!A!\u0002\u0013\t9\u0003\u0003\u0006\u0002.\u0001\u0011\t\u0011)A\u0005\u0003_A!\"a\u000f\u0001\u0005\u0003\u0005\u000b\u0011BA\u001f\u0011)\t\u0019\u0005\u0001B\u0001B\u0003%\u0011Q\t\u0005\u000b\u0003\u0017\u0002!\u0011!Q\u0001\n\u00055\u0003BCA*\u0001\t\u0005\t\u0015!\u0003\u0002V!Q\u00111\f\u0001\u0003\u0002\u0003\u0006I!!\u0018\t\u0015\u0005\r\u0004A!A!\u0002\u0013\t)\u0007\u0003\u0006\u0002\u0012\u0002\u0011\t\u0011)A\u0005\u0003KBq!a&\u0001\t\u0003\tI\nC\u0004\u0002D\u0002!\t%!2\t\re\u0003A\u0011IAo\u0011\u001d\tY\u000f\u0001C!\u0003[Dq!!@\u0001\t\u0003\ni\u000eC\u0004\u0002\u0000\u0002!\tE!\u0001\t\u000f\t\r\u0002\u0001\"\u0003\u0003&!9!q\u0005\u0001\u0005\n\t\u0015\u0002b\u0002B\u0015\u0001\u0011%!1\u0006\u0005\b\u0005g\u0001A\u0011\u0002B\u0016\u0011)\u0011)\u0004\u0001EC\u0002\u0013\u0005!q\u0007\u0005\n\u0005\u000f\u0002!\u0019!C\u0005\u0005\u0013B\u0001Ba\u0014\u0001A\u0003%!1\n\u0005\b\u0005#\u0002A\u0011\u0001B*\u0011\u001d\u0011Y\u0006\u0001C\u0005\u0005;BqA!\u001a\u0001\t\u0003\ni\u000eC\u0004\u0003h\u0001!\t%!8\t\u000f\t%\u0004\u0001\"\u0011\u0003l!9!\u0011\u000f\u0001\u0005\u0012\tM\u0004b\u0002B<\u0001\u0011E!\u0011\u0010\u0005\b\u0005{\u0002A\u0011\u0002B@\u0011\u001d\u0011\u0019\t\u0001C\t\u0005\u000bCqA!\u001b\u0001\t\u0003\u0012I\tC\u0004\u0003\u001c\u0002!\tE!(\t\u000f\t%\u0006\u0001\"\u0011\u0002^\"9!1\u0016\u0001\u0005\n\t5\u0006b\u0002BX\u0001\u0011%!Q\u0016\u0005\b\u0005c\u0003A\u0011\u0002BW\u0011\u001d\u0011\u0019\f\u0001C\u0005\u0005kCqA!0\u0001\t\u0013\u0011y\fC\u0004\u0003d\u0002!IA!:\t\u000f\tU\b\u0001\"\u0003\u0003x\"911\u0002\u0001\u0005\n\t5\u0006bBB\u0007\u0001\u0011%!Q\u0016\u0005\b\u0007\u001f\u0001A\u0011BB\t\u0011\u001d\u0019)\u0002\u0001C\u0005\u0007/Aqa!\u0007\u0001\t\u0013\u00199\u0002C\u0004\u0004\u001c\u0001!Iaa\u0006\t\u000f\ru\u0001\u0001\"\u0003\u0003.\"91q\u0004\u0001\u0005\u0002\u0005u\u0007bCB\u0017\u0001\u0001\u0007\t\u0019!C\u0001\u0007_A1ba\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0004:!Y1q\b\u0001A\u0002\u0003\u0005\u000b\u0015BB\u0019\u0011\u001d\u0019i\u0005\u0001C\u0001\u0007\u001fBqa!\u0016\u0001\t\u0003\u00199fB\u0004\u0004~\u0001C\taa \u0007\r}\u0002\u0005\u0012ABA\u0011\u001d\t9\n\u0010C\u0001\u0007\u0013CqAa'=\t\u0003\u0019YI\u0001\tTc2\u001cFo\u001c:bO\u00164\u0015mY1eK*\u0011\u0011IQ\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0011#\u0002\u0013a,'-[1mC\n\u001c(\"A#\u0002\u0007\r|Wn\u0001\u0001\u0014\u0011\u0001A\u0005\u000b\u0016/`K>\u0004\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0006!!.\u0019<b\u0013\ty%J\u0001\u0004PE*,7\r\u001e\t\u0003#Jk\u0011\u0001Q\u0005\u0003'\u0002\u0013Qb\u0015;pe\u0006<WMR1dC\u0012,\u0007CA+[\u001b\u00051&BA,Y\u0003%a\u0017.];jE\u0006\u001cXM\u0003\u0002Z\u0001\u00069Q\u000f]4sC\u0012,\u0017BA.W\u00055\u0011UMZ8sKV\u0003xM]1eKB\u0011\u0011+X\u0005\u0003=\u0002\u0013!\u0003V3ti\u0006+H\u000f[3oi&\u001c\u0017\r^5p]B\u0011\u0001mY\u0007\u0002C*\u0011!\rQ\u0001\u0003I\nL!\u0001Z1\u0003!1K\u0017/^5cCN,7+\u001e9q_J$\bC\u00014n\u001b\u00059'B\u00015j\u0003\u0019\u0019\bO]5oO*\u0011!n[\u0001\u0005C.\\\u0017M\u0003\u0002m\u0001\u000691/\u001e9q_J$\u0018B\u00018h\u0005I\u00196-\u00197b'B\u0014\u0018N\\4TkB\u0004xN\u001d;\u0011\u0005A<X\"A9\u000b\u0005I\u001c\u0018aB2p]R,\u0007\u0010\u001e\u0006\u0003iV\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002m\u0006\u0019qN]4\n\u0005a\f(aF!qa2L7-\u0019;j_:\u001cuN\u001c;fqR\fu/\u0019:f\u000351w\u000e\u001c3feN+'O^5dKB\u00111P`\u0007\u0002y*\u0011Q\u0010Q\u0001\bg\u0016\u0014h/[2f\u0013\tyHPA\u0007G_2$WM]*feZL7-Z\u0001\u0010M\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ssB!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n\u0001\u000b!B]3q_NLGo\u001c:z\u0013\u0011\ti!a\u0002\u0003\u001f\u0019\u000b7-\u001a;SKB|7/\u001b;pef\fa\u0002^3b[J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\u0011\t9\"a\u0002\u0002\u0007M\fH.\u0003\u0003\u0002\u001c\u0005U!!E*rYR+\u0017-\u001c*fa>\u001c\u0018\u000e^8ss\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\t\u0005\u0015\u0011\u0011E\u0005\u0005\u0003G\t9AA\tSK2,\u0017m]3SKB|7/\u001b;pef\fAC]3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,\u0007cA>\u0002*%\u0019\u00111\u0006?\u0003)I+G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\u0004B!!\r\u000285\u0011\u00111\u0007\u0006\u0005\u0003k\t)\"A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0002BA\u001d\u0003g\u0011Q\u0003R3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-A\fd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssB!\u0011QAA \u0013\u0011\t\t%a\u0002\u0003/\r{gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\u0018aF2bY\u0016tG-\u0019:F]R\u0014\u0018PU3q_NLGo\u001c:z!\u0011\t)!a\u0012\n\t\u0005%\u0013q\u0001\u0002\u0018\u0007\u0006dWM\u001c3be\u0016sGO]=SKB|7/\u001b;pef\f\u0001#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3\u0011\u0007m\fy%C\u0002\u0002Rq\u0014\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\u0002#Q\u0014\u0018nZ4feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002\u0006\u0005]\u0013\u0002BA-\u0003\u000f\u0011\u0011\u0003\u0016:jO\u001e,'OU3q_NLGo\u001c:z\u0003=!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0003BA\u0019\u0003?JA!!\u0019\u00024\tyA+Y:l!\u0016\u00148/[:uK:\u001cW-\u0001\u0007kI\n\u001cG+Z7qY\u0006$X\r\u0005\u0003\u0002h\u0005ETBAA5\u0015\u0011\tY'!\u001c\u0002\t\r|'/\u001a\u0006\u0004\u0003_\u001a\u0018\u0001\u00026eE\u000eLA!a\u001d\u0002j\ta!\n\u001a2d)\u0016l\u0007\u000f\\1uK\":A\"a\u001e\u0002\f\u00065\u0005\u0003BA=\u0003\u000fk!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u000bC:tw\u000e^1uS>t'\u0002BAA\u0003\u0007\u000bqAZ1di>\u0014\u0018PC\u0002\u0002\u0006N\fQAY3b]NLA!!#\u0002|\tI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u001f\u000b\u0011\u0004\u001f7s%\u0016\u0004xn]5u_JL(\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006)\"/\u001a9peRLgn\u001a&eE\u000e$V-\u001c9mCR,\u0007fB\u0007\u0002x\u0005-\u0015QS\u0011\u0003\u0003#\u000ba\u0001P5oSRtD\u0003HAN\u0003;\u000by*!)\u0002$\u0006\u0015\u0016qUAU\u0003W\u000bi+a,\u00022\u0006M\u0016q\u0017\t\u0003#\u0002AQ!\u001f\bA\u0002iDq!!\u0001\u000f\u0001\u0004\t\u0019\u0001C\u0004\u0002\u00109\u0001\r!!\u0005\t\u000f\u0005ua\u00021\u0001\u0002 !9\u0011Q\u0005\bA\u0002\u0005\u001d\u0002bBA\u0017\u001d\u0001\u0007\u0011q\u0006\u0005\b\u0003wq\u0001\u0019AA\u001f\u0011\u001d\t\u0019E\u0004a\u0001\u0003\u000bBq!a\u0013\u000f\u0001\u0004\ti\u0005C\u0004\u0002T9\u0001\r!!\u0016\t\u000f\u0005mc\u00021\u0001\u0002^!9\u00111\r\bA\u0002\u0005\u0015\u0004\u0006CAZ\u0003o\nY)!$\t\u000f\u0005Ee\u00021\u0001\u0002f!B\u0011qWA<\u0003\u0017\u000b)\nK\u0002\u000f\u0003{\u0003B!!\u001f\u0002@&!\u0011\u0011YA>\u0005%\tU\u000f^8xSJ,G-\u0001\tyYJ+G.Z1tKZ+'o]5p]R\u0011\u0011q\u0019\t\u0005\u0003\u0013\fI.\u0004\u0002\u0002L*\u0019\u0011,!4\u000b\t\u0005=\u0017\u0011[\u0001\u0004CBL'\u0002BAj\u0003+\faa]3sm\u0016\u0014(bAAl\u0005\u0006AA-\u001a9m_fLG/\u0003\u0003\u0002\\\u0006-'a\u0002,feNLwN\u001c\u000b\u0003\u0003?\u0004B!!9\u0002h6\u0011\u00111\u001d\u0006\u0003\u0003K\fQa]2bY\u0006LA!!;\u0002d\n!QK\\5u\u0003a\u0011X\r]8tSR|'/\u001f,feNLwN\\*feZL7-Z\u000b\u0003\u0003_\u0004B!!=\u0002z6\u0011\u00111\u001f\u0006\u00043\u0006U(bAA|\u0005\u0006Q\u0001\u0010\u001c9mCR4wN]7\n\t\u0005m\u00181\u001f\u0002\u0019%\u0016\u0004xn]5u_JLh+\u001a:tS>t7+\u001a:wS\u000e,\u0017!\u00033p+B<'/\u00193f\u0003M\u0019w.\u001e8u%\u0016\u001cwN\u001d3t\u0013:$\u0016M\u00197f)\u0011\u0011\u0019A!\u0003\u0011\t\u0005\u0005(QA\u0005\u0005\u0005\u000f\t\u0019O\u0001\u0003M_:<\u0007b\u0002B\u0006'\u0001\u0007!QB\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004BAa\u0004\u0003\u001e9!!\u0011\u0003B\r!\u0011\u0011\u0019\"a9\u000e\u0005\tU!b\u0001B\f\r\u00061AH]8pizJAAa\u0007\u0002d\u00061\u0001K]3eK\u001aLAAa\b\u0003\"\t11\u000b\u001e:j]\u001eTAAa\u0007\u0002d\u00061r/\u001b9f\u001fV$\u0018I]2iSZ,G)\u0019;bE\u0006\u001cX-\u0006\u0002\u0002`\u0006yq/\u001b9f\u001fV$H)\u0019;bE\u0006\u001cX-\u0001\njg\u0012\u00137\t\\3b]V\u0004XI\\1cY\u0016$WC\u0001B\u0017!\u0011\t\tOa\f\n\t\tE\u00121\u001d\u0002\b\u0005>|G.Z1o\u0003yI7/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e)s_\u001aLG.Z!di&4X-\u0001\u0006eCR\f7k\\;sG\u0016,\"A!\u000f\u0011\t\tm\"1I\u0007\u0003\u0005{QA!a\u0006\u0003@)\u0011!\u0011I\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0005\u000b\u0012iD\u0001\u0006ECR\f7k\\;sG\u0016\f!A\u0014'\u0016\u0005\t-\u0003cA%\u0003N%\u0019!q\u0004&\u0002\u00079c\u0005%A\u0006uC\ndW-\u0012=jgR\u001cH\u0003\u0002B+\u00053\"BA!\f\u0003X!9\u00111M\u000eA\u0004\u0005\u0015\u0004b\u0002B\u00067\u0001\u0007!QB\u0001\u0013I\u0016dW\r^3UC\ndWmQ8oi\u0016tG\u000f\u0006\u0003\u0003`\t\rD\u0003BAp\u0005CBq!a\u0019\u001d\u0001\b\t)\u0007C\u0004\u0003\fq\u0001\rA!\u0004\u00023\u0011,G.\u001a;f!\u0016\u0014X.[:tS>t7K\\1qg\"|Go]\u0001\bG2,\u0017M\\;q\u0003\u0019!W\r\\3uKR!!Q\u0006B7\u0011\u001d\u0011yg\ba\u0001\u0005\u001b\t!!\u001b3\u0002\u001d\u0011,G.\u001a;f\t\u0016d\u0017N^3ssR!\u0011q\u001cB;\u0011\u001d\u0011y\u0007\ta\u0001\u0005\u001b\tq\u0002Z3mKR,G)Y:iE>\f'\u000f\u001a\u000b\u0005\u0003?\u0014Y\bC\u0004\u0003p\u0005\u0002\rA!\u0004\u0002%%\u001cx\t\\8cC2\u001cV\r\u001e;j]\u001e\u001c\u0018\n\u001a\u000b\u0005\u0005[\u0011\t\tC\u0004\u0003p\t\u0002\rA!\u0004\u0002\u001b\u0011,G.\u001a;f%\u0016dW-Y:f)\u0011\tyNa\"\t\u000f\t=4\u00051\u0001\u0003\u000eQ!!Q\u0006BF\u0011\u001d\u0011i\t\na\u0001\u0005\u001f\u000bA\u0001^3b[B!!\u0011\u0013BL\u001b\t\u0011\u0019JC\u0002\u0003\u0016\u0002\u000ba\u0001Z8nC&t\u0017\u0002\u0002BM\u0005'\u0013A\u0001V3b[\u0006\tB-\u001a7fi\u00164%o\\7Be\u000eD\u0017N^3\u0015\t\t}%Q\u0015\t\u0005\u0003C\u0014\t+\u0003\u0003\u0003$\u0006\r(aA%oi\"9!qU\u0013A\u0002\t5\u0011!\u0003:fY\u0016\f7/Z%e\u0003U1XM]5gsJ+\u0007o\\:ji>\u0014\u0018p\u00117fC:\f\u0011bY8v]RTuNY:\u0015\u0005\t}\u0015\u0001D2pk:$hi\u001c7eKJ\u001c\u0018!E2pk:$\u0018\t\u001d9mS\u000e\fG/[8og\u0006I1m\\;oiJ{wo\u001d\u000b\u0007\u0005?\u00139L!/\t\u000f\t-!\u00061\u0001\u0003\u000e!9!1\u0018\u0016A\u0002\t5\u0011AC2pYVlgNT1nK\u0006\u0019r-\u001a;SK6\f\u0017N\\5oO\u0012+G/Y5mgRA!\u0011\u0019Bm\u00057\u0014y\u000e\u0005\u0004\u0003D\n5'1\u001b\b\u0005\u0005\u000b\u0014IM\u0004\u0003\u0003\u0014\t\u001d\u0017BAAs\u0013\u0011\u0011Y-a9\u0002\u000fA\f7m[1hK&!!q\u001aBi\u0005\r\u0019V-\u001d\u0006\u0005\u0005\u0017\f\u0019\u000f\u0005\u0005\u0002b\nU'Q\u0002B\u0007\u0013\u0011\u00119.a9\u0003\rQ+\b\u000f\\33\u0011\u001d\u0011Ya\u000ba\u0001\u0005\u001bAqA!8,\u0001\u0004\u0011i!\u0001\u0007jI\u000e{G.^7o\u001d\u0006lW\rC\u0004\u0003b.\u0002\rA!\u0004\u0002\u001fQLG\u000f\\3D_2,XN\u001c(b[\u0016\fqB^3sS\u001aLH*\u001a4u_Z,'o\u001d\u000b\r\u0003?\u00149Oa;\u0003n\nE(1\u001f\u0005\b\u0005Sd\u0003\u0019\u0001B\u0007\u0003\u001diWm]:bO\u0016DqAa\u0003-\u0001\u0004\u0011i\u0001C\u0004\u0003p2\u0002\rA!\u0004\u0002\u001f\r|WO\u001c;D_2,XN\u001c(b[\u0016DqA!8-\u0001\u0004\u0011i\u0001C\u0004\u0003b2\u0002\rA!\u0004\u00025Q,7\u000f\u001e#jI:{Go\u00117fC:\fe\r^3s\u0013R\u001cX\r\u001c4\u0015\u0011\te(q`B\u0002\u0007\u000f\u00012!\u0015B~\u0013\r\u0011i\u0010\u0011\u0002\u0015)\u0016\u001cHo\u00117fC:,\b/\u0012=dKB$\u0018n\u001c8\t\u000f\r\u0005Q\u00061\u0001\u0003\u000e\u0005AA/Z:u\u001d\u0006lW\rC\u0004\u0004\u00065\u0002\rA!1\u0002\r\u0005\u001cG/\u001b<f\u0011\u001d\u0019I!\fa\u0001\u0005\u0003\f\u0001\"\u0019:dQ&4X\rZ\u0001\u000eG>,h\u000e\u001e*fY\u0016\f7/Z:\u0002\u001b\r|WO\u001c;Ue&<w-\u001a:t\u0003m9W\r\u001e*f[\u0006Lg.\u001b8h)JLwmZ3sg\u0012+G/Y5mgR\u001111\u0003\t\u0007\u0005\u0007\u0014iM!\u0004\u00023\u001d,GOU3nC&t\u0017N\\4G_2$WM\u001d#fi\u0006LGn\u001d\u000b\u0003\u0005\u0003\f1dZ3u%\u0016l\u0017-\u001b8j]\u001e\u0014V\r\\3bg\u0016\u001cH)\u001a;bS2\u001c\u0018aI4fiJ+W.Y5oS:<\u0017I]2iSZ,GMU3mK\u0006\u001cXm\u001d#fi\u0006LGn]\u0001\u0016G>,h\u000e^!sG\"Lg/\u001a3SK2,\u0017m]3t\u0003%\u0019G.Z1o12$%\rK\u00026\u0007G\u0001Ba!\n\u0004*5\u00111q\u0005\u0006\u0005\u0003{\u0012y$\u0003\u0003\u0004,\r\u001d\"A\u0003)sK\u0012+7\u000f\u001e:ps\u0006\u0011\u0012\r\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u+\t\u0019\t\u0004E\u0002q\u0007gI1a!\u000er\u0005I\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002-\u0005\u0004\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010^0%KF$B!a8\u0004<!I1QH\u001c\u0002\u0002\u0003\u00071\u0011G\u0001\u0004q\u0012\n\u0014aE1qa2L7-\u0019;j_:\u001cuN\u001c;fqR\u0004\u0003f\u0001\u001d\u0004DA!1QIB%\u001b\t\u00199E\u0003\u0003\u0002\u0006\u0006\r\u0018\u0002BB&\u0007\u000f\u0012ABQ3b]B\u0013x\u000e]3sif\fQcZ3u\u0003B\u0004H.[2bi&|gnQ8oi\u0016DH\u000f\u0006\u0002\u00042!\u001a\u0011ha\u0015\f\u0001\u0005)2/\u001a;BaBd\u0017nY1uS>t7i\u001c8uKb$H\u0003BAp\u00073B\u0011b!\u0010;\u0003\u0003\u0005\ra!\r)\u0007i\u001a\u0019\u0006K\u0004\u0001\u0007?\nYi!\u001b\u0011\t\r\u00054QM\u0007\u0003\u0007GR1!! r\u0013\u0011\u00199ga\u0019\u0003\u000fA\u0013xNZ5mK2\u001211N\u0011\u0003\u0007[\nq\"\u001b8uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0015\u0004\u0001\rE\u0004\u0003BB:\u0007sj!a!\u001e\u000b\u0007\r]4/\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAaa\u001f\u0004v\tI1i\\7q_:,g\u000e^\u0001\u0011'Fd7\u000b^8sC\u001e,g)Y2bI\u0016\u0004\"!\u0015\u001f\u0014\u0007q\u001a\u0019\t\u0005\u0003\u0002b\u000e\u0015\u0015\u0002BBD\u0003G\u0014a!\u00118z%\u00164GCAB@)\u0011\u0019ii!%\u0015\t\t}5q\u0012\u0005\b\u0003Gr\u0004\u0019AA3\u0011\u001d\u00119K\u0010a\u0001\u0005\u001b\u0001")
public class SqlStorageFacade
implements StorageFacade,
BeforeUpgrade,
TestAuthentication,
LiquibaseSupport,
ScalaSpringSupport,
ApplicationContextAware {
    private DataSource dataSource;
    private final FolderService folderService;
    private final FacetRepository facetRepository;
    private final SqlTeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    private final TriggerRepository triggerRepository;
    private final TaskPersistence taskPersistence;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;
    @Qualifier(value="reportingJdbcTemplate")
    private final JdbcTemplate reportingJdbcTemplate;
    private final String NL;
    private ApplicationContext applicationContext;
    private volatile boolean bitmap$0;

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> Map<String, T> springBeans(ClassTag<T> evidence$3) {
        return ScalaSpringSupport.springBeans$((ScalaSpringSupport)this, evidence$3);
    }

    public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
        return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
    }

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    public <T> T asAdmin(Function0<T> block) {
        return (T)TestAuthentication.asAdmin$((TestAuthentication)this, block);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    public Version xlReleaseVersion() {
        return Version.valueOf((String)"xl-release", (String)"0.0.0");
    }

    public void upgrade() {
        this.doUpgrade();
    }

    public RepositoryVersionService repositoryVersionService() {
        return null;
    }

    public void doUpgrade() {
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    @Override
    public long countRecordsInTable(String tableName) {
        return BoxesRunTime.unboxToLong((Object)this.jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE));
    }

    private void wipeOutArchiveDatabase() {
        if (this.isDbCleanupEnabled()) {
            DataSource reportingDataSource = (DataSource)this.springBean("reportingDataSource", ClassTag$.MODULE$.apply(DataSource.class));
            LiquibaseSupport reporting = new LiquibaseSupport(null, reportingDataSource){
                private final DataSource reportingDataSource$1;

                public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
                    return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
                }

                public DataSource dataSource() {
                    return this.reportingDataSource$1;
                }
                {
                    this.reportingDataSource$1 = reportingDataSource$1;
                    LiquibaseSupport.$init$((LiquibaseSupport)this);
                }
            };
            reporting.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutArchiveDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void wipeOutDatabase() {
        if (this.isDbCleanupEnabled() && this.isIntegrationTestProfileActive()) {
            this.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private boolean isDbCleanupEnabled() {
        String nodbcleanup = System.getProperty("nodbcleanup", "false");
        boolean isCleanupEnabled = !Boolean.parseBoolean(nodbcleanup);
        this.logger().info(new StringBuilder(17).append("Cleanup enabled: ").append(isCleanupEnabled).toString());
        return isCleanupEnabled;
    }

    private boolean isIntegrationTestProfileActive() {
        return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])this.applicationContext().getEnvironment().getActiveProfiles()), (Object)"integrationTest");
    }

    private DataSource dataSource$lzycompute() {
        SqlStorageFacade sqlStorageFacade = this;
        synchronized (sqlStorageFacade) {
            if (!this.bitmap$0) {
                this.dataSource = (DataSource)this.springBean("xlrRepositoryDataSource", ClassTag$.MODULE$.Nothing());
                this.bitmap$0 = true;
            }
        }
        return this.dataSource;
    }

    public DataSource dataSource() {
        if (!this.bitmap$0) {
            return this.dataSource$lzycompute();
        }
        return this.dataSource;
    }

    private String NL() {
        return this.NL;
    }

    public boolean tableExists(String tableName, JdbcTemplate jdbcTemplate) {
        boolean bl;
        try {
            jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void deleteTableContent(String tableName, JdbcTemplate jdbcTemplate) {
        if (this.tableExists(tableName, jdbcTemplate)) {
            this.logger().info(new StringBuilder(9).append("DELETING ").append(tableName).toString());
            jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(tableName).toString());
            return;
        }
    }

    @Override
    public void deletePermissionSnapshots() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.PERMISSION_SNAPSHOTS$.MODULE$.TABLE(), sqlJdbcTemplate);
    }

    @Override
    public void cleanup() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.DEPENDENCIES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASE_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.COMMENTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASKS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_ACTIVITY_LOGS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES_EXT$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISK_ASSESSMENTS", sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISKS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGER_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.ARTIFACTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASK_JOBS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deletePermissionSnapshots();
        if (this.tableExists(Schema.PATHS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(31).append("DELETE FROM ").append(Schema.PATHS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).append(" OR ").append(Schema.PATHS$.MODULE$.DESCENDANT_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        if (this.tableExists(Schema.FOLDERS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(15).append("UPDATE ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" SET ").append(Schema.FOLDERS$.MODULE$.SECURITY_UID()).append(" = ").append(FolderRow.Root$.MODULE$.uid()).toString());
            this.jdbcTemplate.execute(new StringBuilder(23).append("DELETE FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        this.deleteTableContent(MetadataSchema.METADATA$.MODULE$.TABLE(), sqlJdbcTemplate);
        if (this.tableExists(Schema.USER_PROFILE$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(30).append("DELETE FROM ").append(Schema.USER_PROFILE$.MODULE$.TABLE()).append(" WHERE ").append(Schema.USER_PROFILE$.MODULE$.USERNAME()).append(" <> 'admin'").toString());
        }
        JdbcTemplate sqlJdbcTemplate2 = this.reportingJdbcTemplate;
        this.deleteTableContent(Schema.Archive$.ITSM_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.DEPLOYMENT_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.CODE_COMPLIANCE_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_TASKS_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_PHASES_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), sqlJdbcTemplate2);
    }

    @Override
    public boolean delete(String id) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            this.logger().trace(new StringBuilder(12).append("Deleting id ").append(id).toString());
            if (Ids.isReleaseId((String)id)) {
                this.deleteRelease(id);
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id, (Integer)$this.taskPersistence.taskUidById(Ids.getParentId((String)id)).get());
            } else if (!Ids.isPlanItemId((String)id)) {
                if (Ids.isFolderId((String)id)) {
                    if ($this.folderService.exists(id)) {
                        $this.folderService.delete(id);
                    }
                } else if (Ids.isCustomConfigurationId((String)id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isCalendarId((String)id)) {
                    $this.calendarEntryRepository.delete(id);
                } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn(new StringBuilder(63).append("Variable '").append(id).append("' will be deleted once the parent release is deleted.").toString());
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    if (Ids.isTriggerId((String)id)) {
                        $this.triggerRepository.delete(id);
                    } else if (Ids.isFacetId((String)id)) {
                        $this.facetRepository.delete(id, $this.facetRepository.delete$default$2());
                    } else if (Ids.isInRelease((String)id)) {
                        this.logger().warn(new StringBuilder(69).append("Id '").append(id).append("' will be deleted once the parent release or template is deleted.").toString());
                    } else if (Ids.isDeliveryId((String)id)) {
                        this.deleteDelivery(id);
                    } else if (Ids.isDashboardId((String)id)) {
                        this.deleteDashboard(id);
                    } else if (!this.isGlobalSettingsId(id)) {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                    }
                }
            }
            return true;
        });
        if (try_ instanceof Success) {
            this.logger().warn(new StringBuilder(8).append("Deleted ").append(id).toString());
            return true;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                this.logger().error(new StringBuilder(51).append("Unable to delete CI with Id: `").append(id).append("` as it was not found").toString());
                return true;
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            this.logger().error(new StringBuilder(31).append("Unable to delete CI with Id: `").append(id).append("`").toString(), e);
            return false;
        }
        throw new MatchError((Object)try_);
    }

    public void deleteDelivery(String id) {
        this.jdbcTemplate.execute(new StringBuilder(40).append("DELETE FROM XLR_DELIVERIES WHERE ID = '").append(Ids.getName((String)id)).append("'").toString());
    }

    public void deleteDashboard(String id) {
        this.jdbcTemplate.execute(new StringBuilder(40).append("DELETE FROM XLR_DASHBOARDS WHERE ID = '").append(Ids.getName((String)id)).append("'").toString());
    }

    private boolean isGlobalSettingsId(String id) {
        String shortId = Ids.getName((String)id);
        return shortId.startsWith("EmailNotificationSettings");
    }

    public void deleteRelease(String id) {
        this.logger().info("Deleting release {}", (Object)id);
        boolean found = false;
        if (this.releaseRepository.exists(id)) {
            this.logger().info("Release {} found in repository", (Object)id);
            try {
                this.teamRepository.deleteTeamsFromPlatform(id);
            }
            catch (NotFoundException e) {
                this.logger().warn(new StringBuilder(26).append("Could not delete teams of ").append(id).toString(), (Throwable)e);
            }
            this.releaseRepository.delete(id, this.releaseRepository.delete$default$2());
            found = true;
        }
        if (this.archivingService.exists(id)) {
            this.logger().info("Release {} found in archive", (Object)id);
            this.deleteFromArchive(id);
            found = true;
        }
        if (this.archivingService.existsPreArchived(id)) {
            this.logger().info("Release {} found as pre-archived", (Object)id);
            this.deleteFromArchive(id);
            found = true;
        }
        if (!found) {
            this.logger().error("Release {} not found neither in repository nor in archive (including pre-archived releases)", (Object)id);
            return;
        }
    }

    @Override
    public boolean delete(Team team) {
        this.logger().trace(new StringBuilder(14).append("Deleting team ").append(team.getId()).toString());
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            return true;
        }
        return false;
    }

    @Override
    public int deleteFromArchive(String releaseId) {
        return SqlStorageFacade$.MODULE$.deleteFromArchive(releaseId, this.reportingJdbcTemplate);
    }

    @Override
    public void verifyRepositoryClean() {
        String testName;
        String string = testName = MDC.get((String)"testName") != null ? new StringBuilder(2).append(MDC.get((String)"testName")).append(": ").toString() : "";
        if (this.countReleases() > 0 || this.countArchivedReleases() > 0) {
            throw this.testDidNotCleanAfterItself(testName, this.getRemainingReleasesDetails(), this.getRemainingArchivedReleasesDetails());
        }
        int triggerCount = this.countTriggers();
        if (triggerCount > 0) {
            throw new TestCleanupException(new StringBuilder(38).append(testName).append("Found ").append(triggerCount).append(" remaining triggers in database:").append(this.NL()).append(this.getRemainingTriggersDetails().mkString(this.NL())).toString());
        }
        if (this.countFolders() > 1) {
            Seq folders = (Seq)this.getRemainingFolderDetails().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        String id = (String)A1._1();
                        String path = (String)A1._2();
                        return (B1)new StringBuilder(4).append(id).append(" -> ").append(path).toString();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<String, String> x1) {
                    Tuple2<String, String> tuple2 = x1;
                    return tuple2 != null;
                }
            });
            throw new TestCleanupException(new StringBuilder(28).append(testName).append("There are leftover folders: ").append(folders).toString());
        }
        int jobsCount = this.countJobs();
        if (jobsCount > 0) {
            Seq jobs = (Seq)this.getRemainingDetails(Schema.TASK_JOBS$.MODULE$.TABLE(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.TASK_ID()).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                    A1 A1 = x$1;
                    return (B1)x$1._2();
                }

                public final boolean isDefinedAt(Tuple2<String, String> x$1) {
                    Tuple2<String, String> tuple2 = x$1;
                    return true;
                }
            });
            throw new TestCleanupException(new StringBuilder(25).append(testName).append("There are leftover jobs: ").append(jobs).toString());
        }
        this.verifyLeftovers(new StringBuilder(31).append(testName).append("There are leftover applications").toString(), "XLR_APPLICATIONS", "CI_UID", "ID", "TITLE");
        this.verifyLeftovers(new StringBuilder(31).append(testName).append("There are leftover environments").toString(), "XLR_ENVIRONMENTS", "CI_UID", "ID", "TITLE");
        this.verifyLeftovers(new StringBuilder(23).append(testName).append("There are leftover jobs").toString(), Schema.TASK_JOBS$.MODULE$.TABLE(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.TASK_ID());
    }

    private int countJobs() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT COUNT(1) FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).toString(), (rs, x$2) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countFolders() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$3) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countApplications() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(CI_UID) FROM XLR_APPLICATIONS", (rs, x$4) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countRows(String tableName, String columnName) {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(columnName).append(") FROM ").append(tableName).toString(), (rs, x$5) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<Tuple2<String, String>> getRemainingDetails(String tableName, String idColumnName, String titleColumnName) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(idColumnName).append(", ").append(titleColumnName).append(" FROM ").append(tableName).toString(), (rs, x$6) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private void verifyLeftovers(String message, String tableName, String countColumnName, String idColumnName, String titleColumnName) {
        int count = this.countRows(tableName, countColumnName);
        if (count > 1) {
            Seq<Tuple2<String, String>> leftOvers = this.getRemainingDetails(tableName, idColumnName, titleColumnName);
            throw new TestCleanupException(new StringBuilder(2).append(message).append(": ").append(leftOvers).toString());
        }
    }

    private TestCleanupException testDidNotCleanAfterItself(String testName, Seq<Tuple2<String, String>> active, Seq<Tuple2<String, String>> archived) {
        int numActive = active.size();
        int numArchived = archived.size();
        int numTotal = numActive + numArchived;
        return new TestCleanupException(new StringBuilder(62).append(testName).append("Found ").append(numTotal).append(" remaining releases (").append(numActive).append(" from database and ").append(numArchived).append(" from archive):\n").append(SqlStorageFacade.all$1(active, archived)).toString());
    }

    private int countReleases() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.RELEASES$.MODULE$.CI_UID()).append(") FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$7) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countTriggers() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.TRIGGERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$8) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<String> getRemainingTriggersDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE()).append(", ").append(Schema.TRIGGERS$.MODULE$.ID()).append(" FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$9) -> new StringBuilder(19).append("Trigger: ").append(rs.getString(1)).append(" with id: ").append(rs.getString(2)).toString())).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingFolderDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(", ").append(Schema.FOLDERS$.MODULE$.FOLDER_PATH()).append(" FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$10) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.RELEASES$.MODULE$.RELEASE_ID()).append(", ").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).append(" FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$11) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingArchivedReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.reportingJdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(", ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TITLE_COLUMN()).append(" FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$12) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private int countArchivedReleases() {
        return BoxesRunTime.unboxToInt((Object)this.reportingJdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(") FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$13) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    @PreDestroy
    public void cleanXlDb() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent("XL_VERSION", sqlJdbcTemplate);
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        this.applicationContext = x$1;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext();
    }

    public void setApplicationContext(ApplicationContext x$1) {
        this.applicationContext_$eq(x$1);
    }

    public static final /* synthetic */ void $anonfun$wipeOutArchiveDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out reporting database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$wipeOutDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out repository database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    private static final String showEntry$1(String tag, Tuple2 entry) {
        Tuple2 tuple2 = entry;
        if (tuple2 != null) {
            String id = (String)tuple2._1();
            String title = (String)tuple2._2();
            return new StringBuilder(9).append(id).append(" -> '").append(title).append("' (").append(tag).append(")").toString();
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String all$1(Seq active$1, Seq archived$1) {
        return ((IterableOnceOps)((IterableOps)active$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("active", entry))).$plus$plus((IterableOnce)archived$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("archive", entry)))).mkString("", "\n * ", "\n");
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, FacetRepository facetRepository, SqlTeamRepository teamRepository, ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, TriggerRepository triggerRepository, TaskPersistence taskPersistence, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate) {
        this.folderService = folderService;
        this.facetRepository = facetRepository;
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.triggerRepository = triggerRepository;
        this.taskPersistence = taskPersistence;
        this.jdbcTemplate = jdbcTemplate;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        BeforeUpgrade.$init$((BeforeUpgrade)this);
        TestAuthentication.$init$((TestAuthentication)this);
        LiquibaseSupport.$init$((LiquibaseSupport)this);
        ScalaSpringSupport.$init$((ScalaSpringSupport)this);
        this.NL = System.lineSeparator();
    }
}

