package com.xebialabs.xlrelease;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.xlrelease.domain.Team;

public interface StorageFacade {
    default Logger logger() {
        return LoggerFactory.getLogger(getClass());
    }

    void cleanup();

    boolean delete(String id);

    boolean delete(Team t);

    int deleteFromArchive(String id);

    void verifyRepositoryClean();

    long countRecordsInTable(String tableName);

    void deletePermissionSnapshots();
}
