package com.xebialabs.xlrelease.utils;

import java.util.List;

import com.xebialabs.deployit.engine.spi.event.CiBaseEvent;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.events.PhaseExecutionEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutionEvent;
import com.xebialabs.xlrelease.domain.events.TaskExecutionEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.SynchronizedSubscribe;

class PlanItemStatusAwaiter<S> extends BaseConditionAwaiter {
    private String planItemId;
    private List<S> expectedStatuses;

    PlanItemStatusAwaiter(XLReleaseEventBus eventBus, String planItemId, List<S> statuses, long timeout) {
        super(eventBus, timeout);
        this.planItemId = planItemId;
        this.expectedStatuses = statuses;
    }

    @Override
    protected String getErrorMessage() {
        return String.format("%s did not reach expected status %s within %d milliseconds",
            planItemId, expectedStatuses, timeout);
    }

    @SynchronizedSubscribe
    public void onEvent(CiBaseEvent event) {
        List<ConfigurationItem> cis = event.getCis();
        cis.forEach(this::doneIfExpectedPlanItemAndStatus);
    }

    @SynchronizedSubscribe
    public void onReleaseExecutionEvent(ReleaseExecutionEvent event) {
        doneIfExpectedPlanItemAndStatus(event.release());
    }

    @SynchronizedSubscribe
    public void onPhaseExecutionEvent(PhaseExecutionEvent event) {
        doneIfExpectedPlanItemAndStatus(event.phase());
    }

    @SynchronizedSubscribe
    public void onTaskExecutionEvent(TaskExecutionEvent event) {
        doneIfExpectedPlanItemAndStatus(event.task());
    }

    private void doneIfExpectedPlanItemAndStatus(ConfigurationItem planItem) {
        if (planItemId.equals(planItem.getId()) &&
                expectedStatuses.contains(planItem.<S>getProperty("status"))) {
            latch.countDown();
        }
    }

}
