package com.xebialabs.xlrelease.api.v1;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.plumbing.ConfigurationItemReaderWriter;
import com.xebialabs.deployit.plumbing.XlrFormatFactory;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;


@Component
public class NonEncryptingPasswordItemReaderWriter extends ConfigurationItemReaderWriter {

    @Autowired
    public NonEncryptingPasswordItemReaderWriter(RepositoryFactory repositoryFactory,
                                                 XlrFormatFactory formats,
                                                 ConfigurationRepository configurationRepository) {
        super(repositoryFactory, formats, configurationRepository);
    }

    @Override
    protected ConfigurationItemConverter createConverter() {
        return new ConfigurationItemConverter();
    }
}

