/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.SqlStorageFacade$;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.TestCleanupException;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.LiquibaseSupport;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringSupport;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeUpgrade;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.util.Map;
import javax.sql.DataSource;
import liquibase.Liquibase;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Profile(value={"integrationTest"})
@ScalaSignature(bytes="\u0006\u0005\rUe\u0001B A\u0001\u001dC\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\u000b\u0003\u0003\u0001!\u0011!Q\u0001\n\u0005\r\u0001BCA\b\u0001\t\u0005\t\u0015!\u0003\u0002\u0012!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005\u0015\u0002A!A!\u0002\u0013\t9\u0003\u0003\u0006\u0002.\u0001\u0011\t\u0011)A\u0005\u0003_A!\"a\u000f\u0001\u0005\u0003\u0005\u000b\u0011BA\u001f\u0011)\t\u0019\u0005\u0001B\u0001B\u0003%\u0011Q\t\u0005\u000b\u0003\u0017\u0002!\u0011!Q\u0001\n\u00055\u0003BCA*\u0001\t\u0005\t\u0015!\u0003\u0002V!Q\u00111\f\u0001\u0003\u0002\u0003\u0006I!!\u0018\t\u0015\u0005\r\u0004A!A!\u0002\u0013\t)\u0007\u0003\u0006\u0002\u0012\u0002\u0011\t\u0011)A\u0005\u0003KBq!a&\u0001\t\u0003\tI\nC\u0004\u0002D\u0002!\t%!2\t\re\u0003A\u0011IAo\u0011\u001d\tY\u000f\u0001C!\u0003[Dq!!@\u0001\t\u0003\ni\u000eC\u0004\u0002\u0000\u0002!\tE!\u0001\t\u000f\t\r\u0002\u0001\"\u0003\u0003&!9!q\u0005\u0001\u0005\n\t\u0015\u0002b\u0002B\u0015\u0001\u0011%!1\u0006\u0005\b\u0005g\u0001A\u0011\u0002B\u0016\u0011)\u0011)\u0004\u0001EC\u0002\u0013\u0005!q\u0007\u0005\n\u0005\u000f\u0002!\u0019!C\u0005\u0005\u0013B\u0001Ba\u0014\u0001A\u0003%!1\n\u0005\b\u0005#\u0002A\u0011\u0001B*\u0011\u001d\u0011Y\u0006\u0001C\u0005\u0005;BqA!\u001a\u0001\t\u0003\ni\u000eC\u0004\u0003h\u0001!\t%!8\t\u000f\t%\u0004\u0001\"\u0011\u0003l!9!\u0011\u000f\u0001\u0005\u0012\tM\u0004b\u0002B<\u0001\u0011E!\u0011\u0010\u0005\b\u0005{\u0002A\u0011\u0002B@\u0011\u001d\u0011\u0019\t\u0001C\t\u0005\u000bCqA!\u001b\u0001\t\u0003\u0012I\tC\u0004\u0003\u001c\u0002!\tE!(\t\u000f\t%\u0006\u0001\"\u0011\u0002^\"9!1\u0016\u0001\u0005\n\t5\u0006b\u0002BX\u0001\u0011%!Q\u0016\u0005\b\u0005c\u0003A\u0011\u0002BW\u0011\u001d\u0011\u0019\f\u0001C\u0005\u0005kCqA!0\u0001\t\u0013\u0011y\fC\u0004\u0003d\u0002!IA!:\t\u000f\tU\b\u0001\"\u0003\u0003x\"911\u0002\u0001\u0005\n\t5\u0006bBB\u0007\u0001\u0011%!Q\u0016\u0005\b\u0007\u001f\u0001A\u0011BB\t\u0011\u001d\u0019)\u0002\u0001C\u0005\u0007/Aqa!\u0007\u0001\t\u0013\u00199\u0002C\u0004\u0004\u001c\u0001!Iaa\u0006\t\u000f\ru\u0001\u0001\"\u0003\u0003.\"91q\u0004\u0001\u0005\u0002\u0005u\u0007bCB\u0019\u0001\u0001\u0007\t\u0019!C\u0001\u0007gA1ba\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0004>!Y11\t\u0001A\u0002\u0003\u0005\u000b\u0015BB\u001b\u0011\u001d\u0019\t\u0006\u0001C\u0001\u0007'Bqaa\u0016\u0001\t\u0003\u0019IfB\u0004\u0004\u0000\u0001C\ta!!\u0007\r}\u0002\u0005\u0012ABB\u0011\u001d\t9\n\u0010C\u0001\u0007\u0017CqAa'=\t\u0003\u0019iI\u0001\tTc2\u001cFo\u001c:bO\u00164\u0015mY1eK*\u0011\u0011IQ\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0011#\u0002\u0013a,'-[1mC\n\u001c(\"A#\u0002\u0007\r|Wn\u0001\u0001\u0014\u0011\u0001A\u0005\u000b\u0016/`K>\u0004\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0006!!.\u0019<b\u0013\ty%J\u0001\u0004PE*,7\r\u001e\t\u0003#Jk\u0011\u0001Q\u0005\u0003'\u0002\u0013Qb\u0015;pe\u0006<WMR1dC\u0012,\u0007CA+[\u001b\u00051&BA,Y\u0003%a\u0017.];jE\u0006\u001cXM\u0003\u0002Z\u0001\u00069Q\u000f]4sC\u0012,\u0017BA.W\u00055\u0011UMZ8sKV\u0003xM]1eKB\u0011\u0011+X\u0005\u0003=\u0002\u0013!\u0003V3ti\u0006+H\u000f[3oi&\u001c\u0017\r^5p]B\u0011\u0001mY\u0007\u0002C*\u0011!\rQ\u0001\u0003I\nL!\u0001Z1\u0003!1K\u0017/^5cCN,7+\u001e9q_J$\bC\u00014n\u001b\u00059'B\u00015j\u0003\u0019\u0019\bO]5oO*\u0011!n[\u0001\u0006a\u0016\\7n\u001c\u0006\u0003Y\u0002\u000bqa];qa>\u0014H/\u0003\u0002oO\n\u00112kY1mCN\u0003(/\u001b8h'V\u0004\bo\u001c:u!\t\u0001x/D\u0001r\u0015\t\u00118/A\u0004d_:$X\r\u001f;\u000b\u0005Q,\u0018aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003Y\f1a\u001c:h\u0013\tA\u0018OA\fBaBd\u0017nY1uS>t7i\u001c8uKb$\u0018i^1sK\u0006iam\u001c7eKJ\u001cVM\u001d<jG\u0016\u0004\"a\u001f@\u000e\u0003qT!! !\u0002\u000fM,'O^5dK&\u0011q\u0010 \u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\u0002\u001f\u0019\f7-\u001a;SKB|7/\u001b;pef\u0004B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013\u0001\u0015A\u0003:fa>\u001c\u0018\u000e^8ss&!\u0011QBA\u0004\u0005=1\u0015mY3u%\u0016\u0004xn]5u_JL\u0018A\u0004;fC6\u0014V\r]8tSR|'/\u001f\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)!\u0011qCA\u0004\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u00037\t)BA\tTc2$V-Y7SKB|7/\u001b;pef\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\u0011\t)!!\t\n\t\u0005\r\u0012q\u0001\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018\u0001\u0006:fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW\rE\u0002|\u0003SI1!a\u000b}\u0005Q\u0011V\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dK\u0006)B-\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0003BA\u0019\u0003oi!!a\r\u000b\t\u0005U\u0012QC\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u0003\u0002:\u0005M\"!\u0006#fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-Z\u0001\u0018G>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\u0004B!!\u0002\u0002@%!\u0011\u0011IA\u0004\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u00180A\fdC2,g\u000eZ1s\u000b:$(/\u001f*fa>\u001c\u0018\u000e^8ssB!\u0011QAA$\u0013\u0011\tI%a\u0002\u0003/\r\u000bG.\u001a8eCJ,e\u000e\u001e:z%\u0016\u0004xn]5u_JL\u0018\u0001E1sG\"Lg/\u001b8h'\u0016\u0014h/[2f!\rY\u0018qJ\u0005\u0004\u0003#b(\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0003E!(/[4hKJ\u0014V\r]8tSR|'/\u001f\t\u0005\u0003\u000b\t9&\u0003\u0003\u0002Z\u0005\u001d!!\u0005+sS\u001e<WM\u001d*fa>\u001c\u0018\u000e^8ss\u0006yA/Y:l!\u0016\u00148/[:uK:\u001cW\r\u0005\u0003\u00022\u0005}\u0013\u0002BA1\u0003g\u0011q\u0002V1tWB+'o]5ti\u0016t7-Z\u0001\rU\u0012\u00147\rV3na2\fG/\u001a\t\u0005\u0003O\n\t(\u0004\u0002\u0002j)!\u00111NA7\u0003\u0011\u0019wN]3\u000b\u0007\u0005=4/\u0001\u0003kI\n\u001c\u0017\u0002BA:\u0003S\u0012AB\u00133cGR+W\u000e\u001d7bi\u0016Ds\u0001DA<\u0003\u0017\u000bi\t\u0005\u0003\u0002z\u0005\u001dUBAA>\u0015\u0011\ti(a \u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\u0002\u0006\r\u0015a\u00024bGR|'/\u001f\u0006\u0004\u0003\u000b\u001b\u0018!\u00022fC:\u001c\u0018\u0002BAE\u0003w\u0012\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0005\u0005=\u0015!\u0007=meJ+\u0007o\\:ji>\u0014\u0018P\u00133cGR+W\u000e\u001d7bi\u0016\fQC]3q_J$\u0018N\\4KI\n\u001cG+Z7qY\u0006$X\rK\u0004\u000e\u0003o\nY)!&\"\u0005\u0005E\u0015A\u0002\u001fj]&$h\b\u0006\u000f\u0002\u001c\u0006u\u0015qTAQ\u0003G\u000b)+a*\u0002*\u0006-\u0016QVAX\u0003c\u000b\u0019,a.\u0011\u0005E\u0003\u0001\"B=\u000f\u0001\u0004Q\bbBA\u0001\u001d\u0001\u0007\u00111\u0001\u0005\b\u0003\u001fq\u0001\u0019AA\t\u0011\u001d\tiB\u0004a\u0001\u0003?Aq!!\n\u000f\u0001\u0004\t9\u0003C\u0004\u0002.9\u0001\r!a\f\t\u000f\u0005mb\u00021\u0001\u0002>!9\u00111\t\bA\u0002\u0005\u0015\u0003bBA&\u001d\u0001\u0007\u0011Q\n\u0005\b\u0003'r\u0001\u0019AA+\u0011\u001d\tYF\u0004a\u0001\u0003;Bq!a\u0019\u000f\u0001\u0004\t)\u0007\u000b\u0005\u00024\u0006]\u00141RAG\u0011\u001d\t\tJ\u0004a\u0001\u0003KB\u0003\"a.\u0002x\u0005-\u0015Q\u0013\u0015\u0004\u001d\u0005u\u0006\u0003BA=\u0003\u007fKA!!1\u0002|\tI\u0011)\u001e;po&\u0014X\rZ\u0001\u0011q2\u0014V\r\\3bg\u00164VM]:j_:$\"!a2\u0011\t\u0005%\u0017\u0011\\\u0007\u0003\u0003\u0017T1!WAg\u0015\u0011\ty-!5\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002T\u0006U\u0017AB:feZ,'OC\u0002\u0002X\n\u000b\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u00037\fYMA\u0004WKJ\u001c\u0018n\u001c8\u0015\u0005\u0005}\u0007\u0003BAq\u0003Ol!!a9\u000b\u0005\u0005\u0015\u0018!B:dC2\f\u0017\u0002BAu\u0003G\u0014A!\u00168ji\u0006A\"/\u001a9pg&$xN]=WKJ\u001c\u0018n\u001c8TKJ4\u0018nY3\u0016\u0005\u0005=\b\u0003BAy\u0003sl!!a=\u000b\u0007e\u000b)PC\u0002\u0002x\n\u000b!\u0002\u001f7qY\u0006$hm\u001c:n\u0013\u0011\tY0a=\u00031I+\u0007o\\:ji>\u0014\u0018PV3sg&|gnU3sm&\u001cW-A\u0005e_V\u0003xM]1eK\u0006\u00192m\\;oiJ+7m\u001c:eg&sG+\u00192mKR!!1\u0001B\u0005!\u0011\t\tO!\u0002\n\t\t\u001d\u00111\u001d\u0002\u0005\u0019>tw\rC\u0004\u0003\fM\u0001\rA!\u0004\u0002\u0013Q\f'\r\\3OC6,\u0007\u0003\u0002B\b\u0005;qAA!\u0005\u0003\u001aA!!1CAr\u001b\t\u0011)BC\u0002\u0003\u0018\u0019\u000ba\u0001\u0010:p_Rt\u0014\u0002\u0002B\u000e\u0003G\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u0010\u0005C\u0011aa\u0015;sS:<'\u0002\u0002B\u000e\u0003G\fac^5qK>+H/\u0011:dQ&4X\rR1uC\n\f7/Z\u000b\u0003\u0003?\fqb^5qK>+H\u000fR1uC\n\f7/Z\u0001\u0013SN$%m\u00117fC:,\b/\u00128bE2,G-\u0006\u0002\u0003.A!\u0011\u0011\u001dB\u0018\u0013\u0011\u0011\t$a9\u0003\u000f\t{w\u000e\\3b]\u0006q\u0012n]%oi\u0016<'/\u0019;j_:$Vm\u001d;Qe>4\u0017\u000e\\3BGRLg/Z\u0001\u000bI\u0006$\u0018mU8ve\u000e,WC\u0001B\u001d!\u0011\u0011YDa\u0011\u000e\u0005\tu\"\u0002BA\f\u0005\u007fQ!A!\u0011\u0002\u000b)\fg/\u0019=\n\t\t\u0015#Q\b\u0002\u000b\t\u0006$\u0018mU8ve\u000e,\u0017A\u0001(M+\t\u0011Y\u0005E\u0002J\u0005\u001bJ1Aa\bK\u0003\rqE\nI\u0001\fi\u0006\u0014G.Z#ySN$8\u000f\u0006\u0003\u0003V\teC\u0003\u0002B\u0017\u0005/Bq!a\u0019\u001c\u0001\b\t)\u0007C\u0004\u0003\fm\u0001\rA!\u0004\u0002%\u0011,G.\u001a;f)\u0006\u0014G.Z\"p]R,g\u000e\u001e\u000b\u0005\u0005?\u0012\u0019\u0007\u0006\u0003\u0002`\n\u0005\u0004bBA29\u0001\u000f\u0011Q\r\u0005\b\u0005\u0017a\u0002\u0019\u0001B\u0007\u0003e!W\r\\3uKB+'/\\5tg&|gn\u00158baNDw\u000e^:\u0002\u000f\rdW-\u00198va\u00061A-\u001a7fi\u0016$BA!\f\u0003n!9!qN\u0010A\u0002\t5\u0011AA5e\u00039!W\r\\3uK\u0012+G.\u001b<fef$B!a8\u0003v!9!q\u000e\u0011A\u0002\t5\u0011a\u00043fY\u0016$X\rR1tQ\n|\u0017M\u001d3\u0015\t\u0005}'1\u0010\u0005\b\u0005_\n\u0003\u0019\u0001B\u0007\u0003II7o\u00127pE\u0006d7+\u001a;uS:<7/\u00133\u0015\t\t5\"\u0011\u0011\u0005\b\u0005_\u0012\u0003\u0019\u0001B\u0007\u00035!W\r\\3uKJ+G.Z1tKR!\u0011q\u001cBD\u0011\u001d\u0011yg\ta\u0001\u0005\u001b!BA!\f\u0003\f\"9!Q\u0012\u0013A\u0002\t=\u0015\u0001\u0002;fC6\u0004BA!%\u0003\u00186\u0011!1\u0013\u0006\u0004\u0005+\u0003\u0015A\u00023p[\u0006Lg.\u0003\u0003\u0003\u001a\nM%\u0001\u0002+fC6\f\u0011\u0003Z3mKR,gI]8n\u0003J\u001c\u0007.\u001b<f)\u0011\u0011yJ!*\u0011\t\u0005\u0005(\u0011U\u0005\u0005\u0005G\u000b\u0019OA\u0002J]RDqAa*&\u0001\u0004\u0011i!A\u0005sK2,\u0017m]3JI\u0006)b/\u001a:jMf\u0014V\r]8tSR|'/_\"mK\u0006t\u0017!C2pk:$(j\u001c2t)\t\u0011y*\u0001\u0007d_VtGOR8mI\u0016\u00148/A\td_VtG/\u00119qY&\u001c\u0017\r^5p]N\f\u0011bY8v]R\u0014vn^:\u0015\r\t}%q\u0017B]\u0011\u001d\u0011YA\u000ba\u0001\u0005\u001bAqAa/+\u0001\u0004\u0011i!\u0001\u0006d_2,XN\u001c(b[\u0016\f1cZ3u%\u0016l\u0017-\u001b8j]\u001e$U\r^1jYN$\u0002B!1\u0003Z\nm'q\u001c\t\u0007\u0005\u0007\u0014iMa5\u000f\t\t\u0015'\u0011\u001a\b\u0005\u0005'\u00119-\u0003\u0002\u0002f&!!1ZAr\u0003\u001d\u0001\u0018mY6bO\u0016LAAa4\u0003R\n\u00191+Z9\u000b\t\t-\u00171\u001d\t\t\u0003C\u0014)N!\u0004\u0003\u000e%!!q[Ar\u0005\u0019!V\u000f\u001d7fe!9!1B\u0016A\u0002\t5\u0001b\u0002BoW\u0001\u0007!QB\u0001\rS\u0012\u001cu\u000e\\;n]:\u000bW.\u001a\u0005\b\u0005C\\\u0003\u0019\u0001B\u0007\u0003=!\u0018\u000e\u001e7f\u0007>dW/\u001c8OC6,\u0017a\u0004<fe&4\u0017\u0010T3gi>4XM]:\u0015\u0019\u0005}'q\u001dBv\u0005[\u0014\tPa=\t\u000f\t%H\u00061\u0001\u0003\u000e\u00059Q.Z:tC\u001e,\u0007b\u0002B\u0006Y\u0001\u0007!Q\u0002\u0005\b\u0005_d\u0003\u0019\u0001B\u0007\u0003=\u0019w.\u001e8u\u0007>dW/\u001c8OC6,\u0007b\u0002BoY\u0001\u0007!Q\u0002\u0005\b\u0005Cd\u0003\u0019\u0001B\u0007\u0003i!Xm\u001d;ES\u0012tu\u000e^\"mK\u0006t\u0017I\u001a;fe&#8/\u001a7g)!\u0011IPa@\u0004\u0004\r\u001d\u0001cA)\u0003|&\u0019!Q !\u0003)Q+7\u000f^\"mK\u0006tW\u000f]#yG\u0016\u0004H/[8o\u0011\u001d\u0019\t!\fa\u0001\u0005\u001b\t\u0001\u0002^3ti:\u000bW.\u001a\u0005\b\u0007\u000bi\u0003\u0019\u0001Ba\u0003\u0019\t7\r^5wK\"91\u0011B\u0017A\u0002\t\u0005\u0017\u0001C1sG\"Lg/\u001a3\u0002\u001b\r|WO\u001c;SK2,\u0017m]3t\u00035\u0019w.\u001e8u)JLwmZ3sg\u0006Yr-\u001a;SK6\f\u0017N\\5oOR\u0013\u0018nZ4feN$U\r^1jYN$\"aa\u0005\u0011\r\t\r'Q\u001aB\u0007\u0003e9W\r\u001e*f[\u0006Lg.\u001b8h\r>dG-\u001a:EKR\f\u0017\u000e\\:\u0015\u0005\t\u0005\u0017aG4fiJ+W.Y5oS:<'+\u001a7fCN,7\u000fR3uC&d7/A\u0012hKR\u0014V-\\1j]&tw-\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:EKR\f\u0017\u000e\\:\u0002+\r|WO\u001c;Be\u000eD\u0017N^3e%\u0016dW-Y:fg\u0006I1\r\\3b]bcGI\u0019\u0015\u0004k\r\r\u0002\u0003BB\u0013\u0007[i!aa\n\u000b\t\u0005u4\u0011\u0006\u0006\u0003\u0007W\tqA[1lCJ$\u0018-\u0003\u0003\u00040\r\u001d\"A\u0003)sK\u0012+7\u000f\u001e:ps\u0006\u0011\u0012\r\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u+\t\u0019)\u0004E\u0002q\u0007oI1a!\u000fr\u0005I\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002-\u0005\u0004\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010^0%KF$B!a8\u0004@!I1\u0011I\u001c\u0002\u0002\u0003\u00071QG\u0001\u0004q\u0012\n\u0014aE1qa2L7-\u0019;j_:\u001cuN\u001c;fqR\u0004\u0003f\u0001\u001d\u0004HA!1\u0011JB'\u001b\t\u0019YE\u0003\u0003\u0002\u0006\u0006\r\u0018\u0002BB(\u0007\u0017\u0012ABQ3b]B\u0013x\u000e]3sif\fQcZ3u\u0003B\u0004H.[2bi&|gnQ8oi\u0016DH\u000f\u0006\u0002\u00046!\u001a\u0011ha\u0012\u0002+M,G/\u00119qY&\u001c\u0017\r^5p]\u000e{g\u000e^3yiR!\u0011q\\B.\u0011%\u0019\tEOA\u0001\u0002\u0004\u0019)\u0004K\u0002;\u0007\u000fB3\u0001AB1!\u0011\u0019\u0019g!\u001b\u000e\u0005\r\u0015$bAB4g\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\r-4Q\r\u0002\n\u0007>l\u0007o\u001c8f]RDs\u0001AB8\u0003\u0017\u001bI\b\u0005\u0003\u0004r\rUTBAB:\u0015\r\ti(]\u0005\u0005\u0007o\u001a\u0019HA\u0004Qe>4\u0017\u000e\\3-\u0005\rm\u0014EAB?\u0003=Ig\u000e^3he\u0006$\u0018n\u001c8UKN$\u0018\u0001E*rYN#xN]1hK\u001a\u000b7-\u00193f!\t\tFhE\u0002=\u0007\u000b\u0003B!!9\u0004\b&!1\u0011RAr\u0005\u0019\te.\u001f*fMR\u00111\u0011\u0011\u000b\u0005\u0007\u001f\u001b\u0019\n\u0006\u0003\u0003 \u000eE\u0005bBA2}\u0001\u0007\u0011Q\r\u0005\b\u0005Os\u0004\u0019\u0001B\u0007\u0001")
public class SqlStorageFacade
implements StorageFacade,
BeforeUpgrade,
TestAuthentication,
LiquibaseSupport,
ScalaSpringSupport,
ApplicationContextAware {
    private DataSource dataSource;
    private final FolderService folderService;
    private final FacetRepository facetRepository;
    private final SqlTeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    private final TriggerRepository triggerRepository;
    private final TaskPersistence taskPersistence;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;
    @Qualifier(value="reportingJdbcTemplate")
    private final JdbcTemplate reportingJdbcTemplate;
    private final String NL;
    private ApplicationContext applicationContext;
    private volatile boolean bitmap$0;

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> Map<String, T> springBeans(ClassTag<T> evidence$3) {
        return ScalaSpringSupport.springBeans$((ScalaSpringSupport)this, evidence$3);
    }

    public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
        return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
    }

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    public <T> T asAdmin(Function0<T> block) {
        return (T)TestAuthentication.asAdmin$((TestAuthentication)this, block);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    public Version xlReleaseVersion() {
        return Version.valueOf((String)"xl-release", (String)"0.0.0");
    }

    public void upgrade() {
        this.doUpgrade();
    }

    public RepositoryVersionService repositoryVersionService() {
        return null;
    }

    public void doUpgrade() {
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    @Override
    public long countRecordsInTable(String tableName) {
        return BoxesRunTime.unboxToLong((Object)this.jdbcTemplate.queryForObject("SELECT count(*) FROM " + tableName, Long.TYPE));
    }

    private void wipeOutArchiveDatabase() {
        if (this.isDbCleanupEnabled()) {
            DataSource reportingDataSource = (DataSource)this.springBean("reportingDataSource", ClassTag$.MODULE$.apply(DataSource.class));
            LiquibaseSupport reporting = new LiquibaseSupport(null, reportingDataSource){
                private final DataSource reportingDataSource$1;

                public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
                    return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
                }

                public DataSource dataSource() {
                    return this.reportingDataSource$1;
                }
                {
                    this.reportingDataSource$1 = reportingDataSource$1;
                    LiquibaseSupport.$init$((LiquibaseSupport)this);
                }
            };
            reporting.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutArchiveDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void wipeOutDatabase() {
        if (this.isDbCleanupEnabled() && this.isIntegrationTestProfileActive()) {
            this.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private boolean isDbCleanupEnabled() {
        String nodbcleanup = System.getProperty("nodbcleanup", "false");
        boolean isCleanupEnabled = !Boolean.parseBoolean(nodbcleanup);
        this.logger().info("Cleanup enabled: " + isCleanupEnabled);
        return isCleanupEnabled;
    }

    private boolean isIntegrationTestProfileActive() {
        return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])this.applicationContext().getEnvironment().getActiveProfiles()), (Object)"integrationTest");
    }

    private DataSource dataSource$lzycompute() {
        SqlStorageFacade sqlStorageFacade = this;
        synchronized (sqlStorageFacade) {
            if (!this.bitmap$0) {
                this.dataSource = (DataSource)this.springBean("xlrRepositoryDataSource", ClassTag$.MODULE$.Nothing());
                this.bitmap$0 = true;
            }
        }
        return this.dataSource;
    }

    public DataSource dataSource() {
        if (!this.bitmap$0) {
            return this.dataSource$lzycompute();
        }
        return this.dataSource;
    }

    private String NL() {
        return this.NL;
    }

    public boolean tableExists(String tableName, JdbcTemplate jdbcTemplate) {
        boolean bl;
        try {
            jdbcTemplate.queryForObject("SELECT count(*) FROM " + tableName, Long.TYPE);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void deleteTableContent(String tableName, JdbcTemplate jdbcTemplate) {
        if (this.tableExists(tableName, jdbcTemplate)) {
            this.logger().info("DELETING " + tableName);
            jdbcTemplate.execute("DELETE FROM " + tableName);
            return;
        }
    }

    @Override
    public void deletePermissionSnapshots() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.PERMISSION_SNAPSHOTS$.MODULE$.TABLE(), sqlJdbcTemplate);
    }

    @Override
    public void cleanup() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.DEPENDENCIES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASE_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.COMMENTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASKS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_ACTIVITY_LOGS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES_EXT$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISK_ASSESSMENTS", sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISKS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGER_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.ARTIFACTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASK_JOBS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASK_EXECUTIONS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.CATEGORIES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deletePermissionSnapshots();
        if (this.tableExists(Schema.PATHS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute("DELETE FROM " + Schema.PATHS$.MODULE$.TABLE() + " WHERE " + Schema.PATHS$.MODULE$.ANCESTOR_UID() + " <> " + FolderRow.Root$.MODULE$.uid() + " OR " + Schema.PATHS$.MODULE$.DESCENDANT_UID() + " <> " + FolderRow.Root$.MODULE$.uid());
        }
        if (this.tableExists(Schema.FOLDERS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute("UPDATE " + Schema.FOLDERS$.MODULE$.TABLE() + " SET " + Schema.FOLDERS$.MODULE$.SECURITY_UID() + " = " + FolderRow.Root$.MODULE$.uid());
            this.jdbcTemplate.execute("DELETE FROM " + Schema.FOLDERS$.MODULE$.TABLE() + " WHERE " + Schema.FOLDERS$.MODULE$.CI_UID() + " <> " + FolderRow.Root$.MODULE$.uid());
        }
        this.deleteTableContent(MetadataSchema.METADATA$.MODULE$.TABLE(), sqlJdbcTemplate);
        if (this.tableExists(Schema.USER_PROFILE$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute("DELETE FROM " + Schema.USER_PROFILE$.MODULE$.TABLE() + " WHERE " + Schema.USER_PROFILE$.MODULE$.USERNAME() + " <> 'admin'");
        }
        JdbcTemplate sqlJdbcTemplate2 = this.reportingJdbcTemplate;
        this.deleteTableContent(Schema.Archive$.ITSM_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.DEPLOYMENT_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.CODE_COMPLIANCE_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_TASKS_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_PHASES_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), sqlJdbcTemplate2);
    }

    @Override
    public boolean delete(String id) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            this.logger().trace("Deleting id " + id);
            if (Ids.isReleaseId((String)id)) {
                this.deleteRelease(id);
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id, (Integer)$this.taskPersistence.taskUidById(Ids.getParentId((String)id)).get());
            } else if (!Ids.isPlanItemId((String)id)) {
                if (Ids.isFolderId((String)id)) {
                    if ($this.folderService.exists(id)) {
                        $this.folderService.delete(id);
                    }
                } else if (Ids.isCustomConfigurationId((String)id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isCalendarId((String)id)) {
                    $this.calendarEntryRepository.delete(id);
                } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn("Variable '" + id + "' will be deleted once the parent release is deleted.");
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    if (Ids.isTriggerId((String)id)) {
                        $this.triggerRepository.delete(id);
                    } else if (Ids.isFacetId((String)id)) {
                        $this.facetRepository.delete(id, $this.facetRepository.delete$default$2());
                    } else if (Ids.isInRelease((String)id)) {
                        this.logger().warn("Id '" + id + "' will be deleted once the parent release or template is deleted.");
                    } else if (Ids.isDeliveryId((String)id)) {
                        this.deleteDelivery(id);
                    } else if (Ids.isDashboardId((String)id)) {
                        this.deleteDashboard(id);
                    } else if (!this.isGlobalSettingsId(id)) {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                    }
                }
            }
            return true;
        });
        if (try_ instanceof Success) {
            this.logger().warn("Deleted " + id);
            return true;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                this.logger().error("Unable to delete CI with Id: `" + id + "` as it was not found");
                return true;
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            this.logger().error("Unable to delete CI with Id: `" + id + "`", e);
            return false;
        }
        throw new MatchError((Object)try_);
    }

    public void deleteDelivery(String id) {
        this.jdbcTemplate.execute("DELETE FROM XLR_DELIVERIES WHERE ID = '" + Ids.getName((String)id) + "'");
    }

    public void deleteDashboard(String id) {
        this.jdbcTemplate.execute("DELETE FROM XLR_DASHBOARDS WHERE ID = '" + Ids.getName((String)id) + "'");
    }

    private boolean isGlobalSettingsId(String id) {
        String shortId = Ids.getName((String)id);
        return shortId.startsWith("EmailNotificationSettings");
    }

    public void deleteRelease(String id) {
        this.logger().info("Deleting release {}", (Object)id);
        boolean found = false;
        if (this.releaseRepository.exists(id)) {
            this.logger().info("Release {} found in repository", (Object)id);
            try {
                this.teamRepository.deleteTeamsFromPlatform(id);
            }
            catch (NotFoundException e) {
                this.logger().warn("Could not delete teams of " + id, (Throwable)e);
            }
            this.releaseRepository.delete(id, false);
            found = true;
        }
        if (this.archivingService.exists(id)) {
            this.logger().info("Release {} found in archive", (Object)id);
            this.deleteFromArchive(id);
            found = true;
        }
        if (this.archivingService.existsPreArchived(id)) {
            this.logger().info("Release {} found as pre-archived", (Object)id);
            this.deleteFromArchive(id);
            found = true;
        }
        if (!found) {
            this.logger().error("Release {} not found neither in repository nor in archive (including pre-archived releases)", (Object)id);
            return;
        }
    }

    @Override
    public boolean delete(Team team) {
        this.logger().trace("Deleting team " + team.getId());
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            return true;
        }
        return false;
    }

    @Override
    public int deleteFromArchive(String releaseId) {
        return SqlStorageFacade$.MODULE$.deleteFromArchive(releaseId, this.reportingJdbcTemplate);
    }

    @Override
    public void verifyRepositoryClean() {
        String testName;
        String string = testName = MDC.get((String)"testName") != null ? MDC.get((String)"testName") + ": " : "";
        if (this.countReleases() > 0 || this.countArchivedReleases() > 0) {
            throw this.testDidNotCleanAfterItself(testName, this.getRemainingReleasesDetails(), this.getRemainingArchivedReleasesDetails());
        }
        int triggerCount = this.countTriggers();
        if (triggerCount > 0) {
            throw new TestCleanupException(testName + "Found " + triggerCount + " remaining triggers in database:" + this.NL() + this.getRemainingTriggersDetails().mkString(this.NL()));
        }
        if (this.countFolders() > 1) {
            Seq folders = (Seq)this.getRemainingFolderDetails().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        String id = (String)A1._1();
                        String path = (String)A1._2();
                        return (B1)(id + " -> " + path);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<String, String> x1) {
                    Tuple2<String, String> tuple2 = x1;
                    return tuple2 != null;
                }
            });
            throw new TestCleanupException(testName + "There are leftover folders: " + folders);
        }
        int jobsCount = this.countJobs();
        if (jobsCount > 0) {
            Seq jobs = (Seq)this.getRemainingDetails(Schema.TASK_JOBS$.MODULE$.TABLE(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.TASK_ID()).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                    A1 A1 = x$1;
                    return (B1)x$1._2();
                }

                public final boolean isDefinedAt(Tuple2<String, String> x$1) {
                    Tuple2<String, String> tuple2 = x$1;
                    return true;
                }
            });
            throw new TestCleanupException(testName + "There are leftover jobs: " + jobs);
        }
        this.verifyLeftovers(testName + "There are leftover applications", "XLR_APPLICATIONS", "CI_UID", "ID", "TITLE");
        this.verifyLeftovers(testName + "There are leftover environments", "XLR_ENVIRONMENTS", "CI_UID", "ID", "TITLE");
        this.verifyLeftovers(testName + "There are leftover jobs", Schema.TASK_JOBS$.MODULE$.TABLE(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.ID(), Schema.TASK_JOBS$.MODULE$.TASK_ID());
    }

    private int countJobs() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(1) FROM " + Schema.TASK_JOBS$.MODULE$.TABLE(), (rs, x$2) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countFolders() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(" + Schema.FOLDERS$.MODULE$.CI_UID() + ") FROM " + Schema.FOLDERS$.MODULE$.TABLE(), (rs, x$3) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countApplications() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(CI_UID) FROM XLR_APPLICATIONS", (rs, x$4) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countRows(String tableName, String columnName) {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(" + columnName + ") FROM " + tableName, (rs, x$5) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<Tuple2<String, String>> getRemainingDetails(String tableName, String idColumnName, String titleColumnName) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query("SELECT " + idColumnName + ", " + titleColumnName + " FROM " + tableName, (rs, x$6) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private void verifyLeftovers(String message, String tableName, String countColumnName, String idColumnName, String titleColumnName) {
        int count = this.countRows(tableName, countColumnName);
        if (count > 1) {
            Seq<Tuple2<String, String>> leftOvers = this.getRemainingDetails(tableName, idColumnName, titleColumnName);
            throw new TestCleanupException(message + ": " + leftOvers);
        }
    }

    private TestCleanupException testDidNotCleanAfterItself(String testName, Seq<Tuple2<String, String>> active, Seq<Tuple2<String, String>> archived) {
        int numActive = active.size();
        int numArchived = archived.size();
        int numTotal = numActive + numArchived;
        return new TestCleanupException(testName + "Found " + numTotal + " remaining releases (" + numActive + " from database and " + numArchived + " from archive):\n" + SqlStorageFacade.all$1(active, archived));
    }

    private int countReleases() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(" + Schema.RELEASES$.MODULE$.CI_UID() + ") FROM " + Schema.RELEASES$.MODULE$.TABLE(), (rs, x$7) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countTriggers() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject("SELECT COUNT(" + Schema.TRIGGERS$.MODULE$.CI_UID() + ") FROM " + Schema.TRIGGERS$.MODULE$.TABLE(), (rs, x$8) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<String> getRemainingTriggersDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query("SELECT " + Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE() + ", " + Schema.TRIGGERS$.MODULE$.ID() + " FROM " + Schema.TRIGGERS$.MODULE$.TABLE(), (rs, x$9) -> "Trigger: " + rs.getString(1) + " with id: " + rs.getString(2))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingFolderDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query("SELECT " + Schema.FOLDERS$.MODULE$.FOLDER_ID() + ", " + Schema.FOLDERS$.MODULE$.FOLDER_PATH() + " FROM " + Schema.FOLDERS$.MODULE$.TABLE(), (rs, x$10) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate.query("SELECT " + Schema.RELEASES$.MODULE$.RELEASE_ID() + ", " + Schema.RELEASES$.MODULE$.RELEASE_TITLE() + " FROM " + Schema.RELEASES$.MODULE$.TABLE(), (rs, x$11) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingArchivedReleasesDetails() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.reportingJdbcTemplate.query("SELECT " + ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN() + ", " + ArchivedReleases$.MODULE$.REPORT_RELEASES_TITLE_COLUMN() + " FROM " + ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), (rs, x$12) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala().toSeq();
    }

    private int countArchivedReleases() {
        return BoxesRunTime.unboxToInt((Object)this.reportingJdbcTemplate.queryForObject("SELECT COUNT(" + ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN() + ") FROM " + ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), (rs, x$13) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    @PreDestroy
    public void cleanXlDb() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent("XL_VERSION", sqlJdbcTemplate);
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        this.applicationContext = x$1;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext();
    }

    public void setApplicationContext(ApplicationContext x$1) {
        this.applicationContext_$eq(x$1);
    }

    public static final /* synthetic */ void $anonfun$wipeOutArchiveDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out reporting database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$wipeOutDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out repository database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    private static final String showEntry$1(String tag, Tuple2 entry) {
        Tuple2 tuple2 = entry;
        if (tuple2 != null) {
            String id = (String)tuple2._1();
            String title = (String)tuple2._2();
            return id + " -> '" + title + "' (" + tag + ")";
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String all$1(Seq active$1, Seq archived$1) {
        return ((IterableOnceOps)((IterableOps)active$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("active", entry))).$plus$plus((IterableOnce)archived$1.map((Function1 & Serializable)entry -> SqlStorageFacade.showEntry$1("archive", entry)))).mkString("", "\n * ", "\n");
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, FacetRepository facetRepository, SqlTeamRepository teamRepository, ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, TriggerRepository triggerRepository, TaskPersistence taskPersistence, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate) {
        this.folderService = folderService;
        this.facetRepository = facetRepository;
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.triggerRepository = triggerRepository;
        this.taskPersistence = taskPersistence;
        this.jdbcTemplate = jdbcTemplate;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        BeforeUpgrade.$init$((BeforeUpgrade)this);
        TestAuthentication.$init$((TestAuthentication)this);
        LiquibaseSupport.$init$((LiquibaseSupport)this);
        ScalaSpringSupport.$init$((ScalaSpringSupport)this);
        this.NL = System.lineSeparator();
    }
}

