/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.utils.BaseConditionAwaiter;
import com.xebialabs.xlrelease.utils.CleanupAwaiter;
import com.xebialabs.xlrelease.utils.CollectingMatchingAwaiter;
import com.xebialabs.xlrelease.utils.EventsAwaiter;
import com.xebialabs.xlrelease.utils.MatchingAwaiter;
import com.xebialabs.xlrelease.utils.PickingAwaiter;
import com.xebialabs.xlrelease.utils.PlanItemStatusAwaiter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import scala.Option;
import scala.PartialFunction;

public class ConditionBuilder<R> {
    private final XLReleaseEventBus eventBus;
    private final Supplier<R> runnable;
    private long timeout = 45000L;
    public static final long DEFAULT_TIMEOUT = 45000L;

    private ConditionBuilder(XLReleaseEventBus eventBus, Supplier<R> runnable) {
        this.eventBus = eventBus;
        this.runnable = runnable;
    }

    public ConditionBuilder<R> withTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    public static <R> ConditionBuilder<R> execute(XLReleaseEventBus eventBus, Supplier<R> runnable) {
        return new ConditionBuilder<R>(eventBus, runnable);
    }

    public <S> R until(String planItemId, List<S> statuses) throws InterruptedException, TimeoutException {
        return this.until(planItemId, statuses, this.getTimeout());
    }

    public <S> R until(String planItemId, List<S> statuses, long timeout) throws InterruptedException, TimeoutException {
        return this.until(() -> new PlanItemStatusAwaiter(this.eventBus, planItemId, statuses, timeout));
    }

    public <S> R until(String planItemId, S ... statuses) throws InterruptedException, TimeoutException {
        return this.until(planItemId, this.getTimeout(), statuses);
    }

    public R until(long timeout, XLReleaseEvent ... eventsInOccurrenceOrder) throws InterruptedException, TimeoutException {
        return this.until(() -> EventsAwaiter.create(this.eventBus, Arrays.asList(eventsInOccurrenceOrder), timeout, EventsAwaiter.VerificationMode.EVENTS_IN_ORDER));
    }

    public <S> R until(String planItemId, long timeout, S ... statuses) throws InterruptedException, TimeoutException {
        return this.until(planItemId, Arrays.asList(statuses), timeout);
    }

    public R until(XLReleaseEvent ... eventsInOccurrenceOrder) throws InterruptedException, TimeoutException {
        return this.until(() -> EventsAwaiter.create(this.eventBus, Arrays.asList(eventsInOccurrenceOrder), this.getTimeout(), EventsAwaiter.VerificationMode.EVENTS_IN_ORDER));
    }

    public R untilInAnyOrder(XLReleaseEvent ... events) throws InterruptedException, TimeoutException {
        return this.until(() -> EventsAwaiter.create(this.eventBus, Arrays.asList(events), this.getTimeout(), EventsAwaiter.VerificationMode.EVENTS_IN_ANY_ORDER));
    }

    public R untilAnyOf(XLReleaseEvent ... events) throws InterruptedException, TimeoutException {
        return this.until(() -> EventsAwaiter.create(this.eventBus, Arrays.asList(events), this.getTimeout(), EventsAwaiter.VerificationMode.ANY_OF_EVENTS));
    }

    public R until(long timeout, PartialFunction<XLReleaseEvent, MatchingAwaiter.MatcherEvent> ... matchers) throws TimeoutException, InterruptedException {
        return this.until(() -> MatchingAwaiter.apply(this.eventBus, timeout, matchers));
    }

    public R until(PartialFunction<XLReleaseEvent, MatchingAwaiter.MatcherEvent> ... matchers) throws TimeoutException, InterruptedException {
        return this.until(() -> MatchingAwaiter.apply(this.eventBus, this.getTimeout(), matchers));
    }

    public R never(PartialFunction<XLReleaseEvent, MatchingAwaiter.MatcherEvent> ... matchers) throws TimeoutException, InterruptedException {
        return this.never(() -> MatchingAwaiter.apply(this.eventBus, this.getTimeout(), matchers));
    }

    public List<XLReleaseEvent> collect(PartialFunction<XLReleaseEvent, MatchingAwaiter.MatcherEvent> ... matchers) throws TimeoutException, InterruptedException {
        return this.collect(() -> CollectingMatchingAwaiter.apply(this.eventBus, this.getTimeout(), matchers));
    }

    public CleanupAwaiter listen() {
        CleanupAwaiter awaiter = new CleanupAwaiter(this.eventBus, this.getTimeout());
        awaiter.startListening();
        return awaiter;
    }

    public <T> Option<T> pick(PartialFunction<XLReleaseEvent, Option<T>> picker) throws TimeoutException, InterruptedException {
        try (PickingAwaiter<T> condition = new PickingAwaiter<T>(this.eventBus, this.getTimeout(), picker);){
            condition.startListening();
            R result = this.runnable.get();
            Option<T> option = condition.get();
            return option;
        }
    }

    private R until(Supplier<BaseConditionAwaiter> conditionSupplier) throws InterruptedException, TimeoutException {
        try (BaseConditionAwaiter condition = conditionSupplier.get();){
            condition.startListening();
            R result = this.runnable.get();
            condition.await();
            R r = result;
            return r;
        }
    }

    private List<XLReleaseEvent> collect(Supplier<BaseConditionAwaiter> conditionSupplier) throws InterruptedException, TimeoutException {
        try (BaseConditionAwaiter condition = conditionSupplier.get();){
            condition.startListening();
            this.runnable.get();
            condition.sleep();
            List<XLReleaseEvent> list = condition.getMatchedEvents();
            return list;
        }
    }

    private R never(Supplier<BaseConditionAwaiter> conditionSupplier) throws InterruptedException, TimeoutException {
        try (BaseConditionAwaiter condition = conditionSupplier.get();){
            condition.startListening();
            R result = this.runnable.get();
            condition.never();
            R r = result;
            return r;
        }
    }
}

