package com.xebialabs.xlrelease;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RetryRule implements TestRule {
    private int retryCount;

    public RetryRule (int retryCount) {
        this.retryCount = retryCount;
    }

    public Statement apply(Statement base, Description description) {
        return statement(base, description);
    }

    private Statement statement(final Statement base, final Description description) {
        return new Statement() {
            @Override
            public void evaluate() throws Throwable {
                for (int attempt = 0; attempt < retryCount; attempt++) {
                    try {
                        base.evaluate();
                        return;
                    } catch (Throwable t) {
                        if (attempt == retryCount - 1 || description.getAnnotation(Retry.class) == null) {
                            throw t;
                        }
                    }
                }
            }
        };
    }
}