/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.XLReleaseTest;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestCleanupException;
import com.xebialabs.xlrelease.TestConfig;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.utils.ReleaseActorLifecycleUtils;
import com.xebialabs.xlrelease.actors.utils.TriggerActorLifecycleUtils;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.CreatedWithoutTemplate;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseFailedEvent;
import com.xebialabs.xlrelease.domain.events.TaskAbortedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskFailedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.GateConditionRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.UserProfileRepository;
import com.xebialabs.xlrelease.repository.UserTokenRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.rules.LoginRule;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.sql.snapshots.service.PermissionsSnapshotService;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.service.FacetService;
import com.xebialabs.xlrelease.service.FeatureService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.PreArchiveService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.spring.configuration.XlrBooterInitializer;
import com.xebialabs.xlrelease.spring.configuration.XlrWebApplicationInitializer;
import com.xebialabs.xlrelease.utils.ConditionBuilder;
import com.xebialabs.xlrelease.utils.Eventually;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.AnnotationFormatError;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.util.InMemoryResource;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.rules.SpringClassRule;
import org.springframework.test.context.junit4.rules.SpringMethodRule;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.javaapi.CollectionConverters;

@RunWith(value=JUnit4.class)
@ContextConfiguration(classes={TestConfig.class}, initializers={XlrWebApplicationInitializer.class, XlrBooterInitializer.class})
@WebAppConfiguration(value="src/test/resources")
@ActiveProfiles(value={"integrationTest"})
public abstract class XLReleaseIntegrationTest
extends XLReleaseTest
implements ApplicationContextAware {
    private static final org.slf4j.Logger logger;
    protected ApplicationContext applicationContext;
    @ClassRule
    public static final SpringClassRule SPRING_CLASS_RULE;
    @Rule
    public final SpringMethodRule springMethodRule = new SpringMethodRule();
    protected List<String> cisForDeletion = new ArrayList<String>();
    private List<Team> teamsForDeletion = new ArrayList<Team>();
    private List<String> cisToUnmark = new ArrayList<String>();
    private List<AutoCloseable> closeablesToClose = new ArrayList<AutoCloseable>();
    @Autowired
    public FolderService folderService;
    @Autowired
    public GateConditionRepository gateConditionRepository;
    @Autowired
    public CommentRepository commentRepository;
    @Autowired
    public ConfigurationService configurationService;
    @Autowired
    public ReleaseService releaseService;
    @Autowired
    public ReleaseRepository releaseRepository;
    @Autowired
    public TriggerRepository triggerRepository;
    @Autowired
    public PhaseRepository phaseRepository;
    @Autowired
    public PlanItemRepository planItemRepository;
    @Autowired
    public UserProfileRepository userProfileRepository;
    @Autowired
    public Eventually eventually;
    @Autowired
    public TeamService teamService;
    @Autowired
    public PermissionsSnapshotService permissionsSnapshotService;
    @Autowired
    public FacetService facetService;
    @Autowired
    public FolderPersistence folderPersistence;
    @Autowired
    public PermissionEditor permissionEditor;
    @Autowired
    private RoleService roleService;
    @Autowired
    protected ReleaseActorLifecycleUtils releaseActorLifecycleUtils;
    @Autowired
    protected TriggerActorLifecycleUtils triggerActorLifecycleUtils;
    @Autowired
    private VariableService variableService;
    @Autowired
    protected ArchivedReleases archivedReleases;
    @Autowired
    protected ArchivingService archivingService;
    @Autowired
    public StorageFacade storageFacade;
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    protected ConfigurationRepository configurationRepository;
    @Autowired(required=false)
    protected List<FeatureService> featureServices = new ArrayList<FeatureService>();
    @Qualifier(value="xlrRepositoryTransactionManager")
    @Autowired
    protected PlatformTransactionManager txManager;
    @Qualifier(value="reportingJdbcTemplate")
    @Autowired
    protected JdbcTemplate reportingJdbcTemplate;
    @Autowired
    private ArchivingSettingsManager archivingSettings;
    @Autowired
    private ReleaseActorService releaseActorService;
    @Autowired
    private XLReleaseEventBus xlrEventBus;
    @Autowired
    private PreArchiveService preArchiveService;
    @Autowired
    public UserTokenService userTokenService;
    @Autowired
    public UserTokenRepository userTokenRepository;
    @Autowired
    private List<CacheManager> cacheManagers;
    @Rule
    public TestName testName = new TestName();

    private static String dbUrl(String defaultUrl, String newDatabaseName, String databaseName) {
        return defaultUrl.replace(databaseName, newDatabaseName).replace(databaseName.toUpperCase(), newDatabaseName.toUpperCase());
    }

    private static String dbUsername(String defaultUsername, String newUsername) {
        if (System.getProperty("xl.database.db-url").contains("db2")) {
            return defaultUsername;
        }
        return newUsername;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean dbUserExists(String repositoryUrl, String user, String pass) {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("user", XLReleaseIntegrationTest.dbUsername("xlrelease", user));
        connectionProperties.setProperty("password", pass);
        String newRepositoryUrl = XLReleaseIntegrationTest.dbUrl(repositoryUrl, user, "xlrelease");
        try (Connection connection = DriverManager.getConnection(newRepositoryUrl, connectionProperties);){
            if (repositoryUrl.contains("db2")) {
                try (Statement statement = connection.createStatement();){
                    boolean bl;
                    block22: {
                        String query = "SELECT 1 FROM SYSIBM.SQLSCHEMAS WHERE TABLE_SCHEM like UPPER('" + user + "')";
                        statement.execute(query);
                        ResultSet rs = statement.getResultSet();
                        try {
                            boolean res;
                            bl = res = rs.next();
                            if (rs == null) break block22;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("Unable to check if user {} exists", (Object)user, (Object)ex);
            return false;
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected boolean featureServicesEnabled() {
        return true;
    }

    protected boolean isRelaxedTest() {
        return false;
    }

    protected boolean workDirVerificationEnabled() {
        return false;
    }

    public List<String> getCisForDeletion() {
        return this.cisForDeletion;
    }

    public XLReleaseEventBus eventBus() {
        return this.xlrEventBus;
    }

    @Before
    public void before() {
        String className = ((Object)((Object)this)).getClass().getSimpleName();
        Assert.assertTrue((String)"Integration tests must end with 'IntegrationTest' or 'Documentation'", (className.endsWith("IntegrationTest") || className.endsWith("Documentation") ? 1 : 0) != 0);
        this.withAdmin(() -> {
            logger.debug("XLReleaseIntegrationTest 'before' started");
            if (StringUtils.hasText((String)this.testName.getMethodName())) {
                MDC.put((String)"testName", (String)this.testName.getMethodName());
            }
            XLReleasePermissions.init();
            if (this.featureServicesEnabled()) {
                this.featureServices.forEach(this.safeRun(FeatureService::start));
            } else {
                this.featureServices.forEach(this.safeRun(FeatureService::stop));
            }
            this.archivingSettings.setEnabled(Boolean.valueOf(true));
            this.enablePrearchive();
            LoginRule.grantAdminPermissionTo((String)"admin", (PermissionEditor)this.permissionEditor, (RoleService)this.roleService);
            this.variableService.findGlobalVariablesOrEmpty().getVariables().forEach(ci -> this.variableService.deleteGlobalVariable(ci.getId()));
            try {
                this.folderService.delete("Applications/FolderDefaultReleaseContent");
            }
            catch (NotFoundException nfe) {
                logger.debug("Can't find default content folder");
            }
            this.terminateTriggerActors();
            this.terminateReleaseActors(FiniteDuration.apply((long)5L, (TimeUnit)TimeUnit.SECONDS));
            this.storageFacade.verifyRepositoryClean();
            logger.debug("XLReleaseIntegrationTest 'before' finished");
            return null;
        });
    }

    private Consumer<? super FeatureService> safeRun(Consumer<? super FeatureService> action) {
        return featureService -> {
            try {
                action.accept((FeatureService)featureService);
            }
            catch (Exception ex) {
                logger.error("Unable to run feature action on {}", (Object)featureService.serviceName(), (Object)ex);
            }
        };
    }

    private void disablePrearchive() {
        this.xlrEventBus.deregister((Object)this.preArchiveService);
    }

    private void enablePrearchive() {
        this.xlrEventBus.register((Object)this.preArchiveService);
    }

    @After
    public void tearDown() throws Exception {
        this.withAdmin(() -> {
            this.featureServices.forEach(this.safeRun(FeatureService::stop));
            this.disablePrearchive();
            this.archivingSettings.setEnabled(Boolean.valueOf(false));
            this.waitForEventBusToBecomeEmpty();
            for (AutoCloseable closeable : this.closeablesToClose) {
                closeable.close();
            }
            try {
                logger.debug("XLReleaseIntegrationTest 'tearDown' started");
                this.abortRunningReleases();
                this.terminateTriggerActors();
                this.cisForDeletion.stream().filter(Ids::isReleaseId).forEach(this::abortReleaseIfNecessary);
                this.terminateReleaseActors(FiniteDuration.apply((long)15L, (TimeUnit)TimeUnit.SECONDS));
                this.deleteCis();
                if (this.isRelaxedTest()) {
                    this.storageFacade.cleanup();
                }
                this.storageFacade.verifyRepositoryClean();
                this.deleteArchivedReleases();
                if (this.workDirVerificationEnabled()) {
                    this.verifyWorkdirClean();
                }
                logger.debug("XLReleaseIntegrationTest 'tearDown' finished");
            }
            catch (Throwable t) {
                logger.error("Test '{}' tearDown failed.", (Object)MDC.get((String)"testName"), (Object)t);
                throw new AnnotationFormatError(t);
            }
            finally {
                this.cisForDeletion.clear();
                this.teamsForDeletion.clear();
                if (StringUtils.hasText((String)this.testName.getMethodName())) {
                    MDC.remove((String)"testName");
                }
                try {
                    this.storageFacade.cleanup();
                }
                catch (Throwable t) {
                    logger.error("Unable to cleanup database", t);
                    throw new AnnotationFormatError(t);
                }
            }
            return null;
        });
        this.invalidateCaches();
    }

    private void invalidateCaches() {
        for (CacheManager cm : this.cacheManagers) {
            for (String cacheName : cm.getCacheNames()) {
                cm.getCache(cacheName).invalidate();
            }
        }
    }

    private void waitForEventBusToBecomeEmpty() {
        logger.info("waiting for event bus to become empty");
        RetryTemplate retry = RetryTemplate.builder().fixedBackoff(50L).maxAttempts(15).build();
        retry.execute(context -> {
            if (this.xlrEventBus.hasPendingMessages()) {
                throw new IllegalStateException("Attempt " + context.getRetryCount());
            }
            return null;
        });
        logger.info("event bus considered empty");
    }

    private void terminateTriggerActors() {
        try {
            this.triggerActorLifecycleUtils.terminateAllTriggerActors();
        }
        catch (Exception ex) {
            logger.error("Failed while terminating trigger actors", (Throwable)ex);
        }
    }

    private void terminateReleaseActors(FiniteDuration apply) {
        try {
            this.releaseActorLifecycleUtils.terminateAllReleaseActorsAndAwait(apply);
        }
        catch (Exception ex) {
            logger.error("Timed out while terminating actors, try increasing the timeout", (Throwable)ex);
        }
    }

    private void deleteArchivedReleases() {
        this.reportingJdbcTemplate.execute("DELETE FROM RELEASES");
    }

    protected void verifyRepositoryClean() {
        this.storageFacade.verifyRepositoryClean();
    }

    protected void verifyWorkdirClean() {
        String workDir = XlrConfig.getInstance().repository().workDir();
        String userDir = System.getProperty("user.dir");
        Path workDirPath = Paths.get(userDir, workDir);
        if (!XLReleaseIntegrationTest.isDirEmpty(workDirPath)) {
            String content = "";
            try (Stream<Path> files = Files.list(workDirPath);){
                content = files.map(Path::toString).collect(Collectors.joining(",", "\n", ""));
            }
            catch (IOException e) {
                logger.warn("Unexpected exception", (Throwable)e);
            }
            XLReleaseIntegrationTest.deleteDirContent(workDirPath);
            throw new TestCleanupException(String.valueOf(workDirPath) + " was not empty (content will be deleted): " + content);
        }
    }

    private static void deleteDirContent(Path directory) {
        try (DirectoryStream<Path> entries = Files.newDirectoryStream(directory);){
            for (Path entry : entries) {
                if (entry.toFile().isDirectory()) {
                    XLReleaseIntegrationTest.deleteDirContent(entry);
                }
                Files.deleteIfExists(entry);
            }
        }
        catch (IOException e) {
            logger.error("Unexpected exception while deleting content of" + String.valueOf(directory), (Throwable)e);
        }
    }

    private static boolean isDirEmpty(Path directory) {
        boolean bl;
        block8: {
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);
            try {
                boolean bl2 = bl = !dirStream.iterator().hasNext();
                if (dirStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dirStream != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TestCleanupException("Unexpected exception", e);
                }
            }
            dirStream.close();
        }
        return bl;
    }

    private void deleteCis() {
        DefaultTransactionDefinition txDef = new DefaultTransactionDefinition();
        txDef.setName("deleteCisTx");
        txDef.setPropagationBehavior(3);
        txDef.setIsolationLevel(2);
        TransactionTemplate template = new TransactionTemplate(this.txManager, (TransactionDefinition)txDef);
        template.execute(transaction -> {
            try {
                this.teamsForDeletion.stream().distinct().collect(Collectors.toList()).removeIf(t -> this.storageFacade.delete((Team)t));
                this.cisForDeletion = this.cisForDeletion.stream().distinct().collect(Collectors.toList());
                this.cisForDeletion.removeAll(this.cisToUnmark);
                this.cisForDeletion.removeIf(id -> Ids.isTriggerId((String)id) && this.storageFacade.delete((String)id));
                this.cisForDeletion.removeIf(id -> Ids.isDependencyId((String)id) && this.storageFacade.delete((String)id));
                this.cisForDeletion.removeIf(id -> this.isPhaseOrTask((String)id) && this.storageFacade.delete((String)id));
                this.cisForDeletion.removeIf(id -> Ids.isTeamId((String)id) && this.storageFacade.delete((String)id));
                this.cisForDeletion.removeIf(id -> Ids.isReleaseId((String)id) && this.storageFacade.delete((String)id));
                this.cisForDeletion.removeIf(id -> Ids.isConfigurationId((String)id) && this.storageFacade.delete((String)id));
                this.cisForDeletion.removeIf(id -> !Ids.isReleaseId((String)id) && !Ids.isConfigurationId((String)id) && !Ids.isFolderId((String)id) && this.storageFacade.delete((String)id));
                this.cisForDeletion.removeIf(id -> Ids.isFolderId((String)id) && this.storageFacade.delete((String)id));
                this.cisForDeletion.removeIf(id -> Ids.isFacetId((String)id) && this.storageFacade.delete((String)id));
                return null;
            }
            catch (Exception e) {
                logger.info("Transaction failed because", (Throwable)e);
                throw e;
            }
        });
    }

    private void abortRunningReleases() {
        Seq releasesToAbort = this.releaseRepository.findIdsByKindAndStatus(CollectionConverters.asScala(List.of(ReleaseKind.RELEASE, ReleaseKind.WORKFLOW)).toSeq(), CollectionConverters.asScala(Arrays.stream(ReleaseStatus.ACTIVE_STATUSES).collect(Collectors.toList())).toSeq());
        if (!(releasesToAbort = ((Iterable)releasesToAbort.filter(releaseId -> !this.abortReleaseIfNecessary((String)releaseId))).toSeq()).isEmpty()) {
            throw new AnnotationFormatError("Unable to abort releases, this can cause odd effects in next test, thus crashing here");
        }
    }

    private boolean abortReleaseIfNecessary(String releaseId) {
        ReleaseStatus releaseStatus = this.releaseRepository.getStatus(releaseId);
        if (releaseStatus != null && releaseStatus.isActive()) {
            int abortAttempts = 5;
            long abortBackoff = 1000L;
            for (int attempt = 0; attempt < abortAttempts; ++attempt) {
                if (attempt > 0) {
                    try {
                        Thread.sleep(abortBackoff);
                        abortBackoff *= 2L;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    this.releaseActorService.abortRelease(releaseId, "aborted by test tearDown");
                    return true;
                }
                catch (Exception ex) {
                    logger.warn("Unable to abort release '{}'", (Object)releaseId, (Object)ex);
                    this.abortAllTasks(releaseId);
                    continue;
                }
            }
            return false;
        }
        return true;
    }

    private void abortAllTasks(String releaseId) {
        try {
            Release release = this.releaseService.findById(releaseId);
            release.getAllTasks().stream().filter(this::abortableTask).forEach(this::abortTask);
        }
        catch (Exception ex) {
            logger.warn("Unable to load release {}. Probably it was already deleted.", (Object)releaseId, (Object)ex);
        }
    }

    private void abortTask(Task t) {
        try {
            String msg = "aborted by tearDown";
            ConditionBuilder.execute(this.xlrEventBus, () -> this.releaseActorService.abortTask(t.getId(), msg)).untilAnyOf(new XLReleaseEvent[]{new TaskCompletedEvent(t, false), new TaskAbortedEvent(t), new TaskFailedEvent(t, msg), new ReleaseFailedEvent(t.getRelease())});
        }
        catch (Exception ex) {
            logger.warn("Unable to abort task '{}'", (Object)t.getId(), (Object)ex);
        }
    }

    private boolean abortableTask(Task task) {
        return task.isInProgress() && task instanceof BaseScriptTask;
    }

    private boolean isPhaseOrTask(String id) {
        return Ids.isPlanItemId((String)id) && !Ids.isReleaseId((String)id);
    }

    protected void deleteOnTearDown(ConfigurationItem ... items) {
        for (ConfigurationItem item : items) {
            this.deleteOnTearDown(item.getId());
        }
    }

    protected void deleteOnTearDown(String ... ids) {
        Collections.addAll(this.cisForDeletion, ids);
    }

    public void markForDeletion(ConfigurationItem item) {
        this.markForDeletion(item.getId());
    }

    public void markForDeletion(String ciId) {
        logger.info("Marking for deletion: '{}'", (Object)ciId);
        this.cisForDeletion.add(ciId);
    }

    public void markForDeletion(Team team) {
        this.teamsForDeletion.add(team);
    }

    public void unmarkForDeletion(String id) {
        this.cisToUnmark.add(id);
        this.teamsForDeletion.removeIf(team -> id.equals(team.getId()));
    }

    public void deleteOrder(ConfigurationItem ... items) {
        this.cisForDeletion = Stream.concat(Arrays.stream(items).map(ConfigurationItem::getId), this.cisForDeletion.stream()).collect(Collectors.toList());
    }

    public void deleteRelease(List<String> releaseIds) {
        releaseIds.forEach(this::deleteRelease);
    }

    public void deleteRelease(String ... releaseIds) {
        this.deleteRelease(Arrays.asList(releaseIds));
    }

    public void deleteRelease(String releaseId) {
        this.releaseRepository.delete(releaseId, false);
    }

    public void storeRelease(Release ... releases) {
        this.storeRelease(Arrays.asList(releases));
    }

    public void storeRelease(List<Release> releases) {
        releases.forEach(this::storeRelease);
    }

    public Release insertArchivedRelease(Release release, String releaseJson, String activityLogs) {
        this.archivedReleases.insert(release, releaseJson, activityLogs, false);
        this.markForDeletion((ConfigurationItem)release);
        return release;
    }

    public Release archiveRelease(Release release) {
        this.storeRelease(release);
        this.preArchiveAndArchiveRelease(release);
        return release;
    }

    public Release preArchiveAndArchiveRelease(Release release) {
        this.archivingService.preArchiveRelease(release);
        this.archivingService.archiveRelease(release.getId());
        return release;
    }

    public int deleteFromArchive(String releaseId) {
        return this.storageFacade.deleteFromArchive(releaseId);
    }

    public void storeChanges(Changes changes) {
        changes.getUpdatedItems().stream().filter(ci -> ci.getType().equals((Object)Type.valueOf(Release.class))).map(Release.class::cast).forEach(r -> this.releaseRepository.update(r));
    }

    public <T extends Task> T getTask(String taskId) {
        return (T)this.taskRepository.findById(taskId, ResolveOptions.WITH_DECORATORS());
    }

    public void createTask(Task task) {
        this.taskRepository.create(task);
    }

    public void updateTask(Task task) {
        this.taskRepository.update(task);
    }

    public void updateTaskProperty(Task task) {
        this.updateTask(task);
    }

    public Phase getPhase(String phaseId) {
        return this.phaseRepository.findById(phaseId);
    }

    public void updatePhase(Phase phase) {
        this.phaseRepository.update(phase.getRelease(), phase, phase);
    }

    public void updateRelease(Release release) {
        this.releaseRepository.update(release);
    }

    public Release storeRelease(Release release) {
        return this.storeRelease(release, DeleteOption.DELETE_RELEASE, DeleteOption.DELETE_TEAMS);
    }

    public Trigger storeTrigger(Trigger trigger) {
        Trigger storedTrigger = this.triggerRepository.create(trigger);
        this.markForDeletion((ConfigurationItem)storedTrigger);
        return storedTrigger;
    }

    public ReleaseTrigger storeTrigger(ReleaseTrigger trigger) {
        return (ReleaseTrigger)this.storeTrigger((Trigger)trigger);
    }

    public Release storeRelease(Release release, DeleteOption ... deleteOptions) {
        Release stored = this.releaseRepository.create(release, (ReleaseCreationSource)new CreatedWithoutTemplate());
        logger.info("Stored release '{}' (uid:{}, id: {})", new Object[]{stored.getTitle(), stored.getCiUid(), stored.getId()});
        if (this.optionHas(deleteOptions, DeleteOption.DELETE_RELEASE)) {
            this.markForDeletion((ConfigurationItem)stored);
        }
        this.storeTeams(stored, deleteOptions);
        for (int tries = 10; tries > 0; --tries) {
            try {
                Thread.sleep(100L);
                this.releaseRepository.findById(release.getId(), ResolveOptions.WITH_DECORATORS());
                for (Task task : release.getAllTasks()) {
                    this.taskRepository.findById(task.getId());
                }
                return stored;
            }
            catch (Exception e) {
                logger.warn("storeRelease check failed: ", (Throwable)e);
                continue;
            }
        }
        throw new RuntimeException("storeRelease unable to check that release is saved");
    }

    public Release storeTemplate(Release releaseData) {
        return this.storeTemplate(releaseData, DeleteOption.DELETE_RELEASE, DeleteOption.DELETE_TEAMS);
    }

    public Release storeTemplate(Release releaseData, DeleteOption ... deleteOptions) {
        return this.storeTemplate(Folder.ROOT_FOLDER_ID, releaseData, deleteOptions);
    }

    public Release storeTemplate(Folder parentFolder, Release releaseData) {
        return this.storeTemplate(parentFolder.getId(), releaseData, DeleteOption.DELETE_RELEASE, DeleteOption.DELETE_TEAMS);
    }

    public Release storeTemplate(Folder parentFolder, Release releaseData, DeleteOption ... deleteOptions) {
        return this.storeTemplate(parentFolder.getId(), releaseData, deleteOptions);
    }

    private Release storeTemplate(String parentFolderId, Release releaseData, DeleteOption ... deleteOptions) {
        Release stored = this.releaseService.createTemplate(releaseData, parentFolderId);
        if (this.optionHas(deleteOptions, DeleteOption.DELETE_RELEASE)) {
            this.markForDeletion((ConfigurationItem)stored);
        }
        if (Ids.ROOT_FOLDER_ID.equals(parentFolderId)) {
            this.storeTeams(stored, deleteOptions);
        }
        return stored;
    }

    public <T extends BaseConfiguration> T storeConfiguration(T configurationItem) {
        BaseConfiguration storedItem = this.configurationRepository.create(configurationItem);
        this.markForDeletion((ConfigurationItem)storedItem);
        return (T)storedItem;
    }

    private void storeTeams(Release stored, DeleteOption[] deleteOptions) {
        logger.warn("Saving teams: {}", (Object)stored.getTeams().stream().map(BaseConfigurationItem::getId).collect(Collectors.joining(",")));
        List savedTeams = this.teamService.saveTeamsToPlatform(stored);
        if (this.optionHas(deleteOptions, DeleteOption.DELETE_TEAMS)) {
            savedTeams.forEach(this::markForDeletion);
        }
    }

    private boolean optionHas(DeleteOption[] deleteOptions, DeleteOption option) {
        return Arrays.asList(deleteOptions).contains((Object)option);
    }

    public Variable getVariable(String variableId) {
        return this.variableService.findById(variableId);
    }

    public Release getRelease(String releaseId) {
        return this.releaseRepository.findById(releaseId);
    }

    public GateCondition getGateCondition(String conditionId) {
        return this.gateConditionRepository.findById(conditionId);
    }

    public PlanItem getPlanItem(String planItemId) {
        return this.planItemRepository.findById(planItemId);
    }

    public String createRole(String roleName) {
        return this.createRole(roleName, Collections.emptyList());
    }

    public String createRole(String roleName, List<String> principals) {
        Role role = new Role(roleName);
        role.setPrincipals(principals);
        List allRoles = this.roleService.readRoleAssignments();
        allRoles.add(role);
        this.roleService.writeRoleAssignments(allRoles);
        return roleName;
    }

    public Folder createFolder(Folder folder, boolean createDefaultTeamsIfTopLevel) {
        return this.createFolder(Ids.getParentId((String)folder.getId()), folder, createDefaultTeamsIfTopLevel);
    }

    public Folder createFolder(String parentId, Folder folder) {
        return this.createFolder(parentId, folder, true);
    }

    public Folder createFolder(String parentId, Folder folder, boolean createDefaultTeamsIfTopLevel) {
        Folder createdFolder = this.folderService.create(parentId, folder, createDefaultTeamsIfTopLevel);
        this.markForDeletion((ConfigurationItem)createdFolder);
        return createdFolder;
    }

    public String encrypt(String password) {
        if (null != password && !XlrConfig.getInstance().repository_decryptPasswords()) {
            return PasswordEncrypter.getInstance().ensureEncrypted(password);
        }
        return password;
    }

    public <T extends AutoCloseable> T registerCloseable(T closeable) {
        this.closeablesToClose.add(closeable);
        return closeable;
    }

    protected void withAdmin(Callable<Void> callable) {
        SecurityContext oldCtxt = SecurityContextHolder.getContext();
        TestingAuthenticationToken adminAuth = new TestingAuthenticationToken((Object)"itusername", (Object)"itpassword", new String[]{"ROLE_ADMIN"});
        SecurityContext newCtxt = SecurityContextHolder.createEmptyContext();
        newCtxt.setAuthentication((Authentication)adminAuth);
        SecurityContextHolder.setContext((SecurityContext)newCtxt);
        try {
            callable.call();
        }
        catch (Exception ex) {
            throw new AnnotationFormatError(ex);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)oldCtxt);
        }
    }

    public List<ILoggingEvent> captureLogs(String ... names) {
        ListAppender listAppender = new ListAppender();
        HashMap<Logger, Level> oldLevels = new HashMap<Logger, Level>();
        for (String name : names) {
            Logger captureLogger = (Logger)LoggerFactory.getLogger((String)name);
            captureLogger.addAppender((Appender)listAppender);
            captureLogger.setLevel(Level.DEBUG);
        }
        listAppender.start();
        this.registerCloseable(this.makeLogAppenderCloser((ListAppender<ILoggingEvent>)listAppender, oldLevels));
        return listAppender.list;
    }

    private AutoCloseable makeLogAppenderCloser(final ListAppender<ILoggingEvent> appender, final Map<Logger, Level> oldLevels) {
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                oldLevels.entrySet().forEach(entry -> {
                    ((Logger)entry.getKey()).setLevel((Level)entry.getValue());
                    ((Logger)entry.getKey()).detachAppender((Appender)appender);
                });
                appender.stop();
                appender.list.clear();
            }
        };
    }

    public void grantGlobalPermissions(String username, Set<Permission> permissions) {
        permissions.forEach(permission -> {
            assert (permission.getLevel() == PermissionHandler.Level.GLOBAL || permission.getLevel() == PermissionHandler.Level.BOTH);
        });
        String testName = MDC.get((String)"testName");
        if (null == testName) {
            testName = "";
        }
        Role roleWithPermission = new Role(String.valueOf(this.roleService.getRoles().size()), "TestRole_" + testName + "_" + username);
        roleWithPermission.getPrincipals().add(username);
        HashMap<Role, Set<Permission>> rolePermission = new HashMap<Role, Set<Permission>>();
        rolePermission.put(roleWithPermission, permissions);
        this.roleService.writeRoleAssignments(Collections.singletonList(roleWithPermission));
        this.permissionEditor.editPermissions(PermissionChecker.GLOBAL_SECURITY_ALIAS(), rolePermission);
    }

    static {
        System.setProperty("config.override_with_env_vars", "true");
        long pid = ProcessHandle.current().pid();
        String userDir = System.getProperty("user.dir");
        boolean userDirIsSameAsWorkdir = userDir.endsWith("build");
        String baseDir = userDirIsSameAsWorkdir ? userDir + File.separator + "test-workdir" + File.separator + pid : "build" + File.separator + "test-workdir" + File.separator + pid;
        System.setProperty("xl.base.dir", baseDir);
        System.setProperty("xl.reporting.engine.location", baseDir + File.separator + "reports");
        System.setProperty("xl.repository.jobLogDir", baseDir + File.separator + "work" + File.separator + "job_logs");
        System.setProperty("xl.repository.workDir", baseDir + File.separator + "work");
        System.setProperty("h2.baseDir", baseDir);
        System.setProperty("logback.baseDir", baseDir);
        System.setProperty("derby.system.home", baseDir);
        System.setProperty("derby.drda.startNetworkServer", "true");
        logger = LoggerFactory.getLogger(XLReleaseIntegrationTest.class);
        String wid = System.getProperty("org.gradle.test.worker");
        if (wid != null) {
            logger.info("Worker id in integration test is: {}", (Object)wid);
            String repositoryUrl = System.getProperty("xl.database.db-url", "jdbc:derby:memory:xlrelease;create=true");
            String archiveUrl = System.getProperty("xl.reporting.db-url", "jdbc:derby:memory:xlarchive;create=true");
            String adminUser = System.getProperty("xl.database.adminUser");
            String adminPassword = System.getProperty("xl.database.adminPassword");
            String dbConfig = System.getProperty("xl.repository.configuration");
            String xlreleaseUsername = "xlrelease" + wid;
            String xlarchiveUsername = "xlarchive" + wid;
            if (!XLReleaseIntegrationTest.dbUserExists(repositoryUrl, xlreleaseUsername, "xlrelease")) {
                Properties connectionProperties = new Properties();
                connectionProperties.setProperty("user", adminUser);
                connectionProperties.setProperty("password", adminPassword);
                try (Connection connection = DriverManager.getConnection(repositoryUrl, connectionProperties);){
                    ResourceDatabasePopulator scriptPopulator = new ResourceDatabasePopulator();
                    DefaultResourceLoader loader = new DefaultResourceLoader();
                    Resource scriptResource = loader.getResource(dbConfig + "_create_users.sql");
                    String script = StreamUtils.copyToString((InputStream)scriptResource.getInputStream(), (Charset)StandardCharsets.UTF_8).replace("{{xlrelease}}", xlreleaseUsername).replace("{{xlarchive}}", xlarchiveUsername);
                    scriptPopulator.addScript((Resource)new InMemoryResource(script));
                    scriptPopulator.populate(connection);
                }
                catch (Exception e) {
                    String msg = "Unable to prepare database " + repositoryUrl + " to run integration tests";
                    logger.error(msg, (Throwable)e);
                    throw new IllegalStateException(msg, e);
                }
            }
            System.setProperty("xl.database.db-url", XLReleaseIntegrationTest.dbUrl(repositoryUrl, xlreleaseUsername, "xlrelease"));
            System.setProperty("xl.reporting.db-url", XLReleaseIntegrationTest.dbUrl(archiveUrl, xlarchiveUsername, "xlarchive"));
            System.setProperty("xl.database.db-username", XLReleaseIntegrationTest.dbUsername("xlrelease", xlreleaseUsername));
            System.setProperty("xl.reporting.db-username", XLReleaseIntegrationTest.dbUsername("xlarchive", xlarchiveUsername));
            System.setProperty("xl.database.max-pool-size", "10");
            System.setProperty("xl.reporting.max-pool-size", "10");
            System.setProperty("xl.metrics.enabled", "true");
        }
        SPRING_CLASS_RULE = new SpringClassRule();
    }

    public static enum DeleteOption {
        DELETE_NONE,
        DELETE_RELEASE,
        DELETE_TEAMS;

    }
}

