package com.xebialabs.xlrelease.utils

import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.actors.utils.ActorLifecycleUtils
import grizzled.slf4j.Logging
import org.apache.pekko.actor.{ActorSystem, PoisonPill}

import scala.concurrent.Await
import scala.concurrent.duration.FiniteDuration

object ActorTermination extends Logging {
  private val lifecycleUtils = new ActorLifecycleUtils() {}

  def terminateAllRiskActorsAndAwait(actorSystemHolder: ActorSystemHolder, waitDuration: FiniteDuration): Unit = {
    val actorPath = s"/user/releaseRiskSupervisor/*"
    terminateActorSelection(actorPath, actorSystemHolder, waitDuration)
  }

  def terminateActorSelection(selection: String, actorSystemHolder: ActorSystemHolder, waitDuration: FiniteDuration): Unit = {
    lazy implicit val system: ActorSystem = actorSystemHolder.unmanagedActorSystem
    val terminationResultFuture = lifecycleUtils.findAndTerminate(path = selection, terminationMsg = Some(PoisonPill))
    val terminationResult = Await.result(terminationResultFuture, waitDuration)
    logger.info(s"Terminated '$selection' with result '$terminationResult'")

  }
}
