package com.xebialabs.xlrelease

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.plumbing.authorization.LoginAuthorizationManager
import com.xebialabs.deployit.security.PermissionEnforcer.ROLE_ADMIN
import com.xebialabs.deployit.security.authentication.PersonalAuthenticationToken
import com.xebialabs.license.service.LicenseService
import com.xebialabs.xlrelease.initialize.SampleTemplatesInitialization
import com.xebialabs.xlrelease.scheduler.WorkManager
import com.xebialabs.xlrelease.security.authority.TenantAuthority
import com.xebialabs.xlrelease.utils.TenantContext
import org.mockito.ArgumentMatchers.any
import org.mockito.Mockito._
import org.mockito.invocation.InvocationOnMock
import org.springframework.security.authentication.{AuthenticationManager, BadCredentialsException, TestingAuthenticationToken}
import org.springframework.security.authorization.{AuthorizationDecision, AuthorizationManager}
import org.springframework.security.core.authority.AuthorityUtils
import org.springframework.security.core.session.SessionRegistry
import org.springframework.security.core.{Authentication, GrantedAuthority}

import java.util
import java.util.function.Supplier
import scala.beans.BeanProperty

class XLReleaseIntegrationTestConfig {
  @BeanProperty
  var licenseService: LicenseService = null

  @BeanProperty
  var sessionRegistry: SessionRegistry = null

  @BeanProperty
  var serverConfiguration: ServerConfiguration = null

  @BeanProperty
  var authenticationManager: AuthenticationManager = null

  @BeanProperty
  var runnerAuthenticationManager: AuthenticationManager = null

  @BeanProperty
  var releaseAuthorizationManager: AuthorizationManager[Object] = null

  @BeanProperty
  var aNull: SampleTemplatesInitialization = null

  @BeanProperty
  var workManager: WorkManager = null
}

object XLReleaseIntegrationTestConfig {
  val instance = new XLReleaseIntegrationTestConfig

  val testUserAccounts = Map(
    "scriptUser1" -> "scriptUserSecret1"
  )

  val testUserTokenAccount = Map(
    "run-as-admin-token" -> "admin"
  )

  def getInstance(): XLReleaseIntegrationTestConfig = {
    init()
    instance
  }

  def init(): Unit = {
    instance.licenseService = mock(classOf[LicenseService])
    instance.sessionRegistry = mock(classOf[SessionRegistry])
    instance.serverConfiguration = new ServerConfiguration
    instance.authenticationManager = mock(classOf[AuthenticationManager])
    instance.runnerAuthenticationManager = mock(classOf[AuthenticationManager])
    instance.workManager = mock(classOf[WorkManager])
    instance.releaseAuthorizationManager = mock(classOf[LoginAuthorizationManager[Object]])
    lenient().when(instance.authenticationManager.authenticate(any(classOf[Authentication]))).thenAnswer((invocation: InvocationOnMock) => {
      val auth = invocation.getArguments()(0).asInstanceOf[Authentication]
      val authUsername = auth.getPrincipal
      val authCredentials = auth.getCredentials

      //hack to test certain username/password combination with mocked auth manager instead of authenticating all users irrespective of password
      if (null != authUsername && testUserAccounts.contains(authUsername.toString)) {
        if (auth.getCredentials.asInstanceOf[String] != testUserAccounts(authUsername.toString)) {
          throw new BadCredentialsException(s"Invalid Credentials for ${auth.getPrincipal}")
        }
      }

      //hack to authenticate certain user tokens
      val principal = if (auth.isInstanceOf[PersonalAuthenticationToken] && null != authCredentials) {
        testUserTokenAccount.get(authCredentials.toString) match {
          case Some(user) => user
          case None => throw new BadCredentialsException("Cannot authenticate with supplied personal access token")
        }
      } else {
        authUsername
      }

      val authorities: util.ArrayList[GrantedAuthority] = new util.ArrayList(auth.getAuthorities)
      authorities.add(new TenantAuthority(TenantContext.SYSTEM_TENANT_ID))
      if ("admin" == authUsername && authorities.isEmpty) {
        authorities.addAll(AuthorityUtils.createAuthorityList(ROLE_ADMIN))
      }
      new TestingAuthenticationToken(principal, authCredentials, authorities)
    })
    lenient().when(instance.releaseAuthorizationManager.authorize(any(classOf[Supplier[Authentication]]), any())).thenAnswer((invocation: InvocationOnMock) => {
      new AuthorizationDecision(true)
    })
  }
}
