package com.xebialabs.xlrelease.dsl.test

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.domain.{Release, ScriptTask}
import com.xebialabs.xlrelease.dsl.test.DslIds.{ID_RELEASE1, ID_TASK1}
import com.xebialabs.xlrelease.test.async._
import com.xebialabs.xlrelease.user.User
import com.xebialabs.xlrelease.{Login, SecurityFixture, XLReleaseIntegrationScalaTest}

trait GroovyScriptIntegrationScalaTest extends XLReleaseIntegrationScalaTest with Login with GroovyDslFixture with SecurityFixture with AsyncSupport {

  private lazy val releaseActorService = springBean[ReleaseActorService]

  /**
   * Executes groovy script task and returns release that contains that task.
   *
   * @param script groovy script task content
   * @return release that contains executing groovy script task
   */
  def executeScript(script: String): Release = {
    val release: Release = updateGroovyScript(script)
    async {
      releaseActorService.startRelease(release.getId, User.SYSTEM)
    } waitFor releaseCompleted(release).orElse(releaseFailed(release)).orElse(releaseStartedFailing(release))
    getRelease(release.getId)
  }

  /**
    * Update groovy script task script in the fixture
    *
    * @param script groovy script tasks script content
    * @return updated release
    */
  protected def updateGroovyScript(script: String): Release = {
    val scriptTask = getTask[ScriptTask](ID_TASK1)
    scriptTask.setScript(script)
    updateTask(scriptTask)
    getRelease(ID_RELEASE1)
  }
}
