/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.utils.BaseConditionAwaiter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsAwaiter
extends BaseConditionAwaiter {
    private static final Logger logger = LoggerFactory.getLogger(EventsAwaiter.class);
    private List<XLReleaseEvent> expectedEvents;
    private Queue<XLReleaseEvent> pendingEvents;
    private List<XLReleaseEvent> actualEvents;
    private VerificationMode mode;

    public EventsAwaiter(XLReleaseEventBus eventBus, List<XLReleaseEvent> eventsInOccurrenceOrder, long timeout) {
        this(eventBus, eventsInOccurrenceOrder, timeout, VerificationMode.EVENTS_IN_ORDER);
    }

    public EventsAwaiter(XLReleaseEventBus eventBus, List<XLReleaseEvent> events, long timeout, VerificationMode mode) {
        super(eventBus, timeout);
        this.expectedEvents = events;
        this.pendingEvents = new ArrayDeque<XLReleaseEvent>(events);
        this.actualEvents = new ArrayList<XLReleaseEvent>();
        this.mode = mode;
    }

    @Subscribe
    public void onEvent(XLReleaseEvent event) {
        logger.trace("Received event: {}", (Object)event);
        this.actualEvents.add(event);
        switch (this.mode) {
            case EVENTS_IN_ORDER: {
                if (!Objects.equals(this.pendingEvents.peek(), event)) break;
                this.pendingEvents.poll();
                break;
            }
            case EVENTS_IN_ANY_ORDER: {
                this.pendingEvents.remove(event);
                break;
            }
            case ANY_OF_EVENTS: {
                if (!this.pendingEvents.contains(event)) break;
                this.pendingEvents.clear();
            }
        }
        if (this.pendingEvents.isEmpty()) {
            this.latch.countDown();
        }
    }

    @Override
    protected String getErrorMessage() {
        return String.format("Did not encounter events %s out of requested ordered list %s within %d milliseconds, events encountered: %s", this.pendingEvents, this.expectedEvents, this.timeout, this.actualEvents);
    }

    static enum VerificationMode {
        EVENTS_IN_ORDER,
        EVENTS_IN_ANY_ORDER,
        ANY_OF_EVENTS;

    }
}

