/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.upgrade.RepositoryInitializer;
import com.xebialabs.deployit.upgrade.Upgrader;
import com.xebialabs.platform.script.jython.EngineInstance;
import com.xebialabs.xlrelease.actors.cluster.XlrActorSystem;
import com.xebialabs.xlrelease.db.XLReleaseDbInitializer;
import com.xebialabs.xlrelease.service.MissingTypesChecker;
import com.xebialabs.xlrelease.service.ServiceStarter;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeLiquibaseUpgrade;
import javax.annotation.PostConstruct;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class TestServiceStarter
extends ServiceStarter {
    private static final Logger logger = LoggerFactory.getLogger(TestServiceStarter.class);

    @Autowired
    public TestServiceStarter(Upgrader upgrader, RepositoryInitializer repositoryInitializer, XlrActorSystem xlrActorSystem, MissingTypesChecker missingTypesChecker, BeforeLiquibaseUpgrade beforeLiquibaseUpgrade, @Qualifier(value="xlrMigrationsDbInitializer") XLReleaseDbInitializer xlrMigrationsDbInitializer, @Qualifier(value="xlrRepositoryDbInitializer") XLReleaseDbInitializer xlrRepositoryDbInitializer, @Qualifier(value="reportingDbInitializer") XLReleaseDbInitializer reportingDbInitializer) {
        super(upgrader, repositoryInitializer, xlrActorSystem, missingTypesChecker, beforeLiquibaseUpgrade, xlrMigrationsDbInitializer, xlrRepositoryDbInitializer, reportingDbInitializer);
    }

    @PostConstruct
    public void startServices() {
        super.startServices();
        this.initializeJython();
        this.initializeGroovy();
    }

    private void initializeJython() {
        try {
            logger.info("Starting up Jython engine (might take a while)...");
            long start = System.currentTimeMillis();
            EngineInstance.jython().eval("True");
            logger.info(String.format("Jython engine loaded in %d ms", System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.warn("Exception while initializing Jython engine", (Throwable)e);
        }
    }

    private void initializeGroovy() {
        try {
            logger.info("Starting up Groovy engine (might take a while)...");
            long start = System.currentTimeMillis();
            ScriptEngine groovy = new ScriptEngineManager().getEngineByName("groovy");
            if (groovy == null) {
                logger.info("No Groovy engine found");
            } else {
                groovy.eval("true");
                logger.info(String.format("Groovy engine loaded in %d ms", System.currentTimeMillis() - start));
            }
        }
        catch (Exception e) {
            logger.warn("Exception while initializing Groovy engine", (Throwable)e);
        }
    }
}

